/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.Collection;
import org.gvsig.fmap.geom.jts.mgeom.MCoordinate;

public class ArrayListCoordinateSequence
extends ArrayList<Coordinate>
implements CoordinateSequence {
    private static final long serialVersionUID = -6406449425908120065L;

    public ArrayListCoordinateSequence(Collection<Coordinate> coordinates) {
        super(coordinates);
    }

    public ArrayListCoordinateSequence() {
    }

    public ArrayListCoordinateSequence(int initialCapacity) {
        super(initialCapacity);
    }

    public int getDimension() {
        Coordinate c = (Coordinate)this.get(0);
        if (c instanceof MCoordinate) {
            if (Double.isNaN(c.z)) {
                return 3;
            }
            return 4;
        }
        if (Double.isNaN(c.z)) {
            return 2;
        }
        return 3;
    }

    public Coordinate getCoordinate(int i) {
        return (Coordinate)this.get(i);
    }

    public Coordinate getCoordinateCopy(int i) {
        return (Coordinate)((Coordinate)this.get(i)).clone();
    }

    public void getCoordinate(int index, Coordinate coord) {
        Coordinate c = (Coordinate)this.get(index);
        coord.x = c.x;
        coord.y = c.y;
        coord.z = c.z;
        if (coord instanceof MCoordinate) {
            ((MCoordinate)coord).m = c instanceof MCoordinate ? ((MCoordinate)c).m : Double.NaN;
        }
    }

    public double getX(int index) {
        return ((Coordinate)this.get((int)index)).x;
    }

    public double getY(int index) {
        return ((Coordinate)this.get((int)index)).y;
    }

    public double getOrdinate(int index, int ordinateIndex) {
        Coordinate c = (Coordinate)this.get(index);
        switch (ordinateIndex) {
            case 0: {
                return c.x;
            }
            case 1: {
                return c.y;
            }
            case 2: {
                return c.z;
            }
            case 3: {
                if (!(c instanceof MCoordinate)) break;
                return ((MCoordinate)c).m;
            }
        }
        return Double.NaN;
    }

    public void setOrdinate(int index, int ordinateIndex, double value) {
        ((Coordinate)this.get(index)).setOrdinate(ordinateIndex, value);
    }

    public Coordinate[] toCoordinateArray() {
        return this.toArray(new Coordinate[this.size()]);
    }

    public Envelope expandEnvelope(Envelope env) {
        for (int i = 0; i < this.size(); ++i) {
            env.expandToInclude((Coordinate)this.get(i));
        }
        return env;
    }

    @Override
    public Object clone() {
        ArrayListCoordinateSequence cloned = new ArrayListCoordinateSequence();
        for (Coordinate item : this) {
            cloned.add((Coordinate)item.clone());
        }
        return cloned;
    }
}

