/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.util;

import com.vividsolutions.jts.algorithm.locate.IndexedPointInAreaLocator;
import com.vividsolutions.jts.densify.Densifier;
import com.vividsolutions.jts.dissolve.LineDissolver;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.operation.linemerge.LineMergeGraph;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.SimpleTriangle;
import org.tinfour.common.Vertex;
import org.tinfour.standard.IncrementalTin;
import org.tinfour.utils.TriangleCollector;
import org.tinspin.index.kdtree.KDTree;

public class MedialAxis {
    private static final GeometryFactory GEOM_FACTORY = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING_SINGLE));
    private Geometry g;
    private KDTree<MedialDisk> kdTree;
    private Geometry dissolved;
    private LineMergeGraph lineMergeGraph;
    private final ArrayList<MedialDisk> voronoiDisks = new ArrayList();
    public MedialDisk rootNode;
    MedialDisk deepestNode;
    public MedialDisk furthestNode;
    private List<MedialDisk> leaves;
    private List<MedialDisk> bifurcations;
    private List<Branch> branches;
    private final HashMap<MedialDisk, Edge> edges;
    public boolean debug = true;
    private double minimumAxialGradient = Double.MAX_VALUE;
    private double maximumAxialGradient = -1.7976931348623157E308;
    private final IndexedPointInAreaLocator pointLocator;

    public MedialAxis(Coordinate[] coordinates) {
        this((Geometry)GEOM_FACTORY.createLinearRing(coordinates));
    }

    public MedialAxis(Geometry g) {
        if (this.debug) {
            System.out.println("Input coordinates #: " + g.getCoordinates().length);
        }
        if (g.getCoordinates().length > 4000) {
            Polygon poly = (Polygon)g;
            g = poly.getNumInteriorRing() > 0 ? TopologyPreservingSimplifier.simplify((Geometry)g, (double)1.0) : DouglasPeuckerSimplifier.simplify((Geometry)g, (double)1.0);
            if (this.debug) {
                System.out.println("Simplifying shape. New coordinates #: " + g.getCoordinates().length);
            }
        }
        this.pointLocator = new IndexedPointInAreaLocator(g);
        this.g = Densifier.densify((Geometry)g, (double)10.0);
        if (this.debug) {
            System.out.println("Densified coordinates #" + this.g.getCoordinates().length);
        }
        TC tc = this.prepareTin();
        this.rootNode = new MedialDisk(null, 0, tc.largestDiskTriangle, tc.largestCircumcircle, 0);
        ArrayDeque<MedialDisk> stack = new ArrayDeque<MedialDisk>(15);
        stack.push(this.rootNode);
        HashSet<SimpleTriangle> remaining = new HashSet<SimpleTriangle>();
        remaining.addAll(tc.triangles);
        remaining.remove(tc.largestDiskTriangle);
        this.edges = new HashMap();
        int depth = 1;
        int id = 1;
        double highestDistance = 0.0;
        while (!stack.isEmpty()) {
            MedialDisk child;
            MedialDisk live = (MedialDisk)stack.pop();
            this.voronoiDisks.add(live);
            if (live.distance > highestDistance) {
                highestDistance = live.distance;
                this.furthestNode = live;
            }
            SimpleTriangle n1 = tc.map.get(live.t.getEdgeA().getDual());
            SimpleTriangle n2 = tc.map.get(live.t.getEdgeB().getDual());
            SimpleTriangle n3 = tc.map.get(live.t.getEdgeC().getDual());
            if (remaining.contains(n1)) {
                child = new MedialDisk(live, id++, n1, tc.cccMap.get(n1), depth);
                stack.add(child);
                live.addchild(child);
                remaining.remove(n1);
                this.edges.put(child, new Edge(live, child));
                child.distance = live.distance + MedialAxis.distance(live.position, child.position);
            }
            if (remaining.contains(n2)) {
                child = new MedialDisk(live, id++, n2, tc.cccMap.get(n2), depth);
                stack.add(child);
                live.addchild(child);
                remaining.remove(n2);
                this.edges.put(child, new Edge(live, child));
                child.distance = live.distance + MedialAxis.distance(live.position, child.position);
            }
            if (remaining.contains(n3)) {
                child = new MedialDisk(live, id++, n3, tc.cccMap.get(n3), depth);
                stack.add(child);
                live.addchild(child);
                remaining.remove(n3);
                this.edges.put(child, new Edge(live, child));
                child.distance = live.distance + MedialAxis.distance(live.position, child.position);
            }
            ++depth;
        }
        this.deepestNode = this.voronoiDisks.get(this.voronoiDisks.size() - 1);
        if (this.debug) {
            System.out.println("Total Area: " + this.rootNode.featureArea);
        }
    }

    public List<MedialDisk> getDisks() {
        return this.voronoiDisks;
    }

    public MedialDisk nearestDisk(double x, double y) {
        if (this.kdTree == null) {
            this.kdTree = KDTree.create((int)2);
            this.voronoiDisks.forEach(disk -> this.kdTree.insert(new double[]{disk.position.x, disk.position.y}, disk));
        }
        return (MedialDisk)this.kdTree.nnQuery(new double[]{x, y}).value();
    }

    public MedialDisk nearestDisk(Coordinate coordinate) {
        return this.nearestDisk(coordinate.x, coordinate.y);
    }

    public List<MedialDisk> getDescendants(MedialDisk parent) {
        ArrayDeque<MedialDisk> stack = new ArrayDeque<MedialDisk>();
        stack.add(parent);
        ArrayList<MedialDisk> out = new ArrayList<MedialDisk>();
        while (!stack.isEmpty()) {
            MedialDisk live = (MedialDisk)stack.pop();
            out.add(live);
            live.children.forEach(child -> stack.add((MedialDisk)child));
        }
        return out;
    }

    public List<MedialDisk> getDescendants(MedialDisk parent, int maxDepth) {
        ArrayDeque<MedialDisk> stack = new ArrayDeque<MedialDisk>();
        stack.add(parent);
        ArrayList<MedialDisk> out = new ArrayList<MedialDisk>();
        for (int depth = 0; !stack.isEmpty() && depth < maxDepth; ++depth) {
            MedialDisk live = (MedialDisk)stack.pop();
            out.add(live);
            live.children.forEach(child -> stack.add((MedialDisk)child));
        }
        return out;
    }

    public List<MedialDisk> getAncestors(MedialDisk child) {
        ArrayList<MedialDisk> out = new ArrayList<MedialDisk>();
        MedialDisk live = child;
        while (live.parent != null) {
            out.add(live);
            live = live.parent;
        }
        return out;
    }

    public Geometry getDissolvedGeometry() {
        if (this.dissolved == null) {
            LineDissolver ld = new LineDissolver();
            this.getEdges().forEach(e -> ld.add((Geometry)e.lineString));
            this.dissolved = ld.getResult();
        }
        return this.dissolved;
    }

    public LineMergeGraph getLineMergeGraph() {
        if (this.lineMergeGraph == null) {
            this.getDissolvedGeometry();
            this.lineMergeGraph = new LineMergeGraph();
            for (int i = 0; i < this.dissolved.getNumGeometries(); ++i) {
                this.lineMergeGraph.addEdge((LineString)this.dissolved.getGeometryN(i));
            }
        }
        return this.lineMergeGraph;
    }

    public List<MedialDisk> getLeaves() {
        if (this.leaves == null) {
            this.leaves = this.voronoiDisks.stream().filter(vd -> vd.degree == 0).collect(Collectors.toList());
        }
        return this.leaves;
    }

    public List<MedialDisk> getBifurcations() {
        if (this.bifurcations == null) {
            this.bifurcations = this.voronoiDisks.stream().filter(vd -> vd.degree == 2).collect(Collectors.toList());
        }
        return this.bifurcations;
    }

    public Collection<Edge> getEdges() {
        return this.edges.values();
    }

    public List<Branch> getBranches() {
        if (this.branches == null) {
            this.branches = new ArrayList<Branch>();
            ArrayList<MedialDisk> forks = new ArrayList<MedialDisk>(this.getBifurcations());
            forks.add(this.rootNode);
            for (MedialDisk disk : forks) {
                for (MedialDisk child : disk.children) {
                    Branch branch = new Branch(disk);
                    MedialDisk node = child;
                    while (node.degree == 1) {
                        branch.add(node);
                        node = node.children.get(0);
                    }
                    branch.end(node);
                    this.branches.add(branch);
                }
            }
        }
        return this.branches;
    }

    public List<Edge> getPrunedEdges(double threshold) {
        threshold = Math.min(1.0, Math.max(0.0, threshold));
        double mappedThreshold = this.minimumAxialGradient + (this.maximumAxialGradient - this.minimumAxialGradient) * threshold;
        ArrayDeque<MedialDisk> stack = new ArrayDeque<MedialDisk>();
        stack.add(this.rootNode);
        ArrayList<Edge> out = new ArrayList<Edge>();
        while (!stack.isEmpty()) {
            MedialDisk live = (MedialDisk)stack.pop();
            live.children.forEach(child -> {
                if (child.axialGradient >= mappedThreshold) {
                    stack.add((MedialDisk)child);
                    out.add(this.edges.get(child));
                }
            });
        }
        return out;
    }

    public List<Edge> getPrunedEdges(double axialThreshold, double distanceThreshold) {
        axialThreshold = Math.min(1.0, Math.max(0.0, axialThreshold));
        axialThreshold = axialThreshold * axialThreshold * axialThreshold;
        double mappedAxial = this.minimumAxialGradient + (this.maximumAxialGradient - this.minimumAxialGradient) * axialThreshold;
        distanceThreshold = 1.0 - Math.min(1.0, Math.max(0.0, distanceThreshold));
        double mappedDistance = this.furthestNode.distance * distanceThreshold;
        ArrayDeque<MedialDisk> stack = new ArrayDeque<MedialDisk>();
        stack.add(this.rootNode);
        ArrayList<Edge> out = new ArrayList<Edge>();
        while (!stack.isEmpty()) {
            MedialDisk live = (MedialDisk)stack.pop();
            live.children.forEach(child -> {
                if (child.axialGradient >= mappedAxial && child.distance <= mappedDistance) {
                    stack.add((MedialDisk)child);
                    out.add(this.edges.get(child));
                }
            });
        }
        return out;
    }

    public List<Edge> getPrunedEdges(double axialThreshold, double distanceThreshold, double areaThreshold) {
        axialThreshold = Math.min(1.0, Math.max(0.0, axialThreshold));
        axialThreshold = axialThreshold * axialThreshold * axialThreshold;
        double mappedAxial = this.minimumAxialGradient + (this.maximumAxialGradient - this.minimumAxialGradient) * axialThreshold;
        distanceThreshold = 1.0 - Math.min(1.0, Math.max(0.0, distanceThreshold));
        double mappedDistance = this.furthestNode.distance * distanceThreshold;
        this.calcFeatureArea();
        areaThreshold = Math.min(1.0, Math.max(0.0, areaThreshold));
        areaThreshold = areaThreshold * areaThreshold * areaThreshold;
        double mappedArea = areaThreshold * this.rootNode.featureArea;
        ArrayDeque<MedialDisk> stack = new ArrayDeque<MedialDisk>();
        stack.add(this.rootNode);
        ArrayList<Edge> out = new ArrayList<Edge>();
        while (!stack.isEmpty()) {
            MedialDisk live = (MedialDisk)stack.pop();
            live.children.forEach(child -> {
                if (child.axialGradient >= mappedAxial && child.distance <= mappedDistance && child.featureArea >= mappedArea) {
                    stack.add((MedialDisk)child);
                    out.add(this.edges.get(child));
                }
            });
        }
        return out;
    }

    private Coordinate getRandomPoint() {
        return null;
    }

    private TC prepareTin() {
        IncrementalTin tin = new IncrementalTin(10.0);
        Coordinate[] coords = this.g.getCoordinates();
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        for (int i = 0; i < coords.length - 1; ++i) {
            vertices.add(new Vertex(coords[i].x, coords[i].y, 0.0));
        }
        tin.add(vertices, null);
        TC tc = new TC(tin);
        TriangleCollector.visitSimpleTriangles((IIncrementalTin)tin, (Consumer)tc);
        return tc;
    }

    private void calculateDepthFirstIndices() {
    }

    private void calculateFeatureArea() {
        List<MedialDisk> nodes = this.getLeaves();
        HashSet<MedialDisk> nextLeaves = new HashSet<MedialDisk>();
        HashMap<MedialDisk, Integer> waitAtNodes = new HashMap<MedialDisk, Integer>();
        this.getBifurcations().forEach(n -> waitAtNodes.put((MedialDisk)n, 0));
        while (!nodes.isEmpty()) {
            Iterator<MedialDisk> iterator = nodes.iterator();
            while (iterator.hasNext()) {
                MedialDisk node;
                MedialDisk current = node = iterator.next();
                while (current.degree < 2) {
                    current.parent.featureArea += current.featureArea;
                    current = current.parent;
                }
                int childrenReached = waitAtNodes.merge(current, 1, Integer::sum);
                if (childrenReached != current.degree || current.parent == null) continue;
                current.parent.featureArea += current.featureArea;
                current = current.parent;
                nextLeaves.add(current);
            }
            nodes = new ArrayList<MedialDisk>(nextLeaves);
            nextLeaves.clear();
        }
    }

    public void calcFeatureArea() {
        if (this.rootNode.area == this.rootNode.featureArea) {
            MedialAxis.recurseFeatureArea(this.rootNode);
        }
    }

    private static double recurseFeatureArea(MedialDisk node) {
        if (node.degree == 0) {
            return node.area;
        }
        for (MedialDisk child : node.children) {
            node.featureArea += MedialAxis.recurseFeatureArea(child);
        }
        return node.featureArea;
    }

    private static double[] circumcircle(Vertex a, Vertex b, Vertex c) {
        double D = (a.getX() - c.getX()) * (b.getY() - c.getY()) - (b.getX() - c.getX()) * (a.getY() - c.getY());
        double px = (((a.getX() - c.getX()) * (a.getX() + c.getX()) + (a.getY() - c.getY()) * (a.getY() + c.getY())) / 2.0 * (b.getY() - c.getY()) - ((b.getX() - c.getX()) * (b.getX() + c.getX()) + (b.getY() - c.getY()) * (b.getY() + c.getY())) / 2.0 * (a.getY() - c.getY())) / D;
        double py = (((b.getX() - c.getX()) * (b.getX() + c.getX()) + (b.getY() - c.getY()) * (b.getY() + c.getY())) / 2.0 * (a.getX() - c.getX()) - ((a.getX() - c.getX()) * (a.getX() + c.getX()) + (a.getY() - c.getY()) * (a.getY() + c.getY())) / 2.0 * (b.getX() - c.getX())) / D;
        double rs = (c.getX() - px) * (c.getX() - px) + (c.getY() - py) * (c.getY() - py);
        return new double[]{px, py, Math.sqrt(rs)};
    }

    private static double distance(Coordinate a, Coordinate b) {
        double deltaX = a.y - b.y;
        double deltaY = a.x - b.x;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    public static void main(String[] args) throws ParseException {
        String wktGeom = "POLYGON ((290 120, 440 60, 560 260, 820 320, 870 340, 840 380, 694 345, 410 260, 360 200, 290 120))";
        WKTReader reader = new WKTReader();
        Geometry geom = reader.read(wktGeom);
        MedialAxis m = new MedialAxis(geom);
        Geometry g2 = m.getDissolvedGeometry();
        System.out.println(g2.toText());
    }

    public class Branch {
        public final MedialDisk root;
        public MedialDisk leaf;
        public List<MedialDisk> innerDisks;
        Branch sibling;
        int forkDegree;
        double length;
        public final List<Edge> edges;
        public LineString lineString;

        Branch(MedialDisk root) {
            this.root = root;
            this.innerDisks = new ArrayList<MedialDisk>();
            this.edges = new ArrayList<Edge>();
        }

        void add(MedialDisk disk) {
            if (this.innerDisks.size() == 0) {
                this.edges.add(new Edge(this.root, disk));
            } else {
                this.edges.add(new Edge(this.innerDisks.get(this.innerDisks.size() - 1), disk));
            }
            this.innerDisks.add(disk);
        }

        void end(MedialDisk disk) {
            this.leaf = disk;
            if (this.innerDisks.isEmpty()) {
                this.edges.add(new Edge(this.root, disk));
            } else {
                this.edges.add(new Edge(this.innerDisks.get(this.innerDisks.size() - 1), disk));
            }
            Coordinate[] coords = new Coordinate[this.innerDisks.size() + 2];
            coords[0] = this.root.position;
            for (int i = 1; i < this.innerDisks.size(); ++i) {
                coords[i] = this.innerDisks.get((int)(i - 1)).position;
            }
            coords[coords.length - 1] = this.leaf.position;
            this.lineString = GEOM_FACTORY.createLineString(coords);
        }

        void smooth(int smoothingType) {
        }

        public boolean terminates() {
            return this.root.isLeaf();
        }
    }

    public class Edge {
        public final MedialDisk head;
        public final MedialDisk tail;
        int depth;
        public final double axialGradient;
        public final LineString lineString;

        Edge(MedialDisk head, MedialDisk tail) {
            this.head = head;
            this.tail = tail;
            this.lineString = GEOM_FACTORY.createLineString(new Coordinate[]{head.position, tail.position});
            this.depth = head.depthBF;
            this.axialGradient = tail.axialGradient;
        }

        public int hashCode() {
            return this.head.t.getEdgeA().hashCode() * (int)(this.tail.position.y + 1.0);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Edge) {
                return this.hashCode() == ((Edge)obj).hashCode();
            }
            return false;
        }
    }

    public class MedialDisk {
        public SimpleTriangle t;
        public MedialDisk parent;
        public List<MedialDisk> children;
        public final int depthBF;
        public int depthDF;
        public int degree = 0;
        double area;
        public double featureArea;
        public double distance = 0.0;
        boolean forkChild = false;
        boolean forkParent = false;
        public final double axialGradient;
        public final Coordinate position;
        public final double radius;
        final int id;

        MedialDisk(MedialDisk parent, int id, SimpleTriangle t, double[] circumcircle, int depthBF) {
            this.parent = parent;
            this.id = id;
            this.t = t;
            this.children = new ArrayList<MedialDisk>(3);
            this.depthBF = depthBF;
            this.featureArea = this.area = t.getArea();
            this.position = new Coordinate(circumcircle[0], circumcircle[1]);
            this.radius = circumcircle[2];
            if (parent != null) {
                this.axialGradient = (this.radius - parent.radius) / MedialAxis.distance(this.position, parent.position);
                MedialAxis.this.minimumAxialGradient = Math.min(MedialAxis.this.minimumAxialGradient, this.axialGradient);
                MedialAxis.this.maximumAxialGradient = Math.max(MedialAxis.this.maximumAxialGradient, this.axialGradient);
            } else {
                this.axialGradient = 0.0;
            }
        }

        private void addchild(MedialDisk child) {
            this.children.add(child);
            ++this.degree;
        }

        boolean isLeaf() {
            return this.children.size() == 0;
        }

        public int hashCode() {
            return this.t.getEdgeA().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof MedialDisk) {
                MedialDisk other = (MedialDisk)obj;
                return other.t.equals(this.t);
            }
            return false;
        }
    }

    private class TC
    implements Consumer<SimpleTriangle> {
        SimpleTriangle largestDiskTriangle = null;
        double[] largestCircumcircle = new double[3];
        HashMap<IQuadEdge, SimpleTriangle> map;
        HashMap<SimpleTriangle, double[]> cccMap = new HashMap();
        ArrayList<Coordinate> coords = new ArrayList();
        HashMap<SimpleTriangle, Coordinate> coord = new HashMap();
        ArrayList<SimpleTriangle> triangles = new ArrayList();

        public TC(IncrementalTin tin) {
            this.map = new HashMap(tin.getEdges().size());
        }

        @Override
        public void accept(SimpleTriangle t) {
            double[] circumcircle = MedialAxis.circumcircle(t.getVertexA(), t.getVertexB(), t.getVertexC());
            Coordinate center = new Coordinate(circumcircle[0], circumcircle[1]);
            if (MedialAxis.this.pointLocator.locate(center) == 0) {
                this.coords.add(center);
                this.coord.put(t, center);
                this.triangles.add(t);
                this.map.put(t.getEdgeA(), t);
                this.map.put(t.getEdgeB(), t);
                this.map.put(t.getEdgeC(), t);
                this.cccMap.put(t, circumcircle);
                if (circumcircle[2] > this.largestCircumcircle[2]) {
                    this.largestDiskTriangle = t;
                    this.largestCircumcircle = circumcircle;
                }
            }
        }
    }
}

