/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.algorithm.swing.impl.saveraster;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.tools.algorithm.swing.impl.saveraster.PixelSelectionPanel;
import org.gvsig.raster.tools.algorithm.swing.impl.saveraster.PrintSelectionPanel;

public class PrintAndPxSelectionPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private PixelSelectionPanel pixelSelectionPanel = null;
    private PrintSelectionPanel printSelectionPanel = null;
    private JLabel sizeImage = null;

    public PrintAndPxSelectionPanel() {
        this.init();
    }

    private void init() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.getPixelSelectionPanel().getRadioPxSelection());
        group.add(this.getPrintSelectionPanel().getRadioPrintSelection());
        this.getPixelSelectionPanel().setEnable(true);
        this.getPrintSelectionPanel().setEnable(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridy = 0;
        this.add((Component)this.getPixelSelectionPanel(), gbc);
        gbc.gridy = 1;
        this.add((Component)this.getPrintSelectionPanel(), gbc);
        gbc.gridy = 2;
        this.add((Component)this.getSizeImage(), gbc);
    }

    public PixelSelectionPanel getPixelSelectionPanel() {
        if (this.pixelSelectionPanel == null) {
            this.pixelSelectionPanel = new PixelSelectionPanel();
            this.pixelSelectionPanel.getRadioPxSelection().addActionListener(this);
        }
        return this.pixelSelectionPanel;
    }

    public PrintSelectionPanel getPrintSelectionPanel() {
        if (this.printSelectionPanel == null) {
            this.printSelectionPanel = new PrintSelectionPanel();
            this.printSelectionPanel.getRadioPrintSelection().addActionListener(this);
        }
        return this.printSelectionPanel;
    }

    public JLabel getSizeImage() {
        if (this.sizeImage == null) {
            this.sizeImage = new JLabel(Messages.getText((String)"result_size") + ": 0 MB");
            this.sizeImage.setForeground(Color.red);
        }
        return this.sizeImage;
    }

    public void setSize(double size) {
        this.getSizeImage().setText(Messages.getText((String)"result_size") + ": " + size + " MB");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getPixelSelectionPanel().getRadioPxSelection()) {
            if (this.getPixelSelectionPanel().getRadioPxSelection().isEnabled()) {
                this.getPixelSelectionPanel().setEnable(true);
                this.getPrintSelectionPanel().setEnable(false);
            } else {
                this.getPixelSelectionPanel().setEnable(false);
                this.getPrintSelectionPanel().setEnable(true);
            }
        }
        if (e.getSource() == this.getPrintSelectionPanel().getRadioPrintSelection()) {
            if (this.getPrintSelectionPanel().getRadioPrintSelection().isEnabled()) {
                this.getPixelSelectionPanel().setEnable(false);
                this.getPrintSelectionPanel().setEnable(true);
            } else {
                this.getPixelSelectionPanel().setEnable(true);
                this.getPrintSelectionPanel().setEnable(false);
            }
        }
    }
}

