/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.provider.z3950;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.beanutils.BeanUtils;
import org.jzkit.a2j.codec.util.OIDRegister;
import org.jzkit.search.provider.iface.IRQuery;
import org.jzkit.search.provider.iface.ScanInformation;
import org.jzkit.search.provider.iface.ScanRequestInfo;
import org.jzkit.search.provider.iface.Scanable;
import org.jzkit.search.provider.iface.SearchException;
import org.jzkit.search.provider.iface.Searchable;
import org.jzkit.search.provider.z3950.OutstandingOperationInfo;
import org.jzkit.search.provider.z3950.PendingSearch;
import org.jzkit.search.provider.z3950.Z3950SearchTask;
import org.jzkit.search.provider.z3950.ZCallbackTarget;
import org.jzkit.search.util.QueryModel.InvalidQueryException;
import org.jzkit.search.util.QueryModel.QueryModel;
import org.jzkit.search.util.RecordModel.ExplicitRecordFormatSpecification;
import org.jzkit.search.util.RecordModel.RecordFormatSpecification;
import org.jzkit.search.util.ResultSet.AbstractIRResultSet;
import org.jzkit.search.util.ResultSet.IRResultSet;
import org.jzkit.search.util.ResultSet.IRResultSetException;
import org.jzkit.z3950.QueryModel.Type1QueryModelBuilder;
import org.jzkit.z3950.QueryModel.Z3950QueryModel;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.DefaultDiagFormat_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.InitializeResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.PresentResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.Records_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.SearchResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.SortResponse_type;
import org.jzkit.z3950.util.APDUEvent;
import org.jzkit.z3950.util.APDUListener;
import org.jzkit.z3950.util.GenericEventToOriginListenerAdapter;
import org.jzkit.z3950.util.ReferencedPDUAvaialableSemaphore;
import org.jzkit.z3950.util.TimeoutExceededException;
import org.jzkit.z3950.util.ZEndpoint;
import org.springframework.context.ApplicationContext;

public class Z3950Origin
implements APDUListener,
Searchable,
Scanable {
    private ZEndpoint assoc = null;
    private boolean assoc_is_accepting_searches = false;
    protected OIDRegister reg = null;
    private Hashtable active_searches = new Hashtable();
    private Hashtable outstanding_requests = new Hashtable();
    private int ref_counter;
    private Logger log = Logger.getLogger(this.getClass().getName());
    public static int dbg_count = 0;
    private Vector outstanding_queries = new Vector();
    private boolean supports_named_result_sets = true;
    private boolean supports_scan = false;
    private boolean target_supports_concurrent_operations = true;
    private String last_search_refid = null;
    private String last_present_refid = null;
    private Object op_count_lock = new Object();
    private int outstanding_operations = 0;
    private GenericEventToOriginListenerAdapter message_adapter = null;
    private String host;
    private int port;
    private String default_record_syntax;
    private String default_record_schema;
    private String default_element_set_name;
    private int pref_message_size;
    private int exceptional_message_size;
    private String charset_encoding;
    private boolean use_reference_id;
    private String service_name;
    private String service_id;
    private int auth_type = 0;
    private String service_user_principal = null;
    private String service_user_group = null;
    private String service_user_credentials = null;
    private Map archetypes;
    private ApplicationContext ctx = null;

    public Z3950Origin(OIDRegister reg) {
        this.reg = reg;
        System.err.println("Z3950Origin::Z3950Origin() (" + ++dbg_count + " active) reg=" + reg);
    }

    public Z3950Origin() {
        System.err.println("Z3950Origin::Z3950Origin() (" + ++dbg_count + " active) reg=" + this.reg);
    }

    protected void finalize() {
        this.log.fine("Z3950Origin::finalize() (" + --dbg_count + " active)");
        this.assoc = null;
        this.active_searches = null;
    }

    public void close() {
        this.log.fine("Z3950Origin::close()");
        if (this.assoc != null) {
            if (this.message_adapter != null) {
                this.assoc.getPDUAnnouncer().deleteObserver((Observer)this.message_adapter);
                this.message_adapter = null;
            }
            this.outstanding_requests.clear();
            this.active_searches.clear();
            try {
                this.assoc.shutdown();
            }
            catch (Exception e) {
                this.log.log(Level.INFO, "Problem...", e.toString());
            }
        }
    }

    public IRResultSet evaluate(IRQuery q) {
        this.log.fine("Z3950Origin::evaluate(...)");
        return this.evaluate(q, null, null);
    }

    public IRResultSet evaluate(IRQuery q, Object user_data) {
        this.log.fine("Z3950Origin::evaluate(...)");
        return this.evaluate(q, user_data, null);
    }

    public IRResultSet evaluate(IRQuery q, Object user_info, Observer[] observers) {
        int timeout = -1;
        this.log.fine("Z3950Origin::evaluate(...,observers)");
        ExplicitRecordFormatSpecification default_spec = new ExplicitRecordFormatSpecification(this.default_record_syntax, null, "f");
        Z3950SearchTask st = new Z3950SearchTask(this, observers, (RecordFormatSpecification)default_spec);
        st.setStatus(16);
        st.setQuery(q);
        String task_id = st.getSetID();
        this.active_searches.put(task_id, new WeakReference<Z3950SearchTask>(st));
        this.log.fine("evaluating the search task....");
        st.setStatus(32);
        this.evaluateTask((AbstractIRResultSet)st, timeout);
        return st;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateTask(AbstractIRResultSet st, int wait_for) {
        this.log.fine("Z3950Origin::evaluateTask(...,observers)");
        IRQuery q = st.getQuery();
        String task_id = st.getSetID();
        String refid = String.valueOf(task_id) + ":srch";
        Z3950SearchTask zst = (Z3950SearchTask)st;
        this.log.fine("Send query");
        if (this.assoc_is_accepting_searches) {
            try {
                this.log.fine("Sending query to remote repository");
                zst.setPrivateStatusCode(2);
                this.log.fine("Sending query directly to target");
                this.sendQuery(q, null, task_id, refid);
                ((Z3950SearchTask)st).z3950_status = 1;
            }
            catch (IOException ioe) {
                zst.setDiagnosticStatus("diag.k-int.1", this.service_name, ioe.toString());
                zst.setPrivateStatusCode(8);
                st.setStatus(8);
                this.log.log(Level.SEVERE, ioe.toString(), ioe);
            }
            catch (InvalidQueryException iqe) {
                this.log.log(Level.SEVERE, "Invalid query exception " + iqe.toString(), iqe);
                zst.setDiagnosticStatus("diag.k-int.5", this.service_name, iqe.toString());
                zst.setPrivateStatusCode(8);
                st.setStatus(8);
            }
            catch (SearchException se) {
                this.log.log(Level.SEVERE, "Search exception " + se.toString(), se);
                zst.setDiagnosticStatus("diag.k-int.3", this.service_name, se.toString());
                zst.setPrivateStatusCode(8);
                st.setStatus(8);
            }
        } else {
            this.log.fine("Association is not yet active, queue the search for later");
            Vector se = this.outstanding_queries;
            synchronized (se) {
                this.outstanding_queries.add(new PendingSearch(q, null, task_id, refid, st));
            }
            this.checkConnection();
        }
        try {
            if (wait_for >= 0) {
                this.log.fine("evaluateQuery is waiting for up to " + wait_for + " ms task status complete or failure");
                st.waitForStatus(12, (long)wait_for);
            } else {
                this.log.fine("timeout < 0.");
            }
        }
        catch (IRResultSetException tee) {
            this.log.fine("Timeout waiting for search response");
        }
    }

    private void sortResultSet(Vector vector, String s, String s1, String s2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendQuery(IRQuery q, Object user_info, String task_id, String refid) throws SearchException, IOException, InvalidQueryException {
        Object object = this.op_count_lock;
        synchronized (object) {
            ++this.outstanding_operations;
        }
        Object small_set_setname = null;
        Object default_element_set_name = null;
        ArrayList v = new ArrayList(q.collections);
        this.log.fine("Collections: " + v);
        this.last_search_refid = refid;
        this.log.fine("-> Sending search request with ID: " + refid + " recsyn is " + this.default_record_syntax);
        Z3950QueryModel qry = null;
        qry = q.query instanceof Z3950QueryModel ? (Z3950QueryModel)q.query : Type1QueryModelBuilder.buildFrom((ApplicationContext)this.ctx, (QueryModel)q.query, (String)"utf-8");
        this.log.fine("Result of transformation is of class " + qry.getClass() + " = " + qry);
        if (this.default_record_syntax == null) {
            throw new SearchException("default record syntax is null for this association.");
        }
        this.assoc.sendSearchRequest(v, qry.toASNType(), refid, 0, 1, 1, true, !this.supports_named_result_sets ? "default" : task_id, small_set_setname == null ? "F" : small_set_setname, default_element_set_name == null ? "B" : default_element_set_name, this.reg.oidByName(this.default_record_syntax));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PresentResponse_type fetchRecords(String task_id, ExplicitRecordFormatSpecification spec, int start, int count, int wait_for) throws IRResultSetException {
        this.log.fine("Z3950Origin::fetchRecords(" + task_id + "," + spec.getSetname() + "," + start + "," + count + "," + wait_for + ")");
        if (this.assoc == null) {
            throw new IRResultSetException("Connection to " + this.service_name + " seems to have died. Cannot request records");
        }
        Object object = this.op_count_lock;
        synchronized (object) {
            ++this.outstanding_operations;
        }
        this.log.fine("Z3950Origin::fetchRecords() from " + this.service_name);
        PresentResponse_type retval = null;
        String schema = "";
        String refid = null;
        this.last_present_refid = refid = String.valueOf(task_id) + ":" + this.ref_counter++;
        this.log.fine("Set refid to " + refid);
        ReferencedPDUAvaialableSemaphore s = new ReferencedPDUAvaialableSemaphore(refid, this.assoc.getPDUAnnouncer());
        this.log.fine("About to send present request");
        try {
            try {
                this.assoc.sendPresentRequest(refid, !this.supports_named_result_sets ? "default" : task_id, (long)start, (long)count, spec);
                this.log.fine("Waiting for present response PDU with refid " + refid);
                s.waitForCondition(wait_for);
                retval = (PresentResponse_type)s.the_pdu.o;
            }
            catch (TimeoutExceededException tee) {
                throw new IRResultSetException("Timeout Exception waiting for records from remote source " + this.service_name);
            }
            catch (IOException ioe) {
                this.log.log(Level.SEVERE, "IO Exception waiting for present response" + ioe, ioe);
                throw new IRResultSetException("IO Exception waiting for records from remote source " + this.service_name);
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            s.destroy();
            throw throwable;
        }
        {
            Object var12_14 = null;
        }
        s.destroy();
        s.destroy();
        if (retval == null) {
            this.log.log(Level.SEVERE, "Present found no records");
            throw new IRResultSetException("Failed to fetch records from remote source " + this.service_name);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncFetchRecords(String task_id, ExplicitRecordFormatSpecification spec, int start, int count, ZCallbackTarget callback) throws IRResultSetException {
        this.log.fine("Z3950Origin::asyncfetchRecords(" + task_id + "," + spec.getSetname() + "," + start + "," + count + ",notification_targets)");
        try {
            if (this.assoc == null) {
                throw new IRResultSetException("Connection to " + this.service_name + " seems to have died. Cannot request records");
            }
            Object object = this.op_count_lock;
            synchronized (object) {
                ++this.outstanding_operations;
            }
            this.log.fine("Z3950Origin::asyncfetchRecords() from " + this.service_name);
            Object retval = null;
            String schema = "";
            String refid = null;
            this.last_present_refid = refid = String.valueOf(task_id) + ":" + this.ref_counter++;
            this.outstanding_requests.put(refid, new OutstandingOperationInfo(refid, "Present", callback));
            this.log.fine("Set refid to " + refid);
            this.assoc.sendPresentRequest(refid, !this.supports_named_result_sets ? "default" : task_id, (long)start, (long)count, spec);
        }
        catch (IOException ioe) {
            this.log.log(Level.SEVERE, "IO Exception waiting for present response" + ioe, ioe);
        }
    }

    private synchronized void checkConnection() {
        if (this.assoc == null) {
            this.log.fine("Assoc is null.... Create new association");
            try {
                this.log.fine("Create association and message adapter - reg=" + this.reg);
                this.assoc = new ZEndpoint(this.reg);
                BeanUtils.copyProperties((Object)this.assoc, (Object)this);
                this.message_adapter = new GenericEventToOriginListenerAdapter((APDUListener)this);
                this.assoc.getPDUAnnouncer().addObserver((Observer)this.message_adapter);
                this.log.fine("Calling ZEndpoint.start()");
                this.assoc.start();
            }
            catch (Exception e) {
                if (this.assoc != null && this.message_adapter != null) {
                    this.assoc.getPDUAnnouncer().deleteObserver((Observer)this.message_adapter);
                }
                this.assoc = null;
                this.message_adapter = null;
                this.log.log(Level.SEVERE, "Probelm connecting" + e, e);
            }
        } else {
            this.log.fine("checkConnection: Association is present");
        }
    }

    public void incomingAPDU(APDUEvent e) {
        this.log.info("Un-handled Generic Incoming APDU notification");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingInitResponse(APDUEvent e) {
        Object object;
        this.log.fine("Processing init response from " + this.service_name);
        InitializeResponse_type init_response = (InitializeResponse_type)e.getPDU().o;
        if (this.log.isLoggable(Level.FINE)) {
            if (init_response.referenceId != null) {
                this.log.fine("  Reference ID : " + new String(init_response.referenceId));
            } else {
                this.log.fine("  Incoming refid is NULL!");
            }
            this.log.fine("  Implementation ID : " + init_response.implementationId);
            this.log.fine("  Implementation Name : " + init_response.implementationName);
            this.log.fine("  Implementation Version : " + init_response.implementationVersion);
        }
        if (init_response.result.booleanValue()) {
            this.assoc_is_accepting_searches = true;
            if (init_response.options.isSet(14)) {
                this.log.fine("Target supports named result sets");
            } else {
                this.log.fine("Target does not support named result sets");
                this.supports_named_result_sets = false;
            }
            if (init_response.options.isSet(8)) {
                this.log.fine("Target claims scan support");
                this.supports_scan = true;
            }
            if (init_response.options.isSet(13)) {
                this.log.fine("Target claims support for concurrent operations");
            } else {
                this.log.fine("Target does not support concurrent operations");
                this.target_supports_concurrent_operations = false;
            }
            if (!this.target_supports_concurrent_operations) {
                this.assoc.setSerialOps();
            }
            object = this.outstanding_queries;
            synchronized (object) {
                Enumeration oq = this.outstanding_queries.elements();
                while (oq.hasMoreElements()) {
                    PendingSearch p = (PendingSearch)oq.nextElement();
                    Z3950SearchTask zst = (Z3950SearchTask)p.st;
                    zst.setPrivateStatusCode(2);
                    this.log.fine("Sending outstanding query, task=" + p.task_id);
                    try {
                        this.sendQuery(p.q, p.user_info, p.task_id, p.refid);
                    }
                    catch (IOException ioe) {
                        this.log.fine(ioe.toString());
                        p.st.setDiagnosticStatus("diag.k-int.1", this.service_name, ioe.toString());
                        p.st.setStatus(8);
                    }
                    catch (InvalidQueryException iqe) {
                        this.log.fine("Invalid query exception " + iqe.toString());
                        p.st.setDiagnosticStatus("diag.k-int.2", this.service_name, iqe.toString());
                        p.st.setStatus(8);
                    }
                    catch (SearchException se) {
                        this.log.fine("Search exception " + se.toString());
                        p.st.setDiagnosticStatus("diag.k-int.3", this.service_name, se.toString());
                        p.st.setStatus(8);
                    }
                }
            }
        }
        this.log.log(Level.SEVERE, "Init was not OK, not sending outstanding queries, and failing those queries in the queue");
        object = this.outstanding_queries;
        synchronized (object) {
            Enumeration oq = this.outstanding_queries.elements();
            while (oq.hasMoreElements()) {
                PendingSearch p = (PendingSearch)oq.nextElement();
                Z3950SearchTask zst = (Z3950SearchTask)p.st;
                zst.setDiagnosticStatus("diag.k-int.4", this.service_name, "Remote target rejected connection");
                zst.setPrivateStatusCode(8);
                zst.setStatus(8);
            }
        }
        this.outstanding_queries.clear();
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingSearchResponse(APDUEvent e) {
        StringTokenizer st;
        SearchResponse_type search_response = (SearchResponse_type)e.getPDU().o;
        Object object = this.op_count_lock;
        synchronized (object) {
            --this.outstanding_operations;
        }
        if (!this.use_reference_id) {
            this.log.fine("Broken REFID, working around by manually setting the last Search_refid used");
            search_response.referenceId = this.last_search_refid.getBytes();
        }
        if (this.log.isLoggable(Level.FINE)) {
            if (search_response.referenceId != null) {
                this.log.fine("Search Response - Reference ID : " + new String(search_response.referenceId));
            } else {
                this.log.log(Level.SEVERE, "The search response has NO REFID!");
            }
            this.log.fine("  Search Result : " + search_response.searchStatus);
            this.log.fine("  Result Count : " + search_response.resultCount);
            this.log.fine("  Num Records Returned : " + search_response.numberOfRecordsReturned);
            this.log.fine("  Next RS position : " + search_response.nextResultSetPosition);
        }
        if ((st = new StringTokenizer(new String(search_response.referenceId), ":")).hasMoreTokens()) {
            String taskid = st.nextToken();
            WeakReference wr = (WeakReference)this.active_searches.get(taskid);
            if (wr != null) {
                Z3950SearchTask tsk = (Z3950SearchTask)wr.get();
                if (tsk != null) {
                    tsk.setFragmentCount(search_response.resultCount.intValue());
                    tsk.setPrivateStatusCode(3);
                    tsk.z3950_status = 2;
                    if (search_response.searchStatus.booleanValue()) {
                        IRQuery q = tsk.getQuery();
                        if (q.sorting != null && !q.sorting.equals("")) {
                            tsk.setPrivateStatusCode(6);
                            Vector<String> setnames_to_sort = new Vector<String>();
                            setnames_to_sort.add(taskid);
                            this.log.fine("Search task contains sort critera: " + q.sorting);
                        } else {
                            this.log.fine("No sorting instructions in task. All complete!");
                            tsk.setStatus(4);
                            if (search_response.records != null) {
                                this.handleRecords(tsk, search_response.records);
                            }
                        }
                    } else {
                        if (search_response.records != null) {
                            this.handleRecords(tsk, search_response.records);
                        }
                        this.log.info("Search failure.....");
                        tsk.setDiagnosticStatus("diag.k-int.3", this.service_name, "Search failure");
                        tsk.setStatus(8);
                    }
                } else {
                    this.log.info("The AbstractIRResultSet associated with REFID " + new String(search_response.referenceId) + " is no longer referenced and has been garbage collected.");
                    this.active_searches.remove(taskid);
                }
            } else {
                this.log.log(Level.SEVERE, "Unable to locate a search for the REFID " + new String(search_response.referenceId) + ". REFID processing at the target may be BROKEN!");
            }
        } else {
            this.log.info("Unable to parse refid for search response");
        }
        Z3950Origin z3950Origin = this;
        synchronized (z3950Origin) {
            this.notifyAll();
        }
    }

    private void handleRecords(Z3950SearchTask tsk, Records_type r) {
        switch (r.which) {
            case 0: {
                ArrayList records = (ArrayList)r.o;
                if (records.size() <= 0) break;
                this.log.fine("  Search has records (type=" + r.which + ", but Z3950Origin should use MSPN of 0?");
                break;
            }
            case 1: {
                this.log.fine("NonSurrogate diagnostics");
                DefaultDiagFormat_type diag = (DefaultDiagFormat_type)r.o;
                String message = "Diagnostic (" + this.service_name + "): " + diag.condition + " addinfo: " + diag.addinfo.toString();
                this.log.fine(message);
                tsk.setDiagnosticStatus("diag.bib1." + diag.condition, this.service_name, message);
                break;
            }
            case 2: {
                this.log.fine("Multiple NonSurrogate diagnostics");
                break;
            }
            default: {
                this.log.fine("Unknown choice type in Records");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingPresentResponse(APDUEvent e) {
        PresentResponse_type present_response = (PresentResponse_type)e.getPDU().o;
        Object object = this.op_count_lock;
        synchronized (object) {
            --this.outstanding_operations;
        }
        this.log.fine("Incoming PresentResponse from " + e.getSource().hashCode());
        if (!this.use_reference_id) {
            this.log.fine("broken refid - manually setting refid using last present refid");
            present_response.referenceId = this.last_present_refid.getBytes();
        }
        if (present_response.referenceId != null) {
            String refid = new String(present_response.referenceId);
            this.log.fine("Present Response - Reference ID : \"" + refid + "\" target=" + this.service_name);
            OutstandingOperationInfo ooi = (OutstandingOperationInfo)this.outstanding_requests.remove(refid);
            if (ooi != null) {
                ooi.getCallbackTarget().notifyPresentResponse(present_response);
            }
        } else {
            this.log.info("incomingPresentResponse::Null refid");
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingDeleteResultSetResponse(APDUEvent e) {
        this.log.fine("Incoming DeleteResultSetResponse");
        Z3950Origin z3950Origin = this;
        synchronized (z3950Origin) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingAccessControlRequest(APDUEvent e) {
        Z3950Origin z3950Origin = this;
        synchronized (z3950Origin) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingAccessControlResponse(APDUEvent e) {
        this.log.fine("Incoming AccessControlResponse");
        Z3950Origin z3950Origin = this;
        synchronized (z3950Origin) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingResourceControlRequest(APDUEvent e) {
        Z3950Origin z3950Origin = this;
        synchronized (z3950Origin) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingResourceControlResponse(APDUEvent e) {
        this.log.fine("Incoming ResourceControlResponse");
        Z3950Origin z3950Origin = this;
        synchronized (z3950Origin) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingTriggerResourceControlRequest(APDUEvent e) {
        Z3950Origin z3950Origin = this;
        synchronized (z3950Origin) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingResourceReportRequest(APDUEvent e) {
        this.log.fine("Incoming ResourceReportResponse");
        Z3950Origin z3950Origin = this;
        synchronized (z3950Origin) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingResourceReportResponse(APDUEvent e) {
        Z3950Origin z3950Origin = this;
        synchronized (z3950Origin) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingScanRequest(APDUEvent e) {
        this.log.fine("Incoming ScanResponse");
        Z3950Origin z3950Origin = this;
        synchronized (z3950Origin) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingScanResponse(APDUEvent e) {
        Z3950Origin z3950Origin = this;
        synchronized (z3950Origin) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingSortRequest(APDUEvent e) {
        this.log.fine("Incoming SortResponse");
        Z3950Origin z3950Origin = this;
        synchronized (z3950Origin) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingSortResponse(APDUEvent e) {
        String taskid;
        WeakReference wr;
        StringTokenizer st;
        SortResponse_type sort_response = (SortResponse_type)e.getPDU().o;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Sort Response");
            if (sort_response.referenceId != null) {
                this.log.fine("  Reference ID : " + new String(sort_response.referenceId));
            }
            this.log.fine("  Sort Status : " + sort_response.sortStatus);
            this.log.fine("  Result Set Status : " + sort_response.resultSetStatus);
        }
        if ((st = new StringTokenizer(new String(sort_response.referenceId), ":")).hasMoreTokens() && (wr = (WeakReference)this.active_searches.get(taskid = st.nextToken())) != null) {
            Z3950SearchTask tsk = (Z3950SearchTask)wr.get();
            tsk.setPrivateStatusCode(7);
            if (tsk != null) {
                switch (sort_response.sortStatus.intValue()) {
                    case 0: {
                        tsk.setStatus(4);
                        break;
                    }
                    case 1: {
                        tsk.setStatus(4);
                        break;
                    }
                    case 2: {
                        this.log.fine("Sort Failure, Result set status is " + sort_response.resultSetStatus);
                        tsk.setDiagnosticStatus("diag.k-int.6", this.service_name, "Sort Failure, Result set status is " + sort_response.resultSetStatus);
                        tsk.setStatus(8);
                    }
                }
            } else {
                this.active_searches.remove(taskid);
            }
        }
        Z3950Origin z3950Origin = this;
        synchronized (z3950Origin) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingSegmentRequest(APDUEvent e) {
        this.log.fine("Incoming SegmentResponse");
        Z3950Origin z3950Origin = this;
        synchronized (z3950Origin) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingExtendedServicesRequest(APDUEvent e) {
        Z3950Origin z3950Origin = this;
        synchronized (z3950Origin) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingExtendedServicesResponse(APDUEvent e) {
        this.log.fine("Incoming ExtendedServicesResponse");
        Z3950Origin z3950Origin = this;
        synchronized (z3950Origin) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingClose(APDUEvent e) {
        this.log.fine("Z3950Origin::incomingClose");
        Enumeration req_enum = this.outstanding_requests.elements();
        while (req_enum.hasMoreElements()) {
            OutstandingOperationInfo ooi = (OutstandingOperationInfo)req_enum.nextElement();
            ooi.getCallbackTarget().notifyClose("closed");
        }
        this.outstanding_requests.clear();
        Z3950Origin z3950Origin = this;
        synchronized (z3950Origin) {
            this.notifyAll();
        }
        this.log.fine("Clearing out old z-association");
        this.assoc = null;
        this.assoc_is_accepting_searches = false;
    }

    public String getTargetDN() {
        return this.service_id;
    }

    public String getTargetName() {
        return this.service_name;
    }

    public boolean isScanSupported() {
        return this.supports_scan;
    }

    public ScanInformation doScan(ScanRequestInfo req) {
        return null;
    }

    public String toString() {
        return "Z3950Origin - " + this.service_name;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getDefaultRecordSyntax() {
        return this.default_record_syntax;
    }

    public String getDefaultRecordSchema() {
        return this.default_record_schema;
    }

    public String getDefaultElementSetName() {
        return this.default_element_set_name;
    }

    public int getPrefMessageSize() {
        return this.pref_message_size;
    }

    public int getExceptionalMessageSize() {
        return this.exceptional_message_size;
    }

    public String getCharsetEncoding() {
        return this.charset_encoding;
    }

    public boolean getUseReferenceId() {
        return this.use_reference_id;
    }

    public String getServiceName() {
        return this.service_name;
    }

    public String getServiceId() {
        return this.service_id;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setDefaultRecordSyntax(String default_record_syntax) {
        this.default_record_syntax = default_record_syntax;
    }

    public void setDefaultRecordSchema(String default_record_schema) {
        this.default_record_schema = default_record_schema;
    }

    public void setDefaultElementSetName(String default_element_set_name) {
        this.default_element_set_name = default_element_set_name;
    }

    public void setPrefMessageSize(int pref_message_size) {
        this.pref_message_size = pref_message_size;
    }

    public void setExceptionalMessageSize(int exceptional_message_size) {
        this.exceptional_message_size = exceptional_message_size;
    }

    public void setCharsetEncoding(String charset_encoding) {
        this.charset_encoding = charset_encoding;
    }

    public void setUseReferenceId(boolean use_reference_id) {
        this.use_reference_id = use_reference_id;
    }

    public void setServiceName(String service_name) {
        this.service_name = service_name;
    }

    public void setServiceId(String service_id) {
        this.service_id = service_id;
    }

    public void setRecordArchetypes(Map archetypes) {
        this.archetypes = archetypes;
    }

    public Map getRecordArchetypes() {
        return this.archetypes;
    }

    public void setAuthType(int auth_type) {
        this.auth_type = auth_type;
    }

    public int getAuthType() {
        return this.auth_type;
    }

    public String getServiceUserPrincipal() {
        return this.service_user_principal;
    }

    public void setServiceUserPrincipal(String service_user_principal) {
        this.service_user_principal = service_user_principal;
    }

    public String getServiceUserGroup() {
        return this.service_user_group;
    }

    public void setServiceUserGroup(String service_user_group) {
        this.service_user_group = service_user_group;
    }

    public String getServiceUserCredentials() {
        return this.service_user_credentials;
    }

    public void setServiceUserCredentials(String service_user_credentials) {
        this.service_user_credentials = service_user_credentials;
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this.ctx = ctx;
        if (this.reg == null) {
            this.reg = (OIDRegister)ctx.getBean("OIDRegister");
        }
    }
}

