/*
 * Decompiled with CFR 0.152.
 */
package org.japura.controller;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import org.japura.Application;
import org.japura.controller.AbstractController;
import org.japura.controller.AbstractControllerManager;
import org.japura.controller.Controller;
import org.japura.controller.ControllerManagerListener;
import org.japura.controller.ControllerModel;
import org.japura.controller.DebugControllers;
import org.japura.debug.DebugComponent;
import org.japura.modal.Modal;

public class DefaultControllerManager
extends AbstractControllerManager {
    @Override
    public void closeModal(ControllerModel model) {
        Object component;
        Controller controller = (Controller)model;
        if (controller.isComponentInstancied() && (component = controller.getComponent()) != null) {
            if (component instanceof JFrame) {
                JFrame frame = (JFrame)component;
                Modal.closeAllModals(frame);
            } else if (component instanceof JDialog) {
                JDialog dialog = (JDialog)component;
                Modal.closeAllModals(dialog);
            } else if (component instanceof JInternalFrame) {
                JInternalFrame frame = (JInternalFrame)component;
                Modal.closeAllModals(frame);
            }
        }
    }

    @Override
    public void removeFromDebugComponents(ControllerModel model) {
        Controller controller = (Controller)model;
        if (DebugComponent.exists(DebugControllers.class)) {
            DebugControllers.Parameter parameter = new DebugControllers.Parameter(controller);
            DebugComponent.publish(DebugControllers.class, parameter);
        }
    }

    @Override
    public void updateDebugComponents() {
        if (DebugComponent.exists(DebugControllers.class)) {
            DebugControllers.Parameter parameter = new DebugControllers.Parameter();
            DebugComponent.publish(DebugControllers.class, parameter);
        }
    }

    @Override
    public Class<?> getNewInstanceClass() {
        return Controller.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void remove(ControllerModel controller, boolean cancelTaskExecution) {
        if (controller != null && !controller.isPermanent()) {
            Controller cc;
            ArrayList<ControllerModel> children = new ArrayList<ControllerModel>();
            this.fetchHierarchy(controller, children);
            AbstractController c = (AbstractController)controller;
            c.beforeFreeController();
            for (ControllerModel child : children) {
                Controller cc2 = (Controller)child;
                cc2.beforeFreeController();
            }
            String groupId = controller.getGroupId();
            if (cancelTaskExecution) {
                Application.getTaskManager().cancel(groupId);
            }
            this.closeModal(controller);
            for (ControllerModel child : children) {
                this.closeModal(child);
            }
            AbstractController parentController = (AbstractController)controller.getParent();
            if (parentController != null) {
                parentController.removeChild(c);
            }
            c.clearParent();
            c.clearChildren();
            for (ControllerModel child : children) {
                cc = (Controller)child;
                cc.clearParent();
                cc.clearChildren();
            }
            this.controllers.remove(controller);
            c.setAsRemoved();
            this.unlink(controller);
            this.removeFromDebugComponents(c);
            for (ControllerModel child : children) {
                cc = (Controller)child;
                this.controllers.remove(child);
                cc.setAsRemoved();
                this.unlink(child);
                this.removeFromDebugComponents(cc);
            }
            c.afterFreeController();
            for (ControllerModel child : children) {
                cc = (Controller)child;
                cc.afterFreeController();
            }
            this.updateDebugComponents();
            List list = this.listeners;
            synchronized (list) {
                for (ControllerManagerListener listener : this.listeners) {
                    listener.removed(controller);
                }
            }
        }
    }
}

