/*
 * Decompiled with CFR 0.152.
 */
package org.japura.dialogs;

import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import org.japura.dialogs.MessageDialogButton;
import org.japura.dialogs.MessagePanel;
import org.japura.i18n.I18nManager;
import org.japura.i18n.I18nStringKeys;

public class DefaultMessageDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Object result;
    private List<MessageDialogButton> buttons;
    private MessagePanel messagePanel;

    public DefaultMessageDialog(Window owner, String title, Image dialogIcon, Image icon, String msg, String detailedMsg, List<MessageDialogButton> buttons) {
        super(owner);
        this.buttons = Collections.unmodifiableList(buttons);
        this.setTitle(title);
        String detailedMsgTitle = null;
        if (detailedMsg != null) {
            detailedMsgTitle = I18nManager.getString(I18nStringKeys.DETAILS.getKey());
        }
        this.messagePanel = new MessagePanel(msg, detailedMsgTitle, detailedMsg);
        if (icon != null) {
            this.messagePanel.setIcon(new ImageIcon(icon));
        }
        for (MessageDialogButton mdb : buttons) {
            mdb.initializeButton(this);
            this.messagePanel.getButtonsPanel().add(mdb.getButton());
        }
        this.add(this.messagePanel);
        this.setModal(true);
        this.setResizable(false);
        if (dialogIcon != null) {
            this.setIconImage(dialogIcon);
        }
        this.pack();
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    public void addContent(Component content, int topMargin) {
        this.messagePanel.addContent(content, topMargin);
        this.pack();
        this.pack();
    }

    public void addContent(Component content) {
        this.messagePanel.addContent(content);
        this.pack();
        this.pack();
    }

    void setResult(Object result) {
        this.result = result;
    }

    public Object getResult() {
        return this.result;
    }

    public List<MessageDialogButton> getButtons() {
        return this.buttons;
    }
}

