/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.CaretListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import org.japura.gui.event.ButtonTextFieldEvent;
import org.japura.gui.event.ButtonTextFieldListener;

public class ButtonTextField
extends JPanel {
    private static final long serialVersionUID = 2L;
    private EventListenerList listeners = new EventListenerList();
    private JTextField field;
    private IconLabel icon;
    private IconLabel selectedDropDownIcon;
    private JPanel dropDownButtonPanel;
    private JLabel dropDownButton;
    private LinkedHashMap<String, Action> actions;
    private String currentButton;
    private MouseAdapter popupMouseAdapter;
    private JPopupMenu actionsChooser;
    private JPanel actionsRoot;
    private DefaultListModel listModel;
    private JList actionsList;
    private ListRenderer listRenderer;
    private URL fixedIcon;
    private int maxWidth;
    private int maxHeight;
    private static int marginGap = 3;

    public ButtonTextField(String text) {
        this(new JTextField(text));
        this.updateMargin();
    }

    public ButtonTextField(int columns) {
        this(new JTextField(columns));
        this.updateMargin();
    }

    public ButtonTextField(String text, int columns) {
        this(new JTextField(text, columns));
        this.updateMargin();
    }

    public ButtonTextField() {
        this(new JTextField());
        this.updateMargin();
    }

    public ButtonTextField(JTextField field) {
        if (field == null) {
            field = new JTextField();
        }
        this.field = field;
        this.setBorder(field.getBorder());
        field.setBorder(null);
        field.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("margin")) {
                    Insets margin = ButtonTextField.this.getField().getMargin();
                    if (margin == null) {
                        ButtonTextField.this.getField().setBorder(null);
                    } else {
                        Border border = BorderFactory.createEmptyBorder(margin.top, margin.left, margin.bottom, margin.right);
                        ButtonTextField.this.getField().setBorder(border);
                    }
                }
            }
        });
        this.updateMargin();
        this.actions = new LinkedHashMap();
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 3;
        gbc.weighty = 1.0;
        this.add((Component)this.getDropDownButtonPanel(), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.getField(), gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        this.add((Component)this.getIcon(), gbc);
    }

    public void addButtonTextFieldListener(ButtonTextFieldListener listener) {
        this.listeners.add(ButtonTextFieldListener.class, listener);
    }

    public void removeButtonTextFieldListener(ButtonTextFieldListener listener) {
        this.listeners.remove(ButtonTextFieldListener.class, listener);
    }

    private void updateMargin() {
        this.getField().setMargin(new Insets(0, marginGap, 0, marginGap));
    }

    public URL getFixedIcon() {
        return this.fixedIcon;
    }

    public void setFixedIcon(URL fixedIcon) {
        this.fixedIcon = fixedIcon;
        if (this.getFixedIcon() != null) {
            this.getIcon().setIcon(new ImageIcon(this.getFixedIcon()));
        } else if (this.icon != null) {
            Action action = this.actions.get(this.currentButton);
            ImageIcon icon = action.getIcon();
            this.getIcon().setIcon(icon);
        } else {
            this.getIcon().setIcon(null);
        }
        this.updateMaxSizes();
    }

    public boolean isDropDownVisible() {
        return this.getDropDownButtonPanel().isVisible();
    }

    public void setDropDownVisible(boolean visible) {
        this.getDropDownButtonPanel().setVisible(visible);
        this.updateDropDownIconBorder();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension dim = new Dimension();
        Dimension fieldDim = this.field.getPreferredSize();
        Insets fieldInsets = this.field.getInsets();
        dim.width += fieldDim.width + fieldInsets.left + fieldInsets.right;
        dim.height += fieldDim.height + fieldInsets.top + fieldInsets.bottom;
        if (this.isDropDownVisible()) {
            Dimension dropDownDim = this.getDropDownButtonPanel().getPreferredSize();
            Insets dropDownInsets = this.getDropDownButtonPanel().getInsets();
            int dropDownHeight = dropDownDim.height + dropDownInsets.top + dropDownInsets.bottom;
            dim.width += dropDownDim.width + dropDownInsets.left + dropDownInsets.right;
            dim.height = Math.max(dim.height, dropDownHeight);
        }
        if (this.isIconVisible()) {
            if (this.getFixedIcon() != null) {
                Dimension iconDim = this.getIcon().getPreferredSize();
                dim.width += iconDim.width;
                dim.height = Math.max(dim.height, iconDim.height);
            } else {
                Insets iconInsets = this.getIcon().getInsets();
                int iconHeight = this.maxHeight + iconInsets.top + iconInsets.bottom;
                dim.width += this.maxWidth + iconInsets.left + iconInsets.right;
                dim.height = Math.max(dim.height, iconHeight);
            }
        }
        Insets insets = this.getInsets();
        dim.width += insets.left + insets.right;
        dim.height += insets.bottom + insets.top;
        return dim;
    }

    public void fireCurrentButtonActionListeners() {
        Action action;
        ActionListener listener;
        if (this.currentButton != null && this.isEnabled() && (listener = (action = this.actions.get(this.currentButton)).getListener()) != null) {
            listener.actionPerformed(new ActionEvent(this, 1001, ""));
        }
    }

    private void showButtonsChooser() {
        if (this.isEnabled()) {
            Dimension dim = this.getSize();
            Dimension bcDim = this.getActionsRoot().getPreferredSize();
            Insets insets = this.getActionsChooser().getInsets();
            int width = dim.width;
            width = bcDim.width + insets.left + insets.right;
            int height = bcDim.height + insets.bottom + insets.top;
            Dimension newDim = new Dimension(width, height);
            this.getActionsChooser().setPreferredSize(newDim);
            this.getActionsChooser().show(this, 0, dim.height);
        }
    }

    private JPopupMenu getActionsChooser() {
        if (this.actionsChooser == null) {
            this.actionsChooser = new JPopupMenu();
            this.actionsChooser.add(this.getActionsRoot());
        }
        return this.actionsChooser;
    }

    private JPanel getActionsRoot() {
        if (this.actionsRoot == null) {
            this.actionsRoot = new JPanel();
            this.actionsRoot.setLayout(new BorderLayout());
            this.actionsRoot.setBorder(BorderFactory.createLineBorder(Color.WHITE, 5));
            this.actionsRoot.add((Component)this.getActionsList(), "Center");
        }
        return this.actionsRoot;
    }

    private DefaultListModel getListModel() {
        if (this.listModel == null) {
            this.listModel = new DefaultListModel();
        }
        return this.listModel;
    }

    private ListRenderer getListRenderer() {
        if (this.listRenderer == null) {
            this.listRenderer = new ListRenderer();
        }
        return this.listRenderer;
    }

    private JList getActionsList() {
        if (this.actionsList == null) {
            this.actionsList = new JList();
            this.actionsList.setCellRenderer(this.getListRenderer());
            this.actionsList.setSelectionMode(0);
            this.actionsList.setModel(this.getListModel());
            this.actionsList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting() && ButtonTextField.this.actionsList.getSelectedIndex() > -1) {
                        ButtonTextField.this.actionsList.clearSelection();
                    }
                }
            });
            this.actionsList.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    ((ButtonTextField)ButtonTextField.this).listRenderer.mouseOverIndex = ButtonTextField.this.actionsList.locationToIndex(e.getPoint());
                    ButtonTextField.this.actionsList.repaint();
                }
            });
            this.actionsList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    String actionName = null;
                    if (((ButtonTextField)ButtonTextField.this).listRenderer.mouseOverIndex >= 0 && ((ButtonTextField)ButtonTextField.this).listRenderer.mouseOverIndex < ButtonTextField.this.getListModel().size()) {
                        actionName = (String)ButtonTextField.this.getListModel().get(((ButtonTextField)ButtonTextField.this).listRenderer.mouseOverIndex);
                    }
                    ButtonTextField.this.getActionsChooser().setVisible(false);
                    ((ButtonTextField)ButtonTextField.this).listRenderer.mouseOverIndex = -1;
                    if (actionName != null) {
                        ButtonTextField.this.setCurrentButton(actionName);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ((ButtonTextField)ButtonTextField.this).listRenderer.mouseOverIndex = -1;
                    ButtonTextField.this.actionsList.repaint();
                }
            });
        }
        return this.actionsList;
    }

    public void addButton(String buttonName, ActionListener listener) {
        this.addButton(buttonName, null, listener);
    }

    public void addButton(String buttonName, URL icon, ActionListener listener) {
        Action action = new Action(listener, icon);
        this.actions.put(buttonName, action);
        this.getListModel().addElement(buttonName);
        if (this.currentButton == null) {
            this.setCurrentButton(buttonName);
        }
        this.updateMaxSizes();
        this.updateDropDownIconBorder();
    }

    private void updateDropDownIconBorder() {
        if (this.isDropDownVisible()) {
            for (Action action : this.actions.values()) {
                if (action.getIcon() == null) continue;
                this.selectedDropDownIcon.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 3));
                return;
            }
        }
        this.selectedDropDownIcon.setBorder(BorderFactory.createEmptyBorder());
    }

    private void updateMaxSizes() {
        this.maxWidth = 0;
        this.maxHeight = 0;
        for (Action action : this.actions.values()) {
            if (action.getIcon() == null) continue;
            this.maxWidth = Math.max(this.maxWidth, action.getIcon().getIconWidth());
            this.maxHeight = Math.max(this.maxHeight, action.getIcon().getIconHeight());
        }
    }

    public JTextField getField() {
        return this.field;
    }

    public boolean isIconVisible() {
        return this.getIcon().isVisible();
    }

    public void setIconVisible(boolean visible) {
        this.getIcon().setVisible(visible);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.field.setEnabled(enabled);
        this.getIcon().setEnabled(enabled);
        this.getDropDownButton().setEnabled(enabled);
    }

    public void setCurrentButton(String buttonName) {
        Action action = this.actions.get(buttonName);
        if (action != null) {
            ButtonTextFieldEvent event = new ButtonTextFieldEvent(this.currentButton, buttonName, System.currentTimeMillis());
            for (ButtonTextFieldListener l : (ButtonTextFieldListener[])this.listeners.getListeners(ButtonTextFieldListener.class)) {
                l.buttonChanged(event);
            }
            this.currentButton = buttonName;
            ImageIcon icon = action.getIcon();
            if (icon != null) {
                this.getSelectedDropDownIcon().setIcon(icon);
            } else {
                this.getSelectedDropDownIcon().setIcon(null);
            }
            if (this.getFixedIcon() == null) {
                this.getIcon().setIcon(icon);
            }
            this.getField().setCaretPosition(0);
        }
    }

    public String getCurrentButtonName() {
        return this.currentButton;
    }

    private IconLabel getIcon() {
        if (this.icon == null) {
            this.icon = new IconLabel(true);
            this.icon.setCursor(new Cursor(12));
            this.icon.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 2));
            this.icon.setBackground(this.field.getBackground());
            this.icon.setOpaque(true);
            this.icon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ButtonTextField.this.fireCurrentButtonActionListeners();
                }
            });
        }
        return this.icon;
    }

    public void setIconCursor(Cursor cursor) {
        this.getIcon().setCursor(cursor);
    }

    @Override
    public void setBackground(Color background) {
        super.setBackground(background);
        if (this.field != null) {
            this.field.setBackground(background);
            this.getIcon().setBackground(background);
        }
    }

    private MouseAdapter getPopupMouseAdapter() {
        if (this.popupMouseAdapter == null) {
            this.popupMouseAdapter = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ButtonTextField.this.showButtonsChooser();
                }
            };
        }
        return this.popupMouseAdapter;
    }

    private JLabel getDropDownButton() {
        if (this.dropDownButton == null) {
            URL url = this.getClass().getResource("/images/jpr_splitbuttondown.png");
            this.dropDownButton = new JLabel();
            this.dropDownButton.setIcon(new ImageIcon(url));
            this.dropDownButton.addMouseListener(this.getPopupMouseAdapter());
        }
        return this.dropDownButton;
    }

    public boolean isSelectedDropDownIconVisible() {
        return this.getSelectedDropDownIcon().isVisible();
    }

    public void setDropDownButtonBackground(Color color) {
        this.getDropDownButtonPanel().setBackground(color);
    }

    public Color getDropDownButtonBackground() {
        return this.getDropDownButtonPanel().getBackground();
    }

    public void setSelectedDropDownIconVisible(boolean visible) {
        this.getSelectedDropDownIcon().setVisible(visible);
    }

    private IconLabel getSelectedDropDownIcon() {
        if (this.selectedDropDownIcon == null) {
            this.selectedDropDownIcon = new IconLabel(false);
            this.selectedDropDownIcon.addMouseListener(this.getPopupMouseAdapter());
        }
        return this.selectedDropDownIcon;
    }

    private JPanel getDropDownButtonPanel() {
        if (this.dropDownButtonPanel == null) {
            this.dropDownButtonPanel = new JPanel(new BorderLayout());
            this.dropDownButtonPanel.addMouseListener(this.getPopupMouseAdapter());
            this.dropDownButtonPanel.add((Component)this.getSelectedDropDownIcon(), "West");
            this.dropDownButtonPanel.add((Component)this.getDropDownButton(), "Center");
            MatteBorder out = BorderFactory.createMatteBorder(0, 0, 0, 1, Color.GRAY);
            Border in = BorderFactory.createEmptyBorder(0, 2, 0, 2);
            CompoundBorder botder = BorderFactory.createCompoundBorder(out, in);
            this.dropDownButtonPanel.setBorder(botder);
        }
        return this.dropDownButtonPanel;
    }

    public void setText(String text) {
        this.getField().setText(text);
    }

    public String getText() {
        return this.getField().getText();
    }

    public void setDocument(Document doc) {
        this.getField().setDocument(doc);
    }

    public Document getDocument() {
        return this.getField().getDocument();
    }

    @Override
    public synchronized void addFocusListener(FocusListener listener) {
        this.getField().addFocusListener(listener);
    }

    @Override
    public synchronized void addKeyListener(KeyListener listener) {
        this.getField().addKeyListener(listener);
    }

    public void addCaretListener(CaretListener listener) {
        this.getField().addCaretListener(listener);
    }

    private class ListRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final long serialVersionUID = -7811567885926598910L;
        public int mouseOverIndex;
        private Border mouseOverBorder;
        private Border mouseOutBorder;
        private JLabel label = new JLabel();
        private IconLabel icon;

        public ListRenderer() {
            this.icon = new IconLabel(false);
            this.setLayout(new BorderLayout(2, 0));
            this.add((Component)this.label, "Center");
            this.add((Component)this.icon, "West");
            this.setBackground(Color.WHITE);
            this.label.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String name = (String)value;
            this.label.setText(name);
            Action action = (Action)ButtonTextField.this.actions.get(name);
            if (action.getIcon() != null) {
                this.icon.setIcon(action.getIcon());
            } else {
                this.icon.setIcon(null);
            }
            if (index == this.mouseOverIndex) {
                this.label.setBorder(this.getMouseOverBorder());
                this.label.setBackground(Color.BLACK);
                this.label.setForeground(Color.WHITE);
            } else {
                this.label.setBorder(this.getMouseOutBorder());
                this.label.setBackground(Color.WHITE);
                this.label.setForeground(Color.BLACK);
            }
            return this;
        }

        public Border getMouseOverBorder() {
            if (this.mouseOverBorder == null) {
                this.mouseOverBorder = BorderFactory.createLineBorder(Color.BLACK, 3);
            }
            return this.mouseOverBorder;
        }

        public Border getMouseOutBorder() {
            if (this.mouseOutBorder == null) {
                this.mouseOutBorder = BorderFactory.createLineBorder(Color.WHITE, 3);
            }
            return this.mouseOutBorder;
        }
    }

    private class IconLabel
    extends JLabel {
        private static final long serialVersionUID = 729241592604471900L;
        private boolean fieldIcon;

        public IconLabel(boolean fieldIcon) {
            super("", null, 0);
            this.fieldIcon = fieldIcon;
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.fieldIcon) {
                return super.getPreferredSize();
            }
            Insets insets = this.getInsets();
            int w = insets.left + insets.right + ButtonTextField.this.maxWidth;
            int h = insets.top + insets.bottom + ButtonTextField.this.maxHeight;
            return new Dimension(w, h);
        }
    }

    private static class Action {
        private ActionListener listener;
        private ImageIcon icon;

        public Action(ActionListener listener, URL urlIcon) {
            this.listener = listener;
            if (urlIcon != null) {
                this.icon = new ImageIcon(urlIcon);
            }
        }

        protected ActionListener getListener() {
            return this.listener;
        }

        protected ImageIcon getIcon() {
            return this.icon;
        }
    }
}

