/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.model;

import java.util.Locale;
import javax.swing.text.BadLocationException;
import org.japura.gui.model.NumberDocument;

public class DoubleDocument
extends NumberDocument<Double> {
    private static final long serialVersionUID = -1334753847712151427L;

    public DoubleDocument() {
        this((Locale)null);
    }

    public DoubleDocument(Locale locale) {
        super(locale, true);
        this.maxValue = Double.MAX_VALUE;
        this.minValue = Double.MIN_VALUE;
    }

    public Double getValue() {
        try {
            Double value;
            Number number;
            String text = this.getText();
            if (text.matches(this.getValidateRegex()) && (number = this.parse(text)) != null && (value = Double.valueOf(number.doubleValue())) >= (Double)this.minValue && value <= (Double)this.maxValue) {
                return value;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setValue(double value) {
        String text = this.format(value);
        try {
            this.remove(0, this.getLength());
            this.insertString(0, text, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public double getMaxValue() {
        return (Double)this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public double getMinValue() {
        return (Double)this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    @Override
    protected boolean isAcceptableValue(Number number) {
        double value = number.doubleValue();
        return value >= this.getMinValue() && value <= this.getMaxValue();
    }
}

