/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.model;

import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public abstract class NumberDocument<T extends Number>
extends PlainDocument {
    private static final long serialVersionUID = 7570259805144825486L;
    private String separator;
    private String validateRegex;
    private String insertRegex;
    protected T maxValue;
    protected T minValue;

    public NumberDocument(Locale locale, boolean acceptFraction) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (acceptFraction) {
            DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance(locale);
            this.separator = Character.toString(dfs.getDecimalSeparator());
            this.validateRegex = "([-]{1,1})?[0-9]{1,}([" + this.separator + "][0-9]{1,})?";
            this.insertRegex = "([-]{1,1})?([0-9]{1,})?([" + this.separator + "])?([0-9]{1,})?";
        } else {
            this.validateRegex = "([-]{1,1})?[0-9]{1,}";
            this.insertRegex = "([-]{1,1})?([0-9]{1,})?";
        }
    }

    protected String getValidateRegex() {
        return this.validateRegex;
    }

    protected NumberFormat getNumberFormat() {
        NumberFormat nf = NumberFormat.getInstance(Locale.getDefault());
        nf.setGroupingUsed(false);
        return nf;
    }

    protected Number parse(String text) {
        NumberFormat n = this.getNumberFormat();
        try {
            return n.parse(text);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String format(Object value) {
        NumberFormat n = this.getNumberFormat();
        n.setMaximumFractionDigits(Integer.MAX_VALUE);
        return n.format(value);
    }

    protected String getText() throws BadLocationException {
        return this.getText(0, this.getLength());
    }

    protected abstract boolean isAcceptableValue(Number var1);

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        Number number;
        String text = this.getText();
        String newText = text.substring(0, offs) + str + text.substring(offs, text.length());
        if (newText.matches(this.insertRegex) && (number = this.parse(newText)) != null && this.isAcceptableValue(number)) {
            super.insertString(offs, str, a);
        }
    }
}

