/*
 * Decompiled with CFR 0.152.
 */
package org.japura.task.ui;

import javax.swing.SwingUtilities;
import org.japura.Application;
import org.japura.task.Task;
import org.japura.task.ui.TaskExecutionUI;
import org.japura.util.InputEventBlocker;

public class InputEventBlockerUI
implements TaskExecutionUI {
    private InputEventBlocker eventHook = new InputEventBlocker();

    @Override
    public void submitted(Task<?> task) {
        if (SwingUtilities.isEventDispatchThread() && Application.getTaskManager().getQueueCount() == 1) {
            this.setEnabled(true);
        }
    }

    @Override
    public void beforeExecute(Task<?> task) {
    }

    @Override
    public void afterExecute(Task<?> task) {
        if (Application.getTaskManager().getQueueCount() == 0) {
            this.setEnabled(false);
        }
    }

    protected void setEnabled(boolean enabled) {
        if (enabled) {
            this.eventHook.apply();
        } else {
            this.eventHook.remove();
        }
    }
}

