/*
 * Decompiled with CFR 0.152.
 */
package org.japura.util.worker;

import org.japura.gui.EnhancedPanel;
import org.japura.gui.ExecutionPanel;
import org.japura.util.worker.SwingWorkerHandler;
import org.japura.util.worker.SwingWorkerHandlerEvent;

public class ModalProgressBarHandler
extends SwingWorkerHandler {
    private EnhancedPanel enhancedPanel;
    private ExecutionPanel executionPanel;

    public ModalProgressBarHandler(EnhancedPanel enhancedPanel) {
        this.enhancedPanel = enhancedPanel;
    }

    @Override
    protected synchronized void before(SwingWorkerHandlerEvent event) {
        if (this.executionPanel == null) {
            String text = event.getName();
            if (text == null) {
                text = "";
            }
            this.executionPanel = new ExecutionPanel(text);
            this.enhancedPanel.setEventsBlocked(true);
            this.enhancedPanel.setWidgetTranslucentBackground(true);
            this.enhancedPanel.addWidget(this.executionPanel);
            this.executionPanel.start();
        }
    }

    @Override
    protected synchronized void after(SwingWorkerHandlerEvent event) {
        if (event.getWorkersCount() == 0) {
            this.executionPanel.stop();
            this.enhancedPanel.setEventsBlocked(false);
            this.enhancedPanel.setWidgetTranslucentBackground(false);
            this.enhancedPanel.removeWidget(this.executionPanel);
            this.executionPanel = null;
        }
    }
}

