/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.annotation.app.extension;

import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.annotation.AnnotationCreationFinishAction;
import org.gvsig.annotation.AnnotationCreationService;
import org.gvsig.annotation.AnnotationLocator;
import org.gvsig.annotation.AnnotationManager;
import org.gvsig.annotation.app.extension.AddLayerFinishAction;
import org.gvsig.annotation.app.extension.AnnotationPreferencesPage;
import org.gvsig.annotation.app.extension.GvSIGAnnotationWindowManager;
import org.gvsig.annotation.swing.AnnotationSwingLocator;
import org.gvsig.annotation.swing.AnnotationSwingManager;
import org.gvsig.annotation.swing.AnnotationWindowManager;
import org.gvsig.annotation.swing.JAnnotationCreationServicePanel;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionBuilder;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.service.ServiceException;

public class AnnotationExtension
extends Extension {
    public static final String PERSIST_DEF_FONT_COLOR_KEY = "def_font_color";
    public static final String PERSIST_DEF_TEXT_VALUE_KEY = "def_text_value";
    public static final String PERSIST_DEF_FONT_TYPE_KEY = "def_font_type";
    public static final String PERSIST_DEF_FONT_STYLE_KEY = "def_font_style";
    public static final String PERSIST_DEF_FONT_HEIGHT_KEY = "def_font_height";
    public static final String PERSIST_DEF_FONT_ROTATION_KEY = "def_font_rotation";
    private AnnotationManager manager;
    private AnnotationSwingManager swingManager;

    public void initialize() {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint ep = extensionPoints.add("AplicationPreferences", "");
        ep.append("AnnotationPreferencesPage", "", (ExtensionBuilder)new AnnotationPreferencesPage());
        IconThemeHelper.registerIcon((String)"preferences", (String)"annotation-preferences", (Object)((Object)this));
    }

    public void postInitialize() {
        super.postInitialize();
        this.manager = AnnotationLocator.getManager();
        this.swingManager = AnnotationSwingLocator.getSwingManager();
        this.swingManager.registerWindowManager((AnnotationWindowManager)new GvSIGAnnotationWindowManager());
    }

    private FLyrVect getCurrentLayer() {
        return this.getCurrentLayer(null);
    }

    private FLyrVect getCurrentLayer(MapContext mapContext) {
        FLyrVect layer = null;
        if (mapContext == null) {
            ApplicationManager application = ApplicationLocator.getManager();
            ViewDocument view = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
            if (view == null) {
                return null;
            }
            mapContext = view.getMapContext();
        }
        FLayer[] actives = mapContext.getLayers().getActives();
        for (int i = 0; i < actives.length; ++i) {
            if (!(actives[i] instanceof FLyrVect)) continue;
            layer = (FLyrVect)actives[i];
            break;
        }
        return layer;
    }

    public void execute(String actionCommand) {
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument view = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (view == null) {
            return;
        }
        MapContext mapContext = view.getMapContext();
        FLyrVect layer = this.getCurrentLayer(mapContext);
        if (layer == null) {
            return;
        }
        this.showAnnotation(this.manager, layer.getFeatureStore(), mapContext);
    }

    public void showAnnotation(AnnotationManager manager, FeatureStore featureStore, MapContext mapContext) {
        try {
            AnnotationCreationService service = manager.getAnnotationCreationService(featureStore);
            service.setAnnotationCreationFinishAction((AnnotationCreationFinishAction)new AddLayerFinishAction(mapContext));
            JAnnotationCreationServicePanel panel = this.swingManager.createAnnotation(service);
            this.swingManager.getWindowManager().showWindow(panel, "Annotation", 2);
        }
        catch (ServiceException e) {
            NotificationManager.addError((Throwable)e);
        }
    }

    public boolean isEnabled() {
        FLyrVect layer = this.getCurrentLayer();
        return layer != null;
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument view = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        return view != null;
    }
}

