/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.swing.api.SwingInstallerManager;
import org.gvsig.installer.swing.api.execution.JShowRequiredPackagesAndAskContinuePanel;
import org.gvsig.installer.swing.impl.DefaultJShowPackageStatusAndAskContinuePanel;

public class DefaultJShowRequiredPackagesAndAskContinuePanel
extends JShowRequiredPackagesAndAskContinuePanel
implements ActionListener {
    private static final long serialVersionUID = 2135985029410816305L;
    private List<String> packages;
    private boolean doCancel = true;

    public DefaultJShowRequiredPackagesAndAskContinuePanel(SwingInstallerManager manager, List<PackageInfo> packages, String message) {
        this.buildPackageList(packages);
        this.createUI(manager, message);
    }

    private void buildPackageList(List<PackageInfo> packages) {
        this.packages = new ArrayList<String>();
        for (int i = 0; i < packages.size(); ++i) {
            PackageInfo pkg = packages.get(i);
            this.packages.add(pkg.getName());
        }
    }

    private void createUI(SwingInstallerManager manager, String message) {
        this.setLayout(new BorderLayout());
        JButton cancelButton = new JButton(manager.getText("_cancel"));
        cancelButton.setActionCommand("cancel");
        cancelButton.addActionListener(this);
        JButton continueButton = new JButton(manager.getText("_continue"));
        continueButton.setActionCommand("continue");
        continueButton.addActionListener(this);
        JList<Object> list = new JList<Object>(this.packages.toArray());
        JScrollPane listScroller = new JScrollPane(list);
        listScroller.setPreferredSize(new Dimension(250, 80));
        listScroller.setAlignmentX(0.0f);
        JPanel listPane = new JPanel();
        listPane.setLayout(new BoxLayout(listPane, 3));
        String html_msg = DefaultJShowPackageStatusAndAskContinuePanel.getHtmlText(message);
        JLabel label = new JLabel(html_msg);
        label.setLabelFor(list);
        listPane.add(label);
        listPane.add(Box.createRigidArea(new Dimension(0, 5)));
        listPane.add(listScroller);
        listPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(cancelButton);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(continueButton);
        this.add(listPane, "Center");
        this.add(buttonPane, "Last");
    }

    public boolean cancelled() {
        return this.doCancel;
    }

    public boolean needShow() {
        return this.packages.size() > 0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.doCancel = "cancel".equals(e.getActionCommand());
        this.setVisible(false);
    }
}

