/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.creation.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.gvsig.installer.lib.api.InstallerLocator;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.swing.api.SwingInstallerLocator;
import org.gvsig.installer.swing.api.creation.JOutputPanel;
import org.gvsig.installer.swing.impl.DefaultSwingInstallerManager;
import org.gvsig.installer.swing.impl.creation.panel.DefaultOutputPanelLayout;

public class DefaultOutputPanel
extends JOutputPanel {
    private static final long serialVersionUID = 1219577194134960697L;
    protected DefaultSwingInstallerManager swingInstallerManager = (DefaultSwingInstallerManager)SwingInstallerLocator.getSwingInstallerManager();
    private DefaultOutputPanelLayout form = null;
    private PackageInfo packageInfo = null;

    public DefaultOutputPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.form = new DefaultOutputPanelLayout();
        this.form.indexFileBrowserButton.setEnabled(false);
        this.form.indexFileTextField.setEditable(false);
        this.form.packageURLTextField.setEnabled(false);
        this.form.packageURLPoolTextField.setEnabled(false);
        this.form.useAbsoluteURLRadioButton.setEnabled(false);
        this.form.usePoolURLRadioButton.setEnabled(false);
        this.form.createPackageIndexCheckBox.setSelected(false);
        this.form.usePoolURLRadioButton.setSelected(true);
        this.form.indexFileBrowserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                File[] f = DefaultOutputPanel.this.showOpenFileDialog("_Select_package_index_file", null);
                if (f != null) {
                    DefaultOutputPanel.this.setPackageIndexFile(f[0]);
                }
            }
        });
        this.form.fileBrowserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                File[] f = DefaultOutputPanel.this.showOpenFileDialog("_Select_package_file", null);
                if (f != null) {
                    DefaultOutputPanel.this.setPackageFile(f[0]);
                }
            }
        });
        this.form.createPackageIndexCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean x = ((DefaultOutputPanel)DefaultOutputPanel.this).form.createPackageIndexCheckBox.isSelected();
                DefaultOutputPanel.this.setCreatePackageIndex(x);
            }
        });
        this.form.useAbsoluteURLRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((DefaultOutputPanel)DefaultOutputPanel.this).form.useAbsoluteURLRadioButton.isSelected()) {
                    ((DefaultOutputPanel)DefaultOutputPanel.this).form.packageURLTextField.setEnabled(true);
                    ((DefaultOutputPanel)DefaultOutputPanel.this).form.packageURLPoolTextField.setEnabled(false);
                } else {
                    ((DefaultOutputPanel)DefaultOutputPanel.this).form.packageURLTextField.setEnabled(false);
                    ((DefaultOutputPanel)DefaultOutputPanel.this).form.packageURLPoolTextField.setEnabled(true);
                }
            }
        });
        this.form.usePoolURLRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((DefaultOutputPanel)DefaultOutputPanel.this).form.useAbsoluteURLRadioButton.isSelected()) {
                    ((DefaultOutputPanel)DefaultOutputPanel.this).form.packageURLTextField.setEnabled(true);
                    ((DefaultOutputPanel)DefaultOutputPanel.this).form.packageURLPoolTextField.setEnabled(false);
                } else {
                    ((DefaultOutputPanel)DefaultOutputPanel.this).form.packageURLTextField.setEnabled(false);
                    ((DefaultOutputPanel)DefaultOutputPanel.this).form.packageURLPoolTextField.setEnabled(true);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add(this.form, "Center");
    }

    public void setPackageInfo(PackageInfo packageInfo) {
        this.packageInfo = packageInfo;
    }

    public File getPackageFile() {
        String s = this.form.fileTextField.getText().trim();
        if (s.length() == 0) {
            return null;
        }
        return new File(s);
    }

    public void setPackageFile(File selectedFile) {
        this.form.fileTextField.setText(selectedFile.toString());
    }

    public boolean isCreatePackageIndex() {
        return this.form.createPackageIndexCheckBox.isSelected();
    }

    public void setCreatePackageIndex(boolean create) {
        if (this.form.createPackageIndexCheckBox.isSelected() != create) {
            this.form.createPackageIndexCheckBox.setSelected(create);
        }
        if (create) {
            this.form.indexFileBrowserButton.setEnabled(true);
            this.form.indexFileTextField.setEditable(true);
            this.form.packageURLTextField.setEnabled(true);
            this.form.packageURLPoolTextField.setEnabled(true);
            this.form.useAbsoluteURLRadioButton.setEnabled(true);
            this.form.usePoolURLRadioButton.setEnabled(true);
        } else {
            this.form.indexFileBrowserButton.setEnabled(false);
            this.form.indexFileTextField.setEditable(false);
            this.form.packageURLTextField.setEnabled(false);
            this.form.packageURLPoolTextField.setEnabled(false);
            this.form.useAbsoluteURLRadioButton.setEnabled(false);
            this.form.usePoolURLRadioButton.setEnabled(false);
        }
    }

    public File getPackageIndexFile() {
        if (!this.isCreatePackageIndex()) {
            return null;
        }
        String s = this.form.indexFileTextField.getText().trim();
        if (s.length() == 0) {
            return null;
        }
        return new File(s);
    }

    public void setPackageIndexFile(File selectedIndexFile) {
        this.form.indexFileTextField.setText(selectedIndexFile.toString());
    }

    public URL getDownloadURL() {
        String s = null;
        if (!this.isCreatePackageIndex()) {
            return null;
        }
        try {
            if (this.form.useAbsoluteURLRadioButton.isSelected()) {
                s = this.form.packageURLTextField.getText();
            } else {
                s = this.form.packageURLPoolTextField.getText();
                File ff = this.getPackageFile();
                PackageInfo pkg = this.getPackageInfo();
                if (pkg == null) {
                    this.form.useAbsoluteURLRadioButton.setSelected(true);
                    this.form.usePoolURLRadioButton.setEnabled(false);
                    JOptionPane.showMessageDialog(null, this.swingInstallerManager.getText("_Cant_use_pool_URL"));
                    return null;
                }
                String fileName = InstallerLocator.getInstallerManager().getPackageFileName(pkg);
                if (!s.endsWith("/")) {
                    s = s + "/";
                }
                s = s + pkg.getCode() + "/" + fileName;
            }
            return new URL(s);
        }
        catch (MalformedURLException e) {
            JOptionPane.showMessageDialog(null, this.swingInstallerManager.getText("_invalid_download_url") + ": " + this.form.packageURLTextField.getText());
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void setDownloadURL(URL downloadURL) {
        this.form.useAbsoluteURLRadioButton.setSelected(false);
        this.form.usePoolURLRadioButton.setSelected(true);
        if (downloadURL == null) {
            this.form.packageURLPoolTextField.setText("");
            this.form.packageURLTextField.setText("");
            return;
        }
        this.form.packageURLTextField.setText(downloadURL.toString());
        try {
            File ff = new File(downloadURL.getPath());
            String s = ff.getParentFile().getParentFile().getAbsolutePath();
            URL url = new URL(downloadURL, s);
            this.form.packageURLPoolTextField.setText(url.toString());
        }
        catch (MalformedURLException e) {
            this.form.packageURLPoolTextField.setText("");
        }
    }

    private File[] showChooserDialog(String title, int type, int selectionMode, boolean multiselection, File initialPath, FileFilter filter, boolean fileHidingEnabled) {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(title);
        fc.setDialogType(type);
        fc.setFileSelectionMode(selectionMode);
        fc.setMultiSelectionEnabled(multiselection);
        fc.setCurrentDirectory(initialPath);
        fc.setFileFilter(filter);
        fc.setFileHidingEnabled(fileHidingEnabled);
        int r = 1;
        switch (type) {
            case 1: {
                r = fc.showSaveDialog((Component)((Object)this));
                break;
            }
            default: {
                r = fc.showOpenDialog((Component)((Object)this));
            }
        }
        if (r != 0) {
            return null;
        }
        if (fc.isMultiSelectionEnabled()) {
            return fc.getSelectedFiles();
        }
        return new File[]{fc.getSelectedFile()};
    }

    private File[] showOpenFileDialog(String title, File initialPath) {
        return this.showChooserDialog(title, 0, 0, false, initialPath, null, false);
    }

    protected PackageInfo getPackageInfo() {
        return this.packageInfo;
    }
}

