/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.execution.panel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.gvsig.installer.lib.api.execution.InstallPackageService;
import org.gvsig.installer.swing.api.SwingInstallerLocator;
import org.gvsig.installer.swing.api.execution.PackageFilter;
import org.gvsig.installer.swing.impl.DefaultSwingInstallerManager;
import org.gvsig.installer.swing.impl.execution.panel.PackagesTablePanel;
import org.gvsig.installer.swing.impl.execution.panel.filters.AllFilter;
import org.gvsig.installer.swing.impl.execution.panel.filters.CategoryFilter;
import org.gvsig.installer.swing.impl.execution.panel.filters.TypeFilter;

public class PackagePropertiesFilterPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 3767011079359743742L;
    private PackagesTablePanel packagesTablePanel;
    private JScrollPane filterScrollPane;
    private JList jList;
    private DefaultListModel model = null;
    private DefaultSwingInstallerManager manager;
    private JButton typesButton;

    public PackagePropertiesFilterPanel(PackagesTablePanel packagesTablePanel) {
        this.packagesTablePanel = packagesTablePanel;
        this.manager = (DefaultSwingInstallerManager)SwingInstallerLocator.getSwingInstallerManager();
        this.initComponents();
    }

    private void initComponents() {
        this.model = new DefaultListModel();
        this.jList = new JList(this.model);
        this.filterScrollPane = new JScrollPane(this.jList);
        MyMouseListener mouseListener = new MyMouseListener();
        this.jList.addMouseListener(mouseListener);
        JButton categoriesButton = new JButton(this.manager.getText("_categories"));
        categoriesButton.setActionCommand("categories");
        categoriesButton.addActionListener(this);
        this.typesButton = new JButton(this.manager.getText("_types"));
        this.typesButton.setActionCommand("types");
        this.typesButton.addActionListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.filterScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)categoriesButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.typesButton, gridBagConstraints);
    }

    public void resetPanel() {
        this.model.removeAllElements();
        PackageFilter filter = null;
        this.packagesTablePanel.setFilter(filter);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        InstallPackageService service = this.packagesTablePanel.getSelectPackagesPanel().getModel().getInstallPackageService();
        if ("categories".equals(e.getActionCommand())) {
            this.packagesTablePanel.resetPanel();
            this.loadCategories();
        } else if ("types".equals(e.getActionCommand())) {
            this.model.removeAllElements();
            this.packagesTablePanel.resetPanel();
            List types = service.getTypes();
            this.model.add(0, new AllFilter());
            if (types != null) {
                for (int i = 0; i < types.size(); ++i) {
                    this.model.add(i + 1, new TypeFilter((String)types.get(i)));
                }
            }
        }
    }

    void setEnabledTypeFilter(boolean enabled) {
        this.typesButton.setEnabled(enabled);
    }

    private void loadCategories() {
        InstallPackageService service = this.packagesTablePanel.getSelectPackagesPanel().getModel().getInstallPackageService();
        this.model.removeAllElements();
        List categories = service.getCategories();
        this.model.add(0, new AllFilter());
        if (categories != null) {
            for (int i = 0; i < categories.size(); ++i) {
                this.model.add(i + 1, new CategoryFilter((String)categories.get(i)));
            }
        }
        this.jList.setSelectedIndex(0);
    }

    public void setInitialFilter() {
        this.loadCategories();
    }

    private class MyMouseListener
    implements MouseListener {
        private MyMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int i = PackagePropertiesFilterPanel.this.jList.getSelectedIndex();
            if (i >= 0) {
                ListModel listModel = PackagePropertiesFilterPanel.this.jList.getModel();
                PackageFilter filter = (PackageFilter)listModel.getElementAt(i);
                PackagePropertiesFilterPanel.this.packagesTablePanel.setFilter(filter);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

