/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.execution.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.swing.api.SwingInstallerLocator;
import org.gvsig.installer.swing.api.SwingInstallerManager;
import org.gvsig.installer.swing.api.execution.PackageFilter;
import org.gvsig.installer.swing.impl.execution.panel.FastFilterButtonsPanel;
import org.gvsig.installer.swing.impl.execution.panel.PackagePropertiesFilterPanel;
import org.gvsig.installer.swing.impl.execution.panel.SelectPackagesPanel;
import org.gvsig.installer.swing.impl.execution.panel.filters.AndFilter;
import org.gvsig.installer.swing.impl.execution.panel.model.PackagesTableModel;
import org.gvsig.installer.swing.impl.execution.panel.renderers.InstallStatusCellEditor;
import org.gvsig.installer.swing.impl.execution.panel.renderers.InstallStatusCellRenderer;
import org.gvsig.installer.swing.impl.execution.panel.renderers.InstalledPackageCellRenderer;
import org.gvsig.installer.swing.impl.execution.panel.renderers.OfficialRecommendedCellRenderer;
import org.gvsig.installer.swing.impl.execution.panel.renderers.OsAndArchitectureCellRenderer;

public class PackagesTablePanel
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 8156088357208685689L;
    protected SwingInstallerManager swingInstallerManager = SwingInstallerLocator.getSwingInstallerManager();
    private JScrollPane descriptionScrollPane;
    private JEditorPane descriptionTextEditor;
    private JScrollPane pluginsScrollPane;
    private JTable pluginsTable;
    private PackagePropertiesFilterPanel filterPanel;
    private FastFilterButtonsPanel fastFilterPanel;
    private SelectPackagesPanel selectPackagesPanel;
    private PackageFilter baseFilter = null;

    public PackagesTablePanel(SelectPackagesPanel selectPackagesPanel) {
        this.selectPackagesPanel = selectPackagesPanel;
        this.initComponents();
        this.pluginsTable.getSelectionModel().addListSelectionListener(this);
        this.pluginsTable.setDefaultRenderer(PackagesTableModel.PackageOfficialRecommended.class, new OfficialRecommendedCellRenderer());
        this.pluginsTable.setDefaultRenderer(PackagesTableModel.PackageStatus.class, new InstallStatusCellRenderer());
        this.pluginsTable.setDefaultEditor(PackagesTableModel.PackageStatus.class, new InstallStatusCellEditor(this.selectPackagesPanel));
        InstalledPackageCellRenderer ipcr = new InstalledPackageCellRenderer();
        this.pluginsTable.setDefaultRenderer(PackagesTableModel.PackageOsAndArchitecture.class, new OsAndArchitectureCellRenderer());
        this.pluginsTable.setDefaultRenderer(String.class, ipcr);
        this.pluginsTable.setDefaultRenderer(Number.class, ipcr);
        this.pluginsTable.setAutoResizeMode(3);
    }

    private void initComponents() {
        this.pluginsTable = new JTable();
        MyMouseListener mouseListener = new MyMouseListener();
        this.pluginsTable.addMouseListener(mouseListener);
        this.pluginsScrollPane = new JScrollPane(this.pluginsTable);
        this.descriptionTextEditor = new JEditorPane();
        this.descriptionTextEditor.setBackground(Color.WHITE);
        this.descriptionTextEditor.setEditable(false);
        this.descriptionTextEditor.setContentType("text/html");
        this.descriptionScrollPane = new JScrollPane(this.descriptionTextEditor);
        this.filterPanel = new PackagePropertiesFilterPanel(this);
        this.filterPanel.setVisible(true);
        this.fastFilterPanel = new FastFilterButtonsPanel(this);
        JSplitPane rightPanel = new JSplitPane(0, this.pluginsScrollPane, this.descriptionScrollPane);
        rightPanel.setResizeWeight(0.8);
        rightPanel.setOneTouchExpandable(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.13;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        this.add((Component)this.filterPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.75;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.fastFilterPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.75;
        gridBagConstraints.weighty = 0.7;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)rightPanel, gridBagConstraints);
    }

    public void resetFilter() {
        this.filterPanel.resetPanel();
        this.valueChanged();
    }

    public void selectPackages() {
        PackagesTableModel pluginsTableModel = (PackagesTableModel)this.pluginsTable.getModel();
        pluginsTableModel.selectDefaultPackages();
    }

    public void setTableModel(PackagesTableModel pluginsTableModel) {
        this.pluginsTable.setModel(pluginsTableModel);
        pluginsTableModel.fireTableDataChanged();
        TableColumnModel tableColumnModel = this.pluginsTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(20);
        tableColumnModel.getColumn(1).setPreferredWidth(20);
        tableColumnModel.getColumn(2).setPreferredWidth(20);
        tableColumnModel.getColumn(3).setPreferredWidth(225);
        tableColumnModel.getColumn(4).setPreferredWidth(130);
        tableColumnModel.getColumn(5).setPreferredWidth(53);
    }

    public List<PackageInfo> getPackagesToInstall() {
        return ((PackagesTableModel)this.pluginsTable.getModel()).getPackagesToInstall();
    }

    public boolean isPackageSelected() {
        return ((PackagesTableModel)this.pluginsTable.getModel()).hasAnyPackageSelected();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.valueChanged();
    }

    public void valueChanged() {
        int row = this.pluginsTable.getSelectedRow();
        if (row < 0) {
            this.descriptionTextEditor.setText("<p></p>");
            return;
        }
        PackageInfo pkginfo = ((PackagesTableModel)this.pluginsTable.getModel()).getPackageInfoAt(row);
        this.descriptionTextEditor.setText(this.getFullDescriptionAsHTML(pkginfo));
        this.descriptionTextEditor.setCaretPosition(0);
    }

    public String getFullDescriptionAsHTML(PackageInfo pkginfo) {
        String html = null;
        String lang = Locale.getDefault().getLanguage();
        InputStream res = this.getClass().getClassLoader().getResourceAsStream("org/gvsig/installer/swing/impl/pkg_description_" + lang + ".html");
        if (res == null) {
            res = this.getClass().getClassLoader().getResourceAsStream("org/gvsig/installer/swing/impl/pkg_description_en.html");
        }
        if (res != null) {
            try {
                List lines = IOUtils.readLines((InputStream)res);
                html = StringUtils.join((Iterable)lines, null);
                res.close();
            }
            catch (Exception lines) {
                // empty catch block
            }
        }
        if (html == null) {
            HTMLCoder coder = new HTMLCoder();
            coder.addTitle(pkginfo.getName());
            coder.addParagraph(pkginfo.getDescription());
            coder.addBeginList();
            coder.addListItem("code", pkginfo.getCode());
            coder.addListItem("Organization", pkginfo.getOwner());
            coder.addListItem("Organization URL", pkginfo.getOwnerURL());
            coder.addListItem("Sources", pkginfo.getSourcesURL());
            coder.addListItem("Dependencies", pkginfo.getDependencies());
            coder.addListItem("Categories", pkginfo.getCategoriesAsString());
            coder.addListItem("Official", pkginfo.isOfficial());
            coder.addEndList();
            return coder.toString();
        }
        html = html.replace("${gvsig.package.info.name}", pkginfo.getName());
        html = html.replace("${gvsig.package.info.description}", pkginfo.getDescription());
        html = html.replace("${gvsig.package.info.official}", pkginfo.isOfficial() ? "true" : "false");
        html = html.replace("${gvsig.package.info.official.label}", pkginfo.isOfficial() ? "official" : "community");
        html = html.replace("${gvsig.package.info.owner}", pkginfo.getOwner());
        html = html.replace("${gvsig.package.info.webURL}", pkginfo.getWebURL() == null ? "" : pkginfo.getWebURL().toString());
        html = html.replace("${gvsig.package.info.categories}", pkginfo.getCategoriesAsString());
        html = html.replace("${gvsig.package.info.sourcesURL}", pkginfo.getSourcesURL() == null ? "" : pkginfo.getSourcesURL().toString());
        html = html.replace("${gvsig.package.info.code}", pkginfo.getCode());
        html = html.replace("${gvsig.package.info.dependencies}", pkginfo.getDependencies() == null ? "" : pkginfo.getDependencies().toString());
        html = html.replace("${gvsig.package.info.version}", pkginfo.getVersion() == null ? "" : pkginfo.getVersion().toString());
        html = html.replace("${gvsig.package.info.state}", pkginfo.getState());
        html = html.replace("${gvsig.package.info.operatingSystem}", pkginfo.getOperatingSystem());
        html = html.replace("${gvsig.package.info.architecture}", pkginfo.getArchitecture());
        html = html.replace("${gvsig.package.info.javaVM}", pkginfo.getJavaVM());
        return html;
    }

    public void setFilter(PackageFilter filter) {
        PackagesTableModel pluginsTableModel = (PackagesTableModel)this.pluginsTable.getModel();
        if (this.baseFilter == null) {
            pluginsTableModel.setFilter(filter);
        } else {
            pluginsTableModel.setFilter(new AndFilter().add(this.baseFilter).add(filter));
        }
        this.selectPackagesPanel.updatePanel();
    }

    public void setBaseFilter(PackageFilter filter) {
        this.baseFilter = filter;
        this.setFilter(null);
    }

    public void setEnabledTypeFilter(boolean enabled) {
        this.filterPanel.setEnabledTypeFilter(enabled);
    }

    public SelectPackagesPanel getSelectPackagesPanel() {
        return this.selectPackagesPanel;
    }

    public void clearAllPanels() {
        this.filterPanel.resetPanel();
        this.descriptionTextEditor.setText("");
        this.fastFilterPanel.resetPanel();
    }

    public void resetPanel() {
        this.filterPanel.resetPanel();
        this.descriptionTextEditor.setText("");
    }

    public void setInitialFilter() {
        this.filterPanel.setInitialFilter();
    }

    private class MyMouseListener
    implements MouseListener {
        private MyMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            PackagesTablePanel.this.selectPackagesPanel.checkIfPluginSelected();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private class HTMLCoder {
        private StringBuffer buffer = new StringBuffer();

        private HTMLCoder() {
        }

        public String toString() {
            return this.buffer.toString();
        }

        public void addTitle(String title) {
            if (title == null) {
                return;
            }
            this.buffer.append("<h1>");
            this.buffer.append(title);
            this.buffer.append("</h1>");
        }

        public void addParagraph(Object text) {
            if (text == null) {
                return;
            }
            String t = text.toString().replaceAll("\\n", "<br>\n");
            this.buffer.append("<p>");
            this.buffer.append(t);
            this.buffer.append("</p>");
        }

        public void addBeginList() {
            this.buffer.append("<ul>");
        }

        public void addEndList() {
            this.buffer.append("</ul>");
        }

        public void addListItem(String label, Object value) {
            if (value == null) {
                return;
            }
            this.buffer.append("<li>");
            this.buffer.append(label);
            this.buffer.append(": <i>");
            this.buffer.append(value.toString());
            this.buffer.append("</i></li>");
        }

        public void addListItem(String label, URL value) {
            if (value == null) {
                return;
            }
            this.buffer.append("<li>");
            this.buffer.append(label);
            this.buffer.append(": <a href=\"");
            this.buffer.append(value.toString());
            this.buffer.append("\">");
            this.buffer.append(value.toString());
            this.buffer.append("</a></li>");
        }
    }
}

