/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.prov.kml.parser.v21.coordinates;

import java.io.IOException;
import java.util.StringTokenizer;
import org.gvsig.compat.CompatLocator;
import org.gvsig.gpe.prov.kml.parser.GPEDeafultKmlParser;
import org.gvsig.gpe.prov.kml.parser.v21.coordinates.KmlCoodinatesIterator;
import org.gvsig.gpe.prov.kml.utils.Kml2_1_Tags;
import org.gvsig.xmlpull.lib.api.stream.IQName;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamReader;
import org.gvsig.xmlpull.lib.api.stream.XmlStreamException;

public class CoordinatesTypeIterator
extends KmlCoodinatesIterator {
    private StringTokenizer coordinatesString = null;

    @Override
    public void initialize(IXmlStreamReader parser, GPEDeafultKmlParser handler, IQName lastTag) throws XmlStreamException, IOException {
        super.initialize(parser, handler, lastTag);
        boolean endFeature = false;
        IQName tag = parser.getName();
        int currentTag = parser.getEventType();
        while (!endFeature) {
            switch (currentTag) {
                case 1: {
                    if (!handler.getQNameComparator().equals(tag, Kml2_1_Tags.COORDINATES)) break;
                    parser.next();
                    String coordinatesTag = parser.getText().trim();
                    if (this.dimension == -1) {
                        this.dimension = this.caculateDimension(coordinatesTag);
                    }
                    this.coordinatesString = new StringTokenizer(coordinatesTag);
                    this.parseAll();
                    return;
                }
                case 2: {
                    if (!handler.getQNameComparator().equals(tag, Kml2_1_Tags.COORDINATES)) break;
                    endFeature = true;
                    break;
                }
            }
            if (endFeature) continue;
            currentTag = parser.next();
            tag = parser.getName();
        }
    }

    private int caculateDimension(String coordinatesTag) {
        StringTokenizer st = new StringTokenizer(coordinatesTag);
        String firstPair = st.hasMoreTokens() ? st.nextToken() : coordinatesTag;
        return CompatLocator.getStringUtils().split(firstPair, ",").length;
    }

    public boolean hasNext() throws IOException {
        return this.coordinatesString.hasMoreTokens();
    }

    public void next(double[] buffer) throws IOException {
        String next = this.coordinatesString.nextToken();
        String[] coordinates = CompatLocator.getStringUtils().split(next.trim(), ",");
        for (int i = 0; i < coordinates.length; ++i) {
            buffer[i] = this.handler.getProfile().getDoubleBinding().parse(coordinates[i]);
        }
    }
}

