/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.prov.kml.utils;

import java.awt.Color;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.gvsig.compat.CompatLocator;
import org.gvsig.gpe.lib.api.GPELocator;
import org.gvsig.gpe.lib.api.GPEManager;
import org.gvsig.xmlpull.lib.api.stream.IQName;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamReader;
import org.gvsig.xmlpull.lib.api.stream.XmlStreamException;

public class KmlUtilsParser {
    private static GPEManager gpeManager = GPELocator.getGPEManager();

    public static Hashtable getAttributes(IXmlStreamReader parser) throws XmlStreamException {
        Hashtable<IQName, String> hash = new Hashtable<IQName, String>();
        int num_atributos = parser.getAttributeCount();
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            IQName atributo = parser.getAttributeName(i);
            String valor = parser.getAttributeValue(i);
            if (valor == null) continue;
            hash.put(atributo, valor);
        }
        return hash;
    }

    public static String removeBlancSymbol(IQName tag) {
        if (tag == null) {
            return null;
        }
        String blancSpace = gpeManager.getStringProperty("defaultBlancSpace");
        if (blancSpace == null) {
            blancSpace = "_";
        }
        return CompatLocator.getStringUtils().replaceAll(tag.getLocalPart(), blancSpace, " ");
    }

    public static String addBlancSymbol(QName name) {
        if (name == null) {
            return null;
        }
        String blancSpace = gpeManager.getStringProperty("defaultBlancSpace");
        if (blancSpace == null) {
            blancSpace = "_";
        }
        return CompatLocator.getStringUtils().replaceAll(name.getLocalPart(), " ", blancSpace);
    }

    public static Color fromABGRtoColor(String abgr) {
        long in = Long.decode("#" + abgr);
        int alpha = (int)(in >> 24) & 0xFF;
        int blue = (int)(in >> 16) & 0xFF;
        int green = (int)(in >> 8) & 0xFF;
        int red = (int)(in >> 0) & 0xFF;
        return new Color(red, green, blue, alpha);
    }

    public static String padWith0(String s) {
        if (s.length() < 2) {
            s = "00".substring(0, 2 - s.length()) + s;
        }
        return s;
    }

    public static String fromColorToABGR(Color color) {
        String alpha = KmlUtilsParser.padWith0(Integer.toHexString(color.getAlpha()));
        String blue = KmlUtilsParser.padWith0(Integer.toHexString(color.getBlue()));
        String green = KmlUtilsParser.padWith0(Integer.toHexString(color.getGreen()));
        String red = KmlUtilsParser.padWith0(Integer.toHexString(color.getRed()));
        String abgr = alpha + blue + green + red;
        return abgr;
    }
}

