/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.swing.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.swing.JRViewer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.report.lib.api.Report;
import org.gvsig.report.swing.api.JReport;
import org.gvsig.report.swing.api.ReportSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.util.UnmodifiableBasicList64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJReport
extends JPanel
implements JReport {
    private static Logger LOG = LoggerFactory.getLogger(DefaultJReport.class);
    private Report report;
    private JRViewer vjrviewer;
    private JLabel lblMessage;
    private Expression filter;

    public DefaultJReport(ReportSwingManager manager, Expression filter) {
        this.initComponents();
        this.vjrviewer = null;
        this.report = null;
        this.filter = filter;
    }

    public DefaultJReport(ReportSwingManager manager, Report report, Expression filter) {
        this(manager, filter);
        this.set(report);
    }

    public JComponent asJComponent() {
        return this;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.lblMessage = new JLabel();
        this.lblMessage.setText("|...");
        this.add((Component)this.lblMessage, "Last");
    }

    public void message(final String msg) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefaultJReport.this.message(msg);
                }
            });
            return;
        }
        if (StringUtils.isEmpty((CharSequence)msg)) {
            this.lblMessage.setText("|");
        } else {
            this.lblMessage.setText(msg);
        }
    }

    public Report get(Report report) {
        return this.report;
    }

    public void set(Report report) {
        this.report = report;
        this.removeAll();
        JLabel lblLoading = new JLabel();
        lblLoading.setText("Loading...");
        lblLoading.setHorizontalAlignment(0);
        String iconName = FilenameUtils.getBaseName((String)"report-busy");
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getCurrent();
        if (theme.exists(iconName)) {
            lblLoading.setIcon(theme.get(iconName));
        }
        this.add((Component)lblLoading, "Center");
        this.add((Component)this.lblMessage, "Last");
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                DefaultJReport.this.loadReport();
            }
        }, "gvSIG_ReportLoader");
        th.start();
    }

    private void loadReport() {
        final SimpleTaskStatus status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Report loader");
        status.setIndeterminate();
        status.addObserver(new Observer(){

            public void update(Observable observable, Object notification) {
                if (observable instanceof TaskStatus) {
                    DefaultJReport.this.message(((TaskStatus)observable).getMessage());
                }
            }
        });
        FeatureStore store = this.report.getConfig().getDataSet().getStore();
        Expression theFilter = this.report.getPreparedFilter(this.filter);
        UnmodifiableBasicList64 features = this.report.getConfig().getDataSet().getFeatures(theFilter);
        if (features.isEmpty()) {
            this.message("El informe no tiene datos.");
            return;
        }
        final MutableObject jasperPrint = new MutableObject();
        try {
            jasperPrint.setValue((Object)((JasperPrint)this.report.generateReport(status, features)));
        }
        catch (Exception ex) {
            LOG.warn("Can't create report.", (Throwable)ex);
            jasperPrint.setValue((Object)new JasperPrint());
            this.message("Can't create report (see log for more information)");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultJReport.this.doAddReportViewer(status, (JasperPrint)jasperPrint.getValue());
            }
        });
    }

    private void doAddReportViewer(SimpleTaskStatus status, JasperPrint jasperPrint) {
        status.message("Creating report viewer");
        this.vjrviewer = new JRViewer(jasperPrint);
        status.message("Rebuilding user intrface");
        this.removeAll();
        this.add((Component)this.lblMessage, "Last");
        this.add((Component)this.vjrviewer, "Center");
        this.revalidate();
        status.message("");
        status.terminate();
    }
}

