/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.swing.impl.actions;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALActionFactory;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.report.ReportActionFactory;
import org.gvsig.report.lib.api.Report;
import org.gvsig.report.lib.api.ReportBuilder;
import org.gvsig.report.lib.api.ReportDataSet;
import org.gvsig.report.lib.api.ReportLocator;
import org.gvsig.report.lib.api.ReportManager;
import org.gvsig.report.swing.api.JReport;
import org.gvsig.report.swing.api.JReportBuilder;
import org.gvsig.report.swing.api.ReportSwingLocator;
import org.gvsig.report.swing.api.ReportSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.swing.impl.windowmanager.DefaultDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDefinedReportCustomActionFactory
implements ReportActionFactory.ReportCustomActionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserDefinedReportCustomActionFactory.class);

    public String getName() {
        return "UserDefinedReport";
    }

    public Action createCustomAction(ActionEvent event, final DALActionFactory.DALActionContext context) {
        final I18nManager i18n = ToolsLocator.getI18nManager();
        AbstractAction action = new AbstractAction(i18n.getTranslation("_User_defined")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureType featureType;
                WindowManager_v2 winmgr = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
                ReportSwingManager reportSwingManager = ReportSwingLocator.getReportSwingManager();
                ReportManager reportManager = ReportLocator.getReportManager();
                FeatureStore store = (FeatureStore)context.getStore();
                try {
                    featureType = store.getDefaultFeatureType();
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't get feature type to make JReportBuilder", (Throwable)ex);
                    return;
                }
                ReportBuilder builder = reportManager.createReportBuilder();
                JReportBuilder panel = reportSwingManager.createJReportBuilder();
                panel.setFeatureType(featureType);
                builder.title(store.getName());
                panel.put(builder);
                Dialog dialog = winmgr.createDialog(panel.asJComponent(), i18n.getTranslation("_Report_builder"), null, 7);
                dialog.setAutoclose(false);
                dialog.addActionListener(e1 -> {
                    if (dialog.getAction() == 2) {
                        ((DefaultDialog)dialog).setVisible(false);
                        return;
                    }
                    StringBuilder msg = new StringBuilder();
                    FeatureQuery fquery = context.getQuery();
                    if (fquery != null) {
                        fquery = fquery.getCopy();
                    }
                    panel.setFeatureQuery(fquery);
                    if (!panel.checkPanel(msg)) {
                        return;
                    }
                    ReportBuilder fetchBuilder = reportManager.createReportBuilder();
                    panel.fetch(fetchBuilder);
                    if (dialog.getAction() == 1) {
                        ((DefaultDialog)dialog).setVisible(false);
                    }
                    ReportDataSet reportDataSet = reportManager.createDataSet(store, fquery);
                    Report report = fetchBuilder.toReport(reportDataSet);
                    UserDefinedReportCustomActionFactory.this.doShowReport(report, context);
                });
                dialog.show(WindowManager.MODE.WINDOW);
            }
        };
        return action;
    }

    private void doShowReport(Report report, DALActionFactory.DALActionContext context) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager winManager = ToolsSwingLocator.getWindowManager();
        ReportSwingManager swingManager = ReportSwingLocator.getReportSwingManager();
        FeatureQuery query = context.getQuery();
        if (query != null) {
            query = query.getCopy();
        }
        Expression filter = null;
        if (context.getSelectedsCount() > 0) {
            filter = context.getFilterForSelecteds();
        } else if (query != null) {
            filter = query.getExpressionFilter();
        }
        if (query != null) {
            query.retrievesAllAttributes();
        }
        JReport reportPanel = swingManager.createJReport(report, filter);
        reportPanel.asJComponent().setPreferredSize(new Dimension(800, 500));
        winManager.showWindow(reportPanel.asJComponent(), i18n.getTranslation("_Report") + ": " + report.getName(), WindowManager.MODE.WINDOW);
    }

    public static void selfRegister() {
        DataSwingManager dalSwingManager = DALSwingLocator.getSwingManager();
        dalSwingManager.registerReportsCustomAction((ReportActionFactory.ReportCustomActionFactory)new UserDefinedReportCustomActionFactory(), true);
    }
}

