/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.swing.impl.reportbuilder;

import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import org.gvsig.report.lib.api.ReportBuilder;
import org.gvsig.report.swing.impl.reportbuilder.DefaultJReportColumnBuilderController;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.util.LabeledValueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJReportGroupController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJReportColumnBuilderController.class);
    private final JComboBox cboGroupLayout;
    private final JCheckBox chkStartNewColumn;
    private final JCheckBox chkStartNewPage;
    private ReportBuilder.GroupBuilder groupBuilder;

    public DefaultJReportGroupController(JComboBox cboGroupLayout, JCheckBox chkStartNewColumn, JCheckBox chkStartNewPage) {
        this.cboGroupLayout = cboGroupLayout;
        this.chkStartNewColumn = chkStartNewColumn;
        this.chkStartNewPage = chkStartNewPage;
        this.initComponents();
    }

    public void fetch(ReportBuilder.GroupBuilder groupBuilder) {
        this.groupBuilder.startInNewColumn(this.chkStartNewColumn.isSelected());
        this.groupBuilder.startInNewPage(this.chkStartNewPage.isSelected());
        Integer layoutGroupValue = (Integer)((LabeledValueImpl)this.cboGroupLayout.getSelectedItem()).getValue();
        this.groupBuilder.groupLayout(layoutGroupValue.intValue());
        groupBuilder.copyFrom(this.groupBuilder);
    }

    public void put(ReportBuilder.GroupBuilder groupBuilder) {
        this.groupBuilder = groupBuilder;
        ComboBoxModel model = this.cboGroupLayout.getModel();
        int groupLayout = this.groupBuilder.getGroupLayout();
        for (int i = 0; i < model.getSize(); ++i) {
            LabeledValueImpl object = (LabeledValueImpl)model.getElementAt(i);
            if (!((Integer)object.getValue()).equals(groupLayout)) continue;
            this.cboGroupLayout.setSelectedIndex(i);
            break;
        }
        this.chkStartNewColumn.setSelected(this.groupBuilder.getStartInNewColumn());
        this.chkStartNewPage.setSelected(this.groupBuilder.getStartInNewPage());
    }

    public void setEnabled(Boolean enabled) {
        this.cboGroupLayout.setEnabled(enabled);
        this.chkStartNewColumn.setEnabled(enabled);
        this.chkStartNewPage.setEnabled(enabled);
    }

    public void clean() {
        this.cboGroupLayout.setSelectedIndex(0);
        this.chkStartNewColumn.setEnabled(false);
        this.chkStartNewPage.setEnabled(false);
    }

    private void initComponents() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.cboGroupLayout.addItem(new LabeledValueImpl(i18n.getTranslation("_Default"), (Object)0));
        this.cboGroupLayout.addItem(new LabeledValueImpl(i18n.getTranslation("_Default_with_headers"), (Object)1));
        this.cboGroupLayout.addItem(new LabeledValueImpl(i18n.getTranslation("_Empty"), (Object)2));
        this.cboGroupLayout.addItem(new LabeledValueImpl(i18n.getTranslation("_Value_for_each"), (Object)3));
        this.cboGroupLayout.addItem(new LabeledValueImpl(i18n.getTranslation("_Value_for_each_with_headers"), (Object)4));
        this.cboGroupLayout.addItem(new LabeledValueImpl(i18n.getTranslation("_Value_in_header"), (Object)5));
        this.cboGroupLayout.addItem(new LabeledValueImpl(i18n.getTranslation("_Value_in_header_and_for_each"), (Object)6));
        this.cboGroupLayout.addItem(new LabeledValueImpl(i18n.getTranslation("_Value_in_header_and_for_each_with_header"), (Object)7));
        this.cboGroupLayout.addItem(new LabeledValueImpl(i18n.getTranslation("_Value_in_header_with_headers"), (Object)8));
        this.cboGroupLayout.addItem(new LabeledValueImpl(i18n.getTranslation("_value_in_header_with_headers_and_column_name"), (Object)9));
        this.setEnabled(false);
    }
}

