/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.extension.InitializeApplicationExtension;
import org.gvsig.app.extension.copytable.CopyTable2ProcessParametersImpl;
import org.gvsig.app.gui.preferencespage.AppSymbolPreferences;
import org.gvsig.app.project.DefaultProject;
import org.gvsig.app.project.documents.view.dynformfield.linkforeingkeywgs.JDynFormFieldForeingKeyWGSFactory;
import org.gvsig.app.project.documents.view.expressionevaluator.ViewElementFactory;
import org.gvsig.app.project.documents.view.expressionevaluator.savedpoints.SavedPointsElementFactory;
import org.gvsig.app.project.symboltables.ProjectSymbolTableFactory;
import org.gvsig.app.project.symboltables.functionPanels.area.AreaAditionalPanelFactory;
import org.gvsig.app.project.symboltables.functionPanels.perimeter.PerimeterAditionalPanelFactory;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLibrary;
import org.gvsig.fmap.mapcontext.MapContextLibrary;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolPreferences;
import org.gvsig.fmap.mapcontrol.MapControlLibrary;
import org.gvsig.i18n.Messages;
import org.gvsig.installer.lib.api.InstallerLibrary;
import org.gvsig.tools.library.AbstractLibrary;
import org.gvsig.tools.library.LibraryException;
import org.gvsig.tools.locator.Locator;
import org.gvsig.tools.locator.ReferenceNotRegisteredException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationLibrary
extends AbstractLibrary {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationLibrary.class);

    public void doRegistration() {
        this.registerAsAPI(ApplicationLibrary.class);
        this.require(MapContextLibrary.class);
        this.require(MapControlLibrary.class);
        this.require(InstallerLibrary.class);
        this.require(ExpressionEvaluatorLibrary.class);
    }

    protected void doInitialize() throws LibraryException {
    }

    protected void doPostInitialize() throws LibraryException {
        ApplicationManager manager = ApplicationLocator.getManager();
        if (manager == null) {
            throw new ReferenceNotRegisteredException("gvSIGApplicationLocator.manager", (Locator)ApplicationLocator.getInstance());
        }
        DefaultProject.registerPersistent();
        MapContextManager mapContextManager = MapContextLocator.getMapContextManager();
        PluginServices plugin = PluginsLocator.getManager().getPlugin(InitializeApplicationExtension.class);
        mapContextManager.setColorTableLibraryFolder(new File(plugin.getPluginHomeFolder(), "colortable"));
        MapContextLocator.getSymbolManager().setSymbolPreferences((SymbolPreferences)new AppSymbolPreferences());
        this.installBaseSymbols();
        ProjectSymbolTableFactory.selfRegister();
        AreaAditionalPanelFactory.selfRegister();
        PerimeterAditionalPanelFactory.selfRegister();
        ViewElementFactory.selfRegister();
        SavedPointsElementFactory.selfRegister();
        JDynFormFieldForeingKeyWGSFactory.selfRegister();
        CopyTable2ProcessParametersImpl.selfRegister();
    }

    private void installBaseSymbols() {
        PluginServices ps = PluginsLocator.getManager().getPlugin(InitializeApplicationExtension.class);
        File from_folder = new File(ps.getPluginDirectory(), "Symbols");
        String to_folder = MapContextLocator.getSymbolManager().getSymbolPreferences().getSymbolLibraryPath();
        try {
            this.copyMissingFolders(from_folder, new File(to_folder));
        }
        catch (IOException ioe) {
            ApplicationLocator.getManager().message(Messages.getText((String)"_Unable_to_copy_symbols_from_main_plugin"), 0);
        }
    }

    private void copyMissingFolders(File fromf, File tof) throws IOException {
        if (fromf == null || tof == null) {
            return;
        }
        if (!fromf.exists() || !fromf.isDirectory() || tof.exists() && tof.isFile()) {
            return;
        }
        if (!tof.exists()) {
            tof.mkdirs();
        }
        File[] from_subs = fromf.listFiles();
        for (int i = 0; i < from_subs.length; ++i) {
            if (!this.folderIsOneIn(from_subs[i], tof)) {
                logger.info("Copying symbols subfolder: " + from_subs[i].getName());
                FileUtils.copyDirectoryToDirectory((File)from_subs[i], (File)tof);
                continue;
            }
            logger.info("Symbols subfolder already exists: " + from_subs[i].getName());
        }
    }

    private boolean folderIsOneIn(File folder, File tofolder) {
        if (!folder.isDirectory()) {
            return false;
        }
        String name = folder.getName();
        String tname = tofolder.getAbsolutePath() + File.separator + name;
        File tfile = new File(tname);
        return tfile.exists();
    }
}

