/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.copytable;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.extension.copytable.CopyTable2PanelView;
import org.gvsig.app.extension.copytable.CopyTable2ProcessParameters;
import org.gvsig.app.extension.copytable.CopyTable2ProcessParametersImpl;
import org.gvsig.configurableactions.ConfigurableActionsMamager;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.expressionevaluator.swing.JExpressionPicker;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.featuretype.AttributeDescriptorPickerController;
import org.gvsig.fmap.dal.swing.storesrepository.StoresRepositoryController;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.bookmarksandhistory.Bookmarks;
import org.gvsig.tools.bookmarksandhistory.History;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.bookmarkshistory.ActionEventWithCurrentValue;
import org.gvsig.tools.swing.api.bookmarkshistory.BookmarksController;
import org.gvsig.tools.swing.api.bookmarkshistory.HistoryController;
import org.gvsig.tools.swing.api.documentfilters.IntegerDocumentFilter;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.util.ToolsUtilLocator;

public class CopyTable2Panel
extends CopyTable2PanelView {
    private static final String BOOKMARKSANDHISTORY_NAME = "CopyTablePanel";
    private static final String CONFIGURABLE_PANEL_ID = "CopyTablePanel";
    private static final Integer MAX_DISTANCE_TO_ASSIGN_FIELD = 3;
    private AttributeDescriptorPickerController pickerSourceFieldJoin;
    private FeatureStore source;
    private FeatureStore target;
    private AttributeDescriptorPickerController pickerTargetFieldJoin;
    private ExpressionPickerController pickerSourceFilter;
    private ExpressionPickerController pickerTargetUpdateExpression;
    private DefaultTableColumnModel fieldsColumnModel;
    private SimpleTaskStatus taskStatus;
    private TaskStatusController status;
    private StoresRepositoryController treeSourceTableController;
    private StoresRepositoryController treeTargetTableController;
    private final Bookmarks bookmarks = ToolsLocator.getBookmarksAndHistoryManager().getBookmarksGroup("CopyTablePanel");
    private final History history = ToolsLocator.getBookmarksAndHistoryManager().getHistoryGroup("CopyTablePanel");
    private BookmarksController bookmarksController;
    private HistoryController historyController;
    private ExpressionPickerController pickerJoinExpression;
    private DataSwingManager dataSwingManager;

    public CopyTable2Panel() {
        this.initComponents();
    }

    private DataSwingManager getDataSwingManager() {
        if (this.dataSwingManager == null) {
            this.dataSwingManager = DALSwingLocator.getSwingManager();
        }
        return this.dataSwingManager;
    }

    private void initComponents() {
        ExpressionEvaluatorSwingManager expressionSwingManager = ExpressionEvaluatorSwingLocator.getManager();
        this.status = ToolsSwingLocator.getTaskStatusSwingManager().createTaskStatusController(this.lblStatusLabel, this.lblStatusMessage, this.pbStatus);
        ConfigurableActionsMamager cfgActionsManager = ToolsUtilLocator.getConfigurableActionsMamager();
        cfgActionsManager.addConfigurableActions("CopyTablePanel", (Object)this, (JComponent)this.btnConfigurableActions);
        this.bookmarksController = ToolsSwingLocator.getToolsSwingManager().createBookmarksController(this.bookmarks, this.btnBookmarks);
        this.historyController = ToolsSwingLocator.getToolsSwingManager().createHistoryController(this.history, this.btnHistory);
        this.historyController.setFilter(null);
        ActionListener bookmarksAndHistoryListener = e -> {
            ActionEventWithCurrentValue event = (ActionEventWithCurrentValue)e;
            switch (event.getID()) {
                case 1002: {
                    event.setCurrentValue((Object)this.fetch(null));
                    break;
                }
                case 1001: {
                    this.put((CopyTable2ProcessParameters)event.getCurrentValue());
                    this.doUpdateComponents();
                }
            }
        };
        this.historyController.addActionListener(bookmarksAndHistoryListener);
        this.bookmarksController.addActionListener(bookmarksAndHistoryListener);
        this.treeSourceTableController = this.getDataSwingManager().createStoresRepositoryController(this.treeSourceTable);
        this.treeSourceTable.addTreeSelectionListener(e -> {
            this.doChangeSource();
            this.doUpdateComponents();
        });
        this.pickerSourceFieldJoin = this.getDataSwingManager().createAttributeDescriptorPickerController(this.cboSourceJoinField);
        this.pickerSourceFieldJoin.setAllowNull(true);
        this.pickerSourceFieldJoin.addChangeListener(e -> this.doUpdateComponents());
        this.treeTargetTableController = this.getDataSwingManager().createStoresRepositoryController(this.treeTargetTable);
        this.treeTargetTable.addTreeSelectionListener(e -> {
            this.doChangeTarget();
            this.doUpdateComponents();
        });
        this.pickerTargetFieldJoin = this.getDataSwingManager().createAttributeDescriptorPickerController(this.cboTargetJoinField);
        this.pickerTargetFieldJoin.setAllowNull(true);
        this.pickerTargetFieldJoin.addChangeListener(e -> this.doUpdateComponents());
        this.pickerSourceFilter = expressionSwingManager.createExpressionPickerController((JTextComponent)this.txtSourceFilter, this.btnSourceFilter, this.btnSourceFilterBookmarks, this.btnSourceFilterHistory);
        this.pickerTargetUpdateExpression = expressionSwingManager.createExpressionPickerController((JTextComponent)this.txtTargetUpdateWhenExpression, this.btnTargetUpdateWhenExpression, this.btnTargetUpdateWhenExpressionBookmarks, this.btnTargetUpdateWhenExpressionHistory);
        this.chkTargetInsertIfNotExistsInTarget.setSelected(false);
        this.chkTargetInsertIfNotExistsInTarget.addChangeListener(e -> this.doUpdateComponents());
        this.chkTargetUpdateIfExistsInTarget.setSelected(false);
        this.chkTargetUpdateIfExistsInTarget.addChangeListener(e -> this.doUpdateComponents());
        this.chkTargetDeleteIfNotExiststInSource.setEnabled(false);
        this.chkTargetDeleteIfNotExiststInSource.addChangeListener(e -> this.doUpdateComponents());
        this.tableFields.setAutoCreateColumnsFromModel(false);
        this.tableFields.setSelectionMode(0);
        this.fieldsColumnModel = new DefaultTableColumnModel();
        this.rdbUseJoinExpression.addActionListener(e -> this.doUpdateComponents());
        this.rdbUseJoinField.addActionListener(e -> this.doUpdateComponents());
        this.pickerJoinExpression = expressionSwingManager.createExpressionPickerController((JTextComponent)this.txtJoinExpression, this.btnJoinExpression, this.btnJoinExpressionBookmarks, this.btnJoinExpressionHistory);
        TableColumn column = new TableColumn();
        column.setHeaderValue("Actualizar");
        column.setCellRenderer(null);
        column.setResizable(true);
        column.setModelIndex(0);
        this.fieldsColumnModel.addColumn(column);
        column = new TableColumn();
        column.setHeaderValue("Campo destino");
        column.setCellRenderer((TableCellRenderer)this.getDataSwingManager().createDefaultFeatureAttributeTableCellRenderer());
        column.setCellEditor(null);
        column.setResizable(true);
        column.setModelIndex(1);
        this.fieldsColumnModel.addColumn(column);
        column = new TableColumn();
        column.setHeaderValue("Campo origen");
        column.setCellRenderer(null);
        column.setCellEditor(new ExpressionCellEditor());
        column.setResizable(true);
        column.setModelIndex(2);
        this.fieldsColumnModel.addColumn(column);
        this.btnCheckAllFields.addActionListener(e -> this.doSetAllChecksOfFields(true));
        this.btnUnCheckAllFields.addActionListener(e -> this.doSetAllChecksOfFields(false));
        this.tableFields.setColumnModel(this.fieldsColumnModel);
        SwingUtilities.invokeLater(() -> {
            this.lblStatusLabel.setText("");
            this.lblStatusMessage.setText("");
            this.pbStatus.setVisible(false);
        });
        this.lblJoinExpressionMsg.setText("<html>" + this.lblJoinExpressionMsg.getText() + "</html>");
        this.doUpdateComponents();
        Dimension screensize = ApplicationLocator.getApplicationManager().getUIManager().getInternalSize();
        ToolsSwingUtils.ensureHeightWitdh((JComponent)this, (int)Math.max(3 * (screensize.height / 4), ToolsSwingUtils.rows2px((int)80)), (int)Math.max(2 * (screensize.width / 4), ToolsSwingUtils.cols2px((int)35)), (int)(7 * (screensize.height / 8)), (int)(3 * (screensize.width / 4)));
    }

    private void doSetAllChecksOfFields(boolean check) {
        MyTableModel model = (MyTableModel)this.tableFields.getModel();
        for (MyTableModel.Row row : model) {
            row.set(0, check);
        }
        model.fireTableDataChanged();
    }

    private void translate() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate((AbstractButton)this.rdbUpdateAlways);
        toolsSwingManager.translate((AbstractButton)this.rdbUpdateWhenConditionIsMet);
        toolsSwingManager.translate((AbstractButton)this.rdbUpdateWhenRecordChanged);
    }

    private void doUpdateComponents() {
        this.translate();
        this.treeSourceTableController.setEnabled(true);
        this.pickerSourceFieldJoin.setEnabled(this.source != null);
        this.pickerSourceFilter.setEnabled(this.source != null);
        this.treeTargetTableController.setEnabled(this.source != null);
        this.btnCheckAllFields.setEnabled(this.source != null && this.target != null);
        this.btnUnCheckAllFields.setEnabled(this.source != null && this.target != null);
        this.rdbUseJoinField.setEnabled(this.source != null && this.target != null);
        this.rdbUseJoinExpression.setEnabled(this.source != null && this.target != null);
        this.rdbNotJoin.setEnabled(this.source != null && this.target != null);
        this.pickerTargetFieldJoin.setEnabled(this.source != null && this.target != null && this.rdbUseJoinField.isSelected() && this.rdbUseJoinField.isEnabled() && this.pickerSourceFieldJoin.getName() != null);
        this.pickerJoinExpression.setEnabled(this.source != null && this.target != null && this.rdbUseJoinExpression.isSelected() && this.rdbUseJoinExpression.isEnabled());
        this.chkTargetInsertIfNotExistsInTarget.setEnabled(this.source != null && this.target != null && (this.pickerSourceFieldJoin.getName() != null && this.pickerTargetFieldJoin.getName() != null || this.rdbUseJoinExpression.isSelected()));
        this.chkTargetUpdateIfExistsInTarget.setEnabled(this.source != null && this.target != null && (this.pickerSourceFieldJoin.getName() != null && this.pickerTargetFieldJoin.getName() != null || this.rdbUseJoinExpression.isSelected()));
        this.chkTargetDeleteIfNotExiststInSource.setEnabled(false);
        this.rdbUpdateWhenRecordChanged.setEnabled(this.chkTargetUpdateIfExistsInTarget.isSelected());
        this.rdbUpdateWhenConditionIsMet.setEnabled(this.chkTargetUpdateIfExistsInTarget.isSelected());
        this.rdbUpdateAlways.setEnabled(this.chkTargetUpdateIfExistsInTarget.isSelected());
        this.pickerTargetUpdateExpression.setEnabled(this.rdbUpdateWhenConditionIsMet.isSelected());
        if (!this.pickerSourceFieldJoin.isEnabled()) {
            this.pickerSourceFieldJoin.clean();
        }
        if (!this.pickerTargetFieldJoin.isEnabled()) {
            this.pickerTargetFieldJoin.clean();
        }
        if (!this.chkTargetInsertIfNotExistsInTarget.isEnabled()) {
            this.chkTargetInsertIfNotExistsInTarget.setSelected(false);
        }
        if (!this.chkTargetUpdateIfExistsInTarget.isEnabled()) {
            this.chkTargetUpdateIfExistsInTarget.setSelected(false);
        }
        if (!this.chkTargetDeleteIfNotExiststInSource.isEnabled()) {
            this.chkTargetDeleteIfNotExiststInSource.setSelected(false);
        }
        if (!this.pickerSourceFilter.isEnabled()) {
            this.pickerSourceFilter.set(null);
        }
    }

    private void doChangeSource() {
        FeatureStore theSource = this.treeSourceTableController.getSelectedFeatureStore();
        if (theSource == null) {
            return;
        }
        if (this.source != null) {
            DisposeUtils.disposeQuietly((Disposable)this.source);
        }
        this.source = theSource;
        this.getDataSwingManager().resetExpressionBuilder(this.pickerTargetUpdateExpression.getConfig());
        this.getDataSwingManager().resetExpressionBuilder(this.pickerJoinExpression.getConfig());
        this.getDataSwingManager().addToExpressionBuilder(this.pickerTargetUpdateExpression.getConfig(), this.source, "source");
        this.getDataSwingManager().addToExpressionBuilder(this.pickerJoinExpression.getConfig(), this.source, "source", true);
        this.pickerSourceFieldJoin.setFeatureType(this.source.getDefaultFeatureTypeQuietly());
        try {
            this.pickerSourceFieldJoin.set((Object)this.source.getDefaultFeatureTypeQuietly().getPrimaryKey()[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.target != null) {
            this.tableFields.setModel(new MyTableModel());
            this.getDataSwingManager().addToExpressionBuilder(this.pickerTargetUpdateExpression.getConfig(), this.target, "target");
            this.getDataSwingManager().addToExpressionBuilder(this.pickerJoinExpression.getConfig(), this.target, "target");
        }
    }

    private void doChangeTarget() {
        FeatureStore theTarget = this.treeTargetTableController.getSelectedFeatureStore();
        if (theTarget == null) {
            return;
        }
        if (this.target != null) {
            DisposeUtils.disposeQuietly((Disposable)this.target);
        }
        this.target = theTarget;
        this.getDataSwingManager().resetExpressionBuilder(this.pickerTargetUpdateExpression.getConfig());
        this.getDataSwingManager().resetExpressionBuilder(this.pickerJoinExpression.getConfig());
        this.getDataSwingManager().addToExpressionBuilder(this.pickerTargetUpdateExpression.getConfig(), this.target, "target");
        this.getDataSwingManager().addToExpressionBuilder(this.pickerJoinExpression.getConfig(), this.target, "target");
        this.pickerTargetFieldJoin.setFeatureType(this.target.getDefaultFeatureTypeQuietly());
        try {
            this.pickerTargetFieldJoin.set((Object)this.target.getDefaultFeatureTypeQuietly().getPrimaryKey()[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.source != null) {
            this.tableFields.setModel(new MyTableModel());
            this.getDataSwingManager().addToExpressionBuilder(this.pickerTargetUpdateExpression.getConfig(), this.source, "source");
            this.getDataSwingManager().addToExpressionBuilder(this.pickerJoinExpression.getConfig(), this.source, "source", true);
        }
    }

    public SimpleTaskStatus getStatus() {
        if (this.taskStatus == null) {
            this.taskStatus = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Copy table");
            this.status.bind((TaskStatus)this.taskStatus);
        }
        this.lblStatusLabel.setVisible(true);
        this.lblStatusMessage.setVisible(true);
        this.pbStatus.setVisible(true);
        return this.taskStatus;
    }

    public void put(CopyTable2ProcessParameters params) {
        FeatureStore sourceStore = params.getSourceStore();
        this.treeSourceTableController.setSelectedStore(sourceStore);
        this.doChangeSource();
        FeatureStore targetStore = params.getTargetStore();
        this.treeTargetTableController.setSelectedStore(targetStore);
        this.doChangeTarget();
        this.pickerSourceFieldJoin.set(params.getSourceFieldForJoin());
        this.pickerSourceFilter.set((Object)params.getSourceFilter());
        this.pickerTargetFieldJoin.set(params.getTargetFieldForJoin());
        this.pickerTargetUpdateExpression.set((Object)params.getUpdateIfExistsInTargetCondition());
        this.chkTargetInsertIfNotExistsInTarget.setSelected(params.isInsertIfNotExistsTargetActive());
        this.chkTargetUpdateIfExistsInTarget.setSelected(params.isUpdateIfExistsTargetActive());
        this.chkTargetDeleteIfNotExiststInSource.setSelected(params.isDeleteIfNotExiststInSourceActive());
        MyTableModel fieldsModel = new MyTableModel();
        this.tableFields.setModel(fieldsModel);
        for (MyTableModel.Row row : fieldsModel.rows) {
            CopyTable2ProcessParameters.ProcessFieldParameters paramfield = params.get(row.getAttrname());
            row.setAttrname(paramfield.getName());
            Expression expression = paramfield.getExpression();
            if (expression != null) {
                row.setExpression(expression.getPhrase());
            } else {
                row.setExpression(null);
            }
            row.setUpdate(paramfield.isCopyThisFieldActive());
        }
        fieldsModel.fireTableDataChanged();
        switch (params.getEditMode()) {
            default: {
                this.rdoOptionsFulledit.setSelected(true);
                this.rdoOptionsPassthrought.setSelected(false);
                break;
            }
            case 3: {
                this.rdoOptionsFulledit.setSelected(false);
                this.rdoOptionsPassthrought.setSelected(true);
            }
        }
        this.chkOptionsBeginEditIfNeed.setSelected(params.isBeginEditIfNeed());
        this.chkOptionsFinishAndRestarEditEach.setSelected(params.isFinishAndRestarEdit());
        this.chkOptionsNotifyUserIfNeedBeginEditing.setSelected(params.isNotifyUserIfNeedBeginEditing());
        this.chkOptionsFinishEditAfterTerminate.setSelected(params.isFinishEditAfterTerminate());
        IntegerDocumentFilter.setValue((JTextField)this.txtOptionsFinishAndRestarEditEach, (int)params.getFinishAndRestarEditEach());
    }

    public CopyTable2ProcessParameters fetch(CopyTable2ProcessParameters params) {
        if (params == null) {
            params = new CopyTable2ProcessParametersImpl();
        }
        params.setSourceStore(this.source);
        params.setSourceFilter(this.pickerSourceFilter.get());
        params.setSourceFieldForJoin(this.pickerSourceFieldJoin.getName());
        params.setTargetStore(this.target);
        if (this.rdbUseJoinExpression.isSelected()) {
            params.setTargetFieldForJoin(null);
            params.setJoinExpression(this.pickerJoinExpression.get());
        } else if (this.rdbUseJoinField.isSelected()) {
            params.setTargetFieldForJoin(this.pickerTargetFieldJoin.getName());
            params.setJoinExpression(null);
        } else {
            params.setTargetFieldForJoin(null);
            params.setJoinExpression(null);
        }
        params.setInsertIfNotExistsTargetActive(this.chkTargetInsertIfNotExistsInTarget.isSelected());
        if (this.chkTargetUpdateIfExistsInTarget.isSelected()) {
            if (this.rdbUpdateAlways.isSelected()) {
                params.setUpdateIfExistsInTargetCondition(null);
                params.setUpdateIfExistsTargetActive(true);
                params.setMustUpdateIfSourceAndTargetAreNotEquals(false);
            } else if (this.rdbUpdateWhenRecordChanged.isSelected()) {
                params.setUpdateIfExistsInTargetCondition(null);
                params.setUpdateIfExistsTargetActive(true);
                params.setMustUpdateIfSourceAndTargetAreNotEquals(true);
            } else if (this.rdbUpdateWhenConditionIsMet.isSelected()) {
                params.setUpdateIfExistsInTargetCondition(this.pickerTargetUpdateExpression.get());
                params.setUpdateIfExistsTargetActive(true);
                params.setMustUpdateIfSourceAndTargetAreNotEquals(false);
            }
        } else {
            params.setUpdateIfExistsInTargetCondition(null);
            params.setUpdateIfExistsTargetActive(false);
            params.setMustUpdateIfSourceAndTargetAreNotEquals(false);
        }
        params.setDeleteIfNotExiststInSourceActive(this.chkTargetDeleteIfNotExiststInSource.isSelected());
        this.fetch_fields(params);
        this.fetch_options(params);
        return params;
    }

    private void fetch_fields(CopyTable2ProcessParameters params) {
        if (this.tableFields.isEditing()) {
            this.tableFields.getCellEditor().stopCellEditing();
        }
        MyTableModel model = (MyTableModel)this.tableFields.getModel();
        for (MyTableModel.Row row : model) {
            Expression exp = null;
            if (StringUtils.isNotBlank((CharSequence)row.getExpression())) {
                exp = ExpressionUtils.createExpression((String)row.getExpression());
            }
            params.add(row.getAttrname(), row.isUpdate(), exp);
        }
    }

    private void fetch_options(CopyTable2ProcessParameters params) {
        if (this.rdoOptionsFulledit.isSelected()) {
            params.setEditMode(1);
        } else {
            params.setEditMode(3);
        }
        params.setBeginEditIfNeed(this.chkOptionsBeginEditIfNeed.isSelected());
        params.setFinishAndRestarEdit(this.chkOptionsFinishAndRestarEditEach.isSelected());
        params.setNotifyUserIfNeedBeginEditing(this.chkOptionsNotifyUserIfNeedBeginEditing.isSelected());
        params.setFinishEditAfterTerminate(this.chkOptionsFinishEditAfterTerminate.isSelected());
        params.setFinishAndRestarEditEach(IntegerDocumentFilter.getValue((JTextField)this.txtOptionsFinishAndRestarEditEach));
    }

    void message(String msg) {
        this.lblStatusMessage.setText(msg);
    }

    void addHistory(CopyTable2ProcessParameters params) {
        this.history.add((Object)params);
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        String name = FilenameUtils.getBaseName((String)imageName);
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getDefault();
        if (theme.exists(name)) {
            return theme.get(name);
        }
        URL url = CopyTable2Panel.class.getResource("images/" + name + ".png");
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }

    private class MyTableModel
    extends AbstractTableModel
    implements Iterable<Row> {
        private final List<Row> rows = new ArrayList<Row>();
        private final String[] columnNames;
        private final Class[] columnClass;
        private FeatureType tableType = null;

        public MyTableModel() {
            if (CopyTable2Panel.this.target != null) {
                this.tableType = CopyTable2Panel.this.target.getDefaultFeatureTypeQuietly();
                for (FeatureAttributeDescriptor targetAttr : this.tableType) {
                    Row row = new Row(CopyTable2Panel.this.getDataSwingManager().getAttributeDescriptorLabel(targetAttr), targetAttr.getName(), this.getSourceExpression(targetAttr.getName()), !targetAttr.isComputed());
                    this.rows.add(row);
                }
            }
            for (Row row : this.rows) {
                if (row.getExpression() == null) continue;
                boolean dup = false;
                for (Row row1 : this.rows) {
                    if (row == row1 || !StringUtils.equalsIgnoreCase((CharSequence)row.getExpression(), (CharSequence)row1.getExpression())) continue;
                    dup = true;
                    row1.setExpression(null);
                }
                if (!dup) continue;
                row.setExpression(null);
            }
            this.columnNames = new String[]{"Actualizar", "Campo", "Expresion"};
            this.columnClass = new Class[]{Boolean.class, String.class, String.class};
        }

        final String getSourceExpression(String targetFieldName) {
            FeatureType sourceType = CopyTable2Panel.this.source.getDefaultFeatureTypeQuietly();
            ExpressionBuilder expBuilder = CopyTable2Panel.this.source.createExpressionBuilder();
            Integer minDistance = Integer.MAX_VALUE;
            String minDistanceSourceFieldName = null;
            FeatureAttributeDescriptor attr = sourceType.getAttributeDescriptor(targetFieldName);
            if (attr != null) {
                return expBuilder.identifier(attr.getName());
            }
            for (FeatureAttributeDescriptor featureAttributeDescriptor : sourceType) {
                String sourceFieldName = featureAttributeDescriptor.getName();
                if (StringUtils.containsIgnoreCase((CharSequence)targetFieldName, (CharSequence)sourceFieldName)) {
                    return expBuilder.identifier(sourceFieldName);
                }
                if (StringUtils.containsIgnoreCase((CharSequence)sourceFieldName, (CharSequence)targetFieldName)) {
                    return expBuilder.identifier(sourceFieldName);
                }
                Integer distance = LevenshteinDistance.getDefaultInstance().apply((CharSequence)targetFieldName, (CharSequence)sourceFieldName);
                if (distance >= minDistance) continue;
                minDistanceSourceFieldName = sourceFieldName;
                minDistance = distance;
            }
            if (minDistance <= MAX_DISTANCE_TO_ASSIGN_FIELD) {
                return expBuilder.identifier(minDistanceSourceFieldName);
            }
            return null;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.columnClass[columnIndex];
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: 
                case 2: {
                    return this.rows.get(rowIndex).get(columnIndex);
                }
                case 1: {
                    FeatureAttributeDescriptor attrdesc = this.tableType.getAttributeDescriptor(this.rows.get(rowIndex).getAttrname());
                    return attrdesc;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.rows.get(rowIndex).set(columnIndex, aValue);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            FeatureAttributeDescriptor attrdesc = this.tableType.getAttributeDescriptor(rowIndex);
            if (attrdesc == null) {
                return false;
            }
            switch (columnIndex) {
                case 1: {
                    return false;
                }
            }
            return true;
        }

        @Override
        public Iterator<Row> iterator() {
            return this.rows.iterator();
        }

        @Override
        public void fireTableDataChanged() {
            super.fireTableDataChanged();
        }

        private class Row {
            String attrname;
            String attrlabel;
            String expression;
            boolean update;

            public Row(String attrlabel, String attrname, String expression, boolean update) {
                this.attrlabel = attrlabel;
                this.attrname = attrname;
                this.expression = expression;
                this.update = update;
            }

            public Object get(int index) {
                switch (index) {
                    case 0: {
                        return this.update;
                    }
                    case 1: {
                        return this.attrlabel;
                    }
                    case 2: {
                        return this.expression;
                    }
                }
                return null;
            }

            public void set(int index, Object value) {
                switch (index) {
                    case 0: {
                        this.update = (Boolean)value;
                        break;
                    }
                    case 1: {
                        this.attrlabel = (String)value;
                        break;
                    }
                    case 2: {
                        this.expression = (String)value;
                        break;
                    }
                }
            }

            public String getAttrname() {
                return this.attrname;
            }

            public String getExpression() {
                return this.expression;
            }

            public boolean isUpdate() {
                return this.update;
            }

            private void setExpression(String expression) {
                this.expression = expression;
            }

            private void setUpdate(boolean update) {
                this.update = update;
            }

            private void setAttrname(String name) {
                this.attrname = name;
                this.attrlabel = name;
            }
        }
    }

    private class ExpressionCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final JExpressionPicker picker;

        public ExpressionCellEditor() {
            ExpressionEvaluatorSwingManager manager = ExpressionEvaluatorSwingLocator.getManager();
            this.picker = manager.createJExpressionPicker();
            this.picker.removeBorder();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jtable, Object value, boolean isSelected, int row, int column) {
            try {
                DataSwingManager manager = DALSwingLocator.getDataSwingManager();
                manager.configureExpressionBuilder(this.picker.getConfig(), CopyTable2Panel.this.source);
                if (value == null) {
                    this.picker.setExpression(null);
                } else {
                    this.picker.setExpression(ExpressionUtils.createExpression((String)((String)value)));
                }
                return this.picker.asJComponent();
            }
            catch (Exception ex) {
                return new JLabel();
            }
        }

        @Override
        public Object getCellEditorValue() {
            Expression exp = this.picker.getExpression();
            if (exp == null) {
                return null;
            }
            return exp.getPhrase();
        }
    }

    private class FeatureAttributeCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final AttributeDescriptorPickerController picker;
        private final JComboBox combo;

        public FeatureAttributeCellEditor() {
            DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
            this.combo = new JComboBox();
            this.picker = dataSwingManager.createAttributeDescriptorPickerController(this.combo);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jtable, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                this.picker.clean();
                return this.combo;
            }
            this.picker.setFeatureType(CopyTable2Panel.this.source.getDefaultFeatureTypeQuietly());
            this.picker.setAllowNull(true);
            this.picker.set(Objects.toString(value, ""));
            return this.combo;
        }

        @Override
        public Object getCellEditorValue() {
            return this.picker.getName();
        }
    }
}

