/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.resourcesmanager;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.extension.resourcesmanager.ResourcesLoaderPanelView;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DatabaseWorkspaceManager;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.resourcesstorage.FilesResourcesStorage;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcesLoaderPanel
extends ResourcesLoaderPanelView
implements Component {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourcesLoaderPanel.class);
    private PickerController<JDBCServerExplorerParameters> connectionPicker;
    private JDBCServerExplorerParameters connection;
    private JDBCServerExplorer server;

    public ResourcesLoaderPanel() {
        this.translate();
        try {
            FileUtils.forceMkdir((File)this.getLocalResourcesPath());
        }
        catch (IOException ex) {
            LOGGER.warn("Can't create local resources path.", (Throwable)ex);
        }
        this.initComponents();
    }

    public JComponent asJComponent() {
        return this;
    }

    private void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate((JComponent)this.lblConnection);
        swingManager.translate((JComponent)this.lblDBResources);
        swingManager.translate((JComponent)this.lblLocalResources);
        swingManager.translate((AbstractButton)this.btnDownload);
        swingManager.translate((AbstractButton)this.btnUpload);
        swingManager.translate((AbstractButton)this.btnAddLocal);
        swingManager.translate((AbstractButton)this.btnDeleteLocal);
        swingManager.translate((AbstractButton)this.btnDeleteRemote);
        swingManager.translate((AbstractButton)this.chkUseLocalResources);
    }

    private void initComponents() {
        this.connectionPicker = DALSwingLocator.getSwingManager().createJDBCConnectionPickerController(this.cboConnection, this.btnConnection);
        this.connectionPicker.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ResourcesLoaderPanel.this.connection = null;
                if (!ResourcesLoaderPanel.this.isValidSelectedConnection()) {
                    ResourcesLoaderPanel.this.connectionPicker.set(null);
                }
                ResourcesLoaderPanel.this.chkUseLocalResources.setSelected(ResourcesLoaderPanel.this.getUseLocalResources());
                ResourcesLoaderPanel.this.refreshDBResources();
                ResourcesLoaderPanel.this.doUpdateEnableComponents();
            }
        });
        DefaultListSelectionModel lstDBResourcesSelectionModel = new DefaultListSelectionModel();
        lstDBResourcesSelectionModel.setSelectionMode(0);
        this.lstDBResources.setSelectionModel(lstDBResourcesSelectionModel);
        lstDBResourcesSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ResourcesLoaderPanel.this.doUpdateEnableComponents();
            }
        });
        this.refreshLocalResources();
        DefaultListSelectionModel lstLocalResourcesSelectionModel = new DefaultListSelectionModel();
        lstLocalResourcesSelectionModel.setSelectionMode(0);
        this.lstLocalResources.setSelectionModel(lstLocalResourcesSelectionModel);
        lstLocalResourcesSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ResourcesLoaderPanel.this.doUpdateEnableComponents();
            }
        });
        this.btnDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourcesLoaderPanel.this.doDownload();
            }
        });
        this.btnUpload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourcesLoaderPanel.this.doUpload();
            }
        });
        this.btnDeleteLocal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourcesLoaderPanel.this.doDeleteLocal();
            }
        });
        this.btnDeleteRemote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourcesLoaderPanel.this.doDeleteRemote();
            }
        });
        this.btnAddLocal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourcesLoaderPanel.this.doAddlocal();
            }
        });
        this.chkUseLocalResources.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourcesLoaderPanel.this.doChangeUseLocalResources();
            }
        });
        this.chkUseLocalResources.setSelected(this.getUseLocalResources());
        this.doUpdateEnableComponents();
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)20, (int)60);
    }

    private void doDownload() {
        LabeledValue selected = (LabeledValue)this.lstDBResources.getSelectedValue();
        if (selected != null) {
            String name = selected.getLabel();
            ResourcesStorage.Resource resource = (ResourcesStorage.Resource)selected.getValue();
            FilesResourcesStorage localResourcesStorage = this.getLocalResourcesStorage();
            if (localResourcesStorage != null) {
                try {
                    if (localResourcesStorage.exists(name)) {
                        ResourcesStorage.Resource localResource = localResourcesStorage.getResource(name);
                        this.copy(resource, localResource);
                    } else {
                        localResourcesStorage.add(name, resource.asInputStream());
                    }
                    this.refreshLocalResources();
                    this.refreshDocuments();
                }
                catch (IOException ex) {
                    LOGGER.warn("Can't download '" + name + "' resource'", (Throwable)ex);
                }
            }
        }
    }

    private void doUpload() {
        LabeledValue selected = (LabeledValue)this.lstLocalResources.getSelectedValue();
        if (selected != null) {
            String name = selected.getLabel();
            ResourcesStorage.Resource resource = (ResourcesStorage.Resource)selected.getValue();
            ResourcesStorage remoteResourcesStorage = this.getDBResourcesStorage();
            if (remoteResourcesStorage != null) {
                try {
                    if (remoteResourcesStorage.exists(name)) {
                        ResourcesStorage.Resource remoteResource = remoteResourcesStorage.getResource(name);
                        this.copy(resource, remoteResource);
                    } else {
                        remoteResourcesStorage.add(name, resource.asInputStream());
                    }
                    this.refreshDBResources();
                    this.refreshDocuments();
                }
                catch (IOException ex) {
                    LOGGER.warn("Can't upload '" + name + "' resource'", (Throwable)ex);
                }
            }
        }
    }

    private void doDeleteLocal() {
        LabeledValue selected = (LabeledValue)this.lstLocalResources.getSelectedValue();
        if (selected != null) {
            String name = selected.getLabel();
            FilesResourcesStorage localResourcesStorage = this.getLocalResourcesStorage();
            if (localResourcesStorage != null && localResourcesStorage.exists(name)) {
                localResourcesStorage.remove(name);
                this.refreshLocalResources();
            }
        }
    }

    private void doDeleteRemote() {
        LabeledValue selected = (LabeledValue)this.lstDBResources.getSelectedValue();
        if (selected != null) {
            String name = selected.getLabel();
            ResourcesStorage remoteResourcesStorage = this.getDBResourcesStorage();
            if (remoteResourcesStorage != null && remoteResourcesStorage.exists(name)) {
                remoteResourcesStorage.remove(name);
                this.refreshDBResources();
            }
        }
    }

    private void doAddlocal() {
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        FoldersManager folderManager = ToolsLocator.getFoldersManager();
        Object[] f = dialogs.showChooserDialog("_Resources_loader", 0, 0, false, null, null, true);
        if (ArrayUtils.isEmpty((Object[])f)) {
            return;
        }
        String name = ((File)f[0]).getName();
        try {
            FileInputStream is = new FileInputStream((File)f[0]);
            FilesResourcesStorage localResourcesStorage = this.getLocalResourcesStorage();
            if (localResourcesStorage != null) {
                if (localResourcesStorage.exists(name)) {
                    ResourcesStorage.Resource localResource = localResourcesStorage.getResource(name);
                    IOUtils.copy((InputStream)is, (OutputStream)localResource.asOutputStream());
                    is.close();
                    localResource.close();
                } else {
                    localResourcesStorage.add(name, (InputStream)is);
                }
                this.refreshLocalResources();
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Can't add '" + name + "' resource'", (Throwable)ex);
        }
    }

    private boolean getUseLocalResources() {
        DataManager manager = DALLocator.getDataManager();
        JDBCServerExplorerParameters con = this.getConnection();
        if (con == null) {
            return false;
        }
        DatabaseWorkspaceManager ws = manager.getDatabaseWorkspace((DataServerExplorerParameters)con);
        if (ws == null) {
            return false;
        }
        return ws.hasAlternativeResourcesStorage();
    }

    private boolean isValidSelectedConnection() {
        DataManager manager = DALLocator.getDataManager();
        JDBCServerExplorerParameters con = (JDBCServerExplorerParameters)this.connectionPicker.get();
        if (con == null) {
            return false;
        }
        DatabaseWorkspaceManager ws = manager.getDatabaseWorkspace((DataServerExplorerParameters)con);
        return ws != null;
    }

    private void doChangeUseLocalResources() {
        DataManager manager = DALLocator.getDataManager();
        JDBCServerExplorerParameters con = this.getConnection();
        if (con == null) {
            return;
        }
        DatabaseWorkspaceManager ws = manager.getDatabaseWorkspace((DataServerExplorerParameters)con);
        if (this.chkUseLocalResources.isSelected()) {
            String s = "<%=$GVSIGHOMEFOLDER%>/plugins/org.gvsig.app.mainplugin/LocalResources";
            ws.setAlternativeResourcesStorage(s);
        } else {
            ws.setAlternativeResourcesStorage(null);
        }
        this.refreshDocuments();
    }

    private void refreshDocuments() {
        DataManager manager = DALLocator.getDataManager();
        JDBCServerExplorerParameters con = this.getConnection();
        if (con == null) {
            return;
        }
        DatabaseWorkspaceManager ws = manager.getDatabaseWorkspace((DataServerExplorerParameters)con);
        StoresRepository repository = ws.getStoresRepository();
        for (String name : repository.keySet()) {
            DataStoreParameters params = (DataStoreParameters)repository.get((Object)name);
            ApplicationLocator.getApplicationManager().refreshDocument(params);
        }
    }

    private void refreshDBResources() {
        ResourcesStorage resourcesStorage = this.getDBResourcesStorage();
        DefaultListModel<LabeledValue> dBResourcesModel = new DefaultListModel<LabeledValue>();
        if (resourcesStorage != null) {
            List dbResourcesNames = resourcesStorage.getResourceNames();
            ArrayList<LabeledValueImpl> resources = new ArrayList<LabeledValueImpl>();
            for (String string : dbResourcesNames) {
                ResourcesStorage.Resource resource = resourcesStorage.getResource(string);
                resources.add(new LabeledValueImpl(string, (Object)resource));
            }
            Collections.sort(resources, (o1, o2) -> StringUtils.compare((String)o1.getLabel(), (String)o2.getLabel()));
            for (LabeledValue labeledValue : resources) {
                dBResourcesModel.addElement(labeledValue);
            }
        }
        this.lstDBResources.setModel(dBResourcesModel);
    }

    private void refreshLocalResources() {
        FilesResourcesStorage localResourcesStorage = this.getLocalResourcesStorage();
        List localResourcesNames = localResourcesStorage.getResourceNames();
        DefaultListModel<LabeledValueImpl> localResourcesModel = new DefaultListModel<LabeledValueImpl>();
        for (String resourceName : localResourcesNames) {
            ResourcesStorage.Resource resource = localResourcesStorage.getResource(resourceName);
            localResourcesModel.addElement(new LabeledValueImpl(resourceName, (Object)resource));
        }
        this.lstLocalResources.setModel(localResourcesModel);
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return ToolsSwingUtils.loadImage((Object)this, (String)imageName);
    }

    public JDBCServerExplorerParameters getConnection() {
        if (this.connection == null) {
            this.connection = (JDBCServerExplorerParameters)this.connectionPicker.get();
        }
        return this.connection;
    }

    public String getConnectionLabel() {
        String label = "";
        if (this.getConnection() != null) {
            ListElement item = (ListElement)this.cboConnection.getSelectedItem();
            label = item.getLabel();
        }
        return label;
    }

    public JDBCServerExplorer getServer() {
        if (this.server == null) {
            try {
                DataManager dataManager = DALLocator.getDataManager();
                if (this.getConnection() != null) {
                    this.server = (JDBCServerExplorer)dataManager.openServerExplorer(this.getConnection().getExplorerName(), (DataServerExplorerParameters)this.getConnection());
                }
            }
            catch (InitializeException | ProviderNotRegisteredException | ValidateDataParametersException ex) {
                LOGGER.warn("Can't open server " + this.getConnection().getExplorerName());
            }
        }
        return this.server;
    }

    public ResourcesStorage getDBResourcesStorage() {
        JDBCServerExplorer theServer = this.getServer();
        return theServer == null ? null : theServer.getResourcesStorage();
    }

    public final File getLocalResourcesPath() {
        File folder = PluginsLocator.getPluginsManager().getApplicationHomeFolder();
        File f = FileUtils.getFile((File)folder, (String[])new String[]{"plugins", "org.gvsig.app.mainplugin", "LocalResources"});
        return f;
    }

    public FilesResourcesStorage getLocalResourcesStorage() {
        File f = this.getLocalResourcesPath();
        FilesResourcesStorage resources = new FilesResourcesStorage(f.getAbsolutePath());
        return resources;
    }

    private void doUpdateEnableComponents() {
        ResourcesStorage dBResourcesStorage = this.getDBResourcesStorage();
        FilesResourcesStorage localResourcesStorage = this.getLocalResourcesStorage();
        this.chkUseLocalResources.setEnabled(dBResourcesStorage != null);
        this.btnDownload.setEnabled(dBResourcesStorage != null && localResourcesStorage != null && this.lstDBResources.getSelectedValue() != null);
        this.btnUpload.setEnabled(dBResourcesStorage != null && localResourcesStorage != null && this.lstLocalResources.getSelectedValue() != null);
        this.btnDeleteLocal.setEnabled(localResourcesStorage != null && this.lstLocalResources.getSelectedValue() != null);
        this.btnDeleteRemote.setEnabled(dBResourcesStorage != null && this.lstDBResources.getSelectedValue() != null);
    }

    private void copy(ResourcesStorage.Resource source, ResourcesStorage.Resource target) throws IOException {
        IOUtils.copy((InputStream)source.asInputStream(), (OutputStream)target.asOutputStream());
        source.close();
        target.close();
    }
}

