/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.updatetable;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Objects;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.extension.updatetable.UpdateTablePanelImpl;
import org.gvsig.app.extension.updatetable.UpdateTableProcess;
import org.gvsig.app.extension.updatetable.UpdateTableProcessParameters;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.arguments.Arguments;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;

public class UpdateTableExtension
extends Extension {
    public void initialize() {
    }

    public void execute(String actionCommand) {
        if ("tools-updatetable".equalsIgnoreCase(actionCommand)) {
            this.doUpdateTable();
        }
    }

    public void execute(String command, Object[] args) {
        Arguments arguments = Arguments.create((Object[])args);
        if (StringUtils.equalsIgnoreCase((CharSequence)"tools-updatetable", (CharSequence)command)) {
            FeatureStore store;
            Object table = arguments.get("table");
            Object useSelection = arguments.get("useSelection");
            String columnName = (String)arguments.get("columnName", String.class, null);
            if (table instanceof FeatureStore) {
                store = (FeatureStore)table;
            } else {
                DataManager dataManager = DALLocator.getDataManager();
                store = (FeatureStore)dataManager.getStoresRepository().getStore(Objects.toString(table, null));
            }
            this.doUpdateTable(store, DataTypeUtils.toBoolean((Object)useSelection, (boolean)false), (String)StringUtils.defaultIfBlank((CharSequence)columnName, null));
        }
    }

    private void doUpdateTable() {
        this.doUpdateTable(null, null, null);
    }

    private void doUpdateTable(FeatureStore store, Boolean useSelection, String columnName) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        final UpdateTablePanelImpl panel = new UpdateTablePanelImpl();
        panel.setStore(store);
        panel.setUseSelection(useSelection);
        panel.setColumnNames(columnName);
        final Dialog dialog = windowManager.createDialog((JComponent)panel, i18n.getTranslation("_Update_table"), i18n.getTranslation("_Update_data_in_a_table"), 3);
        dialog.setAutoclose(false);
        dialog.setButtonLabel(1, i18n.getTranslation("_Update"));
        dialog.setButtonLabel(2, i18n.getTranslation("_Close"));
        dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (dialog.getAction()) {
                    case 1: {
                        dialog.setButtonEnabled(1, false);
                        UpdateTableProcess process = UpdateTableProcess.createProcess();
                        UpdateTableProcessParameters params = process.createParameters();
                        panel.fetch(params);
                        if (UpdateTablePanelImpl.confirmUpdateTableParameters(params) != 0) {
                            dialog.setButtonEnabled(1, true);
                            return;
                        }
                        process.parameters(params).status(panel.getStatus()).postProcess(() -> {
                            panel.postProcess();
                            DisposeUtils.dispose((Object)params);
                            dialog.setButtonEnabled(1, true);
                        });
                        process.start();
                        break;
                    }
                    case 2: {
                        ((JComponent)dialog).setVisible(false);
                    }
                }
            }
        });
        dialog.show(WindowManager.MODE.WINDOW, Collections.singletonMap("align", 10));
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }
}

