/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.preferencespage;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.preferences.AbstractPreferencePage;
import org.gvsig.andami.preferences.StoreException;
import org.gvsig.app.gui.panels.ColorChooserPanel;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolPreferences;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.gui.beans.swing.JBlank;
import org.gvsig.gui.beans.swing.JComboBoxFontSizes;
import org.gvsig.gui.beans.swing.JComboBoxFonts;
import org.gvsig.gui.beans.swing.JFileChooser;
import org.gvsig.i18n.Messages;

public class SymbologyPage
extends AbstractPreferencePage {
    private static final long serialVersionUID = 1L;
    private SymbolPreferences preferences = null;
    private ColorChooserPanel defaultColor = null;
    private ColorChooserPanel defaultFillColor = null;
    private JSlider jsDefaultSelectionAlpha = null;
    private JSlider jsFillSelelctionAlpha = null;
    protected String id = ((Object)((Object)this)).getClass().getName();
    private boolean panelStarted = false;
    private JButton btnSelectProjectsFolder = null;
    private ActionListener btnFileChooserAction = null;
    private JTextField txtProjectsFolder = null;
    private JComboBoxFonts fonts = null;
    private JComboBoxFontSizes sizes = null;
    private ImageIcon icon = null;
    private JCheckBox aleatoryFillColor;

    public SymbolPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = MapContextLocator.getSymbolManager().getSymbolPreferences();
        }
        return this.preferences;
    }

    public void setChangesApplied() {
        this.setChanged(false);
    }

    public String getID() {
        return this.id;
    }

    public ImageIcon getIcon() {
        if (this.icon == null) {
            this.icon = IconThemeHelper.getImageIcon((String)"symbology-preferences");
        }
        return this.icon;
    }

    public JPanel getPanel() {
        if (this.panelStarted) {
            return this;
        }
        this.panelStarted = true;
        this.addComponent(new JLabel(" "));
        GridBagLayoutPanel selectionDefaultColorPanel = new GridBagLayoutPanel();
        selectionDefaultColorPanel.setBorder((Border)new TitledBorder(Messages.getText((String)"_Default_color")));
        selectionDefaultColorPanel.setLayout((LayoutManager)new GridBagLayout());
        selectionDefaultColorPanel.add((Component)new JLabel(Messages.getText((String)"fill")));
        this.defaultColor = new ColorChooserPanel();
        selectionDefaultColorPanel.add((Component)this.defaultColor);
        selectionDefaultColorPanel.add((Component)new JLabel(Messages.getText((String)"alpha")));
        this.jsDefaultSelectionAlpha = new JSlider(0, 255);
        selectionDefaultColorPanel.add((Component)this.jsDefaultSelectionAlpha);
        selectionDefaultColorPanel.add((Component)new JBlank(50, 50));
        this.jsDefaultSelectionAlpha.setPreferredSize(new Dimension(100, 30));
        this.jsDefaultSelectionAlpha.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SymbologyPage.this.defaultColor.setAlpha(((JSlider)e.getSource()).getValue());
            }
        });
        this.addComponent(new JLabel(" "));
        this.addComponent((Component)selectionDefaultColorPanel);
        GridBagLayoutPanel selectionFillColor = new GridBagLayoutPanel();
        selectionFillColor.setBorder((Border)new TitledBorder(Messages.getText((String)"_Default_fill_color")));
        selectionFillColor.setLayout((LayoutManager)new GridBagLayout());
        selectionFillColor.add((Component)new JLabel(Messages.getText((String)"fill")));
        this.defaultFillColor = new ColorChooserPanel();
        selectionFillColor.add((Component)this.defaultFillColor);
        selectionFillColor.add((Component)new JLabel(Messages.getText((String)"alpha")));
        this.jsFillSelelctionAlpha = new JSlider(0, 255);
        selectionFillColor.add((Component)this.jsFillSelelctionAlpha);
        this.jsFillSelelctionAlpha.setPreferredSize(new Dimension(100, 30));
        this.jsFillSelelctionAlpha.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SymbologyPage.this.defaultFillColor.setAlpha(((JSlider)e.getSource()).getValue());
            }
        });
        selectionFillColor.add((Component)new JBlank(50, 50));
        this.aleatoryFillColor = new JCheckBox();
        selectionFillColor.add((Component)this.aleatoryFillColor);
        selectionFillColor.add((Component)new JLabel("   " + Messages.getText((String)"_Random")));
        this.aleatoryFillColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == SymbologyPage.this.aleatoryFillColor) {
                    SymbologyPage.this.defaultFillColor.setEnabled(!SymbologyPage.this.aleatoryFillColor.isSelected());
                    SymbologyPage.this.jsFillSelelctionAlpha.setEnabled(!SymbologyPage.this.aleatoryFillColor.isSelected());
                }
            }
        });
        this.addComponent(new JLabel(" "));
        this.addComponent((Component)selectionFillColor);
        this.btnFileChooserAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(SymbologyPage.this.btnSelectProjectsFolder)) {
                    String path = SymbologyPage.this.txtProjectsFolder.getText();
                    FileFilter def = new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            return f.isDirectory();
                        }

                        @Override
                        public String getDescription() {
                            return null;
                        }
                    };
                    File file = new File(path);
                    JFileChooser fc = file.exists() ? new JFileChooser("SYMBOLOGY_PREFERENCE_PAGE_FILECHOOSER", file) : new JFileChooser("SYMBOLOGY_PREFERENCE_PAGE_FILECHOOSER", JFileChooser.getLastPath((String)"SYMBOLOGY_PREFERENCE_PAGE_FILECHOOSER", (File)file));
                    fc.setFileSelectionMode(1);
                    fc.setMultiSelectionEnabled(false);
                    fc.setAcceptAllFileFilterUsed(false);
                    fc.addChoosableFileFilter(def);
                    int result = fc.showOpenDialog((Component)((Object)SymbologyPage.this));
                    if (result == 0 && (file = fc.getSelectedFile()) != null && e.getSource().equals(SymbologyPage.this.btnSelectProjectsFolder)) {
                        SymbologyPage.this.txtProjectsFolder.setText(file.getAbsolutePath());
                    }
                }
            }
        };
        this.btnSelectProjectsFolder = new JButton(Messages.getText((String)"browse"));
        this.btnSelectProjectsFolder.addActionListener(this.btnFileChooserAction);
        JPanel panelBrowser = new JPanel();
        panelBrowser.setBorder(new TitledBorder(Messages.getText((String)"_Symbols_folder")));
        this.txtProjectsFolder = new JTextField(30);
        panelBrowser.add(this.txtProjectsFolder);
        panelBrowser.add(this.btnSelectProjectsFolder);
        this.addComponent(panelBrowser);
        this.fonts = new JComboBoxFonts();
        this.sizes = new JComboBoxFontSizes();
        JPanel panelFont = new JPanel(new FlowLayout());
        panelFont.setBorder(new TitledBorder(Messages.getText((String)"_Default_font")));
        panelFont.add((Component)this.fonts);
        panelFont.add((Component)this.sizes);
        this.addComponent(panelFont);
        this.initializeValues();
        return this;
    }

    public String getTitle() {
        return Messages.getText((String)"Simbologia");
    }

    public void initializeValues() {
        if (!this.panelStarted) {
            this.getPanel();
        }
        this.defaultColor.setColor(this.getPreferences().getDefaultSymbolColor());
        this.defaultColor.setAlpha(this.getPreferences().getDefaultSymbolColor().getAlpha());
        this.jsDefaultSelectionAlpha.setValue(this.getPreferences().getDefaultSymbolColor().getAlpha());
        this.aleatoryFillColor.setSelected(this.getPreferences().isDefaultSymbolFillColorAleatory());
        this.defaultFillColor.setColor(this.getPreferences().getDefaultSymbolFillColor());
        this.defaultFillColor.setAlpha(this.getPreferences().getDefaultSymbolFillColor().getAlpha());
        this.jsFillSelelctionAlpha.setValue(this.getPreferences().getDefaultSymbolFillColor().getAlpha());
        this.txtProjectsFolder.setText(this.getPreferences().getSymbolLibraryPath());
        this.fonts.setSelectedItem((Object)this.getPreferences().getDefaultSymbolFont().getFamily());
        this.sizes.setSelectedItem((Object)this.getPreferences().getDefaultSymbolFont().getSize());
        this.defaultFillColor.setEnabled(!this.aleatoryFillColor.isSelected());
        this.jsFillSelelctionAlpha.setEnabled(!this.aleatoryFillColor.isSelected());
    }

    public void initializeDefaults() {
        this.defaultColor.setColor(Color.DARK_GRAY);
        this.defaultColor.setAlpha(255);
        this.jsDefaultSelectionAlpha.setValue(255);
        this.aleatoryFillColor.setSelected(true);
        this.defaultFillColor.setColor(new Color(60, 235, 235));
        this.defaultFillColor.setAlpha(255);
        this.jsFillSelelctionAlpha.setValue(255);
        String path = PluginServices.getPluginServices((Object)((Object)this)).getPluginHomeFolder().getAbsolutePath() + File.separator + "Symbols";
        this.txtProjectsFolder.setText(path);
        this.fonts.setSelectedItem((Object)"SansSerif");
        this.sizes.setSelectedItem((Object)14);
        this.defaultFillColor.setEnabled(!this.aleatoryFillColor.isSelected());
        this.jsFillSelelctionAlpha.setEnabled(!this.aleatoryFillColor.isSelected());
    }

    public boolean isValueChanged() {
        return super.hasChanged();
    }

    public void storeValues() throws StoreException {
        this.persistPreferences();
    }

    private void persistPreferences() {
        Color color;
        if (this.defaultColor.getColor() != null) {
            color = this.defaultColor.getColor();
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.jsDefaultSelectionAlpha.getValue());
            this.getPreferences().setDefaultSymbolColor(color);
        }
        if (this.aleatoryFillColor != null) {
            this.getPreferences().setDefaultSymbolFillColorAleatory(this.aleatoryFillColor.isSelected());
        }
        if (this.defaultFillColor.getColor() != null) {
            color = this.defaultFillColor.getColor();
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.jsFillSelelctionAlpha.getValue());
            this.getPreferences().setDefaultSymbolFillColor(color);
        }
        if (this.txtProjectsFolder.getText() != null) {
            this.getPreferences().setSymbolLibraryPath(this.txtProjectsFolder.getText());
        }
        if (this.fonts.getFont() != null && this.sizes.getSelectedItem() != null) {
            String f = (String)this.fonts.getSelectedItem();
            Font font = new Font(f, 0, (Integer)this.sizes.getSelectedItem());
            this.getPreferences().setDefaultSymbolFont(font);
        }
    }
}

