/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.imp;

import java.awt.Component;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.cresques.cts.IProjection;
import org.gvsig.about.AboutLocator;
import org.gvsig.about.AboutManager;
import org.gvsig.andami.Arguments;
import org.gvsig.andami.Launcher;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.actioninfo.ActionInfo;
import org.gvsig.andami.ui.ToolsWindowManager;
import org.gvsig.andami.ui.mdiFrame.MainFrame;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.MDIManager;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.JavaPreferencesNode;
import org.gvsig.app.PreferencesNode;
import org.gvsig.app.extension.Version;
import org.gvsig.app.extension.develtools.InfoPanel;
import org.gvsig.app.gui.WizardPanel;
import org.gvsig.app.imp.DefaultPreferencesNode;
import org.gvsig.app.prepareAction.PrepareContext;
import org.gvsig.app.prepareAction.PrepareContextView;
import org.gvsig.app.prepareAction.PrepareDataStore;
import org.gvsig.app.prepareAction.PrepareDataStoreParameters;
import org.gvsig.app.prepareAction.PrepareLayer;
import org.gvsig.app.project.DefaultProject;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.gui.IDocumentWindow;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.operations.SingleLayer;
import org.gvsig.fmap.mapcontrol.CompoundLayersTreeModel;
import org.gvsig.fmap.mapcontrol.CompoundStoresTreeModel;
import org.gvsig.fmap.mapcontrol.MapControlLocator;
import org.gvsig.gui.ColorTablesFactory;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.swing.SymbologySwingLocator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.dispose.DisposableManager;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.extensionpoint.ExtensionBuilder;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.icontheme.IconThemeManager;
import org.gvsig.tools.util.PropertiesSupport;
import org.gvsig.tools.util.PropertiesSupportHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApplicationManager
implements ApplicationManager {
    private static Logger logger = LoggerFactory.getLogger(DefaultApplicationManager.class);
    private static final String EPNAME_PREPARE_OPEN_DATASTORE = "org.gvsig.datastore.open.prepare";
    private static final String EPNAME_PREPARE_OPEN_DATASTOREPARAMETERS = "org.gvsig.datastoreparameters.open.prepare";
    private static final String EPNAME_PREPARE_OPEN_LAYER = "org.gvsig.layer.open.prepare";
    private static final String EPNAME_ADD_TABLE_WIZARD = "AddLayerWizard";
    private ExtensionPointManager epManager;
    private Version version;
    private PropertiesSupportHelper psh = new PropertiesSupportHelper();

    public DefaultApplicationManager() {
        this.epManager = ToolsLocator.getExtensionPointManager();
        this.epManager.add(EPNAME_PREPARE_OPEN_DATASTORE, "Actions to do when open a DataStore");
        this.epManager.add(EPNAME_PREPARE_OPEN_DATASTOREPARAMETERS, "Actions to do before open a DataStore with parameters");
        this.epManager.add(EPNAME_PREPARE_OPEN_LAYER, "Actions to do after create a Layer");
        this.epManager.add(EPNAME_ADD_TABLE_WIZARD, "Wizards to add new document table");
        try {
            this.version = new Version();
        }
        catch (Exception ex) {
            logger.warn("Can't locate application version.");
        }
    }

    @Override
    public DataStore pepareOpenDataSource(DataStore store, PrepareContext context) throws Exception {
        ExtensionPoint ep = this.epManager.get(EPNAME_PREPARE_OPEN_DATASTORE);
        if (ep.getCount() == 0) {
            return store;
        }
        DataStore result = store;
        Iterator iter = ep.iterator();
        while (iter.hasNext()) {
            PrepareDataStore prepare = (PrepareDataStore)((ExtensionPoint.Extension)iter.next()).create();
            result = prepare.prepare(store, context);
        }
        return result;
    }

    @Override
    public DataStoreParameters prepareOpenDataStoreParameters(DataStoreParameters storeParameters, PrepareContext context) throws Exception {
        ExtensionPoint ep = this.epManager.get(EPNAME_PREPARE_OPEN_DATASTOREPARAMETERS);
        if (ep.getCount() == 0) {
            return storeParameters;
        }
        DataStoreParameters result = storeParameters;
        Iterator iter = ep.iterator();
        while (iter.hasNext()) {
            PrepareDataStoreParameters prepare = (PrepareDataStoreParameters)((ExtensionPoint.Extension)iter.next()).create();
            result = prepare.prepare(storeParameters, context);
        }
        return result;
    }

    @Override
    public List<DataStoreParameters> prepareOpenDataStoreParameters(List<DataStoreParameters> storeParameters, PrepareContext context) throws Exception {
        int j;
        DataStoreParameters param;
        int i;
        ExtensionPoint ep = this.epManager.get(EPNAME_PREPARE_OPEN_DATASTOREPARAMETERS);
        if (ep.getCount() == 0) {
            return storeParameters;
        }
        ArrayList<DataStoreParameters> result = new ArrayList<DataStoreParameters>();
        Iterator iter = ep.iterator();
        ArrayList<PrepareDataStoreParameters> prepareList = new ArrayList<PrepareDataStoreParameters>();
        while (iter.hasNext()) {
            prepareList.add((PrepareDataStoreParameters)((ExtensionPoint.Extension)iter.next()).create());
        }
        for (i = 0; i < storeParameters.size(); ++i) {
            param = storeParameters.get(i);
            for (j = 0; j < prepareList.size(); ++j) {
                ((PrepareDataStoreParameters)prepareList.get(j)).pre(param, context);
            }
        }
        for (i = 0; i < storeParameters.size(); ++i) {
            param = storeParameters.get(i);
            if (param == null) continue;
            for (j = 0; j < prepareList.size() && (param = ((PrepareDataStoreParameters)prepareList.get(j)).prepare(param, context)) != null; ++j) {
            }
            if (param == null) continue;
            result.add(param);
        }
        for (i = 0; i < storeParameters.size(); ++i) {
            param = storeParameters.get(i);
            for (j = 0; j < prepareList.size(); ++j) {
                ((PrepareDataStoreParameters)prepareList.get(j)).post(param, context);
            }
        }
        return result;
    }

    @Override
    public void registerPrepareOpenDataStore(PrepareDataStore action) {
        ExtensionPoint ep = this.epManager.get(EPNAME_PREPARE_OPEN_DATASTORE);
        ep.append(action.getName(), action.getDescription(), (ExtensionBuilder)action);
    }

    @Override
    public void registerPrepareOpenDataStoreParameters(PrepareDataStoreParameters action) {
        ExtensionPoint ep = this.epManager.get(EPNAME_PREPARE_OPEN_DATASTOREPARAMETERS);
        ep.append(action.getName(), action.getDescription(), (ExtensionBuilder)action);
    }

    @Override
    public FLayer prepareOpenLayer(FLayer layer, PrepareContextView context) throws Exception {
        ExtensionPoint ep = this.epManager.get(EPNAME_PREPARE_OPEN_LAYER);
        if (ep.getCount() == 0) {
            return layer;
        }
        FLayer result = layer;
        Iterator iter = ep.iterator();
        while (iter.hasNext()) {
            PrepareLayer prepare = (PrepareLayer)((ExtensionPoint.Extension)iter.next()).create();
            result = prepare.prepare(result, context);
        }
        return result;
    }

    @Override
    public void registerPrepareOpenLayer(PrepareLayer action) {
        ExtensionPoint ep = this.epManager.get(EPNAME_PREPARE_OPEN_LAYER);
        ep.append(action.getName(), action.getDescription(), (ExtensionBuilder)action);
    }

    @Override
    public void registerAddTableWizard(String name, String description, Class<? extends WizardPanel> wpClass) {
        ExtensionPoint ep = this.epManager.get(EPNAME_ADD_TABLE_WIZARD);
        ep.append(name, description, wpClass);
    }

    @Override
    public List<WizardPanel> getWizardPanels() throws Exception {
        ExtensionPoint ep = this.epManager.get(EPNAME_ADD_TABLE_WIZARD);
        ArrayList<WizardPanel> result = new ArrayList<WizardPanel>();
        Iterator iter = ep.iterator();
        while (iter.hasNext()) {
            result.add((WizardPanel)((ExtensionPoint.Extension)iter.next()).create());
        }
        return result;
    }

    @Override
    public DataManager getDataManager() {
        return DALLocator.getDataManager();
    }

    @Override
    public GeometryManager getGeometryManager() {
        return GeometryLocator.getGeometryManager();
    }

    @Override
    public PersistenceManager getPersistenceManager() {
        return ToolsLocator.getPersistenceManager();
    }

    @Override
    public DisposableManager getDisposableManager() {
        return ToolsLocator.getDisposableManager();
    }

    @Override
    public DynObjectManager getDynObjectManager() {
        return ToolsLocator.getDynObjectManager();
    }

    @Override
    public ExtensionPointManager getExtensionPointManager() {
        return ToolsLocator.getExtensionPointManager();
    }

    @Override
    public ProjectManager getProjectManager() {
        return ProjectManager.getInstance();
    }

    @Override
    public MDIManager getUIManager() {
        return PluginServices.getMDIManager();
    }

    @Override
    public MapContextManager getMapContextManager() {
        return MapContextLocator.getMapContextManager();
    }

    @Override
    public DataTypesManager getDataTypesManager() {
        return ToolsLocator.getDataTypesManager();
    }

    @Override
    public IProjection getCRS(String code) {
        return CRSFactory.getCRS((String)code);
    }

    @Override
    public IconThemeManager getIconThemeManager() {
        return ToolsSwingLocator.getIconThemeManager();
    }

    @Override
    public Arguments getArguments() {
        return Launcher.getArguments();
    }

    @Override
    public String getFromClipboard() {
        return PluginServices.getFromClipboard();
    }

    @Override
    public void putInClipboard(String data) {
        PluginServices.putInClipboard((String)data);
    }

    @Override
    public Project getCurrentProject() {
        return ProjectManager.getInstance().getCurrentProject();
    }

    @Override
    public FLayer getCurrentLayer() {
        ViewDocument viewdoc = (ViewDocument)this.getActiveDocument(ViewManager.TYPENAME);
        if (viewdoc == null) {
            return null;
        }
        MapContext mapContext = viewdoc.getMapContext();
        return mapContext.getLayers().getFirstActiveLayer();
    }

    @Override
    public PreferencesNode getPreferences(String node) {
        if (node.equalsIgnoreCase("project")) {
            return DefaultProject.getPreferences();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)node, (CharSequence)"gvsig.foldering")) {
            return new JavaPreferencesNode(node);
        }
        return new DefaultPreferencesNode(node);
    }

    @Override
    public PreferencesNode getPreferences() {
        return new DefaultPreferencesNode();
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public void close(boolean quietly) {
        Launcher.closeApplication((boolean)quietly);
    }

    @Override
    public AboutManager getAbout() {
        AboutManager manager = AboutLocator.getManager();
        return manager;
    }

    @Override
    public ColorTablesFactory getColorTablesFactory() {
        return SymbologySwingLocator.getSwingManager().getColorTablesFactory();
    }

    @Override
    public void registerColorTablesFactory(ColorTablesFactory factory) {
        SymbologySwingLocator.getSwingManager().setColorTablesFactory(factory);
    }

    @Override
    public IWindow getActiveWindow() {
        try {
            IWindow window = PluginServices.getMDIManager().getActiveWindow();
            return window;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public Document getActiveDocument() {
        return this.getActiveDocument((Class<? extends Document>)null);
    }

    @Override
    public Document getActiveDocument(String documentTypeName) {
        Document document = this.getActiveDocument();
        if (document != null && document.getTypeName().equalsIgnoreCase(documentTypeName)) {
            return document;
        }
        return null;
    }

    @Override
    public Document getActiveDocument(Class<? extends Document> documentClass) {
        Project project = this.getCurrentProject();
        if (project == null) {
            return null;
        }
        return project.getActiveDocument(documentClass);
    }

    @Override
    public IWindow getActiveWindow(Class<? extends Document> documentClass) {
        Project project = this.getCurrentProject();
        if (project == null) {
            return null;
        }
        return project.getActiveWindow(documentClass);
    }

    @Override
    public JComponent getActiveComponent(Class<? extends Document> documentClass) {
        Document document = this.getActiveDocument(documentClass);
        if (document == null) {
            return null;
        }
        return document.getMainComponent();
    }

    @Override
    public IDocumentWindow getDocumentWindow(Document document) {
        Class<? extends IDocumentWindow> defaultDocumentClass = document.getFactory().getMainWindowClass();
        return (IDocumentWindow)this.getUIManager().getSingletonWindow(defaultDocumentClass, (Object)document);
    }

    @Override
    public String getLocaleLanguage() {
        return Launcher.getAndamiConfig().getLocaleLanguage();
    }

    public void messageDialog(String message, String title, int messageType) {
        MainFrame main = PluginServices.getMainFrame();
        main.messageDialog(message, title, messageType);
    }

    public void messageDialog(String message, String[] messageArgs, String title, int messageType) {
        MainFrame main = PluginServices.getMainFrame();
        main.messageDialog(message, messageArgs, title, messageType);
    }

    public void messageDialog(String message, String[] messageArgs, String title, int messageType, String msgid) {
        MainFrame main = PluginServices.getMainFrame();
        main.messageDialog(message, messageArgs, title, messageType, msgid);
    }

    public int confirmDialog(String message, String title, int optionType, int messageType) {
        MainFrame main = PluginServices.getMainFrame();
        return main.confirmDialog(message, title, optionType, messageType);
    }

    public int confirmDialog(String message, String title, int optionType, int messageType, String msgid) {
        MainFrame main = PluginServices.getMainFrame();
        return main.confirmDialog(message, title, optionType, messageType, msgid);
    }

    public String inputDialog(String message, String title, int messageType, String initialValue) {
        MainFrame main = PluginServices.getMainFrame();
        return main.inputDialog(message, title, messageType, initialValue);
    }

    public String inputDialog(String message, String title) {
        MainFrame main = PluginServices.getMainFrame();
        return main.inputDialog(message, title);
    }

    public void showDialog(Component contents, String title) {
        MainFrame main = PluginServices.getMainFrame();
        main.showDialog(contents, title);
    }

    public Component createComponent(Class<? extends Component> theClass, Object ... parameters) {
        MainFrame main = PluginServices.getMainFrame();
        return main.createComponentWithParams(theClass, parameters);
    }

    public Component createComponentWithParams(Class<? extends Component> theClass, Object[] parameters) {
        MainFrame main = PluginServices.getMainFrame();
        return main.createComponentWithParams(theClass, parameters);
    }

    public File[] showChooserDialog(String title, int type, int selectionMode, boolean multiselection, File initialPath, FileFilter filter, boolean fileHidingEnabled) {
        MainFrame main = PluginServices.getMainFrame();
        return main.showChooserDialog(title, type, selectionMode, multiselection, initialPath, filter, fileHidingEnabled);
    }

    public ImmutablePair<File[], Charset> showChooserDialog(String title, int type, int selectionMode, boolean multiselection, File initialPath, FileFilter filter, boolean fileHidingEnabled, boolean askCharset) {
        MainFrame main = PluginServices.getMainFrame();
        return main.showChooserDialog(title, type, selectionMode, multiselection, initialPath, filter, fileHidingEnabled, askCharset);
    }

    public File[] showChooserDialog(String title, int type, int selectionMode, boolean multiselection, File initialPath, FileFilter filter, boolean fileHidingEnabled, JComponent accesory) {
        MainFrame main = PluginServices.getMainFrame();
        return main.showChooserDialog(title, type, selectionMode, multiselection, initialPath, filter, fileHidingEnabled, accesory);
    }

    public File[] showOpenDirectoryDialog(String title, File initialPath) {
        return this.showChooserDialog(title, 0, 1, false, initialPath, null, false);
    }

    public File[] showOpenFileDialog(String title, File initialPath) {
        return this.showChooserDialog(title, 0, 0, false, initialPath, null, false);
    }

    public File[] showSaveFileDialog(String title, File initialPath) {
        return this.showChooserDialog(title, 1, 0, false, initialPath, null, false);
    }

    public void message(String message, int message_type) {
        MainFrame main = PluginServices.getMainFrame();
        if (main != null) {
            main.message(message, message_type);
        }
    }

    @Override
    public String translate(String message, String ... args) {
        return Messages.translate((String)message, (String[])args);
    }

    @Override
    public Component getRootComponent() {
        return (Component)PluginServices.getMainFrame();
    }

    @Override
    public void refreshMenusAndToolBars() {
        PluginServices.getMainFrame().refreshControls();
    }

    @Override
    public MainFrame getMainFrame() {
        return PluginServices.getMainFrame();
    }

    @Override
    public void addMenu(ActionInfo action, String text) {
        MainFrame f = this.getMainFrame();
        f.addMenu(action, text);
    }

    @Override
    public void addTool(ActionInfo action, String toolBarName) {
        MainFrame f = this.getMainFrame();
        f.addTool(action, toolBarName);
        f.refreshControls();
    }

    @Override
    public void addSelectableTool(ActionInfo action, String toolBarName) {
        MainFrame f = this.getMainFrame();
        f.addSelectableTool(action, toolBarName, "unico", false);
        f.refreshControls();
    }

    @Override
    public void showTextDialog(WindowManager.MODE mode, String title, String htmlText) {
        this.showTextDialog(mode, title, htmlText, null);
    }

    @Override
    public void showTextDialog(final WindowManager.MODE mode, final String title, final String htmlText, final HyperlinkListener hyperlinkListener) {
        if (!SwingUtilities.isEventDispatchThread()) {
            if (mode == WindowManager.MODE.DIALOG) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            DefaultApplicationManager.this.showTextDialog(mode, title, htmlText, hyperlinkListener);
                        }
                    });
                }
                catch (Exception ex) {
                    logger.warn("Can't show text dialog:\n" + htmlText, (Throwable)ex);
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DefaultApplicationManager.this.showTextDialog(mode, title, htmlText, hyperlinkListener);
                    }
                });
            }
            return;
        }
        InfoPanel.showPanel(title, mode, htmlText, hyperlinkListener);
    }

    @Override
    public TreeModel createProjectLayersTreeModel() {
        CompoundLayersTreeModel model = (CompoundLayersTreeModel)MapControlLocator.getMapControlManager().createCompoundLayersTreeModel();
        Project project = this.getCurrentProject();
        List<Document> views = project.getDocuments(ViewManager.TYPENAME);
        for (Document view : views) {
            model.addLayers(((ViewDocument)view).getMapContext().getLayers());
        }
        return model;
    }

    @Override
    public TreeModel createProjectStoresTreeModel() {
        CompoundStoresTreeModel model = MapControlLocator.getMapControlManager().createCompoundStoresTreeModel();
        Project project = this.getCurrentProject();
        List<Document> views = project.getDocuments(ViewManager.TYPENAME);
        for (Document view : views) {
            model.addLayers(((ViewDocument)view).getMapContext().getLayers());
        }
        return model;
    }

    public Object getProperty(String name) {
        return this.psh.getProperty(name);
    }

    public void setProperty(String name, Object value) {
        this.psh.setProperty(name, value);
    }

    public Map<String, Object> getProperties() {
        return this.psh.getProperties();
    }

    @Override
    public void addPropertiesObserver(Observer o) {
        this.psh.addObserver(o);
    }

    @Override
    public void deletePropertiesObserver(Observer o) {
        this.psh.deleteObserver(o);
    }

    @Override
    public void deletePropertiesObservers() {
        this.psh.deleteObservers();
    }

    @Override
    public void refreshDocument(FeatureStore store) {
        if (store == null) {
            return;
        }
        this.refreshDocument(store.getParameters());
    }

    @Override
    public void refreshDocument(DataStoreParameters params) {
        if (params == null) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.refreshDocument(params));
            return;
        }
        ProjectManager projectManager = this.getProjectManager();
        Project project = projectManager.getCurrentProject();
        for (Document doc : project.getDocuments()) {
            if (!doc.contains(params)) continue;
            if (StringUtils.equals((CharSequence)doc.getTypeName(), (CharSequence)ViewManager.TYPENAME)) {
                ViewDocument view = (ViewDocument)doc;
                Iterator<FLayer> it = view.deepiterator();
                while (it.hasNext()) {
                    DataStore layerStore;
                    FLayer layer = it.next();
                    if (!(layer instanceof SingleLayer) || (layerStore = ((SingleLayer)layer).getDataStore()) == null || !params.isTheSameStore(layerStore.getParameters())) continue;
                    try {
                        layer.invalidate();
                    }
                    catch (Exception ex) {
                        logger.debug("Can't refresh layer " + layerStore.getFullName(), (Throwable)ex);
                    }
                }
            }
            doc.refresh();
        }
    }

    public Object get(String key) {
        IWindow[] windows;
        Object value = null;
        for (IWindow window : windows = this.getUIManager().getOrderedWindows()) {
            String title = window.getWindowInfo().getTitle();
            Component component = null;
            if (window instanceof PropertiesSupport) {
                component = (JComponent)window;
            } else if (window instanceof ToolsWindowManager.Window && (component = ((ToolsWindowManager.Window)window).getContents()) instanceof Dialog) {
                component = ((Dialog)component).getContents();
            }
            if (component instanceof PropertiesSupport && (value = ((PropertiesSupport)component).getProperty(key)) != null) break;
        }
        return value;
    }

    @Override
    public String makeTitle(String base, String docname, String docname2) {
        return ToolsSwingUtils.makeTitle((String)base, (String)docname, (String)docname2);
    }
}

