/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project;

import java.awt.Color;
import javax.swing.UIManager;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.app.imp.DefaultPreferencesNode;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.utils.StringUtilities;
import org.gvsig.utils.XMLEntity;

public class ProjectPreferences
extends DefaultPreferencesNode {
    public static final String DEFAULT_PROJECTION_KEY_NAME = "DefaultProjection";
    private static final String ZOOM_IN_FACTOR = "ZoomInFactor";
    private static final String ZOOM_OUT_FACTOR = "ZoomOutFactor";
    private static final String KEEP_SCALE_ON_RESIZING = "KeepScaleOnResizing";
    private static final String OPEN_WITH_A_NEW_MAXIMIZED_VIEW = "OpenWithANewMaximizedView";
    private static final String ADD_NEW_LAYERS_IN_INVISIBLE_MODE = "NewLayersInInvisibleMode";
    private IProjection defaultProjection = null;
    private final IProjection defaultFactoryProjection = MapContextLocator.getMapContextManager().getDefaultCRS();
    private Color defaultSelectionColor = MapContext.DEFAULT_SELECTION_COLOR;
    private Color defaultViewBackColor = null;
    private Color defaultOverviewBackColor = null;
    private int defaultMapUnits = -1;
    private int defaultDistanceUnits = -1;
    private int defaultDistanceArea = -1;
    private final PluginServices plugin = PluginsLocator.getManager().getPlugin((Object)this);
    private final DynObject pluginPreferences = this.plugin.getPluginProperties();

    public void setDefaultProjection(IProjection defaultProjection) {
        this.defaultProjection = defaultProjection;
        if (defaultProjection != null) {
            XMLEntity xml = this.plugin.getPersistentXML();
            xml.putProperty(DEFAULT_PROJECTION_KEY_NAME, defaultProjection.getAbrev());
        }
    }

    public void setDefaultProjection(String defaultProjection) {
        if (!StringUtils.isEmpty((CharSequence)defaultProjection)) {
            this.setDefaultProjection(CRSFactory.getCRS((String)defaultProjection));
        }
    }

    public IProjection getDefaultProjection() {
        if (this.defaultProjection == null) {
            XMLEntity xml = this.plugin.getPersistentXML();
            if (xml.contains(DEFAULT_PROJECTION_KEY_NAME)) {
                String projCode = xml.getStringProperty(DEFAULT_PROJECTION_KEY_NAME);
                this.defaultProjection = CRSFactory.getCRS((String)projCode);
            } else {
                this.defaultProjection = this.defaultFactoryProjection;
            }
        }
        return this.defaultProjection;
    }

    @Override
    public int getInt(String name, int defaultValue) {
        if (name.equalsIgnoreCase("DefaultDistanceUnits")) {
            return this.getDefaultDistanceUnits();
        }
        if (name.equalsIgnoreCase("DefaultDistanceArea")) {
            return this.getDefaultDistanceArea();
        }
        if (name.equalsIgnoreCase("DefaultMapUnits")) {
            return this.getDefaultMapUnits();
        }
        return super.getInt(name, defaultValue);
    }

    public void setDefaultSelectionColor(Color color) {
        if (color == null) {
            return;
        }
        this.defaultSelectionColor = color;
        XMLEntity xml = this.plugin.getPersistentXML();
        xml.putProperty("DefaultSelectionColor", StringUtilities.color2String((Color)color));
    }

    public Color getDefaultSelectionColor() {
        XMLEntity xml = this.plugin.getPersistentXML();
        if (xml.contains("DefaultSelectionColor")) {
            this.defaultSelectionColor = StringUtilities.string2Color((String)xml.getStringProperty("DefaultSelectionColor"));
        }
        if (this.defaultSelectionColor == null) {
            this.defaultSelectionColor = MapContext.DEFAULT_SELECTION_COLOR;
        }
        return this.defaultSelectionColor;
    }

    public Color getDefaultViewBackColor() {
        XMLEntity xml = PluginServices.getPluginServices((String)"org.gvsig.app").getPersistentXML();
        if (xml.contains("DefaultViewBackColor")) {
            this.defaultViewBackColor = StringUtilities.string2Color((String)xml.getStringProperty("DefaultViewBackColor"));
        }
        if (this.defaultViewBackColor == null) {
            this.defaultViewBackColor = UIManager.getColor("EditorPane.background");
            if (this.defaultViewBackColor == null) {
                this.defaultViewBackColor = Color.WHITE;
            }
        }
        return this.defaultViewBackColor;
    }

    public void setDefaultViewBackColor(Color color) {
        this.defaultViewBackColor = color;
        XMLEntity xml = this.plugin.getPersistentXML();
        xml.putProperty("DefaultViewBackColor", StringUtilities.color2String((Color)color));
    }

    public Color getDefaultOverviewBackColor() {
        XMLEntity xml = this.plugin.getPersistentXML();
        if (xml.contains("defaultOverviewBackColor")) {
            this.defaultOverviewBackColor = StringUtilities.string2Color((String)xml.getStringProperty("defaultOverviewBackColor"));
        }
        if (this.defaultOverviewBackColor == null) {
            this.defaultOverviewBackColor = UIManager.getColor("EditorPane.background");
            if (this.defaultOverviewBackColor == null) {
                this.defaultOverviewBackColor = Color.WHITE;
            }
        }
        return this.defaultOverviewBackColor;
    }

    public void setDefaultOverviewBackColor(Color color) {
        this.defaultOverviewBackColor = color;
    }

    public int getDefaultMapUnits() {
        if (this.defaultMapUnits == -1) {
            XMLEntity xml = this.plugin.getPersistentXML();
            if (xml.contains("DefaultMapUnits")) {
                this.defaultMapUnits = xml.getIntProperty("DefaultMapUnits");
            } else {
                String[] unitNames = MapContext.getDistanceNames();
                for (int i = 0; i < unitNames.length; ++i) {
                    if (!unitNames[i].equals("Metros")) continue;
                    this.defaultMapUnits = i;
                    break;
                }
            }
            if (this.defaultMapUnits == -1 || this.defaultMapUnits >= MapContext.getDistanceNames().length) {
                this.defaultMapUnits = MapContext.getDistancePosition((String)"Metros");
            }
        }
        return this.defaultMapUnits;
    }

    public int getDefaultDistanceUnits() {
        if (this.defaultDistanceUnits == -1) {
            XMLEntity xml = this.plugin.getPersistentXML();
            if (xml.contains("DefaultDistanceUnits")) {
                this.defaultDistanceUnits = xml.getIntProperty("DefaultDistanceUnits");
            } else {
                String[] unitNames = MapContext.getDistanceNames();
                for (int i = 0; i < unitNames.length; ++i) {
                    if (!unitNames[i].equals("Metros")) continue;
                    this.defaultDistanceUnits = i;
                    break;
                }
            }
            if (this.defaultDistanceUnits == -1 || this.defaultDistanceUnits >= MapContext.getDistanceNames().length) {
                this.defaultDistanceUnits = MapContext.getDistancePosition((String)"Metros");
            }
        }
        return this.defaultDistanceUnits;
    }

    public int getDefaultDistanceArea() {
        if (this.defaultDistanceArea == -1) {
            XMLEntity xml = this.plugin.getPersistentXML();
            if (xml.contains("DefaultDistanceArea")) {
                this.defaultDistanceArea = xml.getIntProperty("DefaultDistanceArea");
            } else {
                String[] unitNames = MapContext.getAreaNames();
                for (int i = 0; i < unitNames.length; ++i) {
                    if (!unitNames[i].equals("Metros")) continue;
                    this.defaultDistanceArea = i;
                    break;
                }
            }
            if (this.defaultDistanceArea == -1 || this.defaultDistanceArea >= MapContext.getAreaNames().length) {
                this.defaultDistanceArea = this.getDefaultDistanceUnits();
            }
        }
        return this.defaultDistanceArea;
    }

    public void setDefaultMapUnits(int mapUnits) {
        this.defaultMapUnits = mapUnits;
        XMLEntity xml = this.plugin.getPersistentXML();
        xml.putProperty("DefaultMapUnits", mapUnits);
    }

    public void setDefaultDistanceUnits(int distanceUnits) {
        this.defaultDistanceUnits = distanceUnits;
        XMLEntity xml = this.plugin.getPersistentXML();
        xml.putProperty("DefaultDistanceUnits", distanceUnits);
    }

    public void setDefaultDistanceArea(int distanceArea) {
        this.defaultDistanceArea = distanceArea;
        XMLEntity xml = this.plugin.getPersistentXML();
        xml.putProperty("DefaultDistanceArea", distanceArea);
    }

    public boolean getAddNewLayersInInvisibleMode() {
        Boolean addNewLayersInInvisibleMode = (Boolean)this.pluginPreferences.getDynValue(ADD_NEW_LAYERS_IN_INVISIBLE_MODE);
        if (addNewLayersInInvisibleMode == null) {
            XMLEntity xml = this.plugin.getPersistentXML();
            addNewLayersInInvisibleMode = xml.contains(ADD_NEW_LAYERS_IN_INVISIBLE_MODE) ? Boolean.valueOf(xml.getBooleanProperty(ADD_NEW_LAYERS_IN_INVISIBLE_MODE)) : Boolean.valueOf(false);
            this.pluginPreferences.setDynValue(ADD_NEW_LAYERS_IN_INVISIBLE_MODE, (Object)addNewLayersInInvisibleMode);
        }
        return BooleanUtils.isTrue((Boolean)addNewLayersInInvisibleMode);
    }

    public void setAddNewLayersInInvisibleMode(boolean addNewLayersInInvisibleMode) {
        this.pluginPreferences.setDynValue(ADD_NEW_LAYERS_IN_INVISIBLE_MODE, (Object)addNewLayersInInvisibleMode);
    }

    public boolean getOpenWithANewMaximizedView() {
        Boolean openWithANewMaximizedView = (Boolean)this.pluginPreferences.getDynValue(OPEN_WITH_A_NEW_MAXIMIZED_VIEW);
        if (openWithANewMaximizedView == null) {
            XMLEntity xml = this.plugin.getPersistentXML();
            openWithANewMaximizedView = xml.contains(OPEN_WITH_A_NEW_MAXIMIZED_VIEW) ? Boolean.valueOf(xml.getBooleanProperty(OPEN_WITH_A_NEW_MAXIMIZED_VIEW)) : Boolean.valueOf(true);
            this.pluginPreferences.setDynValue(OPEN_WITH_A_NEW_MAXIMIZED_VIEW, (Object)openWithANewMaximizedView);
        }
        return BooleanUtils.isTrue((Boolean)openWithANewMaximizedView);
    }

    public void setOpenWithANewMaximizedView(boolean openWithANewMaximizedView) {
        this.pluginPreferences.setDynValue(OPEN_WITH_A_NEW_MAXIMIZED_VIEW, (Object)openWithANewMaximizedView);
    }

    public boolean getKeepScaleOnResizing() {
        Boolean keepScaleOnResizing = (Boolean)this.pluginPreferences.getDynValue(KEEP_SCALE_ON_RESIZING);
        if (keepScaleOnResizing == null) {
            XMLEntity xml = this.plugin.getPersistentXML();
            keepScaleOnResizing = xml.contains(KEEP_SCALE_ON_RESIZING) ? Boolean.valueOf(xml.getBooleanProperty(KEEP_SCALE_ON_RESIZING)) : Boolean.valueOf(false);
            this.pluginPreferences.setDynValue(KEEP_SCALE_ON_RESIZING, (Object)keepScaleOnResizing);
        }
        return BooleanUtils.isTrue((Boolean)keepScaleOnResizing);
    }

    public void setKeepScaleOnResizing(boolean keepScaleOnResizing) {
        this.pluginPreferences.setDynValue(KEEP_SCALE_ON_RESIZING, (Object)keepScaleOnResizing);
    }

    public double getZoomInFactor() {
        Double zoomInFactor = (Double)this.pluginPreferences.getDynValue(ZOOM_IN_FACTOR);
        if (zoomInFactor == null) {
            XMLEntity xml = this.plugin.getPersistentXML();
            zoomInFactor = xml.contains(ZOOM_IN_FACTOR) ? Double.valueOf(xml.getDoubleProperty(ZOOM_IN_FACTOR)) : Double.valueOf(MapContext.ZOOMINFACTOR);
            this.pluginPreferences.setDynValue(ZOOM_IN_FACTOR, (Object)zoomInFactor);
        }
        return zoomInFactor;
    }

    public void setZoomInFactor(double zoomInFactor) {
        this.pluginPreferences.setDynValue(ZOOM_IN_FACTOR, (Object)zoomInFactor);
    }

    public double getZoomOutFactor() {
        Double zoomOutFactor = (Double)this.pluginPreferences.getDynValue(ZOOM_OUT_FACTOR);
        if (zoomOutFactor == null) {
            XMLEntity xml = this.plugin.getPersistentXML();
            zoomOutFactor = xml.contains(ZOOM_OUT_FACTOR) ? Double.valueOf(xml.getDoubleProperty(ZOOM_OUT_FACTOR)) : Double.valueOf(MapContext.ZOOMOUTFACTOR);
            this.pluginPreferences.setDynValue(ZOOM_OUT_FACTOR, (Object)zoomOutFactor);
        }
        return zoomOutFactor;
    }

    public void setZoomOutFactor(double zoomOutFactor) {
        this.pluginPreferences.setDynValue(ZOOM_OUT_FACTOR, (Object)zoomOutFactor);
    }

    public boolean getHideLegendInToCOfNonVisibleLayers() {
        Boolean hideLegendInToCOfNonVisibleLayers = (Boolean)this.pluginPreferences.getDynValue("hideLegendInToCOfNonVisibleLayers");
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)hideLegendInToCOfNonVisibleLayers, (boolean)true);
    }

    public void setHideLegendInToCOfNonVisibleLayers(boolean hideLegendInToCOfNonVisibleLayers) {
        this.pluginPreferences.setDynValue("hideLegendInToCOfNonVisibleLayers", (Object)hideLegendInToCOfNonVisibleLayers);
    }
}

