/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.actions;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.AbstractDocumentAction;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.actions.CopyPasteDocsUtils;
import org.gvsig.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CutDocumentAction
extends AbstractDocumentAction {
    private static Logger logger = LoggerFactory.getLogger(CutDocumentAction.class);

    public CutDocumentAction() {
        super("cut");
        this.order = 0;
        this.title = PluginServices.getText((Object)this, (String)"cortar");
        this.group = ProjectManager.getInstance().addDocumentActionGroup("ClipboardActions", "Clipboard actions", null, 0);
    }

    @Override
    public int getOrder() {
        return 1;
    }

    @Override
    public boolean isVisible(Document item, List<Document> selectedItems) {
        return true;
    }

    @Override
    public boolean isAvailable(Document item, List<Document> selectedItems) {
        return selectedItems.size() > 0;
    }

    @Override
    public void execute(Document document, List<Document> documents) {
        ArrayList<Document> docs = new ArrayList<Document>(documents);
        if (document != null && !docs.contains(document)) {
            docs.add(document);
        }
        try {
            CopyPasteDocsUtils.saveToClipboard(docs);
        }
        catch (Exception e) {
            logger.info("While copying docs to clipboard in cut operation.", (Throwable)e);
            JOptionPane.showMessageDialog(ApplicationLocator.getManager().getRootComponent(), Messages.getText((String)"_Clipboard_error") + ":\n" + CopyPasteDocsUtils.getLastMessage(e), this.title, 0);
            try {
                CopyPasteDocsUtils.clearClipboard(null);
            }
            catch (Exception exc) {
                logger.error("While clearing clipboard.", (Throwable)exc);
            }
        }
        Project project = ProjectManager.getInstance().getCurrentProject();
        for (Document doc : docs) {
            if (!doc.isLocked()) continue;
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"locked_element_it_cannot_be_deleted") + ": " + doc.getName());
            return;
        }
        int option = JOptionPane.showConfirmDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"desea_borrar_el_documento"));
        if (option != 0) {
            return;
        }
        this.removeDocuments(docs, project);
    }

    private boolean removeDocuments(List<Document> selectedItems, Project project) {
        for (Document document : selectedItems) {
            if (document.isLocked()) {
                JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"locked_element_it_cannot_be_deleted") + ": " + document.getName());
                continue;
            }
            PluginServices.getMDIManager().closeSingletonWindow((Object)document);
            project.remove(document);
        }
        return true;
    }
}

