/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.fmap.dal.AbstractStoresRepository;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.util.UnmodifiableBasicSet;
import org.gvsig.tools.util.UnmodifiableBasicSetAdapter;

class ViewDocumentStoresRepository
extends AbstractStoresRepository {
    private final ViewDocument viewdoc;

    public ViewDocumentStoresRepository(String name, ViewDocument viewdoc) {
        super(name);
        this.viewdoc = viewdoc;
    }

    public ViewDocumentStoresRepository(ViewDocument viewdoc) {
        this(viewdoc.getName(), viewdoc);
    }

    private Map<String, Pair<DataStoreParameters, DataStore>> getAll() {
        HashMap<String, Pair<DataStoreParameters, DataStore>> all = new HashMap<String, Pair<DataStoreParameters, DataStore>>();
        for (FLayer layer : this.viewdoc.layers()) {
            FeatureStore store;
            if (!(layer instanceof FLyrVect) || (store = ((FLyrVect)layer).getFeatureStore()) == null) continue;
            String theName = layer.getName();
            if (all.containsKey(theName)) {
                theName = theName + "$";
                int counter = 1;
                while (all.containsKey(theName + counter)) {
                    ++counter;
                }
                theName = theName + counter;
            }
            all.put(theName, (Pair<DataStoreParameters, DataStore>)new ImmutablePair((Object)store.getParameters(), (Object)store));
        }
        if (all.isEmpty()) {
            return null;
        }
        return all;
    }

    private Map<String, Pair<FeatureType, FeatureStore>> getAllFeatureTypes() {
        HashMap<String, Pair<FeatureType, FeatureStore>> all = new HashMap<String, Pair<FeatureType, FeatureStore>>();
        for (FLayer layer : this.viewdoc.layers()) {
            FeatureStore store;
            if (!(layer instanceof FLyrVect) || (store = ((FLyrVect)layer).getFeatureStore()) == null) continue;
            String theName = layer.getName();
            if (all.containsKey(theName)) {
                theName = theName + "$";
                int counter = 1;
                while (all.containsKey(theName + counter)) {
                    ++counter;
                }
                theName = theName + counter;
            }
            all.put(theName, (Pair<FeatureType, FeatureStore>)new ImmutablePair((Object)store.getDefaultFeatureTypeQuietly(), (Object)store));
        }
        if (all.isEmpty()) {
            return null;
        }
        return all;
    }

    protected DataStoreParameters getMyParameters(String name) {
        Map<String, Pair<DataStoreParameters, DataStore>> all = this.getAll();
        if (all == null) {
            return null;
        }
        Pair<DataStoreParameters, DataStore> data = all.get(name);
        if (data == null) {
            return null;
        }
        return (DataStoreParameters)data.getLeft();
    }

    protected FeatureType getMyFeatureType(String name) {
        Map<String, Pair<FeatureType, FeatureStore>> all = this.getAllFeatureTypes();
        if (all == null) {
            return null;
        }
        Pair<FeatureType, FeatureStore> data = all.get(name);
        if (data == null) {
            return null;
        }
        return (FeatureType)all.get(name).getLeft();
    }

    public DataStore getStore(String name) {
        Map<String, Pair<DataStoreParameters, DataStore>> all = this.getAll();
        if (all == null) {
            return null;
        }
        Pair<DataStoreParameters, DataStore> data = all.get(name);
        if (data == null) {
            return null;
        }
        DataStore store = (DataStore)data.getRight();
        DisposeUtils.bind((Disposable)store);
        return store;
    }

    public String getStoreId(String label) {
        Map<String, Pair<DataStoreParameters, DataStore>> all = this.getAll();
        if (all == null) {
            return null;
        }
        Pair<DataStoreParameters, DataStore> data = all.get(label);
        if (data == null) {
            return null;
        }
        return this.getID() + "/" + label;
    }

    public boolean containsKey(String key) {
        Map<String, Pair<DataStoreParameters, DataStore>> all = this.getAll();
        if (all == null) {
            return false;
        }
        return all.containsKey(key);
    }

    protected UnmodifiableBasicSet<String> getMyKeySet() {
        Map<String, Pair<DataStoreParameters, DataStore>> all = this.getAll();
        if (all == null) {
            return null;
        }
        return new UnmodifiableBasicSetAdapter(all.keySet());
    }

    protected boolean isEmptyMyRepository() {
        Map<String, Pair<DataStoreParameters, DataStore>> all = this.getAll();
        return all.isEmpty();
    }

    protected int getMySize() {
        Map<String, Pair<DataStoreParameters, DataStore>> all = this.getAll();
        return all.size();
    }

    public Iterator<DataStoreParameters> iterator() {
        Map<String, Pair<DataStoreParameters, DataStore>> all = this.getAll();
        final Iterator<Pair<DataStoreParameters, DataStore>> it = all.values().iterator();
        return new Iterator<DataStoreParameters>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public DataStoreParameters next() {
                return (DataStoreParameters)((Pair)it.next()).getLeft();
            }
        };
    }
}

