/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.expressionevaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.expressionevaluator.Function;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.ExpressionBuilderConfig;
import org.gvsig.expressionevaluator.swing.spi.AbstractElement;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.operations.SingleLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;

public class ViewLayersElement
extends AbstractElement
implements Element.GroupElement,
Element.SimpleElement {
    private final List<Element> children;

    public ViewLayersElement(ViewDocument view) {
        super(view.getName());
        DataSwingManager dalSwingManager = DALSwingLocator.getSwingManager();
        this.children = new ArrayList<Element>();
        Iterator<FLayer> it = view.deepiterator();
        while (it.hasNext()) {
            Object e;
            FLayer layer = it.next();
            if (!(layer instanceof SingleLayer)) continue;
            if (layer instanceof FLyrVect) {
                e = dalSwingManager.createFeatureStoreElement();
                e.setFeatureStore(((FLyrVect)layer).getFeatureStore());
                e.setName(layer.getName());
                this.children.add((Element)e);
                continue;
            }
            e = new LayerEntryElement(view, layer);
            this.children.add((Element)e);
        }
    }

    public Element setConfig(ExpressionBuilderConfig config) {
        super.setConfig(config);
        for (Element child : this.children) {
            child.setConfig(config);
        }
        return this;
    }

    public Collection<Element> getValues() {
        return this.children;
    }

    public Element get(int index) {
        return this.children.get(index);
    }

    public int size() {
        return this.children.size();
    }

    public Iterator<Element> iterator() {
        return this.children.iterator();
    }

    public void addElement(Element element) {
        this.children.add(element);
    }

    public void addElement(Function function) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<Element> getElements() {
        return this.children;
    }

    public void dispose() {
        for (Element child : this.children) {
            DisposeUtils.disposeQuietly((Disposable)child);
        }
        this.children.clear();
    }

    private class LayerEntryElement
    extends AbstractElement
    implements Element.ConstantElement {
        private final FLayer layer;

        public LayerEntryElement(ViewDocument view, FLayer layer) {
            super(layer.getName(), (Object)layer.getName(), "expressionbuilder-element-constant");
            this.layer = layer;
        }

        public Object getValue() {
            return this.layer.getName();
        }
    }
}

