/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.commons.collections4.CollectionUtils;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectExtent;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class ExtentListSelectorModel
implements ListModel,
PropertyChangeListener {
    private final Project project;
    private final List<ListDataListener> listeners = new ArrayList<ListDataListener>();

    public ExtentListSelectorModel(Project p) {
        this.project = p;
    }

    @Override
    public int getSize() {
        ProjectExtent[] extents = this.project.getExtents();
        List<Document> views = this.project.getDocuments(ViewManager.TYPENAME);
        if (CollectionUtils.isEmpty(views)) {
            return extents.length;
        }
        return extents.length + views.size();
    }

    public ProjectExtent getElementAt(int arg0) {
        ProjectExtent[] extents = this.project.getExtents();
        if (arg0 < extents.length) {
            return extents[arg0];
        }
        int n = arg0 - extents.length;
        List<Document> views = this.project.getDocuments(ViewManager.TYPENAME);
        if (CollectionUtils.isEmpty(views) || views.size() < n) {
            return null;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        ViewDocument view = (ViewDocument)views.get(n);
        ProjectExtent extent = new ProjectExtent();
        extent.setExtent(view.getMapContext().getViewPort().getEnvelope());
        extent.setDescription(i18n.getTranslation("Vista") + ": " + view.getName());
        return extent;
    }

    public boolean isView(int index) {
        ProjectExtent[] extents = this.project.getExtents();
        return index >= extents.length;
    }

    @Override
    public void addListDataListener(ListDataListener arg0) {
        this.listeners.add(arg0);
    }

    @Override
    public void removeListDataListener(ListDataListener arg0) {
        this.listeners.remove(arg0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent change) {
        if (change.getPropertyName().equals("addExtent")) {
            ListDataEvent event = new ListDataEvent(this, 1, 0, this.getSize());
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).intervalAdded(event);
            }
        } else {
            ListDataEvent event = new ListDataEvent(this, 2, 0, this.getSize());
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).intervalRemoved(event);
            }
        }
    }
}

