/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.gui.JComboBoxUnits;
import org.gvsig.app.gui.panels.CRSSelectPanel;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.ProjectPreferences;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.i18n.Messages;
import org.gvsig.propertypage.PropertiesPage;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.pickercontroller.ColorPickerController;

public class GeneralViewPropertiesPage
extends JPanel
implements PropertiesPage {
    private static final long serialVersionUID = 1356416393907133043L;
    private JPanel propertiesPanel;
    private JLabel jLabelName = null;
    private JTextField txtName = null;
    private JLabel jLabelDate = null;
    private JTextField txtDate = null;
    private JLabel jLabelOwner = null;
    private JTextField txtOwner = null;
    private JLabel jLabelMapUnits = null;
    private JComboBox cmbMapUnits = null;
    private JLabel jLabelDistanceUnits = null;
    private JComboBox cmbDistanceUnits = null;
    private JLabel jLabelAreaUnits = null;
    private JTextArea txtComments = null;
    private JLabel jLabelColor = null;
    private JLabel jLabelSelectionColor = null;
    private JLabel jLabelComments = null;
    private JTextField txtColor = null;
    private JTextField txtSelectionColor = null;
    private JCheckBox setAsDefCrsChk = null;
    private Color backColor = null;
    private JButton btnColor = null;
    private JButton btnSelectionColor = null;
    private ViewDocument view = null;
    private JScrollPane jScrollPane = null;
    protected CRSSelectPanel jPanelProj = null;
    private boolean isAcceppted = false;
    private JComboBox cmbDistanceArea = null;
    private ColorPickerController colorPicker;
    private ColorPickerController selectionColorPicker;

    public GeneralViewPropertiesPage(ViewDocument view) {
        super(new BorderLayout());
        this.view = view;
        this.initComponents();
    }

    public void setData(Object data) {
    }

    public boolean whenAccept() {
        this.isAcceppted = true;
        return this.whenApply();
    }

    public boolean whenApply() {
        String name = this.txtName.getText();
        if (name == null || name.length() == 0) {
            return false;
        }
        Project project = ProjectManager.getInstance().getCurrentProject();
        List<Document> views = project.getDocuments(ViewManager.TYPENAME);
        for (Document theView : views) {
            if (this.view.equals(theView) || !theView.getName().equals(name)) continue;
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), Messages.getText((String)"elemento_ya_existe"));
            return false;
        }
        if (!this.view.isLocked()) {
            this.view.setName(name);
            this.view.setCreationDate(this.txtDate.getText());
            this.view.setOwner(this.txtOwner.getText());
            this.view.setComment(this.txtComments.getText());
            this.view.getMapContext().getViewPort().setMapUnits(this.cmbMapUnits.getSelectedIndex());
            this.view.getMapContext().getViewPort().setDistanceUnits(this.cmbDistanceUnits.getSelectedIndex());
            this.view.getMapContext().getViewPort().setDistanceArea(this.cmbDistanceArea.getSelectedIndex());
            this.view.setBackColor(this.backColor);
            this.view.getMapContext().setSelectionColor(this.txtSelectionColor.getBackground());
            if (this.jPanelProj.isOkPressed()) {
                if (!this.jPanelProj.getCurProj().isProjected()) {
                    this.getCmbMapUnits().setSelectedItem(Messages.getText((String)"Grados"));
                    this.getCmbMapUnits().setEnabled(false);
                } else {
                    if (this.getCmbMapUnits().getSelectedItem().equals(Messages.getText((String)"Grados"))) {
                        this.getCmbMapUnits().setSelectedIndex(1);
                    }
                    this.getCmbMapUnits().setEnabled(true);
                }
                this.view.setProjection(this.jPanelProj.getCurProj());
                if (this.getSetAsDefaultCrsCheckbox().isSelected()) {
                    this.setAppDefaultCRS(this.jPanelProj.getCurProj().getAbrev());
                }
                this.view.getMapContext().getViewPort().setMapUnits(this.cmbMapUnits.getSelectedIndex());
            }
        }
        return true;
    }

    public boolean whenCancel() {
        this.isAcceppted = false;
        return true;
    }

    public String getTitle() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("General");
    }

    public int getPriority() {
        return 1000;
    }

    public JComponent asJComponent() {
        return this;
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        this.add(this.getCenterPanel(), "North");
        this.selectionColorPicker = toolsSwingManager.createColorPickerController((JTextComponent)this.txtSelectionColor, this.btnSelectionColor);
        Color theColor = this.view.getMapContext().getSelectionColor();
        if (theColor == null) {
            theColor = MapContext.DEFAULT_SELECTION_COLOR;
        }
        this.selectionColorPicker.set((Object)theColor);
        this.colorPicker = toolsSwingManager.createColorPickerController((JTextComponent)this.txtColor, this.btnColor);
        this.backColor = theColor = this.view.getMapContext().getViewPort().getBackColor();
        if (theColor == null) {
            theColor = Color.WHITE;
        }
        this.colorPicker.set((Object)theColor);
    }

    private Component getCenterPanel() {
        if (this.propertiesPanel == null) {
            this.propertiesPanel = new JPanel(new GridBagLayout());
            this.propertiesPanel.setLayout(new GridBagLayout());
            this.propertiesPanel.setBorder(BorderFactory.createEmptyBorder(4, 5, 4, 5));
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 5, 2, 5);
            c.gridy = -1;
            this.addRow(this.propertiesPanel, c, this.getJLabelName(), this.getTxtName());
            this.addRow(this.propertiesPanel, c, this.getJLabelDate(), this.getTxtDate());
            this.addRow(this.propertiesPanel, c, this.getJLabelOwner(), this.getTxtOwner());
            this.addRow(this.propertiesPanel, c, this.getJLabelMapUnits(), this.getCmbMapUnits());
            this.addRow(this.propertiesPanel, c, this.getJLabelDistanceUnits(), this.getCmbDistanceUnits());
            this.addRow(this.propertiesPanel, c, this.getJLabelAreaUnits(), this.getCmbDistanceArea());
            this.addRow(this.propertiesPanel, c, new JLabel(" "), new JLabel(" "));
            GridLayout gl = new GridLayout(1, 2);
            JPanel selectionColorPanel = new JPanel(gl);
            selectionColorPanel.add(this.getJLabelSelectionColor());
            JPanel secondHalfPanel = new JPanel(new GridBagLayout());
            GridBagConstraints c2 = new GridBagConstraints();
            c2.fill = 1;
            c2.weightx = 1.0;
            c2.gridx = 0;
            c2.gridwidth = 1;
            c2.gridy = 0;
            c2.insets = new Insets(0, 1, 0, 1);
            secondHalfPanel.add((Component)this.getTxtSelectionColor(), c2);
            c2.fill = 0;
            c2.weightx = 0.0;
            c2.gridx = 1;
            secondHalfPanel.add((Component)this.getBtnSelectionColor(), c2);
            selectionColorPanel.add(secondHalfPanel);
            c.gridx = 0;
            c.gridwidth = 2;
            ++c.gridy;
            this.propertiesPanel.add((Component)selectionColorPanel, c);
            c.gridwidth = 1;
            gl = new GridLayout(1, 2);
            JPanel colorPanel = new JPanel(gl);
            colorPanel.add(this.getJLabelColor());
            secondHalfPanel = new JPanel(new GridBagLayout());
            c2 = new GridBagConstraints();
            c2.fill = 1;
            c2.weightx = 1.0;
            c2.gridx = 0;
            c2.gridwidth = 1;
            c2.gridy = 0;
            c2.insets = new Insets(0, 1, 0, 1);
            secondHalfPanel.add((Component)this.getTxtColor(), c2);
            c2.fill = 0;
            c2.weightx = 0.0;
            c2.gridx = 1;
            secondHalfPanel.add((Component)this.getBtnColor(), c2);
            colorPanel.add(secondHalfPanel);
            c.gridx = 0;
            c.gridwidth = 2;
            ++c.gridy;
            this.propertiesPanel.add((Component)colorPanel, c);
            c.gridwidth = 1;
            c.anchor = 17;
            c.weightx = 0.0;
            c.gridx = 0;
            c.gridwidth = 0;
            ++c.gridy;
            c.weightx = 1.0;
            c.fill = 2;
            this.propertiesPanel.add((Component)this.getJPanelProj(), c);
            c.anchor = 10;
            ++c.gridy;
            JPanel auxp = new JPanel(new BorderLayout());
            auxp.add((Component)this.getSetAsDefaultCrsCheckbox(), "Center");
            this.propertiesPanel.add((Component)auxp, c);
            this.addRow(this.propertiesPanel, c, new JLabel(" "), new JLabel(" "));
            c.anchor = 17;
            c.weightx = 0.0;
            c.gridx = 0;
            ++c.gridy;
            this.propertiesPanel.add((Component)this.getJLabelComments(), c);
            c.fill = 1;
            c.weightx = 1.0;
            ++c.gridy;
            c.gridwidth = 2;
            this.propertiesPanel.add((Component)this.getJScrollPaneComments(), c);
        }
        return this.propertiesPanel;
    }

    private JCheckBox getSetAsDefaultCrsCheckbox() {
        if (this.setAsDefCrsChk == null) {
            this.setAsDefCrsChk = new JCheckBox(Messages.getText((String)"_Set_this_CRS_as_app_default"));
            this.updateSetAsDefaultCRSChk();
        }
        return this.setAsDefCrsChk;
    }

    private String getAppDefaultCRS() {
        ProjectPreferences pp = new ProjectPreferences();
        IProjection curr_def = pp.getDefaultProjection();
        return curr_def.getAbrev();
    }

    private void setAppDefaultCRS(String abbrev) {
        IProjection proj = CRSFactory.getCRS((String)abbrev);
        ProjectPreferences projectPreferences = ApplicationLocator.getProjectManager().getProjectPreferences();
        projectPreferences.setDefaultProjection(proj);
    }

    private void updateSetAsDefaultCRSChk() {
        String curr_app_crs_def;
        IProjection view_proj = this.getJPanelProj().getCurProj();
        String view_abbrev = view_proj.getAbrev();
        if (view_abbrev.compareToIgnoreCase(curr_app_crs_def = this.getAppDefaultCRS()) == 0) {
            this.getSetAsDefaultCrsCheckbox().setSelected(true);
            this.getSetAsDefaultCrsCheckbox().setEnabled(false);
        } else {
            this.getSetAsDefaultCrsCheckbox().setEnabled(true);
            this.getSetAsDefaultCrsCheckbox().setSelected(false);
        }
    }

    private void addRow(JComponent panel, GridBagConstraints c, JComponent label, JComponent text) {
        c.anchor = 17;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        panel.add((Component)label, c);
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((Component)text, c);
    }

    private JLabel getJLabelName() {
        if (this.jLabelName == null) {
            this.jLabelName = new JLabel(Messages.getText((String)"nombre") + ":");
        }
        return this.jLabelName;
    }

    private JTextField getTxtName() {
        if (this.txtName == null) {
            this.txtName = new JTextField(this.view.getName());
        }
        return this.txtName;
    }

    private JLabel getJLabelDate() {
        if (this.jLabelDate == null) {
            this.jLabelDate = new JLabel(Messages.getText((String)"creation_date") + ":");
        }
        return this.jLabelDate;
    }

    private JTextField getTxtDate() {
        if (this.txtDate == null) {
            this.txtDate = new JTextField(this.view.getCreationDate());
            this.txtDate.setEditable(false);
            this.txtDate.setBackground(Color.white);
        }
        return this.txtDate;
    }

    private JLabel getJLabelOwner() {
        if (this.jLabelOwner == null) {
            this.jLabelOwner = new JLabel(Messages.getText((String)"owner") + ":");
        }
        return this.jLabelOwner;
    }

    private JTextField getTxtOwner() {
        if (this.txtOwner == null) {
            this.txtOwner = new JTextField(this.view.getOwner());
        }
        return this.txtOwner;
    }

    private JLabel getJLabelMapUnits() {
        if (this.jLabelMapUnits == null) {
            this.jLabelMapUnits = new JLabel(Messages.getText((String)"map_units") + ":");
        }
        return this.jLabelMapUnits;
    }

    private JComboBox getCmbMapUnits() {
        if (this.cmbMapUnits == null || MapContext.getDistanceNames().length > this.cmbMapUnits.getItemCount()) {
            this.cmbMapUnits = new JComboBoxUnits(false);
            IProjection proj = this.view.getProjection();
            if (!proj.isProjected()) {
                this.cmbMapUnits.setSelectedItem(Messages.getText((String)"Grados"));
                this.cmbMapUnits.setEnabled(false);
            } else {
                if (this.cmbMapUnits.getItemCount() != MapContext.getDistanceNames().length) {
                    this.cmbMapUnits.removeItem(Messages.getText((String)"Grados"));
                    this.view.getMapContext().getViewPort().setMapUnits(1);
                }
                this.cmbMapUnits.setSelectedIndex(this.view.getMapContext().getViewPort().getMapUnits());
                this.cmbMapUnits.setEnabled(true);
            }
        }
        return this.cmbMapUnits;
    }

    private JLabel getJLabelDistanceUnits() {
        if (this.jLabelDistanceUnits == null) {
            this.jLabelDistanceUnits = new JLabel(Messages.getText((String)"distance_units") + ":");
        }
        return this.jLabelDistanceUnits;
    }

    private JLabel getJLabelAreaUnits() {
        if (this.jLabelAreaUnits == null) {
            this.jLabelAreaUnits = new JLabel(Messages.getText((String)"unidades_area") + ":");
        }
        return this.jLabelAreaUnits;
    }

    private JComboBox getCmbDistanceUnits() {
        if (this.cmbDistanceUnits == null || MapContext.getDistanceNames().length > this.cmbDistanceUnits.getItemCount()) {
            this.cmbDistanceUnits = new JComboBoxUnits(false);
            this.cmbDistanceUnits.setSelectedIndex(this.view.getMapContext().getViewPort().getDistanceUnits());
        }
        return this.cmbDistanceUnits;
    }

    private JLabel getJLabelComments() {
        if (this.jLabelComments == null) {
            this.jLabelComments = new JLabel(Messages.getText((String)"comentarios") + ":");
            this.jLabelComments.setHorizontalAlignment(2);
            this.jLabelComments.setHorizontalTextPosition(2);
        }
        return this.jLabelComments;
    }

    private JTextArea getTxtComments() {
        if (this.txtComments == null) {
            this.txtComments = new JTextArea(this.view.getComment());
            this.txtComments.setRows(3);
            this.txtComments.setColumns(20);
        }
        return this.txtComments;
    }

    private JLabel getJLabelColor() {
        if (this.jLabelColor == null) {
            this.jLabelColor = new JLabel(Messages.getText((String)"background_color") + ":");
        }
        return this.jLabelColor;
    }

    private JLabel getJLabelSelectionColor() {
        if (this.jLabelSelectionColor == null) {
            this.jLabelSelectionColor = new JLabel(Messages.getText((String)"_Selection_color") + ":");
        }
        return this.jLabelSelectionColor;
    }

    private JTextField getTxtColor() {
        if (this.txtColor == null) {
            this.txtColor = new JTextField();
        }
        return this.txtColor;
    }

    private JTextField getTxtSelectionColor() {
        if (this.txtSelectionColor == null) {
            this.txtSelectionColor = new JTextField();
        }
        return this.txtSelectionColor;
    }

    private JButton getBtnColor() {
        if (this.btnColor == null) {
            this.btnColor = new JButton();
            this.btnColor.setText("...");
        }
        return this.btnColor;
    }

    private JButton getBtnSelectionColor() {
        if (this.btnSelectionColor == null) {
            this.btnSelectionColor = new JButton();
            this.btnSelectionColor.setText("...");
        }
        return this.btnSelectionColor;
    }

    private JScrollPane getJScrollPaneComments() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getTxtComments());
            Dimension dim = this.getTxtComments().getPreferredSize();
            this.jScrollPane.setMinimumSize(new Dimension(dim.width, dim.height + 10));
        }
        return this.jScrollPane;
    }

    private CRSSelectPanel getJPanelProj() {
        if (this.jPanelProj == null) {
            IProjection proj = this.view.getProjection();
            this.jPanelProj = CRSSelectPanel.getPanel((IProjection)proj);
            this.jPanelProj.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (GeneralViewPropertiesPage.this.jPanelProj.isOkPressed()) {
                        int numberOfLayers = GeneralViewPropertiesPage.this.view.getMapContext().getLayers().getLayersCount();
                        if (numberOfLayers > 0) {
                            GeneralViewPropertiesPage.this.warningViewProjectionChange();
                        }
                        if (!GeneralViewPropertiesPage.this.jPanelProj.getCurProj().isProjected()) {
                            GeneralViewPropertiesPage.this.getCmbMapUnits().setSelectedItem(PluginServices.getText((Object)this, (String)"Grados"));
                            GeneralViewPropertiesPage.this.getCmbMapUnits().setEnabled(false);
                        } else {
                            if (GeneralViewPropertiesPage.this.getCmbMapUnits().getSelectedItem().equals(PluginServices.getText((Object)this, (String)"Grados"))) {
                                GeneralViewPropertiesPage.this.getCmbMapUnits().setSelectedIndex(1);
                            }
                            GeneralViewPropertiesPage.this.getCmbMapUnits().setEnabled(true);
                        }
                        GeneralViewPropertiesPage.this.updateSetAsDefaultCRSChk();
                    }
                }
            });
        }
        return this.jPanelProj;
    }

    private void warningViewProjectionChange() {
        JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), Messages.getText((String)"view_contain_layers"));
    }

    public Object getWindowModel() {
        return this.view;
    }

    public boolean isAcceppted() {
        return this.isAcceppted;
    }

    private JComboBox getCmbDistanceArea() {
        String[] names = MapContext.getAreaNames();
        if (this.cmbDistanceArea == null || names.length > this.cmbDistanceArea.getItemCount()) {
            for (int i = 0; i < names.length; ++i) {
                names[i] = Messages.getText((String)names[i]) + MapContext.getOfLinear((int)i);
            }
            this.cmbDistanceArea = new JComboBox<String>(names);
            this.cmbDistanceArea.setEditable(false);
            this.cmbDistanceArea.setSelectedIndex(this.view.getMapContext().getViewPort().getDistanceArea());
        }
        return this.cmbDistanceArea;
    }
}

