/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.info.gui;

import org.gvsig.app.project.documents.view.info.gui.XMLItem;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class VectorialXMLItem
implements XMLItem {
    private FeatureSet selection;
    private FLayer layer;

    public VectorialXMLItem(FeatureSet selection, FLayer layer) {
        this.selection = selection;
        this.layer = layer;
    }

    @Override
    public FLayer getLayer() {
        return this.layer;
    }

    @Override
    public void parse(ContentHandler handler) throws SAXException {
        AttributesImpl aii = new AttributesImpl();
        handler.startElement("", "", this.layer.getName(), aii);
        DisposableIterator iterator = null;
        try {
            iterator = this.selection.fastIterator();
            int j = 0;
            while (iterator.hasNext()) {
                Feature feature = (Feature)iterator.next();
                AttributesImpl ai = new AttributesImpl();
                FeatureType featureType = ((FLyrVect)this.layer).getFeatureStore().getDefaultFeatureType();
                for (int k = 0; k < featureType.size(); ++k) {
                    FeatureAttributeDescriptor attr = featureType.get(k);
                    Object value = feature.get(k);
                    String strValue = value == null ? "{null}" : value.toString();
                    ai.addAttribute("", attr.getName(), attr.getName(), "xs:string", strValue);
                }
                handler.startElement("", "", String.valueOf(j), ai);
                handler.endElement("", "", String.valueOf(j));
                ++j;
            }
        }
        catch (ReadException e) {
            throw new SAXException((Exception)((Object)e));
        }
        catch (DataException e) {
            throw new SAXException((Exception)((Object)e));
        }
        finally {
            DisposeUtils.dispose((Disposable)iterator);
        }
        handler.endElement("", "", this.layer.getName());
    }
}

