/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.legend.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.app.project.documents.view.legend.gui.AbstractThemeManagerPage;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.geom.type.GeometryTypeNotSupportedException;
import org.gvsig.fmap.geom.type.GeometryTypeNotValidException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLyrDefault;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.gui.beans.swing.JBlank;
import org.gvsig.tools.locator.LocatorException;

public class General
extends AbstractThemeManagerPage {
    private static final long serialVersionUID = 1L;
    private FLayer layer;
    private NumberFormat nf = NumberFormat.getInstance();
    private JPanel pnlLayerName = null;
    private GridBagLayoutPanel pnlScale = null;
    private JPanel pnlProperties = null;
    private JLabel lblLayerName = null;
    private JTextField txtLayerName = null;
    private JTextField txtMaxScale = null;
    private JTextArea propertiesTextArea = null;
    private JRadioButton rdBtnShowAlways = null;
    private JRadioButton rdBtnDoNotShow = null;
    private JTextField txtMinScale = null;
    private JScrollPane scrlProperties;

    public General() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        GridBagLayoutPanel aux = new GridBagLayoutPanel();
        aux.addComponent((Component)this.getPnlLayerName());
        aux.addComponent((Component)new JBlank(10, 10));
        aux.addComponent("", (Component)this.getPnlScale());
        JPanel aux2 = new JPanel(new GridLayout(1, 2));
        aux2.add(this.getPnlProperties());
        aux.addComponent((Component)aux2);
        aux.setPreferredSize(this.getPreferredSize());
        this.add((Component)aux, "Center");
        this.add((Component)new JBlank(5, 10), "West");
        this.add((Component)new JBlank(5, 10), "East");
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    @Override
    public void setModel(FLayer layer) {
        this.layer = layer;
        if (layer.getMinScale() != -1.0) {
            this.getTxtMaxScale().setText(this.nf.format(layer.getMinScale()));
        }
        if (layer.getMaxScale() != -1.0) {
            this.getTxtMinScale().setText(this.nf.format(layer.getMaxScale()));
        }
        if (layer.getMinScale() == -1.0 && layer.getMaxScale() == -1.0) {
            this.getRdBtnShowAlways().setSelected(true);
            this.txtMaxScale.setEnabled(false);
            this.txtMinScale.setEnabled(false);
        } else {
            this.getRdBtnDoNotShowWhen().setSelected(true);
            this.txtMaxScale.setEnabled(true);
            this.txtMinScale.setEnabled(true);
        }
        this.txtLayerName.setText(layer.getName());
        this.showLayerInfo();
    }

    private JPanel getPnlLayerName() {
        if (this.pnlLayerName == null) {
            this.lblLayerName = new JLabel();
            this.pnlLayerName = new JPanel();
            this.lblLayerName.setText(PluginServices.getText((Object)this, (String)"Nombre") + ":");
            this.lblLayerName.setComponentOrientation(ComponentOrientation.UNKNOWN);
            this.pnlLayerName.setComponentOrientation(ComponentOrientation.UNKNOWN);
            this.pnlLayerName.add((Component)this.lblLayerName, null);
            this.pnlLayerName.add((Component)this.getTxtLayerName(), null);
        }
        return this.pnlLayerName;
    }

    private GridBagLayoutPanel getPnlScale() {
        if (this.pnlScale == null) {
            this.pnlScale = new GridBagLayoutPanel();
            this.pnlScale.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), PluginServices.getText((Object)this, (String)"rango_de_escalas"), 0, 0, null, null));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.getRdBtnShowAlways());
            buttonGroup.add(this.getRdBtnDoNotShowWhen());
            this.pnlScale.addComponent((Component)this.getRdBtnShowAlways());
            this.pnlScale.addComponent((Component)this.getRdBtnDoNotShowWhen());
            JPanel aux = new JPanel(new FlowLayout(0));
            aux.add(this.getTxtMaxScale());
            aux.add(new JLabel("(" + PluginServices.getText((Object)this, (String)"escala_maxima") + ")"));
            GridBagLayoutPanel aux2 = new GridBagLayoutPanel();
            aux2.addComponent(PluginServices.getText((Object)this, (String)"este_por_encima_de") + " 1:", (Component)aux);
            aux = new JPanel(new FlowLayout(0));
            aux.add(this.getTxtMinScale());
            aux.add(new JLabel("(" + PluginServices.getText((Object)this, (String)"escala_minima") + ")"));
            aux2.addComponent(PluginServices.getText((Object)this, (String)"este_por_debajo_de_") + " 1:", (Component)aux);
            this.pnlScale.addComponent((Component)new JBlank(20, 1), (Component)aux2);
            this.pnlScale.addComponent((Component)new JBlank(20, 1), (Component)aux2);
        }
        return this.pnlScale;
    }

    private JPanel getPnlProperties() {
        if (this.pnlProperties == null) {
            this.pnlProperties = new JPanel();
            this.pnlProperties.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), PluginServices.getText((Object)this, (String)"propiedades"), 0, 0, null, null));
            this.pnlProperties.add((Component)this.getScrlProperties(), null);
        }
        return this.pnlProperties;
    }

    private JTextField getTxtLayerName() {
        if (this.txtLayerName == null) {
            this.txtLayerName = new JTextField(25);
            this.txtLayerName.setEditable(false);
        }
        return this.txtLayerName;
    }

    private JTextField getTxtMaxScale() {
        if (this.txtMaxScale == null) {
            this.txtMaxScale = new JTextField(15);
            this.txtMaxScale.setEnabled(false);
        }
        return this.txtMaxScale;
    }

    private JTextArea getPropertiesTextArea() {
        if (this.propertiesTextArea == null) {
            this.propertiesTextArea = new JTextArea();
            this.propertiesTextArea.setEditable(false);
            this.propertiesTextArea.setBackground(SystemColor.control);
        }
        return this.propertiesTextArea;
    }

    private JScrollPane getScrlProperties() {
        if (this.scrlProperties == null) {
            this.scrlProperties = new JScrollPane();
            this.scrlProperties.setViewportView(this.getPropertiesTextArea());
            this.scrlProperties.setBorder(BorderFactory.createBevelBorder(1));
            this.scrlProperties.setPreferredSize(new Dimension(350, 180));
        }
        return this.scrlProperties;
    }

    private JRadioButton getRdBtnShowAlways() {
        if (this.rdBtnShowAlways == null) {
            this.rdBtnShowAlways = new JRadioButton();
            this.rdBtnShowAlways.setText(PluginServices.getText((Object)this, (String)"Mostrar_siempre"));
            this.rdBtnShowAlways.setSelected(true);
            this.rdBtnShowAlways.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    General.this.txtMaxScale.setEnabled(false);
                    General.this.txtMinScale.setEnabled(false);
                }
            });
        }
        return this.rdBtnShowAlways;
    }

    private JRadioButton getRdBtnDoNotShowWhen() {
        if (this.rdBtnDoNotShow == null) {
            this.rdBtnDoNotShow = new JRadioButton();
            this.rdBtnDoNotShow.setText(PluginServices.getText((Object)this, (String)"No_mostrar_la_capa_cuando_la_escala"));
            this.rdBtnDoNotShow.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    General.this.txtMaxScale.setEnabled(true);
                    General.this.txtMinScale.setEnabled(true);
                }
            });
        }
        return this.rdBtnDoNotShow;
    }

    private JTextField getTxtMinScale() {
        if (this.txtMinScale == null) {
            this.txtMinScale = new JTextField(15);
            this.txtMinScale.setEnabled(false);
        }
        return this.txtMinScale;
    }

    private String getLayerName() {
        return this.txtLayerName.getText().toString();
    }

    private void showLayerInfo() {
        try {
            String info = ((FLyrDefault)this.layer).getInfoString();
            if (info == null) {
                StringBuffer buff = new StringBuffer();
                Envelope fullExtentViewPort = this.layer.getFullEnvelope();
                IProjection viewPortProj = this.layer.getMapContext().getProjection();
                buff.append(PluginServices.getText((Object)this, (String)"Extent"));
                buff.append(" ");
                buff.append(viewPortProj.getAbrev());
                buff.append(" (" + PluginServices.getText((Object)this, (String)"view_projection") + "):\n\t");
                buff.append(PluginServices.getText((Object)this, (String)"Superior") + ":\t" + fullExtentViewPort.getMaximum(1) + "\n\t");
                buff.append(PluginServices.getText((Object)this, (String)"Inferior") + ":\t" + fullExtentViewPort.getMinimum(1) + "\n\t");
                buff.append(PluginServices.getText((Object)this, (String)"Izquierda") + ":\t" + fullExtentViewPort.getMinimum(0) + "\n\t");
                buff.append(PluginServices.getText((Object)this, (String)"Derecha") + ":\t" + fullExtentViewPort.getMaximum(0) + "\n");
                if (this.layer.getProjection() != null && !this.layer.getProjection().getAbrev().equals(viewPortProj.getAbrev())) {
                    IProjection nativeLayerProj = this.layer.getProjection();
                    ICoordTrans ct = viewPortProj.getCT(nativeLayerProj);
                    Envelope nativeLayerExtent = fullExtentViewPort.convert(ct);
                    buff.append(PluginServices.getText((Object)this, (String)"Extent") + " ");
                    buff.append(nativeLayerProj.getAbrev());
                    buff.append(" (" + PluginServices.getText((Object)this, (String)"layer_native_projection") + "):\n\t");
                    buff.append(PluginServices.getText((Object)this, (String)"Superior") + ":\t" + nativeLayerExtent.getMaximum(1) + "\n\t");
                    buff.append(PluginServices.getText((Object)this, (String)"Inferior") + ":\t" + nativeLayerExtent.getMinimum(1) + "\n\t");
                    buff.append(PluginServices.getText((Object)this, (String)"Izquierda") + ":\t" + nativeLayerExtent.getMinimum(0) + "\n\t");
                    buff.append(PluginServices.getText((Object)this, (String)"Derecha") + ":\t" + nativeLayerExtent.getMaximum(0) + "\n");
                }
                if (this.layer instanceof FLyrVect) {
                    FeatureStore fStore = ((FLyrVect)this.layer).getFeatureStore();
                    buff.append(PluginServices.getText((Object)this, (String)"Origen_de_datos") + ": ");
                    buff.append(fStore.getName());
                    info = buff.toString();
                    DataStoreParameters parameters = fStore.getParameters();
                    info = parameters instanceof FilesystemStoreParameters ? info + "\n" + PluginServices.getText((Object)this, (String)"fichero") + ": " + ((FilesystemStoreParameters)parameters).getFile() : info + "\n" + fStore.getName() + "\n";
                    String sGeomType = "Unknow";
                    try {
                        GeometryType geomType = ((FLyrVect)this.layer).getTypeVectorLayer();
                        sGeomType = geomType.getName();
                    }
                    catch (LocatorException e) {
                        NotificationManager.addError((Throwable)e);
                    }
                    catch (GeometryTypeNotSupportedException e) {
                        NotificationManager.showMessageWarning((String)"Not supported GeometryType", (Exception)((Object)e));
                    }
                    catch (GeometryTypeNotValidException e) {
                        NotificationManager.showMessageWarning((String)"Not valid GeometryType", (Exception)((Object)e));
                    }
                    info = info + "\n" + PluginServices.getText((Object)this, (String)"type") + ": " + sGeomType + "\n";
                } else {
                    info = buff.toString();
                    info = info + PluginServices.getText((Object)this, (String)"Origen_de_datos") + ": " + this.layer.getName();
                }
            }
            this.getPropertiesTextArea().setText(info);
        }
        catch (ReadException e) {
            NotificationManager.addError((String)e.getMessage(), (Throwable)e);
        }
        catch (DataException e) {
            NotificationManager.addError((String)e.getMessage(), (Throwable)e);
        }
    }

    private boolean isScaleActive() {
        return this.getRdBtnDoNotShowWhen().isSelected();
    }

    @Override
    public void acceptAction() {
    }

    @Override
    public void cancelAction() {
    }

    @Override
    public void applyAction() {
        block9: {
            if (this.isScaleActive()) {
                try {
                    this.layer.setMinScale(this.nf.parse(this.getTxtMaxScale().getText()).doubleValue());
                }
                catch (ParseException ex) {
                    if (this.getTxtMaxScale().getText().compareTo("") == 0) {
                        this.layer.setMinScale(-1.0);
                    }
                    System.err.print(ex.getLocalizedMessage());
                }
                try {
                    this.layer.setMaxScale(this.nf.parse(this.getTxtMinScale().getText()).doubleValue());
                }
                catch (ParseException ex) {
                    if (this.getTxtMinScale().getText().compareTo("") == 0) {
                        this.layer.setMaxScale(-1.0);
                        break block9;
                    }
                    System.err.print(ex.getLocalizedMessage());
                }
            } else {
                this.layer.setMinScale(-1.0);
                this.layer.setMaxScale(-1.0);
            }
        }
        if (!this.getLayerName().equals(this.layer.getName())) {
            this.layer.setName(this.getLayerName());
        }
    }

    @Override
    public String getName() {
        return PluginServices.getText((Object)this, (String)"General");
    }
}

