/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.legend.gui;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class LegendFileFilter
extends FileFilter {
    private String fileExt = "";
    private String description = "";
    private I18nManager i18n = ToolsLocator.getI18nManager();

    public LegendFileFilter(String ext, String desc) {
        this.fileExt = ext.toLowerCase();
        this.description = desc;
    }

    public LegendFileFilter(String ext) {
        StringBuilder sb = new StringBuilder();
        this.fileExt = ext.toLowerCase();
        this.description = this.i18n.getTranslation("format_for_legends");
        this.description = StringUtils.replace((String)this.description, (String)"%(ext)", (String)ext.toUpperCase());
        sb.append(this.description);
        sb.append(" (*." + ext.toLowerCase() + ")");
        this.description = sb.toString();
    }

    public String getFileExtension() {
        return this.fileExt;
    }

    @Override
    public boolean accept(File pathname) {
        if (pathname.isDirectory()) {
            return true;
        }
        return pathname.getAbsolutePath().toLowerCase().endsWith("." + this.fileExt);
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

