/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.legend.gui.legendactions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.documents.view.legend.gui.LegendFileFilter;
import org.gvsig.app.project.documents.view.legend.gui.LegendsPanel;
import org.gvsig.app.project.documents.view.legend.gui.legendactions.AbstractLoadSaveLegendAction;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.driver.ILegendReader;
import org.gvsig.i18n.Messages;

public class LoadLegendAction
extends AbstractLoadSaveLegendAction {
    private static final long serialVersionUID = 8023893921676942206L;

    public LoadLegendAction() {
        this.putValue("Name", PluginServices.getText((Object)this, (String)"Recuperar_leyenda") + "...");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!(e.getSource() instanceof LegendsPanel)) {
            return;
        }
        try {
            this.loadLegend((LegendsPanel)e.getSource());
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(ApplicationLocator.getManager().getRootComponent(), Messages.getText((String)"_Unable_to_read_legend") + "\n\n" + e1.getMessage(), Messages.getText((String)"legend"), 2);
        }
    }

    private void loadLegend(LegendsPanel legends) throws Exception {
        List<LegendFileFilter> filters = this.getLegendFileFilters(false);
        if (filters.isEmpty()) {
            JOptionPane.showMessageDialog(ApplicationLocator.getManager().getRootComponent(), Messages.getText((String)"_No_input_format_available"), Messages.getText((String)"legend"), 2);
            return;
        }
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(false);
        for (int i = 0; i < filters.size(); ++i) {
            fileChooser.addChoosableFileFilter(filters.get(i));
        }
        if (fileChooser.showOpenDialog((Component)PluginServices.getMainFrame()) == 0) {
            File file = fileChooser.getSelectedFile();
            LegendFileFilter lff = (LegendFileFilter)fileChooser.getFileFilter();
            MapContextManager mcoman = MapContextLocator.getMapContextManager();
            ILegendReader lr = mcoman.createLegendReader(lff.getFileExtension());
            ILegend leg = lr.read(file, 0);
            legends.setLegend(leg);
        }
    }
}

