/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toc.actions;

import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.extension.ProjectExtension;
import org.gvsig.app.gui.styling.SymbolSelector;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.documents.view.legend.gui.ISymbolSelector;
import org.gvsig.app.project.documents.view.toc.AbstractTocContextMenuAction;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.app.project.documents.view.toc.TocItemLeaf;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.IClassifiedVectorLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.ISingleSymbolLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorLegend;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.impl.MultiLayerFillSymbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeSymbolTocMenuEntry
extends AbstractTocContextMenuAction {
    private static final Logger logger = LoggerFactory.getLogger(ChangeSymbolTocMenuEntry.class);

    @Override
    public String getGroup() {
        return "group1";
    }

    @Override
    public int getGroupOrder() {
        return 10;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public String getText() {
        return PluginServices.getText((Object)this, (String)"change_symbol");
    }

    @Override
    public boolean isEnabled(ITocItem item, FLayer[] selectedItems) {
        return true;
    }

    @Override
    public boolean isVisible(ITocItem item, FLayer[] selectedItems) {
        return this.isTocItemLeaf(item);
    }

    @Override
    public void execute(ITocItem item, FLayer[] selectedItems) {
        boolean showDialog = this.isTocItemLeaf(item);
        if (!showDialog) {
            return;
        }
        try {
            int shapeType;
            if (!(selectedItems[0] instanceof FLyrVect)) {
                return;
            }
            FLyrVect layer = (FLyrVect)selectedItems[0];
            ISymbol oldSymbol = ((TocItemLeaf)item).getSymbol();
            if (oldSymbol instanceof MultiLayerFillSymbol) {
                MultiLayerFillSymbol ms = (MultiLayerFillSymbol)oldSymbol;
                for (int i = 0; i < ms.getLayerCount(); ++i) {
                    if (!ms.getLayer(i).getClass().getName().equals("org.gvsig.symbology.symbols.DotDensityFillSymbol")) continue;
                    return;
                }
            }
            if ((shapeType = ((IVectorLegend)layer.getLegend()).getShapeType()) == 0) {
                logger.debug("Error legend " + layer.getLegend() + " does not have shapetype initialized");
                shapeType = layer.getShapeType();
            }
            ISymbolSelector symSel = null;
            try {
                symSel = SymbolSelector.createSymbolSelector((Object)oldSymbol, (int)shapeType);
            }
            catch (IllegalArgumentException iaEx) {
                return;
            }
            PluginServices.getMDIManager().addWindow((IWindow)symSel);
            ISymbol newSymbol = (ISymbol)symSel.getSelectedObject();
            if (newSymbol == null) {
                return;
            }
            newSymbol.setDescription(oldSymbol.getDescription());
            for (int i = 0; i < selectedItems.length; ++i) {
                FLyrVect theLayer = (FLyrVect)selectedItems[i];
                try {
                    ILegend legend = theLayer.getLegend();
                    if (legend instanceof IClassifiedVectorLegend) {
                        IClassifiedVectorLegend cv = (IClassifiedVectorLegend)legend;
                        cv.replace(oldSymbol, newSymbol);
                        continue;
                    }
                    if (!(legend instanceof ISingleSymbolLegend)) continue;
                    ISingleSymbolLegend ss = (ISingleSymbolLegend)legend;
                    ss.setDefaultSymbol(newSymbol);
                    continue;
                }
                catch (Exception e) {
                    NotificationManager.addWarning((String)(PluginServices.getText((Object)this, (String)"skipped_symbol_changed_for_layer") + ": " + theLayer.getName()), (Throwable)e);
                }
            }
            MapContext mc = layer.getMapContext();
            mc.invalidate();
            Project project = ((ProjectExtension)PluginServices.getExtension(ProjectExtension.class)).getProject();
            project.setModified(true);
            mc.callLegendChanged();
        }
        catch (ReadException e) {
            NotificationManager.addError((String)PluginServices.getText((Object)this, (String)"getting_shape_type"), (Throwable)e);
        }
    }
}

