/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toc.actions;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JOptionPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.extension.ProjectExtension;
import org.gvsig.app.project.Project;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.CancelationException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyPasteLayersUtils {
    private static Logger logger = LoggerFactory.getLogger(CopyPasteLayersUtils.class);
    private static String CLIPBOARD_FILE_NAME = "gvSIG_layers_clipboard.tmp";
    private static File clipboardFolder = null;

    private CopyPasteLayersUtils() {
    }

    private static PersistenceManager getPersMan() {
        return ToolsLocator.getPersistenceManager();
    }

    private static File getClipboardFolder() {
        if (clipboardFolder == null) {
            File appf = PluginsLocator.getManager().getApplicationHomeFolder();
            clipboardFolder = new File(appf, "clipboard-layers");
            clipboardFolder.mkdirs();
        }
        return clipboardFolder;
    }

    private static OutputStream getClipboardOStream() throws IOException {
        File f = new File(CopyPasteLayersUtils.getClipboardFolder(), CLIPBOARD_FILE_NAME);
        if (f.exists()) {
            f.delete();
        }
        f.createNewFile();
        f.deleteOnExit();
        return new FileOutputStream(f);
    }

    public static void clearClipboard() throws IOException {
        File f = new File(CopyPasteLayersUtils.getClipboardFolder(), CLIPBOARD_FILE_NAME);
        if (f.exists()) {
            f.delete();
        }
    }

    private static InputStream getClipboardIStream() throws IOException {
        File f = new File(CopyPasteLayersUtils.getClipboardFolder(), CLIPBOARD_FILE_NAME);
        if (f.exists()) {
            return new FileInputStream(f);
        }
        return null;
    }

    public static boolean isClipboardEmpty() {
        File f = new File(CopyPasteLayersUtils.getClipboardFolder(), CLIPBOARD_FILE_NAME);
        return !f.exists();
    }

    public static FLayers getClipboardAsFLayers() throws PersistenceException {
        InputStream is = null;
        try {
            is = CopyPasteLayersUtils.getClipboardIStream();
            if (is == null) {
                return null;
            }
            Object obj = CopyPasteLayersUtils.getPersMan().getObject(is);
            is.close();
            if (obj instanceof FLayers) {
                return (FLayers)obj;
            }
            return null;
        }
        catch (Exception e) {
            logger.info("While getting object from clipboard: ", (Throwable)e);
            throw new PersistenceException((Throwable)e);
        }
    }

    public static void saveToClipboard(PersistentState st) throws PersistenceException {
        OutputStream os = null;
        try {
            os = CopyPasteLayersUtils.getClipboardOStream();
            CopyPasteLayersUtils.getPersMan().saveState(st, os);
            os.close();
            if (st.getContext().getErrors() != null) {
                throw st.getContext().getErrors();
            }
        }
        catch (Exception ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    public static PersistentState getAsFLayersPersistentState(FLayer[] actives, MapContext ctxt) throws PersistenceException {
        FLayers lyrs = new FLayers();
        lyrs.setMapContext(ctxt);
        lyrs.setName("copy-paste-root");
        FLayer item = null;
        if (actives != null) {
            for (int i = 0; i < actives.length; ++i) {
                if (actives[i] instanceof FLayers) {
                    FLayers aux = (FLayers)actives[i];
                    FLayers copyaux = new FLayers();
                    copyaux.setMapContext(ctxt);
                    copyaux.setName(aux.getName());
                    for (int j = 0; j < aux.getLayersCount(); ++j) {
                        copyaux.addLayer(aux.getLayer(j));
                    }
                    lyrs.addLayer((FLayer)copyaux);
                    continue;
                }
                item = actives[i];
                try {
                    item = item.cloneLayer();
                }
                catch (Exception ex) {
                    throw new PersistenceException((Throwable)ex);
                }
                lyrs.addLayer(item);
            }
        }
        PersistentState state = null;
        state = CopyPasteLayersUtils.getPersMan().getState((Object)lyrs, true);
        if (state.getContext().getErrors() != null) {
            throw state.getContext().getErrors();
        }
        return state;
    }

    public static boolean removeLayers(FLayer[] actives, MapContext mc) {
        int i;
        if (actives == null || actives.length == 0) {
            return false;
        }
        for (i = 0; i < actives.length; ++i) {
            if (!actives[i].isEditing() || !actives[i].isAvailable()) continue;
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), Messages.getText((String)"no_se_puede_borrar_una_capa_en_edicion"), Messages.getText((String)"eliminar_capa"), 2);
            return false;
        }
        mc.beginAtomicEvent();
        for (i = actives.length - 1; i >= 0; --i) {
            try {
                FLayers parent = actives[i].getParentLayer();
                if (actives[i] instanceof FLayers) {
                    FLayers grouped = (FLayers)actives[i];
                    parent.removeLayer((FLayer)grouped);
                    while (grouped.getLayersCount() > 0) {
                        FLayer lay = grouped.getLayer(0);
                        grouped.removeLayer(lay);
                    }
                } else {
                    parent.removeLayer(actives[i]);
                }
                IWindow[] wList = PluginServices.getMDIManager().getAllWindows();
                for (int j = 0; j < wList.length; ++j) {
                    String name = wList[j].getWindowInfo().getAdditionalInfo();
                    for (int k = 0; k < actives.length; ++k) {
                        if (name == null || actives == null || actives[k] == null || actives[k].getName() == null || name.compareTo(actives[k].getName()) != 0) continue;
                        PluginServices.getMDIManager().closeWindow(wList[j]);
                    }
                }
                continue;
            }
            catch (CancelationException e1) {
                JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), Messages.getText((String)"No_ha_sido_posible_realizar_la_operacion"), Messages.getText((String)"eliminar_capa"), 2);
                logger.info("Error while removing layers.", (Throwable)e1);
                return false;
            }
        }
        mc.endAtomicEvent();
        Project project = ((ProjectExtension)PluginServices.getExtension(ProjectExtension.class)).getProject();
        project.setModified(true);
        PluginServices.getMainFrame().enableControls();
        return true;
    }

    public static boolean addLayers(FLayers clipboard_root, FLayers target_root) {
        if (clipboard_root == null || clipboard_root.getLayersCount() == 0) {
            return false;
        }
        int n = clipboard_root.getLayersCount();
        FLayer item = null;
        for (int i = 0; i < n; ++i) {
            item = clipboard_root.getLayer(i);
            target_root.addLayer(item);
        }
        return true;
    }
}

