/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toc.actions;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.gvsig.app.project.documents.view.toc.actions.LayerErrorsView;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.operations.SingleLayer;
import org.gvsig.fmap.mapcontrol.swing.dynobject.DynObjectEditor;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.util.impl.CallableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerErrorsPanel
extends LayerErrorsView {
    private static final Logger logger = LoggerFactory.getLogger(LayerErrorsPanel.class);
    private static final long serialVersionUID = -5972995402218954892L;
    private FLayer layer;

    public LayerErrorsPanel(FLayer layer) {
        this.initComponents();
        this.setLayer(layer);
    }

    public LayerErrorsPanel(String name, Exception ex) {
        this.initComponents();
        this.setName(name);
        this.setError(ex);
    }

    private void initComponents() {
        this.translate();
        this.txtMessage.setContentType("text/html");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayerErrorsPanel.this.doClose();
            }
        });
        this.btnViewParameters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayerErrorsPanel.this.doViewParameters();
            }
        });
        this.setPreferredSize(new Dimension(550, 400));
    }

    @Override
    public void setName(String name) {
        this.txtLayerName.setText(name);
    }

    public void setError(Throwable e) {
        ArrayList<Throwable> exs = new ArrayList<Throwable>();
        exs.add(e);
        this.txtMessage.setText(new MessageAsHTML(exs).toString());
        this.btnViewParameters.setEnabled(false);
    }

    public void setLayer(FLayer layer) {
        this.layer = layer;
        if (layer == null) {
            this.setName("(null)");
            this.txtMessage.setText("layer is null");
        } else {
            this.setName(layer.getName());
            this.txtMessage.setText(new MessageAsHTML(layer.getErrors()).toString());
        }
        this.btnViewParameters.setEnabled(this.layer instanceof SingleLayer);
    }

    private void translate() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.lblLayer.setText(i18nManager.getTranslation("_Layer") + ":");
        this.lblProblem.setText(i18nManager.getTranslation("_Problems") + ":");
        this.btnClose.setText(i18nManager.getTranslation("_Close"));
        this.btnViewParameters.setText(i18nManager.getTranslation("_View_properties_of_data_source"));
    }

    private void doClose() {
        this.setVisible(false);
    }

    private void doViewParameters() {
        try {
            DynObjectEditor editor = new DynObjectEditor((DynObject)((SingleLayer)this.layer).getDataStore().getParameters());
            editor.editObject(true);
        }
        catch (Throwable th) {
            logger.warn("Can't show standard properties dialog for this parameters.", th);
        }
    }

    private class MessageAsHTML {
        StringBuilder html;
        Set<String> usedMsgs;

        public MessageAsHTML(List<Throwable> exs) {
            this.clear();
            this.build(exs);
        }

        public MessageAsHTML() {
            this.clear();
        }

        public void clear() {
            this.html = new StringBuilder();
            this.usedMsgs = new HashSet<String>();
        }

        public void build(List<Throwable> exs) {
            for (Throwable ex : exs) {
                ArrayList causes = new ArrayList();
                causes.addAll(ExceptionUtils.getThrowableList((Throwable)ex));
                if (ex instanceof List) {
                    causes.addAll((List)((Object)ex));
                }
                for (Throwable cause : causes) {
                    if (cause instanceof List) continue;
                    if (cause instanceof CallableException) {
                        cause = ((CallableException)cause).getCause();
                    }
                    if (cause == null) continue;
                    String message = cause.getMessage();
                    if (message == null) {
                        message = cause.getClass().getSimpleName();
                    }
                    if (message.startsWith("_")) {
                        I18nManager i18n = ToolsLocator.getI18nManager();
                        message = i18n.getTranslation(message);
                    }
                    if (this.usedMsgs.contains(message)) continue;
                    this.usedMsgs.add(message);
                    this.html.append("<li>");
                    this.html.append(message.replace("\n", "<br>\n"));
                    if (cause.getCause() != null) {
                        this.build(ExceptionUtils.getThrowableList((Throwable)cause.getCause()));
                    }
                    this.html.append("</li>\n");
                }
            }
        }

        public String toString() {
            return "<ul>\n" + this.html.toString() + "</ul>\n";
        }
    }
}

