/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toc.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.BooleanUtils;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.ProjectPreferences;
import org.gvsig.app.project.documents.view.IContextMenuAction;
import org.gvsig.app.project.documents.view.toc.DnDJTree;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.app.project.documents.view.toc.ITocOrderListener;
import org.gvsig.app.project.documents.view.toc.TocItemBranch;
import org.gvsig.app.project.documents.view.toc.TocItemLeaf;
import org.gvsig.app.project.documents.view.toc.gui.FPopupMenu;
import org.gvsig.app.project.documents.view.toc.gui.TOCRenderer;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.events.AtomicEvent;
import org.gvsig.fmap.mapcontext.events.listeners.AtomicEventListener;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.LayerCollectionEvent;
import org.gvsig.fmap.mapcontext.layers.operations.Classifiable;
import org.gvsig.fmap.mapcontext.layers.operations.IHasImageLegend;
import org.gvsig.fmap.mapcontext.layers.operations.LayerCollection;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.IClassifiedLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.ISingleSymbolLegend;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TOC
extends JComponent {
    private static final long serialVersionUID = 5689047685537359038L;
    private static final Logger logger = LoggerFactory.getLogger(TOC.class);
    private MapContext mapContext;
    private final DnDJTree m_Tree;
    private final DefaultTreeModel m_TreeModel;
    private final DefaultMutableTreeNode m_Root;
    private final TOCRenderer m_TocRenderer;
    private final JScrollPane m_Scroller;
    private final ItemsExpandeds itemsExpandeds = new ItemsExpandeds();
    private NodeSelectionListener nodeSelectionListener = null;

    public TOC() {
        this.setName("TOC");
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(100, 80));
        this.setPreferredSize(new Dimension(100, 80));
        this.m_Root = new DefaultMutableTreeNode(Object.class);
        this.m_TreeModel = new DefaultTreeModel(this.m_Root);
        this.m_Tree = new DnDJTree(this.m_TreeModel);
        this.m_TocRenderer = new TOCRenderer(this.m_Tree.getBackground());
        this.m_Tree.setCellRenderer(this.m_TocRenderer);
        this.m_Tree.setRootVisible(false);
        this.m_Tree.setShowsRootHandles(true);
        this.m_Tree.getSelectionModel().setSelectionMode(4);
        this.nodeSelectionListener = new NodeSelectionListener(this.m_Tree);
        this.m_Tree.addMouseListener(this.nodeSelectionListener);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                TOC.this.tocResized();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.m_Tree.addOrderListener(new ITocOrderListener(){

            @Override
            public void orderChanged(int oldPos, int newPos, FLayers layers) {
                try {
                    layers.moveTo(oldPos, newPos);
                }
                catch (Exception e) {
                    logger.warn("Can't change order of layers in TOC", (Throwable)e);
                }
                TOC.this.mapContext.invalidate();
            }

            @Override
            public void parentChanged(FLayers source, FLayers targer, FLayer layer) {
                try {
                    source.move(layer, (LayerCollection)targer);
                }
                catch (Exception e) {
                    logger.warn("Can't move layers in TOC", (Throwable)e);
                }
                TOC.this.mapContext.invalidate();
            }
        });
        this.m_Tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (node.getUserObject() instanceof ITocItem) {
                    TOC.this.itemsExpandeds.setMark((ITocItem)node.getUserObject(), false);
                }
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (node.getUserObject() instanceof ITocItem) {
                    TOC.this.itemsExpandeds.setMark((ITocItem)node.getUserObject(), true);
                }
            }
        });
        this.m_Tree.setRowHeight(0);
        this.m_Scroller = new JScrollPane(this.m_Tree);
        this.m_Scroller.setBorder(BorderFactory.createEmptyBorder());
        this.add(this.m_Scroller);
    }

    public void removeListeners() {
        this.m_Tree.removeMouseListener(this.nodeSelectionListener);
        this.m_Tree.invalidateListeners();
    }

    public void setMapContext(MapContext mc) {
        this.mapContext = mc;
        this.mapContext.addAtomicEventListener(new AtomicEventListener(){

            public void atomicEvent(final AtomicEvent e) {
                LayerCollectionEvent[] events;
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.atomicEvent(e);
                        }
                    });
                    return;
                }
                if (e.getLayerCollectionEvents().length > 0 || e.getLegendEvents().length > 0) {
                    TOC.this.reloadLayers();
                }
                if (e.getLayerEvents().length > 0) {
                    TOC.this.repaint();
                }
                if (e.getExtentEvents().length > 0) {
                    TOC.this.repaint();
                }
                for (LayerCollectionEvent event : events = e.getLayerCollectionEvents()) {
                    if (event.getEventType() == 0 && PluginServices.getMainFrame() != null) {
                        PluginServices.getMainFrame().enableControls();
                    }
                    if (event.getEventType() != 3 || !TOC.this.haveToAddNewLayersInInvisibleMode()) continue;
                    event.getAffectedLayer().setVisible(false);
                }
            }
        });
        this.mapContext.getLayers().addLegendListener(e -> this.reloadLayers());
        this.reloadLayers();
    }

    public void refresh() {
        this.reloadLayers();
    }

    public void reloadLayers() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.reloadLayers());
            return;
        }
        FLayers theLayers = this.mapContext.getLayers();
        this.m_Root.removeAllChildren();
        this.m_Root.setAllowsChildren(true);
        this.reloadLayers((LayerCollection)theLayers, this.m_Root);
        this.m_TreeModel.reload();
        this.itemsExpandeds.update(this.m_Tree, this.m_Root);
    }

    private void reloadLayers(LayerCollection theLayers, DefaultMutableTreeNode parentNode) {
        int width = this.m_Tree.getWidth();
        if (width == 0) {
            width = 300;
        }
        Font font = this.m_Tree.getFont();
        FontMetrics metrics = this.getFontMetrics(font);
        Dimension sizeBranch = new Dimension(width, metrics.getHeight() + 4);
        for (int i = theLayers.getLayersCount() - 1; i >= 0; --i) {
            FLayer lyr = theLayers.getLayer(i);
            if (!lyr.isInTOC()) continue;
            TocItemBranch elTema = new TocItemBranch(lyr);
            elTema.setSize(sizeBranch);
            DefaultMutableTreeNode nodeLayer = new DefaultMutableTreeNode(elTema);
            this.m_TreeModel.insertNodeInto(nodeLayer, parentNode, parentNode.getChildCount());
            if (lyr instanceof LayerCollection) {
                LayerCollection group = (LayerCollection)lyr;
                this.reloadLayers(group, nodeLayer);
                continue;
            }
            if (!this.haveToShowLeyendOfLayer(lyr)) continue;
            this.addLegend(nodeLayer, lyr);
        }
    }

    private void addLegend(final DefaultMutableTreeNode nodeLayer, FLayer lyr) {
        int width = this.m_Tree.getWidth();
        if (width == 0) {
            width = 300;
        }
        Dimension sizeLeaf = new Dimension(width, 15);
        if (lyr instanceof Classifiable) {
            Classifiable classifiable = (Classifiable)lyr;
            ILegend legendInfo = classifiable.getLegend();
            try {
                if (legendInfo instanceof IClassifiedLegend) {
                    IClassifiedLegend cl = (IClassifiedLegend)legendInfo;
                    String[] descriptions = cl.getDescriptions();
                    ISymbol[] symbols = cl.getSymbols();
                    for (int j = 0; j < descriptions.length; ++j) {
                        TocItemLeaf itemLeaf = new TocItemLeaf(symbols[j], descriptions[j], classifiable.getShapeType());
                        itemLeaf.setSize(sizeLeaf);
                        DefaultMutableTreeNode nodeValue = new DefaultMutableTreeNode(itemLeaf);
                        this.m_TreeModel.insertNodeInto(nodeValue, nodeLayer, nodeLayer.getChildCount());
                    }
                }
                if (legendInfo instanceof ISingleSymbolLegend && legendInfo.getDefaultSymbol() != null) {
                    TocItemLeaf itemLeaf = new TocItemLeaf(legendInfo.getDefaultSymbol(), legendInfo.getDefaultSymbol().getDescription(), classifiable.getShapeType());
                    itemLeaf.setSize(sizeLeaf);
                    DefaultMutableTreeNode nodeValue = new DefaultMutableTreeNode(itemLeaf);
                    this.m_TreeModel.insertNodeInto(nodeValue, nodeLayer, nodeLayer.getChildCount());
                }
                if (legendInfo instanceof IHasImageLegend) {
                    final IHasImageLegend imageLegend = (IHasImageLegend)legendInfo;
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Image image = imageLegend.getImageLegend();
                            SwingUtilities.invokeLater(() -> {
                                int w = 0;
                                int h = 0;
                                if (image != null) {
                                    w = image.getWidth(null);
                                    h = image.getHeight(null);
                                }
                                if (image != null && w > 0 && h > 0) {
                                    TocItemLeaf itemLeaf = new TocItemLeaf();
                                    itemLeaf.setImageLegend(image, "", new Dimension(w, h));
                                    DefaultMutableTreeNode nodeValue = new DefaultMutableTreeNode(itemLeaf);
                                    TOC.this.m_TreeModel.insertNodeInto(nodeValue, nodeLayer, nodeLayer.getChildCount());
                                }
                            });
                        }
                    }, "ToCImageLegendUpdate");
                    thread.start();
                }
            }
            catch (Throwable e) {
                logger.warn(MessageFormat.format("Can't add leyend of layer {0} to the TOC.", lyr), e);
            }
        }
    }

    private void tocResized() {
        Enumeration<TreeNode> enumeration = this.m_Root.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!(n.getUserObject() instanceof TocItemBranch)) continue;
            ITocItem item = (ITocItem)n.getUserObject();
            Dimension szAnt = item.getSize();
            item.setSize(new Dimension(this.getWidth() - 40, szAnt.height));
        }
    }

    public JScrollPane getJScrollPane() {
        return this.m_Scroller;
    }

    public DnDJTree getTree() {
        return this.m_Tree;
    }

    private boolean haveToAddNewLayersInInvisibleMode() {
        ProjectPreferences projectPreferences = ApplicationLocator.getProjectManager().getProjectPreferences();
        return projectPreferences.getAddNewLayersInInvisibleMode();
    }

    private boolean haveToShowLeyendOfLayer(FLayer layer) {
        ProjectPreferences projectPreferences = ApplicationLocator.getProjectManager().getProjectPreferences();
        return layer.isVisible() || !projectPreferences.getHideLegendInToCOfNonVisibleLayers();
    }

    class NodeSelectionListener
    extends MouseAdapter {
        JTree tree;
        JDialog dlg;
        JColorChooser colorChooser;
        FPopupMenu popmenu = null;
        DefaultMutableTreeNode node;

        NodeSelectionListener(JTree tree) {
            this.tree = tree;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseClicked(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            int row = this.tree.getRowForLocation(x, y);
            TreePath path = this.tree.getPathForRow(row);
            FLayers layers = TOC.this.mapContext.getLayers();
            List<FLayer> plainListLayers = this.toPlainList((FLayer)layers);
            plainListLayers.remove(plainListLayers.size() - 1);
            int countDeepActiveLayers = this.countDeepActiveLayers(plainListLayers);
            if (path != null) {
                if (e.getClickCount() == 1) {
                    this.node = (DefaultMutableTreeNode)path.getLastPathComponent();
                }
                if (this.node != null && this.node.getUserObject() instanceof TocItemBranch) {
                    if (e.getClickCount() >= 2 && e.getButton() == 1) {
                        e.consume();
                        PluginServices.getMDIManager().setWaitCursor();
                        try {
                            TocItemBranch leaf = (TocItemBranch)this.node.getUserObject();
                            IContextMenuAction action = leaf.getDoubleClickAction();
                            if (action != null) {
                                FLayer[] actives;
                                ArrayList<Object> targetLayers = new ArrayList<Object>();
                                TocItemBranch owner = (TocItemBranch)this.node.getUserObject();
                                FLayer masterLayer = owner.getLayer();
                                targetLayers.add(masterLayer);
                                for (FLayer active : actives = TOC.this.mapContext.getLayers().getActives()) {
                                    if (active.getClass().equals(masterLayer.getClass())) {
                                        if (!(active instanceof FLyrVect)) continue;
                                        FLyrVect vectorLayer = (FLyrVect)active;
                                        FLyrVect vectorMaster = (FLyrVect)masterLayer;
                                        if (vectorLayer.getShapeType() == vectorMaster.getShapeType()) {
                                            targetLayers.add(vectorLayer);
                                            vectorLayer.setActive(true);
                                            continue;
                                        }
                                        vectorLayer.setActive(false);
                                        continue;
                                    }
                                    active.setActive(false);
                                }
                                for (int k = 0; k < targetLayers.size(); ++k) {
                                    if (!((FLayer)targetLayers.get(k)).isAvailable()) {
                                        return;
                                    }
                                    ((FLayer)targetLayers.get(k)).setActive(true);
                                }
                                action.execute(leaf, targetLayers.toArray(new FLayer[0]));
                            }
                        }
                        catch (Exception ex) {
                            NotificationManager.addError((Throwable)ex);
                        }
                        finally {
                            PluginServices.getMDIManager().restoreCursor();
                        }
                        return;
                    }
                    TocItemBranch elTema = (TocItemBranch)this.node.getUserObject();
                    FLayer lyr = elTema.getLayer();
                    if (lyr.isAvailable()) {
                        lyr.getMapContext().beginAtomicEvent();
                    }
                    if ((e.getModifiers() & 1) != 0 && (e.getButton() == 1 || e.getButton() == 3)) {
                        if (countDeepActiveLayers > 0) {
                            this.selectInterval(plainListLayers, lyr);
                        } else {
                            this.setActiveLayer(lyr, !lyr.isActive());
                        }
                    } else if ((e.getModifiers() & 2) == 0) {
                        boolean active;
                        if (e.getButton() == 1) {
                            if (countDeepActiveLayers > 1) {
                                layers.setAllActives(false);
                                this.setActiveLayer(lyr, true);
                            } else {
                                active = lyr.isActive();
                                layers.setAllActives(false);
                                this.setActiveLayer(lyr, !active);
                            }
                        }
                        if (e.getButton() == 3 && !lyr.isActive()) {
                            active = lyr.isActive();
                            layers.setAllActives(false);
                            this.setActiveLayer(lyr, !active);
                        }
                    } else {
                        if (e.getButton() == 1) {
                            this.setActiveLayer(lyr, !lyr.isActive());
                        }
                        if (e.getButton() == 3 && !lyr.isActive()) {
                            lyr.setActive(true);
                        }
                    }
                    Point layerNodeLocation = this.tree.getUI().getPathBounds(this.tree, path).getLocation();
                    Rectangle checkBoxBounds = TOC.this.m_TocRenderer.getCheckBoxBounds();
                    checkBoxBounds.translate((int)layerNodeLocation.getX(), (int)layerNodeLocation.getY());
                    if (checkBoxBounds.contains(e.getPoint())) {
                        this.updateVisible(lyr);
                    }
                    if (e.getButton() == 3) {
                        this.popmenu = new FPopupMenu(TOC.this.mapContext, this.node);
                        this.tree.add(this.popmenu);
                        this.popmenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                    if (lyr.isAvailable()) {
                        lyr.getMapContext().endAtomicEvent();
                    }
                }
                if (this.node != null && this.node.getUserObject() instanceof TocItemLeaf) {
                    TocItemBranch owner = (TocItemBranch)((DefaultMutableTreeNode)this.node.getParent()).getUserObject();
                    FLayer masterLayer = owner.getLayer();
                    if (e.getClickCount() >= 2 && e.getButton() == 1) {
                        e.consume();
                        PluginServices.getMDIManager().setWaitCursor();
                        try {
                            TocItemLeaf leaf = (TocItemLeaf)this.node.getUserObject();
                            IContextMenuAction action = leaf.getDoubleClickAction();
                            if (action != null) {
                                action.execute(leaf, new FLayer[]{masterLayer});
                            }
                        }
                        catch (Exception ex) {
                            logger.warn("Problems executing action in the ToC.", (Throwable)ex);
                        }
                        finally {
                            PluginServices.getMDIManager().restoreCursor();
                        }
                        return;
                    }
                }
                ((DefaultTreeModel)this.tree.getModel()).nodeChanged(this.node);
                if (row == 0) {
                    this.tree.revalidate();
                    this.tree.repaint();
                }
                if (PluginServices.getMainFrame() != null) {
                    PluginServices.getMainFrame().enableControls();
                }
            } else if (e.getButton() == 3) {
                this.popmenu = new FPopupMenu(TOC.this.mapContext, null);
                this.tree.add(this.popmenu);
                this.popmenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        private void setActiveLayer(FLayer layer, boolean active) {
            if (layer instanceof FLayers) {
                FLayers group = (FLayers)layer;
                if (group.isActive()) {
                    if (active) {
                        group.setActive(true, true);
                    } else {
                        group.setActive(false, false);
                    }
                } else if (active) {
                    group.setActive(true, false);
                } else {
                    group.setActive(false, true);
                }
                return;
            }
            layer.setActive(active);
        }

        private void selectInterval(List<FLayer> layers, FLayer lyr) {
            int firstActive = Integer.MAX_VALUE;
            int lastActive = -1;
            int myLayer = -1;
            for (int j = 0; j < layers.size(); ++j) {
                FLayer layerAux = layers.get(j);
                if (layerAux.isActive()) {
                    if (firstActive > j) {
                        firstActive = j;
                    }
                    if (lastActive < j) {
                        lastActive = j;
                    }
                    if (layerAux.equals(lyr)) {
                        myLayer = j;
                    }
                }
                if (myLayer >= 0 || !layerAux.equals(lyr)) continue;
                myLayer = j;
            }
            if (firstActive < Integer.MAX_VALUE && myLayer >= 0) {
                for (int pasada = 0; pasada < 2; ++pasada) {
                    FLayer layerAux;
                    int j;
                    if (myLayer < firstActive) {
                        for (j = 0; j < myLayer; ++j) {
                            layerAux = layers.get(j);
                            if (pasada == 0) {
                                if (!(layerAux instanceof FLayers)) continue;
                                layerAux.setActive(false);
                                continue;
                            }
                            if (layerAux instanceof FLayers) continue;
                            layerAux.setActive(false);
                        }
                        for (j = myLayer; j <= lastActive; ++j) {
                            layerAux = layers.get(j);
                            if (pasada == 0) {
                                if (!(layerAux instanceof FLayers)) continue;
                                layerAux.setActive(true);
                                continue;
                            }
                            if (layerAux instanceof FLayers) continue;
                            layerAux.setActive(true);
                        }
                        for (j = lastActive + 1; j < layers.size(); ++j) {
                            layerAux = layers.get(j);
                            if (pasada == 0) {
                                if (!(layerAux instanceof FLayers)) continue;
                                layerAux.setActive(false);
                                continue;
                            }
                            if (layerAux instanceof FLayers) continue;
                            layerAux.setActive(false);
                        }
                        continue;
                    }
                    if (myLayer > lastActive) {
                        for (j = 0; j < firstActive; ++j) {
                            layerAux = layers.get(j);
                            if (pasada == 0) {
                                if (!(layerAux instanceof FLayers)) continue;
                                layerAux.setActive(false);
                                continue;
                            }
                            if (layerAux instanceof FLayers) continue;
                            layerAux.setActive(false);
                        }
                        for (j = firstActive; j <= myLayer; ++j) {
                            layerAux = layers.get(j);
                            if (pasada == 0) {
                                if (!(layerAux instanceof FLayers)) continue;
                                layerAux.setActive(true);
                                continue;
                            }
                            if (layerAux instanceof FLayers) continue;
                            layerAux.setActive(true);
                        }
                        for (j = myLayer + 1; j < layers.size(); ++j) {
                            layerAux = layers.get(j);
                            if (pasada == 0) {
                                if (!(layerAux instanceof FLayers)) continue;
                                layerAux.setActive(false);
                                continue;
                            }
                            if (layerAux instanceof FLayers) continue;
                            layerAux.setActive(false);
                        }
                        continue;
                    }
                    for (j = 0; j < myLayer; ++j) {
                        layerAux = layers.get(j);
                        if (pasada == 0) {
                            if (!(layerAux instanceof FLayers)) continue;
                            layerAux.setActive(false);
                            continue;
                        }
                        if (layerAux instanceof FLayers) continue;
                        layerAux.setActive(false);
                    }
                    for (j = myLayer; j <= lastActive; ++j) {
                        layerAux = layers.get(j);
                        if (pasada == 0) {
                            if (!(layerAux instanceof FLayers)) continue;
                            layerAux.setActive(true);
                            continue;
                        }
                        if (layerAux instanceof FLayers) continue;
                        layerAux.setActive(true);
                    }
                    for (j = lastActive + 1; j < layers.size(); ++j) {
                        layerAux = layers.get(j);
                        if (pasada == 0) {
                            if (!(layerAux instanceof FLayers)) continue;
                            layerAux.setActive(false);
                            continue;
                        }
                        if (layerAux instanceof FLayers) continue;
                        layerAux.setActive(false);
                    }
                }
            }
        }

        private List<FLayer> toPlainList(FLayer layer) {
            return this.toPlainList(layer, new ArrayList<FLayer>());
        }

        private List<FLayer> toPlainList(FLayer layer, List<FLayer> result) {
            if (layer instanceof FLayers) {
                FLayers layerGroup = (FLayers)layer;
                for (int i = 0; i < layerGroup.getLayersCount(); ++i) {
                    this.toPlainList(layerGroup.getLayer(i), result);
                }
            }
            result.add(layer);
            return result;
        }

        private int countDeepActiveLayers(List<FLayer> layers) {
            int count = 0;
            for (FLayer fLayer : layers) {
                if (!fLayer.isActive()) continue;
                ++count;
            }
            return count;
        }

        private void updateVisible(FLayer lyr) {
            if (lyr.isAvailable()) {
                lyr.setVisible(!lyr.visibleRequired());
                this.updateVisibleChild(lyr);
                this.updateVisibleParent(lyr);
                if (this.node != null && !(lyr instanceof FLayers)) {
                    if (TOC.this.haveToShowLeyendOfLayer(lyr)) {
                        if (this.node.getChildCount() == 0) {
                            TOC.this.addLegend(this.node, lyr);
                        }
                    } else {
                        this.node.removeAllChildren();
                        TOC.this.m_TreeModel.reload(this.node);
                    }
                }
            }
        }

        private void updateVisibleChild(FLayer lyr) {
            if (lyr instanceof FLayers) {
                FLayers layergroup = (FLayers)lyr;
                for (int i = 0; i < layergroup.getLayersCount(); ++i) {
                    layergroup.getLayer(i).setVisible(lyr.visibleRequired());
                    this.updateVisibleChild(layergroup.getLayer(i));
                }
            }
        }

        private void updateVisibleParent(FLayer lyr) {
            FLayers parent = lyr.getParentLayer();
            if (parent != null) {
                boolean parentVisible = false;
                for (int i = 0; i < parent.getLayersCount(); ++i) {
                    if (!parent.getLayer(i).visibleRequired()) continue;
                    parentVisible = true;
                }
                parent.setVisible(parentVisible);
                this.updateVisibleParent((FLayer)parent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            super.mouseReleased(arg0);
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
            super.mouseEntered(arg0);
        }
    }

    private static class ItemsExpandeds {
        private final Map<Object, Boolean> itemsExpanded = new HashMap<Object, Boolean>();
        private boolean expandingNodes = false;

        private ItemsExpandeds() {
        }

        public boolean isMarked(ITocItem item) {
            String key = item.getLabel();
            boolean isItemExpanded = BooleanUtils.isTrue((Boolean)this.itemsExpanded.get(key));
            return isItemExpanded;
        }

        public void setMark(ITocItem item, boolean expanded) {
            String key = item.getLabel();
            this.itemsExpanded.put(key, expanded);
        }

        public void removeLayer(FLayer layer) {
            String key = layer.getName();
            this.itemsExpanded.remove(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(JTree tree, TreeNode node) {
            if (this.expandingNodes) {
                return;
            }
            try {
                this.expandingNodes = true;
                DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
                Enumeration<? extends TreeNode> nodes = node.children();
                while (nodes.hasMoreElements()) {
                    DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)nodes.nextElement();
                    if (curNode.getChildCount() > 0) {
                        this.update(tree, curNode);
                    }
                    TreePath path = new TreePath(treeModel.getPathToRoot(curNode));
                    ITocItem item = (ITocItem)curNode.getUserObject();
                    if (this.isMarked(item)) {
                        tree.expandPath(path);
                        continue;
                    }
                    tree.collapsePath(path);
                }
            }
            finally {
                this.expandingNodes = false;
            }
        }
    }
}

