/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toolListeners;

import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.view.MapOverview;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.EnvelopeEvent;
import org.gvsig.fmap.mapcontrol.tools.Events.MoveEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PanListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.RectangleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapOverviewChangeZoomListener
implements RectangleListener,
PanListener {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(MapOverviewChangeZoomListener.class);
    private final Image izoomin = PluginServices.getIconTheme().get("cursor-zoom-in").getImage();
    protected MapControl mapControl;

    public MapOverviewChangeZoomListener(MapControl mapControl) {
        this.mapControl = mapControl;
    }

    public void rectangle(EnvelopeEvent event) throws BehaviorException {
        if (!this.checkModifiers(event.getEvent())) {
            return;
        }
        MapOverview mov = (MapOverview)this.mapControl;
        ViewPort vpView = mov.getAssociatedMapContext().getViewPort();
        ViewPort vp = mov.getViewPort();
        if (vp.getExtent() != null && vpView.getExtent() != null) {
            Rectangle2D pxRectangle = event.getPixelCoordRect();
            Envelope realRectangle = event.getWorldCoordRect();
            if (pxRectangle.getWidth() < 3.0 && pxRectangle.getHeight() < 3.0) {
                return;
            }
            vpView.setEnvelope(realRectangle);
            mov.getAssociatedMapContext().invalidate();
            vpView.setEnvelope(realRectangle);
        }
    }

    public Image getImageCursor() {
        return this.izoomin;
    }

    public boolean cancelDrawing() {
        return true;
    }

    public void move(MoveEvent event) throws BehaviorException {
        if (!this.checkModifiers(event.getEvent())) {
            return;
        }
        MapOverview mov = (MapOverview)this.mapControl;
        ViewPort vpView = mov.getAssociatedMapContext().getViewPort();
        ViewPort vp = mov.getViewPort();
        if (vp.getExtent() != null && vpView.getExtent() != null) {
            Point2D p1 = vp.toMapPoint(event.getFrom());
            Point2D p2 = vp.toMapPoint(event.getTo());
            Envelope realRectangle = null;
            double x = 0.0;
            double y = 0.0;
            double xMax = 0.0;
            double yMax = 0.0;
            if (p1.getX() < p2.getX()) {
                x = p1.getX();
                xMax = p2.getX();
            } else {
                x = p2.getX();
                xMax = p1.getX();
            }
            if (p1.getY() < p2.getY()) {
                y = p1.getY();
                yMax = p2.getY();
            } else {
                y = p2.getY();
                yMax = p1.getY();
            }
            try {
                realRectangle = geomManager.createEnvelope(x, y, xMax, yMax, 0);
            }
            catch (CreateEnvelopeException e) {
                logger.error("Error creating the envelope", (Throwable)e);
            }
            mov.refreshOverView(realRectangle);
        }
    }

    private boolean checkModifiers(MouseEvent event) {
        int keyPressedMask;
        int modifiers = event.getModifiers();
        return (modifiers & (keyPressedMask = 16)) == keyPressedMask;
    }
}

