/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toolListeners;

import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.view.MapOverview;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.MoveEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PanListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapOverviewPanListener
implements PanListener {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(MapOverviewPanListener.class);
    private final Image icursor = PluginServices.getIconTheme().get("cursor-crux").getImage();
    protected MapControl mapControl;

    public MapOverviewPanListener(MapControl mapControl) {
        this.mapControl = mapControl;
    }

    public Image getImageCursor() {
        return this.icursor;
    }

    public boolean cancelDrawing() {
        return true;
    }

    public void move(MoveEvent event) throws BehaviorException {
        if (!this.checkModifiers(event.getEvent())) {
            return;
        }
        MapOverview mov = (MapOverview)this.mapControl;
        ViewPort vp = mov.getViewPort();
        ViewPort vpView = mov.getAssociatedMapContext().getViewPort();
        if (vp.getExtent() != null && vpView.getExtent() != null) {
            Envelope curEnvelope = vpView.getAdjustedExtent();
            Point2D thePoint = vp.toMapPoint(event.getTo());
            double diffx = (curEnvelope.getMaximum(0) - curEnvelope.getMinimum(0)) / 2.0;
            double diffy = (curEnvelope.getMaximum(1) - curEnvelope.getMinimum(1)) / 2.0;
            try {
                Envelope envelope = geomManager.createEnvelope(thePoint.getX() - diffx, thePoint.getY() - diffy, thePoint.getX() + diffx, thePoint.getY() + diffy, 0);
                mov.refreshOverView(envelope);
                vpView.setEnvelope(envelope);
            }
            catch (CreateEnvelopeException e) {
                logger.error("Error creating the envelope", (Throwable)e);
            }
            mov.getAssociatedMapContext().invalidate();
        }
    }

    private boolean checkModifiers(MouseEvent event) {
        int keyPressedMask;
        int modifiers = event.getModifiers();
        return (modifiers & (keyPressedMask = 4)) == keyPressedMask;
    }
}

