/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.swing;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jpedal.PageOffsets;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.Commands;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.gui.generic.GUIMouseHandler;
import org.jpedal.examples.simpleviewer.gui.swing.SwingMouseSelection;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.render.DynamicVectorRenderer;

public class SwingMouseHandler
implements GUIMouseHandler {
    private PdfDecoder decode_pdf;
    private SwingGUI currentGUI;
    private Values commonValues;
    private Commands currentCommands;
    private String message = "";
    private Rectangle[] boxes = new Rectangle[8];
    private int handlesGap = 5;
    private int oldX = -1;
    private int oldY = -1;
    private boolean dragAltering = false;
    private int boxContained = -1;
    private boolean drawingCursorBox = false;
    private int old_m_x2 = -1;
    private int old_m_y2 = -1;
    private boolean drawingTurnover = false;
    private boolean previewTurnover = false;
    private boolean pageTurnAnimating = false;
    private int pageFlowCurrentPage;
    private double middleDragStartX;
    private double middleDragStartY;
    private double xVelocity;
    private double yVelocity;
    private Timer middleDragTimer;
    private int cx;
    private int cy;

    public int[] getCursorLocation() {
        return new int[]{this.cx, this.cy};
    }

    public SwingMouseHandler(PdfDecoder pdfDecoder, SwingGUI swingGUI, Values values, Commands commands) {
        this.decode_pdf = pdfDecoder;
        this.currentGUI = swingGUI;
        this.commonValues = values;
        this.currentCommands = commands;
        SwingMouseSelection swingMouseSelection = new SwingMouseSelection(pdfDecoder, values, this);
        swingMouseSelection.setupMouse();
        pdfDecoder.setMouseMode(0);
        pdfDecoder.addExternalHandler(this, 10);
    }

    public void checkLinks(boolean bl, PdfObjectReader pdfObjectReader) {
        Map map = this.currentGUI.getHotspots();
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            FormObject formObject = null;
            while (iterator.hasNext() && !(formObject = (FormObject)iterator.next()).getBoundingRectangle().contains(this.cx, this.cy)) {
                formObject = null;
            }
            if (formObject != null) {
                System.out.println(bl + " obj=" + formObject + " " + formObject.getObjectRefAsString() + " " + formObject.getBoundingRectangle());
                if (!bl) {
                    return;
                }
                PdfObject pdfObject = null;
                PdfObject pdfObject2 = formObject.getDictionary(5667);
                if (pdfObject2 != null) {
                    pdfObject = pdfObject2.getDictionary(5398);
                }
                JFileChooser jFileChooser = new JFileChooser(this.commonValues.getInputDir());
                jFileChooser.setFileSelectionMode(0);
                int n = jFileChooser.showSaveDialog(this.currentGUI.getFrame());
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    if (pdfObject != null) {
                        pdfObjectReader.checkResolved(pdfObject);
                    }
                    PdfObject pdfObject3 = pdfObject.getDictionary(22);
                    String string = pdfObject3.getCachedStreamFile(pdfObjectReader);
                    System.out.println("file=" + string);
                    if (string != null) {
                        ObjectStore.copy(string, file.toString());
                    } else {
                        byte[] byArray = pdfObject3.getDecodedStream();
                        if (byArray != null) {
                            try {
                                FileOutputStream fileOutputStream = new FileOutputStream(file);
                                fileOutputStream.write(byArray);
                                fileOutputStream.close();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                }
            }
        }
    }

    public void setupExtractor() {
        this.decode_pdf.addMouseMotionListener(new Extractor_mouse_mover());
        this.decode_pdf.addMouseListener(new Extractor_mouse_clicker());
    }

    protected void scrollAndUpdateCoords(MouseEvent mouseEvent) {
        int n = this.decode_pdf.getScrollInterval();
        Rectangle rectangle = new Rectangle(this.currentGUI.AdjustForAlignment(mouseEvent.getX()), mouseEvent.getY(), n, n);
        if (this.currentGUI.allowScrolling() && !this.decode_pdf.getVisibleRect().contains(rectangle)) {
            this.decode_pdf.scrollRectToVisible(rectangle);
        }
        this.updateCoords(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.isShiftDown());
    }

    public void updateCordsFromFormComponent(MouseEvent mouseEvent) {
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        int n = jComponent.getX() + mouseEvent.getX();
        int n2 = jComponent.getY() + mouseEvent.getY();
        this.updateCoords(n, n2, mouseEvent.isShiftDown());
    }

    public void updateCoords(int n, int n2, boolean bl) {
        float f = this.currentGUI.getScaling();
        SwingMouseHandler swingMouseHandler = this;
        int n3 = swingMouseHandler.currentGUI.getPDFDisplayInset();
        int n4 = this.currentGUI.getRotation();
        int n5 = this.currentGUI.AdjustForAlignment(n) - n3;
        int n6 = n2 - n3;
        if (this.commonValues.maxViewY != 0) {
            n5 = (int)((double)((float)n5 - (float)this.commonValues.dx * f) / this.commonValues.viewportScale);
            n6 = (int)(((double)this.currentGUI.mediaH - (double)((float)this.currentGUI.mediaH - (float)n6 / f - (float)this.commonValues.dy) / this.commonValues.viewportScale) * (double)f);
        }
        this.cx = (int)((float)n5 / f);
        this.cy = (int)((float)n6 / f);
        if (this.decode_pdf.getDisplayView() != 1) {
            this.cx = 0;
            this.cy = 0;
        } else if (n4 == 90) {
            int n7 = this.cx + this.currentGUI.cropY;
            this.cx = this.cy + this.currentGUI.cropX;
            this.cy = n7;
        } else if (n4 == 180) {
            this.cx = this.currentGUI.cropW + this.currentGUI.cropX - this.cx;
            this.cy += this.currentGUI.cropY;
        } else if (n4 == 270) {
            int n8 = this.currentGUI.cropH + this.currentGUI.cropY - this.cx;
            this.cx = this.currentGUI.cropW + this.currentGUI.cropX - this.cy;
            this.cy = n8;
        } else {
            this.cx += this.currentGUI.cropX;
            this.cy = this.currentGUI.cropH + this.currentGUI.cropY - this.cy;
        }
        SwingMouseHandler swingMouseHandler2 = this;
        if (swingMouseHandler2.commonValues.isProcessing() | this.commonValues.getSelectedFile() == null) {
            this.currentGUI.setCoordText("  X:  Y:   ");
        } else {
            this.currentGUI.setCoordText("  X: " + this.cx + " Y: " + this.cy + ' ' + ' ' + this.message);
        }
    }

    public void updateRectangle() {
        Rectangle rectangle;
        Rectangle rectangle2 = this.currentGUI.getRectangle();
        if (rectangle2 != null && (rectangle = this.decode_pdf.getCombinedAreas(rectangle2, false)) != null) {
            this.commonValues.m_x1 = rectangle.x;
            this.commonValues.m_y2 = rectangle.y;
            this.commonValues.m_x2 = rectangle.x + rectangle.width;
            this.commonValues.m_y1 = rectangle.y + rectangle.height;
            rectangle2 = rectangle;
            this.decode_pdf.updateCursorBoxOnScreen(rectangle2, PdfDecoder.highlightColor);
            this.decode_pdf.repaint();
        }
    }

    public void setupMouse() {
        this.decode_pdf.addMouseMotionListener(new mouse_mover());
        this.decode_pdf.addMouseListener(new mouse_clicker());
        this.decode_pdf.addMouseWheelListener(new mouse_wheel());
    }

    protected int[] updateXY(MouseEvent mouseEvent) {
        float f = this.currentGUI.getScaling();
        SwingMouseHandler swingMouseHandler = this;
        int n = swingMouseHandler.currentGUI.getPDFDisplayInset();
        int n2 = this.currentGUI.getRotation();
        int n3 = (int)((float)(this.currentGUI.AdjustForAlignment(mouseEvent.getX()) - n) / f);
        int n4 = (int)((float)(mouseEvent.getY() - n) / f);
        if (this.commonValues.maxViewY != 0) {
            n3 = (int)((double)((float)n3 - (float)this.commonValues.dx * f) / this.commonValues.viewportScale);
            n4 = (int)(((double)this.currentGUI.mediaH - (double)((float)this.currentGUI.mediaH - (float)n4 / f - (float)this.commonValues.dy) / this.commonValues.viewportScale) * (double)f);
        }
        int[] nArray = new int[2];
        if (n2 == 90) {
            nArray[1] = n3 + this.currentGUI.cropY;
            nArray[0] = n4 + this.currentGUI.cropX;
        } else if (n2 == 180) {
            nArray[0] = this.currentGUI.mediaW - (n3 + this.currentGUI.mediaW - this.currentGUI.cropW - this.currentGUI.cropX);
            nArray[1] = n4 + this.currentGUI.cropY;
        } else if (n2 == 270) {
            nArray[1] = this.currentGUI.mediaH - (n3 + this.currentGUI.mediaH - this.currentGUI.cropH - this.currentGUI.cropY);
            nArray[0] = this.currentGUI.mediaW - (n4 + this.currentGUI.mediaW - this.currentGUI.cropW - this.currentGUI.cropX);
        } else {
            nArray[0] = n3 + this.currentGUI.cropX;
            nArray[1] = this.currentGUI.mediaH - (n4 + this.currentGUI.mediaH - this.currentGUI.cropH - this.currentGUI.cropY);
        }
        return nArray;
    }

    public void setPageTurnAnimating(boolean bl) {
        this.pageTurnAnimating = bl;
        if (bl) {
            this.currentGUI.forward.setEnabled(false);
            this.currentGUI.back.setEnabled(false);
            this.currentGUI.fforward.setEnabled(false);
            this.currentGUI.fback.setEnabled(false);
            this.currentGUI.end.setEnabled(false);
            this.currentGUI.first.setEnabled(false);
        } else {
            this.currentGUI.hideRedundentNavButtons();
        }
    }

    public boolean getPageTurnAnimating() {
        return this.pageTurnAnimating;
    }

    static /* synthetic */ Rectangle[] access$2202(SwingMouseHandler swingMouseHandler, Rectangle[] rectangleArray) {
        swingMouseHandler.boxes = rectangleArray;
        return rectangleArray;
    }

    protected class Extractor_mouse_mover
    extends mouse_mover {
        private boolean inRect;
        private boolean handleChange;

        protected Extractor_mouse_mover() {
            this.inRect = false;
            this.handleChange = false;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            this.altIsDown = mouseEvent.isAltDown();
            Rectangle rectangle = SwingMouseHandler.this.currentGUI.getRectangle();
            if (rectangle == null || SwingMouseHandler.this.drawingCursorBox) {
                SwingMouseHandler.this.decode_pdf.setDrawCrossHairs(true, SwingMouseHandler.this.boxContained, Color.red);
                super.mouseDragged(mouseEvent);
                SwingMouseHandler.this.boxContained = -1;
                return;
            }
            int[] nArray = SwingMouseHandler.this.updateXY(mouseEvent);
            SwingMouseHandler.access$2202(SwingMouseHandler.this, this.createNewRectangles(rectangle));
            if (SwingMouseHandler.this.boxContained == -1) {
                for (n = 0; n < SwingMouseHandler.this.boxes.length; ++n) {
                    if (!SwingMouseHandler.this.boxes[n].contains(SwingMouseHandler.this.oldX, SwingMouseHandler.this.oldY)) continue;
                    SwingMouseHandler.this.boxContained = n;
                    break;
                }
            }
            if (SwingMouseHandler.this.boxContained != -1 || SwingMouseHandler.this.dragAltering) {
                SwingMouseHandler.this.drawingCursorBox = false;
                n = SwingMouseHandler.this.boxContained;
                int n2 = (int)SwingMouseHandler.this.boxes[SwingMouseHandler.this.boxContained].getCenterX();
                int n3 = (int)SwingMouseHandler.this.boxes[SwingMouseHandler.this.boxContained].getCenterY();
                if (rectangle.x == n2) {
                    ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 = nArray[0];
                } else if (rectangle.x + rectangle.width == n2) {
                    ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 = nArray[0];
                }
                if (rectangle.y == n3) {
                    ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 = nArray[1];
                } else if (rectangle.y + rectangle.height == n3) {
                    ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 = nArray[1];
                }
                boolean bl = false;
                boolean bl2 = false;
                if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 > ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2) {
                    bl = true;
                }
                if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 > ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1) {
                    bl2 = true;
                }
                if (bl || bl2) {
                    switch (n) {
                        case 0: {
                            if (!bl) break;
                            n = 3;
                            break;
                        }
                        case 1: {
                            if (!bl2) break;
                            n = 2;
                            break;
                        }
                        case 2: {
                            if (!bl2) break;
                            n = 1;
                            break;
                        }
                        case 3: {
                            if (!bl) break;
                            n = 0;
                            break;
                        }
                        case 4: {
                            if (bl) {
                                n = 6;
                            } else if (bl2) {
                                n = 5;
                            }
                            if (!bl || !bl2) break;
                            n = 7;
                            break;
                        }
                        case 5: {
                            if (bl) {
                                n = 7;
                            } else if (bl2) {
                                n = 4;
                            }
                            if (!bl || !bl2) break;
                            n = 6;
                            break;
                        }
                        case 6: {
                            if (bl) {
                                n = 4;
                            } else if (bl2) {
                                n = 7;
                            }
                            if (!bl || !bl2) break;
                            n = 5;
                            break;
                        }
                        case 7: {
                            if (bl) {
                                n = 5;
                            } else if (bl2) {
                                n = 6;
                            }
                            if (!bl || !bl2) break;
                            n = 4;
                        }
                    }
                }
                SwingMouseHandler.this.decode_pdf.setDrawCrossHairs(true, n, Color.red);
                SwingMouseHandler.this.scrollAndUpdateCoords(mouseEvent);
                this.generateNewCursorBox();
                SwingMouseHandler.this.dragAltering = true;
                SwingMouseHandler.this.oldX = nArray[0];
                SwingMouseHandler.this.oldY = nArray[1];
            } else {
                SwingMouseHandler.this.drawingCursorBox = true;
                SwingMouseHandler.this.boxContained = -1;
                SwingMouseHandler.this.decode_pdf.setDrawCrossHairs(true, SwingMouseHandler.this.boxContained, Color.red);
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 = SwingMouseHandler.this.oldX;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 = SwingMouseHandler.this.oldY;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 = nArray[0];
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 = nArray[1];
                SwingMouseHandler.this.scrollAndUpdateCoords(mouseEvent);
                this.generateNewCursorBox();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            Rectangle rectangle = SwingMouseHandler.this.currentGUI.getRectangle();
            SwingMouseHandler.access$2202(SwingMouseHandler.this, this.createNewRectangles(rectangle));
            if (SwingMouseHandler.this.boxes != null) {
                int n = SwingMouseHandler.this.boxContained;
                SwingMouseHandler.this.boxContained = -1;
                for (int i = 0; i < SwingMouseHandler.this.boxes.length; ++i) {
                    if (!SwingMouseHandler.this.boxes[i].contains(SwingMouseHandler.this.cx, SwingMouseHandler.this.cy)) continue;
                    SwingMouseHandler.this.boxContained = i;
                    break;
                }
                if (SwingMouseHandler.this.boxContained != n) {
                    this.handleChange = true;
                }
            }
            if (rectangle != null) {
                if (rectangle.x - SwingMouseHandler.this.handlesGap < SwingMouseHandler.this.cx && rectangle.x + rectangle.width + SwingMouseHandler.this.handlesGap > SwingMouseHandler.this.cx && rectangle.y - SwingMouseHandler.this.handlesGap < SwingMouseHandler.this.cy && rectangle.y + rectangle.height + SwingMouseHandler.this.handlesGap > SwingMouseHandler.this.cy) {
                    SwingMouseHandler.this.decode_pdf.setDrawCrossHairs(true, SwingMouseHandler.this.boxContained, Color.red);
                    if (!this.inRect || this.handleChange) {
                        SwingMouseHandler.this.decode_pdf.repaint();
                        this.handleChange = false;
                        this.inRect = true;
                    }
                } else {
                    SwingMouseHandler.this.decode_pdf.setDrawCrossHairs(false, SwingMouseHandler.this.boxContained, Color.red);
                    if (this.inRect || this.handleChange) {
                        SwingMouseHandler.this.decode_pdf.repaint();
                        this.handleChange = false;
                        this.inRect = false;
                    }
                }
            }
        }

        private Rectangle[] createNewRectangles(Rectangle rectangle) {
            if (rectangle != null) {
                int n = rectangle.x;
                int n2 = rectangle.y;
                int n3 = n + rectangle.width;
                int n4 = n2 + rectangle.height;
                Rectangle[] rectangleArray = new Rectangle[]{new Rectangle(n - SwingMouseHandler.this.handlesGap, n2 + Math.abs(n4 - n2) / 2 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(n + Math.abs(n3 - n) / 2 - SwingMouseHandler.this.handlesGap, n2 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(n + Math.abs(n3 - n) / 2 - SwingMouseHandler.this.handlesGap, n4 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(n3 - SwingMouseHandler.this.handlesGap, n2 + Math.abs(n4 - n2) / 2 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(n - SwingMouseHandler.this.handlesGap, n2 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(n - SwingMouseHandler.this.handlesGap, n4 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(n3 - SwingMouseHandler.this.handlesGap, n2 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(n3 - SwingMouseHandler.this.handlesGap, n4 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2)};
                return rectangleArray;
            }
            return null;
        }
    }

    protected class Extractor_mouse_clicker
    extends mouse_clicker {
        protected Extractor_mouse_clicker() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Rectangle rectangle = SwingMouseHandler.this.currentGUI.getRectangle();
            if (rectangle == null) {
                super.mousePressed(mouseEvent);
                SwingMouseHandler.this.drawingCursorBox = true;
            } else {
                int[] nArray = SwingMouseHandler.this.updateXY(mouseEvent);
                SwingMouseHandler.this.oldX = nArray[0];
                SwingMouseHandler.this.oldY = nArray[1];
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            int n;
            SwingMouseHandler.this.drawingCursorBox = false;
            SwingMouseHandler.this.old_m_x2 = -1;
            SwingMouseHandler.this.old_m_y2 = -1;
            SwingMouseHandler.this.updateCoords(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.isShiftDown());
            if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 > ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2) {
                n = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 = n;
            }
            if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 < ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2) {
                n = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 = n;
            }
            SwingMouseHandler.this.decode_pdf.repaint();
            SwingMouseHandler.this.dragAltering = false;
        }
    }

    protected class mouse_mover
    implements MouseMotionListener {
        boolean altIsDown = false;

        public void mouseDragged(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.altIsDown = mouseEvent.isAltDown();
                SwingMouseHandler.this.scrollAndUpdateCoords(mouseEvent);
                if (SwingMouseHandler.this.commonValues.isPDF()) {
                    this.generateNewCursorBox();
                }
                if (((SwingMouseHandler)SwingMouseHandler.this).currentGUI.addUniqueIconToFileAttachment) {
                    SwingMouseHandler.this.checkLinks(false, SwingMouseHandler.this.decode_pdf.getIO());
                }
                if (((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.turnoverOn && (SwingMouseHandler.this.drawingTurnover || SwingMouseHandler.this.previewTurnover) && SwingMouseHandler.this.decode_pdf.getDisplayView() == 3) {
                    SwingMouseHandler.this.currentGUI.setCursor(2);
                    if (SwingMouseHandler.this.currentGUI.getDragLeft()) {
                        if (SwingMouseHandler.this.currentGUI.getDragTop()) {
                            SwingMouseHandler.this.decode_pdf.setUserOffsets(mouseEvent.getX(), mouseEvent.getY(), 996);
                        } else {
                            SwingMouseHandler.this.decode_pdf.setUserOffsets(mouseEvent.getX(), mouseEvent.getY(), 998);
                        }
                    } else if (SwingMouseHandler.this.currentGUI.getDragTop()) {
                        SwingMouseHandler.this.decode_pdf.setUserOffsets(mouseEvent.getX(), mouseEvent.getY(), 997);
                    } else {
                        SwingMouseHandler.this.decode_pdf.setUserOffsets(mouseEvent.getX(), mouseEvent.getY(), 999);
                    }
                }
            } else if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                SwingMouseHandler.this.xVelocity = ((double)mouseEvent.getX() - SwingMouseHandler.this.decode_pdf.getVisibleRect().getX() - SwingMouseHandler.this.middleDragStartX) / 4.0;
                SwingMouseHandler.this.yVelocity = ((double)mouseEvent.getY() - SwingMouseHandler.this.decode_pdf.getVisibleRect().getY() - SwingMouseHandler.this.middleDragStartY) / 4.0;
            }
        }

        protected void generateNewCursorBox() {
            if (SwingMouseHandler.this.old_m_x2 != -1 | SwingMouseHandler.this.old_m_y2 != -1 | Math.abs(((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 - SwingMouseHandler.this.old_m_x2) > 5 | Math.abs(((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 - SwingMouseHandler.this.old_m_y2) > 5) {
                int n = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1;
                if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 > ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2) {
                    n = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2;
                }
                int n2 = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1;
                if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 > ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2) {
                    n2 = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2;
                }
                int n3 = Math.abs(((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 - ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1);
                int n4 = Math.abs(((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 - ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1);
                if (!DynamicVectorRenderer.textBasedHighlight) {
                    SwingMouseHandler.this.decode_pdf.removeFoundTextArea(SwingMouseHandler.this.currentGUI.getRectangle(), SwingMouseHandler.this.commonValues.getCurrentPage());
                }
                Rectangle rectangle = new Rectangle(n, n2, n3, n4);
                SwingMouseHandler.this.currentGUI.setRectangle(rectangle);
                SwingMouseHandler.this.decode_pdf.updateCursorBoxOnScreen(rectangle, PdfDecoder.highlightColor);
                if (!SwingMouseHandler.this.decode_pdf.isExtractingAsImage()) {
                    int n5 = SwingMouseHandler.this.decode_pdf.getDynamicRenderer().getObjectUnderneath(((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1, ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1);
                    if (!DynamicVectorRenderer.textBasedHighlight || this.altIsDown && n5 != 1 && n5 != 4 && n5 != 5 && n5 != 6) {
                        SwingMouseHandler.this.decode_pdf.clearHighlights();
                        if (SwingMouseHandler.this.decode_pdf.getDisplayView() != 1 && SwingMouseHandler.this.decode_pdf.getDisplayView() != 5 && SwingMouseHandler.this.decode_pdf.getDisplayView() != 6) {
                            int n6 = SwingMouseHandler.this.commonValues.getCurrentPage();
                            while ((float)rectangle.y < (float)((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.getPageOffsets((int)n6).y / SwingMouseHandler.this.decode_pdf.getScaling() && n6 > 0) {
                                SwingMouseHandler.this.decode_pdf.addHighlights(new Rectangle[]{rectangle}, true, --n6);
                            }
                            n6 = SwingMouseHandler.this.commonValues.getCurrentPage();
                            while ((float)rectangle.y > (float)((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.getPageOffsets((int)n6).y / SwingMouseHandler.this.decode_pdf.getScaling() + (float)SwingMouseHandler.this.decode_pdf.getPdfPageData().getCropBoxHeight(n6) && n6 > 0) {
                                SwingMouseHandler.this.decode_pdf.addHighlights(new Rectangle[]{rectangle}, true, ++n6);
                            }
                        }
                        SwingMouseHandler.this.decode_pdf.addHighlights(new Rectangle[]{rectangle}, true, SwingMouseHandler.this.commonValues.getCurrentPage());
                    } else {
                        Rectangle rectangle2 = new Rectangle(((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1, ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1, ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 - ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1, ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 - ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1);
                        if (SwingMouseHandler.this.decode_pdf.getDisplayView() != 1) {
                            rectangle2 = new Rectangle(((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1, ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1, ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 - ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1, ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 - ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2);
                        }
                        if (SwingMouseHandler.this.decode_pdf.getDisplayView() != 1 && SwingMouseHandler.this.decode_pdf.getDisplayView() != 5 && SwingMouseHandler.this.decode_pdf.getDisplayView() != 6) {
                            Rectangle rectangle3;
                            int n7 = SwingMouseHandler.this.commonValues.getCurrentPage();
                            while ((float)(-rectangle2.y) < (float)((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.getPageOffsets((int)n7).y / SwingMouseHandler.this.decode_pdf.getScaling() && n7 > 0) {
                                rectangle3 = new Rectangle(rectangle2.x - ((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.getPageOffsets((int)(--n7)).x + SwingMouseHandler.this.decode_pdf.getInsetW(), rectangle2.y - ((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.getPageOffsets((int)n7).y + SwingMouseHandler.this.decode_pdf.getInsetH(), rectangle2.width, -rectangle2.height);
                                SwingMouseHandler.this.decode_pdf.addHighlights(new Rectangle[]{rectangle3}, false, n7);
                            }
                            n7 = SwingMouseHandler.this.commonValues.getCurrentPage();
                            while ((float)(-rectangle2.y) > (float)((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.getPageOffsets((int)n7).y / SwingMouseHandler.this.decode_pdf.getScaling() + (float)SwingMouseHandler.this.decode_pdf.getPdfPageData().getCropBoxHeight(n7) && n7 < SwingMouseHandler.this.commonValues.getPageCount()) {
                                rectangle3 = new Rectangle(rectangle2.x - ((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.getPageOffsets((int)(++n7)).x, rectangle2.y - ((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.getPageOffsets((int)n7).y, rectangle2.width, -rectangle2.height);
                                SwingMouseHandler.this.decode_pdf.addHighlights(new Rectangle[]{rectangle3}, false, n7);
                            }
                            rectangle3 = new Rectangle(rectangle2.x - ((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.getPageOffsets((int)n7).x + SwingMouseHandler.this.decode_pdf.getInsetW(), rectangle2.y - ((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.getPageOffsets((int)n7).y + SwingMouseHandler.this.decode_pdf.getInsetH(), rectangle2.width, -rectangle2.height);
                            SwingMouseHandler.this.decode_pdf.addHighlights(new Rectangle[]{rectangle3}, false, SwingMouseHandler.this.commonValues.getCurrentPage());
                        } else {
                            SwingMouseHandler.this.decode_pdf.addHighlights(new Rectangle[]{rectangle2}, false, SwingMouseHandler.this.commonValues.getCurrentPage());
                        }
                    }
                }
                SwingMouseHandler.this.old_m_x2 = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2;
                SwingMouseHandler.this.old_m_y2 = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2;
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            double d;
            double d2;
            float f;
            int n;
            Point point;
            if (SwingMouseHandler.this.decode_pdf.getDisplayView() == 5) {
                int n2;
                int n3;
                if (SwingMouseHandler.this.currentGUI.getRotation() % 180 == 90) {
                    n3 = SwingMouseHandler.this.decode_pdf.getPdfPageData().getCropBoxHeight(1);
                    n2 = SwingMouseHandler.this.decode_pdf.getPdfPageData().getCropBoxWidth(1);
                } else {
                    n3 = SwingMouseHandler.this.decode_pdf.getPdfPageData().getCropBoxWidth(1);
                    n2 = SwingMouseHandler.this.decode_pdf.getPdfPageData().getCropBoxHeight(1);
                }
                point = mouseEvent.getPoint();
                double d3 = (int)point.getX();
                n = (int)point.getY();
                f = SwingMouseHandler.this.decode_pdf.getScaling();
                d2 = f * (float)n2;
                int n4 = SwingMouseHandler.this.decode_pdf.getInsetH();
                d3 -= (double)(SwingMouseHandler.this.decode_pdf.getWidth() / 2);
                double d4 = (double)n3 * 0.5 * (double)f;
                d = PageOffsets.getPageFlowPageWidth((int)((float)n3 * f), f);
                if (d3 < -d4) {
                    d3 = d3 + d4 - d;
                } else if (d3 >= d4) {
                    d3 = d3 - d4 + d;
                } else {
                    SwingMouseHandler.this.decode_pdf.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                double d5 = d3 > 0.0 ? (d - d3 % d) / ((double)((float)n3 * f) * PageOffsets.PAGEFLOW_SIDE_SIZE * 0.5) : (d - -d3 % d) / ((double)((float)n3 * f) * PageOffsets.PAGEFLOW_SIDE_SIZE * 0.5);
                double d6 = d5 * (PageOffsets.PAGEFLOW_SIDE_SIZE * d2 * 0.15000000000000002);
                if ((double)n < (double)n4 + (1.0 - PageOffsets.PAGEFLOW_SIDE_SIZE) * d2 / 2.0 + d6) {
                    SwingMouseHandler.this.decode_pdf.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                if ((double)n > (double)n4 + d2 - (1.0 - PageOffsets.PAGEFLOW_SIDE_SIZE) * d2 / 2.0 - d6) {
                    SwingMouseHandler.this.decode_pdf.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                d3 = SwingMouseHandler.this.currentGUI.getCurrentPage() + (int)(d3 / d);
                SwingMouseHandler.this.pageFlowCurrentPage = (int)d3;
                if (d3 > 0.0 && d3 <= (double)SwingMouseHandler.this.decode_pdf.getPdfPageData().getPageCount()) {
                    SwingMouseHandler.this.decode_pdf.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    SwingMouseHandler.this.decode_pdf.setCursor(Cursor.getPredefinedCursor(0));
                }
            } else if (SwingMouseHandler.this.decode_pdf.getDisplayView() == 3 && ((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.turnoverOn && ((SwingGUI)SwingMouseHandler.this.decode_pdf.getExternalHandler(11)).getPageTurnScalingAppropriate() && !SwingMouseHandler.this.decode_pdf.getPdfPageData().hasMultipleSizes() && !SwingMouseHandler.this.getPageTurnAnimating()) {
                Point point2;
                float f2 = (float)SwingMouseHandler.this.decode_pdf.getPdfPageData().getCropBoxHeight(1) * SwingMouseHandler.this.decode_pdf.getScaling() - 1.0f;
                float f3 = (float)SwingMouseHandler.this.decode_pdf.getPdfPageData().getCropBoxWidth(1) * SwingMouseHandler.this.decode_pdf.getScaling() - 1.0f;
                if ((SwingMouseHandler.this.decode_pdf.getPdfPageData().getRotation(1) + SwingMouseHandler.this.currentGUI.getRotation()) % 180 == 90) {
                    float f4 = f2;
                    f2 = f3 + 1.0f;
                    f3 = f4;
                }
                point = new Point();
                if (SwingMouseHandler.this.commonValues.getCurrentPage() + 1 < SwingMouseHandler.this.commonValues.getPageCount()) {
                    point.x = (int)(SwingMouseHandler.this.decode_pdf.getVisibleRect().getWidth() / 2.0 + (double)f3);
                    point.y = (int)((float)SwingMouseHandler.this.decode_pdf.getInsetH() + f2);
                    point2 = mouseEvent.getPoint();
                    if (point2.x > point.x - 30 && point2.x <= point.x && (point2.y > point.y - 30 && point2.y <= point.y || (float)point2.y >= (float)point.y - f2 && (float)point2.y < (float)point.y - f2 + 30.0f)) {
                        SwingMouseHandler.this.currentGUI.setCursor(1);
                        SwingMouseHandler.this.previewTurnover = true;
                        if ((float)point2.y >= (float)point.y - f2 && (float)point2.y < (float)point.y - f2 + 30.0f) {
                            point.y = (int)((float)point.y - f2);
                            SwingMouseHandler.this.decode_pdf.setUserOffsets((int)point2.getX(), (int)point2.getY(), 997);
                        } else {
                            SwingMouseHandler.this.decode_pdf.setUserOffsets((int)point2.getX(), (int)point2.getY(), 999);
                        }
                    } else {
                        if (SwingMouseHandler.this.currentGUI.getDragTop()) {
                            point.y = (int)((float)point.y - f2);
                        }
                        this.testFall(point, point2, false);
                    }
                }
                if (SwingMouseHandler.this.commonValues.getCurrentPage() != 1) {
                    point.x = (int)(SwingMouseHandler.this.decode_pdf.getVisibleRect().getWidth() / 2.0 - (double)f3);
                    point.y = (int)((float)SwingMouseHandler.this.decode_pdf.getInsetH() + f2);
                    point2 = mouseEvent.getPoint();
                    if (point2.x < point.x + 30 && point2.x >= point.x && (point2.y > point.y - 30 && point2.y <= point.y || (float)point2.y >= (float)point.y - f2 && (float)point2.y < (float)point.y - f2 + 30.0f)) {
                        SwingMouseHandler.this.currentGUI.setCursor(1);
                        SwingMouseHandler.this.previewTurnover = true;
                        if ((float)point2.y >= (float)point.y - f2 && (float)point2.y < (float)point.y - f2 + 30.0f) {
                            point.y = (int)((float)point.y - f2);
                            SwingMouseHandler.this.decode_pdf.setUserOffsets((int)point2.getX(), (int)point2.getY(), 996);
                        } else {
                            SwingMouseHandler.this.decode_pdf.setUserOffsets((int)point2.getX(), (int)point2.getY(), 998);
                        }
                    } else {
                        if (SwingMouseHandler.this.currentGUI.getDragTop()) {
                            point.y = (int)((float)point.y - f2);
                        }
                        this.testFall(point, point2, true);
                    }
                }
            }
            if (((SwingMouseHandler)SwingMouseHandler.this).currentGUI.useNewLayout) {
                int[] nArray = new int[2];
                nArray[0] = 1;
                if (SwingMouseHandler.this.decode_pdf.getDisplayView() == 1 || SwingMouseSelection.activateMultipageHighlight) {
                    int n5;
                    int n6;
                    if (SwingMouseHandler.this.currentGUI.getRotation() % 180 == 90) {
                        n6 = SwingMouseHandler.this.decode_pdf.getPdfPageData().getCropBoxHeight(1);
                        n5 = SwingMouseHandler.this.decode_pdf.getPdfPageData().getCropBoxWidth(1);
                    } else {
                        n6 = SwingMouseHandler.this.decode_pdf.getPdfPageData().getCropBoxWidth(1);
                        n5 = SwingMouseHandler.this.decode_pdf.getPdfPageData().getCropBoxHeight(1);
                    }
                    Point point3 = mouseEvent.getPoint();
                    int n7 = (int)point3.getX();
                    n = (int)point3.getY();
                    f = SwingMouseHandler.this.decode_pdf.getScaling();
                    d2 = f * (float)n5;
                    double d7 = f * (float)n6;
                    int n8 = SwingMouseHandler.this.decode_pdf.getInsetH();
                    d = (double)(SwingMouseHandler.this.decode_pdf.getWidth() / 2) - d7 / 2.0;
                    nArray[1] = (double)n7 >= d && (double)n7 <= d + d7 && n >= n8 && (double)n <= (double)n8 + d2 ? 1 : 0;
                } else {
                    nArray[1] = 0;
                }
                SwingMouseHandler.this.currentGUI.setMultibox(nArray);
            }
            SwingMouseHandler.this.updateCoords(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.isShiftDown());
            if (((SwingMouseHandler)SwingMouseHandler.this).currentGUI.addUniqueIconToFileAttachment) {
                SwingMouseHandler.this.checkLinks(false, SwingMouseHandler.this.decode_pdf.getIO());
            }
        }

        public void testFall(final Point point, final Point point2, boolean bl) {
            if (!SwingMouseHandler.this.previewTurnover) {
                return;
            }
            float f = (float)SwingMouseHandler.this.decode_pdf.getPdfPageData().getCropBoxWidth(1) * SwingMouseHandler.this.decode_pdf.getScaling() - 1.0f;
            if ((SwingMouseHandler.this.decode_pdf.getPdfPageData().getRotation(1) + SwingMouseHandler.this.currentGUI.getRotation()) % 180 == 90) {
                f = (float)SwingMouseHandler.this.decode_pdf.getPdfPageData().getCropBoxHeight(1) * SwingMouseHandler.this.decode_pdf.getScaling();
            }
            final float f2 = f;
            if (!bl) {
                if (!SwingMouseHandler.this.currentGUI.getDragLeft()) {
                    SwingMouseHandler.this.decode_pdf.setCursor(Cursor.getDefaultCursor());
                    Thread thread = new Thread(){

                        public void run() {
                            point.x = (int)(SwingMouseHandler.this.decode_pdf.getVisibleRect().getWidth() / 2.0 + (double)f2);
                            boolean bl = true;
                            if ((float)point2.x < (float)point.x - f2) {
                                point.x = (int)((float)point.x - 2.0f * f2);
                                bl = false;
                            }
                            int n = 1;
                            if (bl && point2.x >= point.x) {
                                point2.x = point.x - 1;
                            }
                            if (!bl && point2.x <= point.x) {
                                point2.x = point.x + 1;
                            }
                            if (!SwingMouseHandler.this.currentGUI.getDragTop() && point2.y >= point.y) {
                                point2.y = point.y - 1;
                            }
                            if (SwingMouseHandler.this.currentGUI.getDragTop() && point2.y <= point.y) {
                                point2.y = point.y + 1;
                            }
                            double d = point.x - point2.x;
                            double d2 = point.y - point2.y;
                            while (bl && point2.getX() <= point.getX() || !bl && point2.getX() >= point.getX() || !SwingMouseHandler.this.currentGUI.getDragTop() && point2.getY() <= point.getY() || SwingMouseHandler.this.currentGUI.getDragTop() && point2.getY() >= point.getY()) {
                                double d3 = (double)n * d * 0.002;
                                double d4 = (double)n * d2 * 0.002;
                                if (Math.abs(d3) < 1.0) {
                                    d3 /= Math.abs(d3);
                                }
                                if (Math.abs(d4) < 1.0) {
                                    d4 /= Math.abs(d4);
                                }
                                point2.setLocation(point2.getX() + d3, point2.getY() + d4);
                                if (SwingMouseHandler.this.currentGUI.getDragTop()) {
                                    SwingMouseHandler.this.decode_pdf.setUserOffsets((int)point2.getX(), (int)point2.getY(), 997);
                                } else {
                                    SwingMouseHandler.this.decode_pdf.setUserOffsets((int)point2.getX(), (int)point2.getY(), 999);
                                }
                                if (n < 32) {
                                    n *= 2;
                                }
                                try {
                                    Thread.sleep(50L);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            if (!bl) {
                                int n2 = SwingMouseHandler.this.commonValues.getCurrentPage() + 1;
                                if (n2 % 2 == 1) {
                                    ++n2;
                                }
                                SwingMouseHandler.this.commonValues.setCurrentPage(n2);
                                SwingMouseHandler.this.currentGUI.setPageNumber();
                                SwingMouseHandler.this.decode_pdf.setPageParameters(SwingMouseHandler.this.currentGUI.getScaling(), SwingMouseHandler.this.commonValues.getCurrentPage());
                                SwingMouseHandler.this.currentGUI.decodePage(false);
                            }
                            SwingMouseHandler.this.decode_pdf.setUserOffsets(0, 0, 995);
                            SwingMouseHandler.this.setPageTurnAnimating(false);
                        }
                    };
                    SwingMouseHandler.this.setPageTurnAnimating(true);
                    thread.start();
                    SwingMouseHandler.this.previewTurnover = false;
                }
            } else if (SwingMouseHandler.this.previewTurnover && SwingMouseHandler.this.currentGUI.getDragLeft()) {
                SwingMouseHandler.this.decode_pdf.setCursor(Cursor.getDefaultCursor());
                Thread thread = new Thread(){

                    public void run() {
                        point.x = (int)(SwingMouseHandler.this.decode_pdf.getVisibleRect().getWidth() / 2.0 - (double)f2);
                        boolean bl = true;
                        if ((float)point2.x > (float)point.x + f2) {
                            point.x = (int)((float)point.x + 2.0f * f2);
                            bl = false;
                        }
                        int n = 1;
                        if (!bl && point2.x >= point.x) {
                            point2.x = point.x - 1;
                        }
                        if (bl && point2.x <= point.x) {
                            point2.x = point.x + 1;
                        }
                        if (!SwingMouseHandler.this.currentGUI.getDragTop() && point2.y >= point.y) {
                            point2.y = point.y - 1;
                        }
                        if (SwingMouseHandler.this.currentGUI.getDragTop() && point2.y <= point.y) {
                            point2.y = point.y + 1;
                        }
                        double d = point.x - point2.x;
                        double d2 = point.y - point2.y;
                        while (!bl && point2.getX() <= point.getX() || bl && point2.getX() >= point.getX() || !SwingMouseHandler.this.currentGUI.getDragTop() && point2.getY() <= point.getY() || SwingMouseHandler.this.currentGUI.getDragTop() && point2.getY() >= point.getY()) {
                            double d3 = (double)n * d * 0.002;
                            double d4 = (double)n * d2 * 0.002;
                            if (Math.abs(d3) < 1.0) {
                                d3 /= Math.abs(d3);
                            }
                            if (Math.abs(d4) < 1.0) {
                                d4 /= Math.abs(d4);
                            }
                            point2.setLocation(point2.getX() + d3, point2.getY() + d4);
                            if (SwingMouseHandler.this.currentGUI.getDragTop()) {
                                SwingMouseHandler.this.decode_pdf.setUserOffsets((int)point2.getX(), (int)point2.getY(), 996);
                            } else {
                                SwingMouseHandler.this.decode_pdf.setUserOffsets((int)point2.getX(), (int)point2.getY(), 998);
                            }
                            if (n < 32) {
                                n *= 2;
                            }
                            try {
                                Thread.sleep(50L);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        if (!bl) {
                            int n2 = SwingMouseHandler.this.commonValues.getCurrentPage() - 2;
                            if (n2 == 0) {
                                n2 = 1;
                            }
                            SwingMouseHandler.this.commonValues.setCurrentPage(n2);
                            SwingMouseHandler.this.currentGUI.setPageNumber();
                            SwingMouseHandler.this.decode_pdf.setPageParameters(SwingMouseHandler.this.currentGUI.getScaling(), SwingMouseHandler.this.commonValues.getCurrentPage());
                            SwingMouseHandler.this.currentGUI.decodePage(false);
                        }
                        SwingMouseHandler.this.decode_pdf.setUserOffsets(0, 0, 995);
                        SwingMouseHandler.this.setPageTurnAnimating(false);
                    }
                };
                SwingMouseHandler.this.setPageTurnAnimating(true);
                thread.start();
                SwingMouseHandler.this.previewTurnover = false;
            }
        }
    }

    protected class mouse_wheel
    implements MouseWheelListener {
        long timeOfLastPageChange;

        protected mouse_wheel() {
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (SwingMouseHandler.this.decode_pdf.getDisplayView() == 6) {
                return;
            }
            if (SwingMouseHandler.this.currentGUI.getProperties().getValue("allowScrollwheelZoom").toLowerCase().equals("true") && mouseWheelEvent.isControlDown()) {
                int n;
                block18: {
                    n = SwingMouseHandler.this.currentGUI.getSelectedComboIndex(252);
                    if (n != -1) {
                        n = (int)SwingMouseHandler.this.decode_pdf.getDPIFactory().removeScaling(SwingMouseHandler.this.decode_pdf.getScaling() * 100.0f);
                    } else {
                        String string = (String)SwingMouseHandler.this.currentGUI.getSelectedComboItem(252);
                        try {
                            n = (int)Float.parseFloat(string);
                        }
                        catch (Exception exception) {
                            char c;
                            int n2;
                            n = -1;
                            int n3 = string.length();
                            for (n2 = 0; n2 < n3 && ((c = string.charAt(n2)) >= '0' && c <= '9') | c == '.'; ++n2) {
                            }
                            if (n2 > 0) {
                                string = string.substring(0, n2);
                            }
                            if (n != -1) break block18;
                            try {
                                n = (int)Float.parseFloat(string);
                            }
                            catch (Exception exception2) {
                                n = -1;
                            }
                        }
                    }
                }
                float f = mouseWheelEvent.getWheelRotation();
                if ((n != 1 || f < 0.0f) && !((float)n + (f = f < 0.0f ? 1.25f : 0.8f) < 0.0f)) {
                    float f2 = (float)n * f;
                    f2 = (int)f2 == n ? (float)(n + 1) : (float)((int)f2);
                    if (f2 < 1.0f) {
                        f2 = 1.0f;
                    }
                    if (f2 > 1000.0f) {
                        f2 = 1000.0f;
                    }
                    final Rectangle rectangle = SwingMouseHandler.this.decode_pdf.getVisibleRect();
                    final double d = (double)mouseWheelEvent.getX() / SwingMouseHandler.this.decode_pdf.getBounds().getWidth();
                    final double d2 = (double)mouseWheelEvent.getY() / SwingMouseHandler.this.decode_pdf.getBounds().getHeight();
                    SwingMouseHandler.this.currentGUI.snapScalingToDefaults(f2);
                    Thread thread = new Thread(){

                        public void run() {
                            try {
                                SwingMouseHandler.this.decode_pdf.scrollRectToVisible(new Rectangle((int)(d * (double)SwingMouseHandler.this.decode_pdf.getWidth() - rectangle.getWidth() / 2.0), (int)(d2 * (double)SwingMouseHandler.this.decode_pdf.getHeight() - rectangle.getHeight() / 2.0), (int)SwingMouseHandler.this.decode_pdf.getVisibleRect().getWidth(), (int)SwingMouseHandler.this.decode_pdf.getVisibleRect().getHeight()));
                                SwingMouseHandler.this.decode_pdf.repaint();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    };
                    thread.start();
                    SwingUtilities.invokeLater(thread);
                }
            } else {
                final JScrollBar jScrollBar = ((JScrollPane)SwingMouseHandler.this.decode_pdf.getParent().getParent()).getVerticalScrollBar();
                if ((jScrollBar.getValue() >= jScrollBar.getMaximum() - jScrollBar.getHeight() || jScrollBar.getHeight() == 0) && mouseWheelEvent.getUnitsToScroll() > 0 && this.timeOfLastPageChange + 700L < System.currentTimeMillis() && SwingMouseHandler.this.currentGUI.getPageNumber() < SwingMouseHandler.this.decode_pdf.getPageCount()) {
                    this.timeOfLastPageChange = System.currentTimeMillis();
                    SwingMouseHandler.this.currentCommands.executeCommand(53, null);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            jScrollBar.setValue(jScrollBar.getMinimum());
                        }
                    });
                } else if (jScrollBar.getValue() == jScrollBar.getMinimum() && mouseWheelEvent.getUnitsToScroll() < 0 && this.timeOfLastPageChange + 700L < System.currentTimeMillis() && SwingMouseHandler.this.currentGUI.getPageNumber() > 1) {
                    this.timeOfLastPageChange = System.currentTimeMillis();
                    SwingMouseHandler.this.currentCommands.executeCommand(52, null);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            jScrollBar.setValue(jScrollBar.getMaximum());
                        }
                    });
                } else {
                    Area area = new Area(SwingMouseHandler.this.decode_pdf.getVisibleRect());
                    AffineTransform affineTransform = new AffineTransform();
                    affineTransform.translate(0.0, mouseWheelEvent.getUnitsToScroll() * SwingMouseHandler.this.decode_pdf.getScrollInterval());
                    area = area.createTransformedArea(affineTransform);
                    SwingMouseHandler.this.decode_pdf.scrollRectToVisible(area.getBounds());
                }
            }
        }
    }

    protected class mouse_clicker
    extends MouseAdapter {
        private mouse_mover mover;
        private long lastPress;

        protected mouse_clicker() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.turnoverOn && SwingMouseHandler.this.previewTurnover && SwingMouseHandler.this.decode_pdf.getDisplayView() == 3 && mouseEvent.getButton() == 1) {
                SwingMouseHandler.this.drawingTurnover = true;
                SwingMouseHandler.this.currentGUI.setCursor(2);
                this.lastPress = System.currentTimeMillis();
            }
            if (mouseEvent.getButton() == 2) {
                SwingMouseHandler.this.middleDragStartX = (double)mouseEvent.getX() - SwingMouseHandler.this.decode_pdf.getVisibleRect().getX();
                SwingMouseHandler.this.middleDragStartY = (double)mouseEvent.getY() - SwingMouseHandler.this.decode_pdf.getVisibleRect().getY();
                SwingMouseHandler.this.currentGUI.setCursor(4);
                if (SwingMouseHandler.this.middleDragTimer == null) {
                    SwingMouseHandler.this.middleDragTimer = new Timer(100, new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            Rectangle rectangle = SwingMouseHandler.this.decode_pdf.getVisibleRect();
                            rectangle.translate((int)SwingMouseHandler.this.xVelocity, (int)SwingMouseHandler.this.yVelocity);
                            if (SwingMouseHandler.this.xVelocity < -2.0) {
                                if (SwingMouseHandler.this.yVelocity < -2.0) {
                                    SwingMouseHandler.this.currentGUI.setCursor(6);
                                } else if (SwingMouseHandler.this.yVelocity > 2.0) {
                                    SwingMouseHandler.this.currentGUI.setCursor(12);
                                } else {
                                    SwingMouseHandler.this.currentGUI.setCursor(5);
                                }
                            } else if (SwingMouseHandler.this.xVelocity > 2.0) {
                                if (SwingMouseHandler.this.yVelocity < -2.0) {
                                    SwingMouseHandler.this.currentGUI.setCursor(8);
                                } else if (SwingMouseHandler.this.yVelocity > 2.0) {
                                    SwingMouseHandler.this.currentGUI.setCursor(10);
                                } else {
                                    SwingMouseHandler.this.currentGUI.setCursor(9);
                                }
                            } else if (SwingMouseHandler.this.yVelocity < -2.0) {
                                SwingMouseHandler.this.currentGUI.setCursor(7);
                            } else if (SwingMouseHandler.this.yVelocity > 2.0) {
                                SwingMouseHandler.this.currentGUI.setCursor(11);
                            } else {
                                SwingMouseHandler.this.currentGUI.setCursor(4);
                            }
                            SwingMouseHandler.this.decode_pdf.scrollRectToVisible(rectangle);
                        }
                    });
                }
                SwingMouseHandler.this.middleDragTimer.start();
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingMouseHandler.this.decode_pdf.getDisplayView() == 5 && mouseEvent.getButton() == 1) {
                if (SwingMouseHandler.this.decode_pdf.getCursor().getType() != 12) {
                    return;
                }
                int n = SwingMouseHandler.this.commonValues.getCurrentPage();
                SwingMouseHandler.this.decode_pdf.getPageFlowBar().setValue(SwingMouseHandler.this.pageFlowCurrentPage - 1);
                SwingMouseHandler.this.pageFlowCurrentPage += SwingMouseHandler.this.pageFlowCurrentPage - n;
                SwingMouseHandler.this.decode_pdf.paintAll(SwingMouseHandler.this.decode_pdf.getGraphics());
            }
            if (SwingMouseHandler.this.decode_pdf.getDisplayView() == 1 && mouseEvent.getButton() == 1 && ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.addUniqueIconToFileAttachment) {
                SwingMouseHandler.this.checkLinks(true, SwingMouseHandler.this.decode_pdf.getIO());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.turnoverOn && SwingMouseHandler.this.decode_pdf.getDisplayView() == 3) {
                SwingMouseHandler.this.drawingTurnover = false;
                boolean bl = SwingMouseHandler.this.currentGUI.getDragLeft();
                boolean bl2 = SwingMouseHandler.this.currentGUI.getDragTop();
                if (this.lastPress + 200L > System.currentTimeMillis()) {
                    if (bl) {
                        SwingMouseHandler.this.currentCommands.executeCommand(52, null);
                    } else {
                        SwingMouseHandler.this.currentCommands.executeCommand(53, null);
                    }
                    SwingMouseHandler.this.previewTurnover = false;
                    SwingMouseHandler.this.currentGUI.setCursor(3);
                } else {
                    Point point = new Point();
                    point.y = SwingMouseHandler.this.decode_pdf.getInsetH();
                    if (!bl2) {
                        point.y = (int)((float)point.y + (float)SwingMouseHandler.this.decode_pdf.getPdfPageData().getCropBoxHeight(1) * SwingMouseHandler.this.decode_pdf.getScaling());
                    }
                    point.x = bl ? (int)(SwingMouseHandler.this.decode_pdf.getVisibleRect().getWidth() / 2.0 - (double)((float)SwingMouseHandler.this.decode_pdf.getPdfPageData().getCropBoxWidth(1) * SwingMouseHandler.this.decode_pdf.getScaling())) : (int)(SwingMouseHandler.this.decode_pdf.getVisibleRect().getWidth() / 2.0 + (double)((float)SwingMouseHandler.this.decode_pdf.getPdfPageData().getCropBoxWidth(1) * SwingMouseHandler.this.decode_pdf.getScaling()));
                    MouseMotionListener[] mouseMotionListenerArray = SwingMouseHandler.this.decode_pdf.getMouseMotionListeners();
                    if (this.mover == null) {
                        for (int i = 0; i < mouseMotionListenerArray.length; ++i) {
                            if (!(mouseMotionListenerArray[i] instanceof mouse_mover)) continue;
                            this.mover = (mouse_mover)mouseMotionListenerArray[i];
                        }
                    }
                    this.mover.testFall(point, mouseEvent.getPoint(), bl);
                }
            }
            if (mouseEvent.getButton() == 2) {
                SwingMouseHandler.this.xVelocity = 0.0;
                SwingMouseHandler.this.yVelocity = 0.0;
                SwingMouseHandler.this.currentGUI.setCursor(3);
                SwingMouseHandler.this.middleDragTimer.stop();
                SwingMouseHandler.this.decode_pdf.repaint();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

