/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.T3Glyph;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

public class FormStream {
    public static final boolean debugUnimplemented = false;
    public static final boolean debug = false;
    private static boolean showFontMessage = false;
    public static final boolean exitOnError = false;
    public static final int READONLY = 1;
    public static final int REQUIRED = 2;
    public static final int NOEXPORT = 4;
    public static final int MULTILINE = 4096;
    public static final int PASSWORD = 8192;
    public static final int NOTOGGLETOOFF = 16384;
    public static final int RADIO = 32768;
    public static final int PUSHBUTTON = 65536;
    public static final int COMBO = 131072;
    public static final int EDIT = 262144;
    public static final int SORT = 524288;
    public static final int FILESELECT = 0x100000;
    public static final int MULTISELECT = 0x200000;
    public static final int DONOTSPELLCHECK = 0x400000;
    public static final int DONOTSCROLL = 0x800000;
    public static final int COMB = 0x1000000;
    public static final int RADIOINUNISON = 0x2000000;
    public static final int RICHTEXT = 0x2000000;
    public static final int COMMITONSELCHANGE = 0x4000000;
    protected PdfObjectReader currentPdfFile;
    public static boolean marksNewJavascriptCode = false;
    public static final int[] id = new int[]{17, 4866, 4668, 21, 40, 20, 37, 5695, 8223, 8211, 8230, 8217, 31, 4865, 27, 22, 38, 4866, 5139, 10019, 5155, 10016, 5152};

    public FormStream() {
    }

    public FormStream(PdfObjectReader pdfObjectReader) {
        this.currentPdfFile = pdfObjectReader;
    }

    public FormObject createAppearanceString(FormObject formObject, PdfObjectReader pdfObjectReader) {
        this.currentPdfFile = pdfObjectReader;
        this.init(formObject);
        return formObject;
    }

    private void init(FormObject formObject) {
        String string;
        int n = formObject.getInt(5686);
        if (n != -1) {
            FormStream.commandFf(formObject, n);
        }
        if (!marksNewJavascriptCode) {
            this.resolveAdditionalAction(formObject);
        }
        this.setupAPimages(formObject, false);
        int n2 = formObject.getNameAsConstant(24);
        if (n2 != -1) {
            if (n2 == 36 || n2 == 32) {
                if (!formObject.hasDownImage()) {
                    formObject.setOffsetDownApp();
                }
            } else if (n2 == 30) {
                formObject.setNoDownIcon();
            } else if (n2 == 25) {
                formObject.setInvertForDownIcon();
            }
        }
        if ((string = formObject.getTextStreamValue(5137)) != null) {
            FormStream.decodeFontCommandObj(string, formObject);
        }
    }

    public void setupAPimages(FormObject formObject, boolean bl) {
        int[] nArray = new int[]{30, 34, 20};
        String[] stringArray = new String[]{"PdfDictionary.N", "PdfDictionary.R", "PdfDictionary.D"};
        int n = nArray.length;
        BufferedImage bufferedImage = null;
        for (int i = 0; i < n; ++i) {
            Map map;
            PdfObject pdfObject;
            PdfObject pdfObject2 = formObject.getDictionary(4384).getDictionary(nArray[i]);
            if (pdfObject2 == null) continue;
            if (bl && nArray[i] == 30) {
                System.out.println(" AP (" + stringArray[i] + ")=" + pdfObject2 + " " + pdfObject2.getObjectRefAsString() + " AP=" + formObject.getDictionary(4384) + " form=" + formObject + " " + formObject.getObjectRefAsString() + " stream=" + pdfObject2.getDecodedStream() + " Off=" + pdfObject2.getDictionary(2045494));
            }
            if (pdfObject2.getDecodedStream() != null) {
                bufferedImage = FormStream.rotate(FormStream.decode(this.currentPdfFile, pdfObject2, formObject.getParameterConstant(1147962727)), formObject.getDictionary(7451).getInt(34));
                if (bl) {
                    System.out.println(bufferedImage);
                }
                if (bufferedImage == null) continue;
                if (nArray[i] == 20) {
                    formObject.setAppearanceImage(bufferedImage, 20, 2045494);
                    if (!bl) continue;
                    System.out.println("D " + bufferedImage);
                    continue;
                }
                if (nArray[i] == 30 && !formObject.hasNormalOff()) {
                    formObject.setAppearanceImage(bufferedImage, 30, 2045494);
                    if (!bl) continue;
                    System.out.println("N " + bufferedImage);
                    continue;
                }
                if (nArray[i] != 34) continue;
                formObject.setAppearanceImage(bufferedImage, 34, 2045494);
                if (!bl) continue;
                System.out.println("R " + bufferedImage);
                continue;
            }
            PdfObject pdfObject3 = pdfObject2.getDictionary(7998);
            if (pdfObject3 != null) {
                bufferedImage = FormStream.rotate(FormStream.decode(this.currentPdfFile, pdfObject3, formObject.getParameterConstant(1147962727)), formObject.getDictionary(7451).getInt(34));
                if (bl) {
                    System.out.println("On=" + pdfObject3 + " " + bufferedImage);
                }
                if (bufferedImage == null) continue;
                if (nArray[i] == 20) {
                    formObject.setAppearanceImage(bufferedImage, 20, 7998);
                    if (!formObject.hasDownOff()) {
                        formObject.setAppearanceImage(null, 20, 2045494);
                    }
                } else if (nArray[i] == 30) {
                    formObject.setAppearanceImage(bufferedImage, 30, 7998);
                    formObject.setNormalOnState("On");
                } else if (nArray[i] == 34) {
                    formObject.setAppearanceImage(bufferedImage, 34, 7998);
                    if (!formObject.hasRolloverOff()) {
                        formObject.setAppearanceImage(null, 34, 2045494);
                    }
                }
            }
            if ((pdfObject = pdfObject2.getDictionary(2045494)) != null) {
                bufferedImage = FormStream.rotate(FormStream.decode(this.currentPdfFile, pdfObject, formObject.getParameterConstant(1147962727)), formObject.getDictionary(7451).getInt(34));
                if (bl) {
                    System.out.println("Off=" + pdfObject + " " + pdfObject.getDecodedStream() + " " + bufferedImage);
                }
                if (bufferedImage == null) continue;
                if (nArray[i] == 20) {
                    formObject.setAppearanceImage(bufferedImage, 20, 2045494);
                } else if (nArray[i] == 30) {
                    formObject.setAppearanceImage(bufferedImage, 30, 2045494);
                } else if (nArray[i] == 34) {
                    formObject.setAppearanceImage(bufferedImage, 34, 2045494);
                }
            }
            if ((map = pdfObject2.getOtherDictionaries()) == null || map.isEmpty()) continue;
            if (bl) {
                System.out.println(formObject.getObjectRefAsString() + " AP Other=" + map);
            }
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object v = map.get(string);
                PdfObject pdfObject4 = (PdfObject)v;
                bufferedImage = FormStream.rotate(FormStream.decode(this.currentPdfFile, pdfObject4, formObject.getParameterConstant(1147962727)), formObject.getDictionary(7451).getInt(34));
                if (bl) {
                    System.out.println("(other) " + string + " " + pdfObject4 + " " + bufferedImage);
                }
                if (bufferedImage == null) continue;
                if (nArray[i] == 20) {
                    if (bl) {
                        System.out.println("D(other) set=" + bufferedImage + " " + formObject);
                    }
                    formObject.setAppearanceImage(bufferedImage, 20, 7998);
                    if (formObject.hasDownOff()) continue;
                    formObject.setAppearanceImage(null, 20, 2045494);
                    continue;
                }
                if (nArray[i] == 30) {
                    formObject.setAppearanceImage(bufferedImage, 30, 7998);
                    formObject.setNormalOnState(string);
                    if (bl) {
                        System.out.println("Set N (other) " + formObject);
                    }
                    if (formObject.hasNormalOff()) continue;
                    formObject.setAppearanceImage(null, 30, 2045494);
                    continue;
                }
                if (nArray[i] != 34) continue;
                formObject.setAppearanceImage(bufferedImage, 34, 7998);
                if (formObject.hasRolloverOff()) continue;
                formObject.setAppearanceImage(null, 34, 2045494);
            }
        }
    }

    private static void commandFf(FormObject formObject, int n) {
        boolean[] blArray = new boolean[32];
        blArray[1] = (n & 1) == 1;
        blArray[2] = (n & 2) == 2;
        blArray[3] = (n & 4) == 4;
        blArray[12] = (n & 0x1000) == 4096;
        blArray[13] = (n & 0x2000) == 8192;
        blArray[14] = (n & 0x4000) == 16384;
        blArray[15] = (n & 0x8000) == 32768;
        blArray[16] = (n & 0x10000) == 65536;
        blArray[17] = (n & 0x20000) == 131072;
        blArray[18] = (n & 0x40000) == 262144;
        blArray[19] = (n & 0x80000) == 524288;
        blArray[20] = (n & 0x100000) == 0x100000;
        blArray[21] = (n & 0x200000) == 0x200000;
        blArray[22] = (n & 0x400000) == 0x400000;
        blArray[23] = (n & 0x800000) == 0x800000;
        blArray[24] = (n & 0x1000000) == 0x1000000;
        blArray[25] = (n & 0x2000000) == 0x2000000;
        blArray[25] = (n & 0x2000000) == 0x2000000;
        blArray[26] = (n & 0x4000000) == 0x4000000;
        formObject.setFlags(blArray);
    }

    private void resolveAdditionalAction(FormObject formObject) {
        int n = id.length;
        for (int i = 0; i < n; ++i) {
            int n2 = id[i];
        }
    }

    public static BufferedImage decode(PdfObjectReader pdfObjectReader, PdfObject pdfObject, int n) {
        return FormStream.decode(pdfObjectReader, pdfObject, n, 0, 0, 0, 0);
    }

    public static BufferedImage decode(PdfObjectReader pdfObjectReader, PdfObject pdfObject, int n, int n2, int n3, int n4, int n5) {
        boolean bl;
        boolean bl2 = bl = n5 == 90 || n5 == 270;
        if (n2 < 0) {
            n2 = -n2;
        }
        if (n3 < 0) {
            n3 = -n3;
        }
        boolean bl3 = true;
        pdfObjectReader.checkResolved(pdfObject);
        try {
            Graphics2D graphics2D;
            BufferedImage bufferedImage;
            float f;
            float f2;
            float f3;
            Object object;
            PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder(pdfObjectReader, bl3, true);
            ObjectStore objectStore = new ObjectStore();
            pdfStreamDecoder.setStore(objectStore);
            DynamicVectorRenderer dynamicVectorRenderer = new DynamicVectorRenderer(0, false, 20, objectStore);
            if (!bl3) {
                dynamicVectorRenderer.setOptimisedRotation(false);
            } else {
                dynamicVectorRenderer.setHiResImageForDisplayMode(bl3);
            }
            pdfStreamDecoder.init(false, true, 15, 0, new PdfPageData(), 0, dynamicVectorRenderer, pdfObjectReader);
            try {
                object = pdfObject.getDictionary(2004251818);
                pdfObjectReader.checkResolved((PdfObject)object);
                if (object != null) {
                    pdfStreamDecoder.readResources((PdfObject)object, false);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Exception " + exception + " reading resources in XForm");
            }
            object = pdfObject.getDecodedStream();
            if (object != null) {
                pdfStreamDecoder.decodeStreamIntoObjects((byte[])object);
            }
            boolean bl4 = pdfStreamDecoder.ignoreColors;
            pdfStreamDecoder = null;
            objectStore.flush();
            T3Glyph t3Glyph = new T3Glyph(dynamicVectorRenderer, 0, 0, bl4, "");
            float[] fArray = pdfObject.getFloatArray(303185736);
            float f4 = 1.0f;
            boolean bl5 = false;
            float f5 = 0.0f;
            float f6 = 0.0f;
            if (fArray != null) {
                int n6;
                f5 = fArray[0];
                f6 = fArray[1];
                int n7 = (int)(fArray[2] - fArray[0]);
                if (n7 < 0) {
                    n7 = -n7;
                }
                if ((n6 = (int)(fArray[3] - fArray[1])) < 0) {
                    n6 = -n6;
                }
                if (n7 == 0 && n6 > 0) {
                    n7 = 1;
                }
                if (n7 > 0 && n6 == 0) {
                    n6 = 1;
                }
                f3 = (float)n2 / (float)n7;
                f2 = (float)n3 / (float)n6;
                if (bl && (int)f3 * 10 != (int)f2 * 10) {
                    int n8 = n6;
                    n6 = n7;
                    n7 = n8;
                    f = f5;
                    f5 = f6;
                    f6 = f;
                    bl5 = true;
                }
                if (n3 < n6 || n2 < n7) {
                    n3 = n6;
                    n2 = n7;
                } else {
                    f3 = (float)n2 / (float)n7;
                    f2 = (float)n3 / (float)n6;
                    if (f3 > f2) {
                        f4 = f3;
                        n3 = (int)((float)n6 * f4);
                    } else {
                        f4 = f2;
                        n2 = (int)((float)n7 * f4);
                    }
                    f5 *= f4;
                    f6 *= f4;
                }
            } else {
                float f7;
                float f8 = 20.0f;
                if ((float)n3 < f8) {
                    n3 = (int)f8;
                }
                if ((float)n2 < f8) {
                    n2 = (int)f8;
                }
                if ((f7 = (float)n2 / f8) > (f3 = (float)n3 / f8)) {
                    f4 = f7;
                    n3 = (int)(f8 * f4);
                } else {
                    f4 = f3;
                    n2 = (int)(f8 * f4);
                }
            }
            if (n2 == 0 || n3 == 0) {
                return null;
            }
            if (f4 > 1.0f) {
                n3 += 2;
                n2 += 2;
            }
            if (n4 == 1) {
                n2 += 2;
                n3 += 2;
            }
            int n9 = n3;
            float[] fArray2 = pdfObject.getFloatArray(1145198201);
            if (fArray2 != null) {
                f3 = fArray2[0];
                f2 = fArray2[1];
                float f9 = fArray2[2];
                f = fArray2[3];
                float f10 = fArray2[4] * f4;
                float f11 = fArray2[5] * f4;
                if (f9 < 0.0f) {
                    if (bl5) {
                        int n10 = n2;
                        n2 = n3;
                        n3 = n10;
                        float f12 = f5;
                        f5 = f6;
                        f6 = f12;
                    }
                    bufferedImage = new BufferedImage(n3, n2, 2);
                    n9 = n2;
                } else {
                    bufferedImage = new BufferedImage(n2, n3, 2);
                    if (!(f2 < 0.0f)) {
                        if (f10 != 0.0f) {
                            f10 = -f5;
                        }
                        if (f11 != 0.0f) {
                            f11 = -f6;
                        }
                    }
                }
                graphics2D = (Graphics2D)bufferedImage.getGraphics();
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(0.0, n9);
                affineTransform.scale(1.0, -1.0);
                graphics2D.setTransform(affineTransform);
                AffineTransform affineTransform2 = new AffineTransform(f3, f2, f9, f, f10, f11);
                graphics2D.transform(affineTransform2);
            } else {
                bufferedImage = new BufferedImage(n2, n3, 2);
                graphics2D = (Graphics2D)bufferedImage.getGraphics();
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(0.0, n9);
                affineTransform.scale(1.0, -1.0);
                graphics2D.setTransform(affineTransform);
            }
            if (n4 == 2) {
                graphics2D.scale(-1.0, -1.0);
            } else if (n4 == 1) {
                graphics2D.translate(1, 1);
            }
            if (n == 1919840408) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
            }
            t3Glyph.render(0, graphics2D, f4, true);
            graphics2D.dispose();
            return bufferedImage;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        catch (Error error) {
            error.printStackTrace();
            return null;
        }
    }

    public static BufferedImage rotate(BufferedImage bufferedImage, int n) {
        BufferedImage bufferedImage2 = null;
        if (bufferedImage == null) {
            return null;
        }
        if (n == 0) {
            return bufferedImage;
        }
        try {
            double d = (double)n * Math.PI / 180.0;
            int n2 = bufferedImage.getWidth();
            int n3 = bufferedImage.getHeight();
            int n4 = (int)Math.round((double)n3 * Math.abs(Math.sin(d)) + (double)n2 * Math.abs(Math.cos(d)));
            int n5 = (int)Math.round((double)n3 * Math.abs(Math.cos(d)) + (double)n2 * Math.abs(Math.sin(d)));
            AffineTransform affineTransform = AffineTransform.getTranslateInstance((n4 - n2) / 2, (n5 - n3) / 2);
            affineTransform.rotate(d, n2 / 2, n3 / 2);
            bufferedImage2 = new BufferedImage(n4, n5, 2);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawRenderedImage(bufferedImage, affineTransform);
            graphics2D.dispose();
        }
        catch (Error error) {
            bufferedImage2 = null;
        }
        return bufferedImage2;
    }

    public boolean hasXFADataSet() {
        return false;
    }

    private static void decodeFontCommandObj(String string, FormObject formObject) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "() []");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        for (n2 = n - 1; n2 > -1; --n2) {
            float f;
            if (stringArray[n2].equals("g")) {
                --n2;
                f = 0.0f;
                try {
                    f = Float.parseFloat(FormStream.handleComma(stringArray[n2]));
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Error in generating g value " + stringArray[n2]);
                }
                formObject.setTextColor(new float[]{f});
                continue;
            }
            if (stringArray[n2].equals("Tf")) {
                --n2;
                int n3 = 8;
                try {
                    n3 = (int)Float.parseFloat(FormStream.handleComma(stringArray[n2]));
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Error in generating Tf size " + stringArray[n2]);
                }
                --n2;
                String string2 = null;
                try {
                    string2 = stringArray[n2];
                    if (string2.startsWith("/")) {
                        string2 = string2.substring(1);
                    }
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Error in generating Tf font " + stringArray[n2]);
                }
                PdfFont pdfFont = new PdfFont();
                formObject.setTextFont(pdfFont.setFont(string2, n3));
                formObject.setTextSize(n3);
                continue;
            }
            if (stringArray[n2].equals("rg") || stringArray[n2].equals("r")) {
                f = Float.parseFloat(FormStream.handleComma(stringArray[--n2]));
                float f2 = Float.parseFloat(FormStream.handleComma(stringArray[--n2]));
                float f3 = Float.parseFloat(FormStream.handleComma(stringArray[--n2]));
                formObject.setTextColor(new float[]{f3, f2, f});
                continue;
            }
            if (stringArray[n2].equals("Sig")) {
                LogWriter.writeFormLog("Sig-  UNIMPLEMENTED=" + string + "< " + n2, false);
                continue;
            }
            if (stringArray[n2].equals("\\n") || showFontMessage) continue;
            showFontMessage = true;
            LogWriter.writeFormLog("{stream} Unknown FONT command " + stringArray[n2] + ' ' + n2 + " string=" + string, false);
        }
    }

    private static String handleComma(String string) {
        int n = string.indexOf(",");
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }
}

