/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.encoding.soapenc;

import java.io.IOException;
import java.io.Writer;
import org.apache.soap.Constants;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.PrefixedName;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;

public class SoapEncUtils {
    public static boolean decodeBooleanValue(String string) {
        switch (string.charAt(0)) {
            case '0': 
            case 'F': 
            case 'f': {
                return false;
            }
            case '1': 
            case 'T': 
            case 't': {
                return true;
            }
        }
        throw new IllegalArgumentException("Invalid boolean value: " + string);
    }

    public static void generateArrayHeader(String string, Class clazz, Object object, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry, QName qName, String string2) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(string, clazz, object, writer, nSStack, xMLJavaMappingRegistry, qName, string2, false);
    }

    public static void generateNullArray(String string, Class clazz, Object object, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry, QName qName, String string2) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(string, clazz, object, writer, nSStack, xMLJavaMappingRegistry, qName, string2, true);
    }

    public static void generateNullStructure(String string, Class clazz, Object object, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(string, clazz, object, writer, nSStack, xMLJavaMappingRegistry, null, null, true);
    }

    public static void generateStructureHeader(String string, Class clazz, Object object, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(string, clazz, object, writer, nSStack, xMLJavaMappingRegistry, null, null, false);
    }

    private static void generateStructureHeader(String string, Class clazz, Object object, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry, QName qName, String string2, boolean bl) throws IllegalArgumentException, IOException {
        String string3;
        String string4;
        Object object2;
        Object object3;
        QName qName2 = xMLJavaMappingRegistry.queryElementType(clazz, "http://schemas.xmlsoap.org/soap/encoding/");
        String string5 = "";
        if (object instanceof PrefixedName && (object3 = ((PrefixedName)(object2 = (PrefixedName)object)).getQName()) != null && (string4 = ((QName)object3).getNamespaceURI()) != null && !string4.equals("") && ((PrefixedName)object2).getPrefix() == null) {
            string3 = nSStack.getPrefixFromURI(string4);
            if (string3 == null) {
                string3 = nSStack.addNSDeclaration(string4);
                string5 = " xmlns:" + string3 + "=\"" + string4 + '\"';
            }
            ((PrefixedName)object2).setPrefix(string3);
        }
        writer.write(String.valueOf('<') + object.toString() + string5);
        object2 = nSStack.getPrefixFromURI("http://www.w3.org/2001/XMLSchema-instance", writer);
        object3 = nSStack.getPrefixFromURI(qName2.getNamespaceURI(), writer);
        writer.write(String.valueOf(' ') + (String)object2 + ':' + "type" + "=\"" + (String)object3 + ':' + qName2.getLocalPart() + '\"');
        if (string == null || !string.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            string4 = nSStack.getPrefixFromURI("http://schemas.xmlsoap.org/soap/envelope/", writer);
            writer.write(String.valueOf(' ') + string4 + ':' + "encodingStyle" + "=\"" + "http://schemas.xmlsoap.org/soap/encoding/" + '\"');
        }
        if (qName != null) {
            string4 = nSStack.getPrefixFromURI(qName.getNamespaceURI(), writer);
            string3 = String.valueOf(string4) + ':' + qName.getLocalPart() + '[' + string2 + ']';
            String string6 = nSStack.getPrefixFromURI("http://schemas.xmlsoap.org/soap/encoding/", writer);
            writer.write(String.valueOf(' ') + string6 + ':' + "arrayType" + "=\"" + string3 + '\"');
        }
        if (bl) {
            writer.write(String.valueOf(' ') + (String)object2 + ':' + "null" + "=\"" + Constants.ATTRVAL_TRUE + "\"/");
        }
        writer.write(62);
    }

    public static QName getAttributeValue(Element element, String string, String string2, String string3, boolean bl) throws IllegalArgumentException {
        String string4 = DOMUtils.getAttributeNS(element, string, string2);
        if (string4 != null) {
            int n = string4.indexOf(58);
            if (n != -1) {
                String string5 = string4.substring(0, n);
                String string6 = string4.substring(n + 1);
                String string7 = DOMUtils.getNamespaceURIFromPrefix(element, string5);
                if (string7 != null) {
                    return new QName(string7, string6);
                }
                throw new IllegalArgumentException("Unable to resolve namespace URI for '" + string5 + "'.");
            }
            throw new IllegalArgumentException("The value of the '" + string + ':' + string2 + "' attribute must be " + "namespace-qualified.");
        }
        if (bl) {
            throw new IllegalArgumentException("The '" + string + ':' + string2 + "' attribute must be " + "specified for every " + string3 + '.');
        }
        return null;
    }

    public static QName getTypeQName(Element element) throws IllegalArgumentException {
        QName qName = SoapEncUtils.getAttributeValue(element, "http://www.w3.org/1999/XMLSchema-instance", "type", null, false);
        if (qName != null) {
            return qName;
        }
        qName = SoapEncUtils.getAttributeValue(element, "http://www.w3.org/2000/10/XMLSchema-instance", "type", null, false);
        if (qName != null) {
            return qName;
        }
        qName = SoapEncUtils.getAttributeValue(element, "http://www.w3.org/2001/XMLSchema-instance", "type", null, false);
        return qName;
    }

    public static boolean isNull(Element element) {
        String string = DOMUtils.getAttributeNS(element, "http://www.w3.org/2001/XMLSchema-instance", "null");
        return string != null && SoapEncUtils.decodeBooleanValue(string);
    }
}

