/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.gui.layerproperties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.IPlacementConstraints;
import org.gvsig.i18n.Messages;
import org.gvsig.labeling.gui.layerproperties.DuplicateLayersMode;
import org.gvsig.labeling.gui.layerproperties.IPlacementProperties;
import org.gvsig.labeling.gui.layerproperties.PlacementProperties;
import org.gvsig.labeling.placements.LinePlacementConstraints;
import org.gvsig.labeling.placements.MultiShapePlacementConstraints;
import org.gvsig.labeling.placements.PlacementManager;
import org.gvsig.labeling.placements.PointPlacementConstraints;
import org.gvsig.labeling.placements.PolygonPlacementConstraints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiShapePlacementProperties
extends JPanel
implements IPlacementProperties {
    private static Logger logger = LoggerFactory.getLogger(MultiShapePlacementProperties.class);
    private static final long serialVersionUID = 2935114466845029008L;
    private PlacementProperties pointProperties;
    private PlacementProperties lineProperties;
    private PlacementProperties polygonProperties;
    private DuplicateLayersMode dupMode;

    public MultiShapePlacementProperties(MultiShapePlacementConstraints constraints) throws Exception {
        MultiShapePlacementConstraints c = null;
        c = constraints != null ? (MultiShapePlacementConstraints)constraints.clone() : (MultiShapePlacementConstraints)PlacementManager.createPlacementConstraints(0);
        this.pointProperties = new PlacementProperties(c.getPointConstraints(), 1, this.getDuplicatesMode());
        this.lineProperties = new PlacementProperties(c.getLineConstraints(), 2, this.getDuplicatesMode());
        this.polygonProperties = new PlacementProperties(c.getPolygonConstraints(), 3, this.getDuplicatesMode());
        this.initialize();
    }

    private DuplicateLayersMode getDuplicatesMode() {
        if (this.dupMode == null) {
            this.dupMode = new DuplicateLayersMode(null);
        }
        return this.dupMode;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        JPanel aux = new JPanel(new BorderLayout());
        JTabbedPane p = new JTabbedPane();
        p.addTab(Messages.getText((String)"points"), this.pointProperties);
        p.addTab(Messages.getText((String)"lines"), this.lineProperties);
        p.addTab(Messages.getText((String)"polygon"), this.polygonProperties);
        this.setLayout(new BorderLayout());
        aux.add((Component)p, "Center");
        aux.add((Component)((Object)this.getDuplicatesMode()), "South");
        this.add((Component)aux, "Center");
    }

    @Override
    public IPlacementConstraints getPlacementConstraints() {
        return new MultiShapePlacementConstraints((PointPlacementConstraints)this.pointProperties.getPlacementConstraints(), (LinePlacementConstraints)this.lineProperties.getPlacementConstraints(), (PolygonPlacementConstraints)this.polygonProperties.getPlacementConstraints());
    }

    public WindowInfo getWindowInfo() {
        return this.pointProperties.getWindowInfo();
    }

    public Object getWindowProfile() {
        return this.pointProperties.getWindowProfile();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean okPressed = "OK".equals(e.getActionCommand());
        boolean cancelPressed = "CANCEL".equals(e.getActionCommand());
        if (okPressed || cancelPressed) {
            if (okPressed) {
                try {
                    this.pointProperties.applyConstraints();
                    this.lineProperties.applyConstraints();
                    this.polygonProperties.applyConstraints();
                }
                catch (GeometryException e1) {
                    logger.error("While applying constraints.", (Throwable)e1);
                }
            }
            if ("CANCEL".equals(e.getActionCommand())) {
                this.pointProperties.constraints = this.pointProperties.oldConstraints;
                this.lineProperties.constraints = this.lineProperties.oldConstraints;
                this.polygonProperties.constraints = this.polygonProperties.oldConstraints;
            }
            ApplicationLocator.getManager().getUIManager().closeWindow((IWindow)this);
            return;
        }
    }
}

