/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.gui.styling;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Stack;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelable;
import org.gvsig.gui.beans.imagenavigator.IClientImageNavigator;
import org.gvsig.gui.beans.imagenavigator.ImageNavigator;
import org.gvsig.gui.beans.imagenavigator.ImageUnavailableException;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.task.Cancellable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerPreview
extends ImageNavigator
implements IClientImageNavigator {
    private static final Logger logger = LoggerFactory.getLogger(LayerPreview.class);
    private static final long serialVersionUID = -7554322442540714114L;
    private FLayer layer = null;
    private ViewPort vp;
    private Stack<Cancellable> cancels = new Stack();
    private static GeometryManager geoman = GeometryLocator.getGeometryManager();

    public LayerPreview() {
        super(null);
        this.setClientImageNavigator(this);
    }

    public void setLayer(FLayer layer) throws ReadException {
        this.layer = layer;
        if (layer != null) {
            this.vp = new ViewPort(layer.getProjection());
            Envelope env = layer.getFullEnvelope();
            this.setViewDimensions(env.getMinimum(0), env.getMaximum(1), env.getMaximum(0), env.getMinimum(1));
        }
        this.updateBuffer();
        this.setEnabled(true);
    }

    public void drawImage(Graphics2D g, double left, double top, double right, double bottom, double zoom, int width, int height) throws ImageUnavailableException {
        PreviewCancellable c = new PreviewCancellable();
        while (!this.cancels.isEmpty()) {
            this.cancels.pop().setCanceled(true);
        }
        this.cancels.push(c);
        if (this.layer == null || width <= 0 || height <= 0 || this.vp == null) {
            return;
        }
        Envelope env = null;
        try {
            env = geoman.createEnvelope(left, bottom, right, top, 0);
        }
        catch (CreateEnvelopeException e1) {
            throw new ImageUnavailableException("Error while initializing layer preview", (Throwable)e1);
        }
        this.vp.setEnvelope(env);
        this.vp.setImageSize(new Dimension(width, height));
        BufferedImage bi = new BufferedImage(width, height, 6);
        double scale = this.layer.getMapContext().getScaleView();
        LayerWithSelection layer = new LayerWithSelection(this.layer);
        try {
            layer.getLayer().draw(bi, g, this.vp, (Cancellable)c, scale);
            if (layer.getLayer() instanceof ILabelable && ((ILabelable)layer.getLayer()).isLabeled()) {
                ((ILabelable)layer.getLayer()).drawLabels(bi, g, this.vp, (Cancellable)c, scale, this.vp.getDPI());
            }
        }
        catch (ReadException e) {
            throw new ImageUnavailableException("Error while drawing layer '" + this.layer.getName() + "'", (Throwable)e);
        }
        finally {
            layer.restore();
        }
    }

    private static class LayerWithSelection {
        FeatureSelection randomSelection = null;
        FeatureSelection originalSelection = null;
        FLayer layer = null;
        FLyrVect layerVect = null;

        public LayerWithSelection(FLayer layer) {
            this.layer = layer;
            if (this.layer instanceof FLyrVect) {
                this.layerVect = (FLyrVect)this.layer;
            }
        }

        public FLayer getLayer() {
            this.save();
            return this.layer;
        }

        public void save() {
            if (this.originalSelection != null) {
                return;
            }
            FeatureStore store = this.layerVect.getFeatureStore();
            try {
                this.originalSelection = store.getFeatureSelection();
                this.randomSelection = this.getRandomSelection();
                store.setSelection((FeatureSet)this.randomSelection);
            }
            catch (DataException ex) {
                logger.warn("Can't set random selection.", (Throwable)ex);
            }
        }

        public void restore() {
            if (this.layerVect == null) {
                return;
            }
            if (this.originalSelection != null) {
                try {
                    this.layerVect.getFeatureStore().setSelection((FeatureSet)this.originalSelection);
                }
                catch (DataException ex) {
                    logger.warn("Can't restore the original selection of layer.", (Throwable)ex);
                }
            }
            if (this.randomSelection != null) {
                this.randomSelection.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FeatureSelection getRandomSelection() {
            if (this.layer == null) {
                return null;
            }
            FLyrVect layer = null;
            if (!(this.layer instanceof FLyrVect)) {
                return null;
            }
            layer = (FLyrVect)this.layer;
            DisposableIterator diter = null;
            FeatureSelection fsel = null;
            FeatureSet featureSet = null;
            FeatureStore store = layer.getFeatureStore();
            try {
                try {
                    featureSet = store.getFeatureSet();
                    fsel = store.createFeatureSelection();
                    diter = featureSet.fastIterator();
                }
                catch (DataException de) {
                    logger.error("While getting store selection", (Throwable)de);
                    FeatureSelection featureSelection = null;
                    if (diter != null) {
                        diter.dispose();
                    }
                    if (featureSet != null) {
                        featureSet.dispose();
                    }
                    return featureSelection;
                }
                Feature feat = null;
                for (long count = 0L; diter.hasNext() && count < 10L; ++count) {
                    feat = (Feature)diter.next();
                    if (count % 4L != 0L) continue;
                    fsel.select(feat);
                }
            }
            finally {
                if (diter != null) {
                    diter.dispose();
                }
                if (featureSet != null) {
                    featureSet.dispose();
                }
            }
            return fsel;
        }
    }

    private class PreviewCancellable
    implements Cancellable {
        private boolean canc = false;

        public boolean isCanceled() {
            return this.canc;
        }

        public void setCanceled(boolean c) {
            this.canc = c;
        }
    }
}

