/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.gui.styling.editortools;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.app.gui.styling.EditorTool;
import org.gvsig.app.gui.styling.StyleEditor;
import org.gvsig.i18n.Messages;
import org.gvsig.labeling.placements.PointLabelPositioner;

public class PointLabelHighPrecedenceTool
extends EditorTool {
    protected String buttonIcon = "set-high-precedence";
    protected byte precedenceValue = 1;
    private final Cursor cursor = Cursor.getDefaultCursor();
    private JToggleButton btnNewPrecedence;
    private PointLabelPositioner positioneer;

    public PointLabelHighPrecedenceTool(JComponent targetEditor) {
        super(targetEditor);
    }

    private JToggleButton getBtnNewPrecedence() {
        if (this.btnNewPrecedence == null) {
            this.btnNewPrecedence = new JToggleButton();
            this.btnNewPrecedence.setSize(EditorTool.SMALL_BTN_SIZE);
            this.btnNewPrecedence.setIcon(this.getIconButton());
            this.btnNewPrecedence.setToolTipText(this.getID().concat(": ").concat(Messages.getText((String)"set_high_precedence")));
        }
        return this.btnNewPrecedence;
    }

    protected ImageIcon getIconButton() {
        return IconThemeHelper.getImageIcon((String)this.buttonIcon);
    }

    public AbstractButton getButton() {
        return this.getBtnNewPrecedence();
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public String getID() {
        return "1";
    }

    public boolean isSuitableFor(Object obj) {
        return obj instanceof PointLabelPositioner;
    }

    public void setModel(Object objectToBeEdited) {
        this.positioneer = (PointLabelPositioner)((Object)objectToBeEdited);
    }

    private int getPositionerCellIndex(Point p) {
        int col;
        Dimension dim = ((StyleEditor)this.owner).getStylePreviewer().getSize();
        int size = Math.min(dim.width, dim.height);
        if (p.getX() > (double)size || p.getY() > (double)size) {
            return -1;
        }
        int cellSize = size / 3;
        int row = (int)p.getY() / cellSize;
        int arrayPosition = 3 * row + (col = (int)p.getX() / cellSize);
        if (arrayPosition == 4) {
            return -1;
        }
        if (arrayPosition > 4) {
            return arrayPosition - 1;
        }
        return arrayPosition;
    }

    public void mousePressed(MouseEvent e) {
        int[] pv = this.positioneer.getPreferenceVector();
        int cellIndex = this.getPositionerCellIndex(e.getPoint());
        if (cellIndex != -1) {
            pv[cellIndex] = this.precedenceValue;
        }
        this.owner.repaint();
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }
}

