/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.label;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import org.cresques.cts.ICoordTrans;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelClass;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelLocationMetrics;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelingMethod;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.IPlacementConstraints;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.IZoomConstraints;
import org.gvsig.fmap.mapcontext.rendering.symbols.ITextSymbol;
import org.gvsig.i18n.Messages;
import org.gvsig.labeling.label.IGeneralLabelingStrategy;
import org.gvsig.labeling.label.LabelClassComparatorByPriority;
import org.gvsig.labeling.label.SmartTextSymbolLabelClass;
import org.gvsig.labeling.lang.LabelClassUtils;
import org.gvsig.labeling.placements.ILabelPlacement;
import org.gvsig.labeling.placements.LinePlacementConstraints;
import org.gvsig.labeling.placements.MultiShapePlacementConstraints;
import org.gvsig.labeling.placements.PlacementManager;
import org.gvsig.labeling.placements.PointPlacementConstraints;
import org.gvsig.labeling.placements.PolygonPlacementConstraints;
import org.gvsig.labeling.placements.RemoveDuplicatesComparator;
import org.gvsig.labeling.symbol.SmartTextSymbol;
import org.gvsig.labeling.symbol.SymbolUtils;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.styling.LabelLocationMetrics;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.impl.AbstractCartographicSupport;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.Cancellable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralLabelingStrategy
extends AbstractCartographicSupport
implements IGeneralLabelingStrategy {
    private static final Logger logger = LoggerFactory.getLogger(GeneralLabelingStrategy.class);
    public static final String GENERAL_LABEL_STRATEGY_PERSISTENCE_NAME = "GENERAL_LABEL_STRATEGY_PERSISTENCE_NAME";
    public static PointPlacementConstraints DefaultPointPlacementConstraints = new PointPlacementConstraints();
    public static LinePlacementConstraints DefaultLinePlacementConstraints = new LinePlacementConstraints();
    public static PolygonPlacementConstraints DefaultPolygonPlacementConstraints = new PolygonPlacementConstraints();
    private static String[] NO_TEXT = new String[]{Messages.getText((String)"text_field")};
    private static MultiShapePlacementConstraints DefaultMultiShapePlacementConstratints = new MultiShapePlacementConstraints();
    private ILabelingMethod method = SymbologyLocator.getSymbologyManager().createDefaultLabelingMethod();
    private IPlacementConstraints placementConstraints;
    private IZoomConstraints zoomConstraints;
    private boolean allowOverlapping;
    protected FLyrVect layer;
    private boolean printMode = false;
    private List<Geometry> drawnGeometryLabels;

    public void setLayer(FLayer layer) {
        FLyrVect l;
        this.layer = l = (FLyrVect)layer;
    }

    public ILabelingMethod getLabelingMethod() {
        return this.method;
    }

    public void setLabelingMethod(ILabelingMethod method) {
        this.method = method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(BufferedImage mapImage, Graphics2D mapGraphics, double scale, ViewPort viewPort, Cancellable cancel, double dpi) throws ReadException {
        this.drawnGeometryLabels = new ArrayList<Geometry>(1000);
        int x = (int)viewPort.getOffset().getX();
        int y = (int)viewPort.getOffset().getY();
        int print_offset_x = x;
        int print_offset_y = y;
        if (this.printMode) {
            x = 0;
            y = 0;
            this.printMode = false;
        }
        TreeMap<String[], GeometryItem> labelsToPlace = null;
        String[] usedFields = this.getUsedFields();
        int notPlacedCount = 0;
        int placedCount = 0;
        ILabelPlacement placement = PlacementManager.getPlacement(this.getPlacementConstraints(), this.layer.getShapeType());
        ILabelClass[] lcs = this.method.getLabelClasses();
        TreeSet<ILabelClass> ts = new TreeSet<ILabelClass>(new LabelClassComparatorByPriority());
        for (int i = 0; i < lcs.length; ++i) {
            ts.add(lcs[i]);
        }
        if (ts.size() == 0) {
            return;
        }
        for (ILabelClass lc : ts) {
            if (!lc.isVisible(scale)) continue;
            FeatureSet fset = null;
            DisposableIterator diter = null;
            try {
                GeometryItem item;
                String[] texts;
                Graphics2D targetGr;
                BufferedImage targetBI;
                try {
                    fset = this.method.getFeatureIteratorByLabelClass(this.layer, lc, viewPort, usedFields);
                }
                catch (DataException e) {
                    throw new ReadException(this.layer.getFeatureStore().getProviderName(), (Throwable)e);
                }
                int duplicateMode = this.getDuplicateLabelsMode();
                if (duplicateMode == 2) {
                    labelsToPlace = new TreeMap<String[], GeometryItem>(new RemoveDuplicatesComparator());
                }
                boolean bLabelsReallocatable = !this.isAllowingOverlap();
                BufferedImage overlapDetectImage = null;
                Graphics2D overlapDetectGraphics = null;
                if (bLabelsReallocatable) {
                    int height;
                    int width = viewPort.getImageWidth() + print_offset_x;
                    if (width < 0) {
                        width = 1;
                    }
                    if ((height = viewPort.getImageHeight() + print_offset_y) < 0) {
                        height = 1;
                    }
                    overlapDetectImage = mapImage != null ? new BufferedImage(mapImage.getWidth() + print_offset_x, mapImage.getHeight() + print_offset_y, 2) : new BufferedImage(viewPort.getImageWidth() + print_offset_x, viewPort.getImageHeight() + print_offset_y, 2);
                    overlapDetectGraphics = overlapDetectImage.createGraphics();
                    overlapDetectGraphics.setRenderingHints(mapGraphics.getRenderingHints());
                }
                if (bLabelsReallocatable) {
                    targetBI = overlapDetectImage;
                    targetGr = overlapDetectGraphics;
                    targetGr.translate(-x, -y);
                } else {
                    targetBI = mapImage;
                    targetGr = mapGraphics;
                }
                try {
                    diter = fset.fastIterator();
                }
                catch (DataException e) {
                    throw new ReadException(this.layer.getFeatureStore().getProviderName(), (Throwable)e);
                }
                Feature featu = null;
                Geometry geome = null;
                while (!cancel.isCanceled() && diter.hasNext()) {
                    featu = ((Feature)diter.next()).getCopy();
                    geome = featu.getDefaultGeometry();
                    if (geome == null || geome.getType() == 16) continue;
                    ICoordTrans ct = this.layer.getCoordTrans();
                    if (ct != null) {
                        geome.reProject(ct);
                    }
                    if (!this.setupLabel(featu, lc, cancel, usedFields, viewPort, dpi, duplicateMode)) continue;
                    texts = lc.getTexts();
                    if (duplicateMode == 2) {
                        item = (GeometryItem)labelsToPlace.get(texts);
                        if (item == null) {
                            item = new GeometryItem(geome, 0);
                            labelsToPlace.put(texts, item);
                        }
                        if (item.geom != null) {
                            ++notPlacedCount;
                            if (geome.getType() != 1) {
                                Envelope auxBox = geome.getEnvelope();
                                double perimeterAux = 2.0 * (auxBox.getLength(0) + auxBox.getLength(1));
                                if (perimeterAux > item.savedPerimeter) {
                                    item.geom = geome;
                                    item.savedPerimeter = perimeterAux;
                                }
                            } else {
                                int weigh = item.weigh;
                                try {
                                    Point pointFromLabel = item.geom.centroid();
                                    Point pointGeome = geome.centroid();
                                    item.geom = GeometryLocator.getGeometryManager().createPoint((pointFromLabel.getX() * (double)weigh + pointGeome.getX()) / (double)(weigh + 1), (pointFromLabel.getY() * (double)weigh + pointGeome.getY()) / (double)(weigh + 1), 0);
                                }
                                catch (Exception ex) {
                                    throw new ReadException(this.layer.getFeatureStore().getProviderName(), (Throwable)ex);
                                }
                            }
                        } else {
                            item.geom = geome;
                        }
                        ++item.weigh;
                        continue;
                    }
                    if (this.isOnePoint(viewPort, geome)) continue;
                    List<Object> geome_parts = new ArrayList<Geometry>();
                    if (duplicateMode == 4) {
                        geome_parts = this.getGeometryParts(geome);
                    } else {
                        geome_parts.add(geome);
                    }
                    try {
                        int n = geome_parts.size();
                        for (int k = 0; k < n; ++k) {
                            this.drawLabelInGeom(targetBI, targetGr, lc, placement, viewPort, (Geometry)geome_parts.get(k), cancel, dpi, bLabelsReallocatable);
                        }
                    }
                    catch (GeometryException e) {
                        throw new ReadException(this.layer.getFeatureStore().getProviderName(), (Throwable)e);
                    }
                    ++placedCount;
                }
                if (duplicateMode == 2) {
                    Iterator<String[]> textsIt = labelsToPlace.keySet().iterator();
                    while (!cancel.isCanceled() && textsIt.hasNext()) {
                        ++notPlacedCount;
                        texts = textsIt.next();
                        item = (GeometryItem)labelsToPlace.get(texts);
                        if (item == null) continue;
                        lc.setTexts(texts);
                        if (this.isOnePoint(viewPort, item.geom)) continue;
                        try {
                            this.drawLabelInGeom(targetBI, targetGr, lc, placement, viewPort, item.geom, cancel, dpi, bLabelsReallocatable);
                        }
                        catch (GeometryException e) {
                            throw new ReadException(this.layer.getFeatureStore().getProviderName(), (Throwable)e);
                        }
                    }
                }
                if (!bLabelsReallocatable) continue;
                targetGr.translate(x, y);
                mapGraphics.drawImage(targetBI, null, null);
            }
            finally {
                if (diter != null) {
                    diter.dispose();
                }
                if (fset == null) continue;
                fset.dispose();
            }
        }
    }

    private List<Geometry> getGeometryParts(Geometry ge) {
        ArrayList<Geometry> resp = new ArrayList<Geometry>();
        if (ge != null) {
            if (ge instanceof MultiPrimitive) {
                MultiPrimitive mp = (MultiPrimitive)ge;
                int n = mp.getPrimitivesNumber();
                for (int i = 0; i < n; ++i) {
                    resp.add((Geometry)mp.getPrimitiveAt(i));
                }
            } else {
                resp.add(ge);
            }
        }
        return resp;
    }

    private void drawLabelInGeom(BufferedImage targetBI, Graphics2D targetGr, ILabelClass lc, ILabelPlacement placement, ViewPort viewPort, Geometry geom, Cancellable cancel, double dpi, boolean bLabelsReallocatable) throws GeometryException {
        lc.setCartographicContext(viewPort, dpi, geom);
        ArrayList<LabelLocationMetrics> llm = null;
        llm = placement.guess(lc, geom, this.getPlacementConstraints(), 0.0, cancel, viewPort);
        this.setReferenceSystem(lc.getReferenceSystem());
        this.setUnit(lc.getUnit());
        this.lookupAndPlaceLabel(targetBI, targetGr, llm, placement, lc, geom, viewPort, cancel, bLabelsReallocatable);
    }

    private int getDuplicateLabelsMode() {
        if (this.getPlacementConstraints() == null) {
            return 4;
        }
        return this.getPlacementConstraints().getDuplicateLabelsMode();
    }

    private boolean lookupAndPlaceLabel(BufferedImage bi, Graphics2D g, ArrayList<LabelLocationMetrics> llm, ILabelPlacement placement, ILabelClass lc, Geometry geom, ViewPort viewPort, Cancellable cancel, boolean bLabelsReallocatable) throws GeometryException {
        GeometryManager gm = GeometryLocator.getGeometryManager();
        for (int i = 0; !cancel.isCanceled() && i < llm.size(); ++i) {
            LabelLocationMetrics labelMetrics = llm.get(i);
            IPlacementConstraints pc = this.getPlacementConstraints();
            if (pc instanceof MultiShapePlacementConstraints) {
                MultiShapePlacementConstraints mpc = (MultiShapePlacementConstraints)pc;
                GeometryType geom_gt = null;
                geom_gt = gm.getGeometryType(geom.getType(), 0);
                if (geom_gt.isTypeOf(1) || geom_gt.isTypeOf(7)) {
                    pc = mpc.getPointConstraints();
                } else if (geom_gt.isTypeOf(2) || geom_gt.isTypeOf(8)) {
                    pc = mpc.getLineConstraints();
                } else if (geom_gt.isTypeOf(3) || geom_gt.isTypeOf(9)) {
                    pc = mpc.getPolygonConstraints();
                }
            }
            if (bLabelsReallocatable) {
                Geometry aux_geom = null;
                aux_geom = lc.getShape((ILabelLocationMetrics)labelMetrics);
                if (this.isOverlapping(bi, aux_geom)) continue;
                if (!pc.isFollowingLine()) {
                    lc.draw(g, (ILabelLocationMetrics)labelMetrics, geom);
                } else {
                    SmartTextSymbolLabelClass smsLc = new SmartTextSymbolLabelClass();
                    SmartTextSymbol sms = new SmartTextSymbol(lc.getTextSymbol(), pc);
                    double sizeBefore = lc.getTextSymbol().getFont().getSize();
                    double sizeAfter = SymbolUtils.getCartographicLength(this, sizeBefore, viewPort, viewPort.getDPI());
                    sms.setFontSize(sizeAfter);
                    smsLc.setTextSymbol((ITextSymbol)sms);
                    geom.transform(viewPort.getAffineTransform());
                    smsLc.draw(g, null, geom);
                    sms.setFontSize(sizeBefore);
                }
                return true;
            }
            if (!pc.isFollowingLine()) {
                lc.draw(g, (ILabelLocationMetrics)labelMetrics, null);
            } else {
                SmartTextSymbolLabelClass smsLc = new SmartTextSymbolLabelClass();
                SmartTextSymbol sms = new SmartTextSymbol(lc.getTextSymbol(), pc);
                double sizeBefore = lc.getTextSymbol().getFont().getSize();
                double sizeAfter = SymbolUtils.getCartographicLength(this, sizeBefore, viewPort, viewPort.getDPI());
                sms.setFontSize(sizeAfter);
                smsLc.setTextSymbol((ITextSymbol)sms);
                geom.transform(viewPort.getAffineTransform());
                smsLc.draw(g, null, geom);
                sms.setFontSize(sizeBefore);
            }
            return true;
        }
        return false;
    }

    private String[] divideExpression(String str) {
        ArrayList<String> r = new ArrayList<String>();
        boolean inQuotationMarks = false;
        int lastIndex = 0;
        for (int i = 0; i < str.length(); ++i) {
            String currentChar = str.substring(i, i + 1);
            if (currentChar.compareTo("\"") == 0) {
                boolean bl = inQuotationMarks = !inQuotationMarks;
                if (!inQuotationMarks) {
                    r.add(str.substring(lastIndex, i + 1).replace("\"", "'"));
                    lastIndex = i + 1;
                }
            }
            if (currentChar.compareTo(":") != 0 || inQuotationMarks) continue;
            if (lastIndex < i) {
                r.add(str.substring(lastIndex, i));
            }
            lastIndex = i + 1;
        }
        if (lastIndex < str.length() - 1) {
            r.add(str.substring(lastIndex));
        }
        String[] result = new String[r.size()];
        r.toArray(result);
        return result;
    }

    private boolean setupLabel(Feature featu, ILabelClass lc, Cancellable cancel, String[] usedFields, ViewPort viewPort, double dpi, int duplicateMode) {
        String expr = lc.getStringLabelExpression();
        long pt1 = System.currentTimeMillis();
        String[] texts = NO_TEXT;
        ArrayList<String> preTexts = new ArrayList<String>();
        try {
            if (expr != null) {
                if (expr.equals("")) {
                    expr = texts[0];
                }
                String[] multiexpr = this.divideExpression(expr);
                for (int i = 0; i < multiexpr.length; ++i) {
                    expr = multiexpr[i];
                    Object res = LabelClassUtils.evaluate(expr, featu.getEvaluatorData());
                    if (res != null) {
                        preTexts.add(res.toString());
                        continue;
                    }
                    preTexts.add("");
                }
                texts = new String[preTexts.size()];
                preTexts.toArray(texts);
            }
            lc.setTexts(texts);
        }
        catch (Exception e) {
            logger.warn("While setting up label", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean isOverlapping(BufferedImage bi, Geometry lblgeom) {
        for (Geometry drawnGeometry : this.drawnGeometryLabels) {
            try {
                if (!drawnGeometry.intersects(lblgeom)) continue;
                return true;
            }
            catch (GeometryOperationException | GeometryOperationNotSupportedException e) {
                logger.warn("Can't check overlapping geometry");
            }
        }
        this.drawnGeometryLabels.add(lblgeom);
        return false;
    }

    private boolean isOnePoint(ViewPort viewPort, Geometry geom) {
        boolean onePoint = false;
        int shapeType = geom.getType();
        if (shapeType != 1 && shapeType != 7) {
            Envelope env = geom.getEnvelope();
            double dist1Pixel = viewPort.getDist1pixel();
            onePoint = env.getLength(0) <= dist1Pixel && env.getLength(1) <= dist1Pixel;
        }
        return onePoint;
    }

    @Override
    public boolean isAllowingOverlap() {
        return this.allowOverlapping;
    }

    @Override
    public void setAllowOverlapping(boolean allowOverlapping) {
        this.allowOverlapping = allowOverlapping;
    }

    public IPlacementConstraints getPlacementConstraints() {
        if (this.placementConstraints != null) {
            return this.placementConstraints;
        }
        GeometryType gt = null;
        try {
            gt = this.layer.getGeometryType();
            gt = GeometryLocator.getGeometryManager().getGeometryType(gt.getType(), 0);
        }
        catch (Exception e) {
            logger.error("While getting placements constraints.", (Throwable)e);
            return null;
        }
        if (gt.isTypeOf(1) || gt.isTypeOf(7)) {
            return DefaultPointPlacementConstraints;
        }
        if (gt.isTypeOf(2) || gt.isTypeOf(8)) {
            return DefaultLinePlacementConstraints;
        }
        if (gt.isTypeOf(3) || gt.isTypeOf(9)) {
            return DefaultPolygonPlacementConstraints;
        }
        if (gt.isTypeOf(6) || gt.isTypeOf(0)) {
            DefaultMultiShapePlacementConstratints.setPointConstraints(DefaultPointPlacementConstraints);
            DefaultMultiShapePlacementConstratints.setLineConstraints(DefaultLinePlacementConstraints);
            DefaultMultiShapePlacementConstratints.setPolygonConstraints(DefaultPolygonPlacementConstraints);
            return DefaultMultiShapePlacementConstratints;
        }
        return null;
    }

    public void setPlacementConstraints(IPlacementConstraints constraints) {
        this.placementConstraints = constraints;
    }

    public IZoomConstraints getZoomConstraints() {
        return this.zoomConstraints;
    }

    public void setZoomConstraints(IZoomConstraints constraints) {
        this.zoomConstraints = constraints;
    }

    public void print(Graphics2D g, double scale, ViewPort viewPort, Cancellable cancel, PrintAttributes properties) throws ReadException {
        double dpi = 100.0;
        int pq = properties.getPrintQuality();
        if (pq == 1) {
            dpi = 300.0;
        } else if (pq == 2) {
            dpi = 600.0;
        } else if (pq == 0) {
            dpi = 72.0;
        }
        this.printMode = true;
        this.draw(null, g, scale, viewPort, cancel, dpi);
    }

    public String[] getUsedFields() {
        FeatureAttributeDescriptor[] atts = null;
        try {
            atts = this.layer.getFeatureStore().getDefaultFeatureType().getAttributeDescriptors();
        }
        catch (DataException e) {
            logger.error("While getting atributes.", (Throwable)e);
        }
        int n = atts.length;
        String[] resp = new String[n];
        for (int i = 0; i < n; ++i) {
            resp[i] = atts[i].getName();
        }
        return resp;
    }

    public boolean shouldDrawLabels(double scale) {
        double minScaleView = -1.0;
        double maxScaleView = -1.0;
        if (this.zoomConstraints != null) {
            minScaleView = this.zoomConstraints.getMinScale();
            maxScaleView = this.zoomConstraints.getMaxScale();
        }
        if (minScaleView == -1.0 && maxScaleView == -1.0) {
            return this.layer.isWithinScale(scale);
        }
        if (minScaleView >= scale) {
            return maxScaleView != -1.0 ? maxScaleView <= scale : true;
        }
        return false;
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(GENERAL_LABEL_STRATEGY_PERSISTENCE_NAME) == null) {
            DynStruct definition = manager.addDefinition(GeneralLabelingStrategy.class, GENERAL_LABEL_STRATEGY_PERSISTENCE_NAME, "GENERAL_LABEL_STRATEGY_PERSISTENCE_NAME Persistence definition", null, null);
            definition.addDynFieldObject("labelingMethod").setClassOfValue(ILabelingMethod.class).setMandatory(true);
            definition.addDynFieldObject("placementConstraints").setClassOfValue(IPlacementConstraints.class).setMandatory(false);
            definition.addDynFieldObject("zoomConstraints").setClassOfValue(IZoomConstraints.class).setMandatory(false);
            definition.addDynFieldBoolean("allowOverlapping").setMandatory(true);
            definition.addDynFieldInt("unit").setMandatory(true);
            definition.addDynFieldInt("referenceSystem").setMandatory(true);
        }
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.method = (ILabelingMethod)state.get("labelingMethod");
        if (state.hasValue("placementConstraints")) {
            this.placementConstraints = (IPlacementConstraints)state.get("placementConstraints");
        }
        if (state.hasValue("zoomConstraints")) {
            this.zoomConstraints = (IZoomConstraints)state.get("zoomConstraints");
        }
        this.allowOverlapping = state.getBoolean("allowOverlapping");
        this.setUnit(state.getInt("unit"));
        this.setReferenceSystem(state.getInt("referenceSystem"));
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("labelingMethod", (Persistent)this.method);
        if (this.placementConstraints != null) {
            state.set("placementConstraints", (Persistent)this.placementConstraints);
        }
        if (this.zoomConstraints != null) {
            state.set("zoomConstraints", (Persistent)this.zoomConstraints);
        }
        state.set("allowOverlapping", this.allowOverlapping);
        state.set("unit", this.getUnit());
        state.set("referenceSystem", this.getReferenceSystem());
    }

    public Object clone() throws CloneNotSupportedException {
        return LabelClassUtils.clone((Persistent)this);
    }

    private class GeometryItem {
        public Geometry geom = null;
        public int weigh = 0;
        public double savedPerimeter;

        public GeometryItem(Geometry geom, int weigh) {
            this.geom = geom;
            this.weigh = weigh;
            this.savedPerimeter = 0.0;
        }
    }
}

